/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_Components_h
#define mozilla_Components_h

#include "nsCOMPtr.h"

struct nsID;

#define NS_IMPL_COMPONENT_FACTORY(iface) \
  template <>                            \
  already_AddRefed<nsISupports> mozCreateComponent<iface>()

template <typename T>
already_AddRefed<nsISupports> mozCreateComponent();

namespace mozilla {
namespace xpcom {

enum class ModuleID : uint16_t {
  Anonymous366,
  Anonymous099,
  Anonymous433,
  Anonymous367,
  AddonContentPolicy,
  Anonymous420,
  Anonymous415,
  Anonymous286,
  Anonymous221,
  Anonymous384,
  Anonymous081,
  Anonymous438,
  Anonymous341,
  FindService,
  Anonymous149,
  URILoader,
  Anonymous357,
  Anonymous334,
  Anonymous281,
  Anonymous086,
  Anonymous331,
  Anonymous266,
  Anonymous122,
  Anonymous017,
  Anonymous314,
  Anonymous205,
  Anonymous376,
  Anonymous108,
  Anonymous448,
  Anonymous439,
  Anonymous211,
  Anonymous147,
  Anonymous219,
  Anonymous106,
  Anonymous151,
  Anonymous261,
  SocketTransport,
  Anonymous250,
  Anonymous329,
  Anonymous449,
  Anonymous215,
  Observer,
  Anonymous026,
  Anonymous338,
  Anonymous302,
  Anonymous304,
  Anonymous035,
  Anonymous280,
  Anonymous364,
  Anonymous290,
  Anonymous256,
  Anonymous275,
  Anonymous351,
  Anonymous085,
  Anonymous056,
  Anonymous083,
  Anonymous178,
  Anonymous444,
  Anonymous097,
  Anonymous067,
  Anonymous173,
  Anonymous197,
  Anonymous158,
  Anonymous414,
  Anonymous082,
  Anonymous078,
  Anonymous421,
  Anonymous131,
  Anonymous344,
  Anonymous358,
  Anonymous170,
  Anonymous226,
  Anonymous248,
  Anonymous135,
  Anonymous373,
  Anonymous148,
  Anonymous186,
  Anonymous065,
  Anonymous273,
  Anonymous079,
  Anonymous396,
  Anonymous279,
  CookieBannerService,
  Anonymous100,
  Anonymous354,
  Anonymous295,
  Anonymous382,
  Anonymous391,
  Anonymous049,
  Anonymous123,
  Anonymous393,
  Anonymous003,
  Anonymous402,
  Anonymous132,
  Anonymous440,
  Anonymous096,
  Anonymous447,
  Anonymous033,
  Anonymous356,
  Anonymous024,
  Prefetch,
  Anonymous321,
  Anonymous176,
  Anonymous307,
  Anonymous301,
  Anonymous252,
  Anonymous254,
  Anonymous264,
  AlertNotification,
  Anonymous422,
  Anonymous133,
  GfxInfo,
  Anonymous169,
  Anonymous009,
  Anonymous023,
  AppStartup,
  Anonymous030,
  ApplicationReputation,
  Anonymous089,
  Anonymous206,
  Anonymous427,
  Anonymous159,
  Anonymous389,
  Anonymous359,
  Anonymous299,
  Anonymous091,
  Anonymous189,
  Anonymous232,
  Anonymous143,
  Anonymous080,
  Anonymous201,
  UrlClassifierPrefixSet,
  Anonymous039,
  Anonymous127,
  Anonymous426,
  Anonymous361,
  Anonymous209,
  Anonymous409,
  Anonymous419,
  Anonymous239,
  Anonymous350,
  DownloadPlatform,
  Anonymous424,
  Anonymous006,
  Anonymous276,
  Anonymous112,
  Anonymous330,
  Anonymous117,
  Anonymous162,
  IdentityCredentialStorageService,
  Anonymous098,
  Anonymous328,
  Anonymous063,
  Anonymous380,
  Anonymous210,
  Anonymous183,
  Anonymous291,
  Anonymous174,
  Anonymous217,
  Anonymous375,
  Anonymous225,
  Anonymous075,
  Anonymous222,
  Anonymous346,
  Anonymous115,
  Anonymous272,
  Anonymous262,
  Anonymous277,
  Anonymous051,
  Anonymous050,
  Anonymous294,
  Anonymous374,
  Anonymous278,
  Anonymous048,
  Anonymous087,
  Anonymous258,
  Anonymous336,
  Anonymous269,
  Anonymous128,
  Anonymous379,
  Anonymous251,
  Anonymous413,
  ExternalProtocolHandler,
  Anonymous145,
  Anonymous093,
  Anonymous011,
  Anonymous188,
  Anonymous313,
  Anonymous034,
  Anonymous267,
  Anonymous282,
  Anonymous192,
  Anonymous246,
  Anonymous348,
  Anonymous104,
  StringBundle,
  Anonymous054,
  Anonymous014,
  Anonymous327,
  Anonymous044,
  Anonymous360,
  TypeAheadFind,
  Anonymous387,
  UUIDGenerator,
  Anonymous271,
  Anonymous059,
  URIFixup,
  Anonymous230,
  Anonymous154,
  Anonymous031,
  Anonymous136,
  Anonymous216,
  Anonymous072,
  Anonymous319,
  Anonymous253,
  Anonymous340,
  Anonymous120,
  Anonymous208,
  Anonymous229,
  Anonymous213,
  Anonymous181,
  Anonymous405,
  Anonymous177,
  Anonymous293,
  Anonymous134,
  Anonymous407,
  Anonymous095,
  Anonymous343,
  Anonymous288,
  Anonymous015,
  Anonymous390,
  Anonymous150,
  Anonymous236,
  Anonymous231,
  Anonymous069,
  Anonymous265,
  Anonymous284,
  Anonymous041,
  Anonymous227,
  Anonymous446,
  Anonymous401,
  Anonymous045,
  Anonymous442,
  Anonymous312,
  Anonymous436,
  Anonymous202,
  Anonymous008,
  Anonymous105,
  Anonymous305,
  Anonymous392,
  Anonymous298,
  Anonymous001,
  Anonymous196,
  Anonymous370,
  Anonymous243,
  UrlClassifierDB,
  Anonymous166,
  Anonymous182,
  Anonymous073,
  Anonymous270,
  Anonymous445,
  Anonymous207,
  Anonymous028,
  DNS,
  Anonymous057,
  Anonymous435,
  Anonymous332,
  Anonymous257,
  Anonymous345,
  Anonymous385,
  PermissionManager,
  Anonymous102,
  Anonymous289,
  Anonymous308,
  Anonymous274,
  Anonymous046,
  Anonymous218,
  Anonymous441,
  Anonymous076,
  Anonymous418,
  Anonymous322,
  Anonymous241,
  Anonymous249,
  Anonymous171,
  Anonymous077,
  Anonymous111,
  Anonymous416,
  Anonymous224,
  Anonymous386,
  Anonymous139,
  Anonymous172,
  Anonymous005,
  Anonymous055,
  Anonymous287,
  Anonymous203,
  Anonymous000,
  IdentityCredentialPromptService,
  Anonymous064,
  Anonymous283,
  Anonymous040,
  Anonymous260,
  Anonymous335,
  Anonymous395,
  AsyncShutdown,
  Anonymous337,
  Anonymous164,
  Anonymous200,
  Anonymous119,
  Anonymous371,
  Anonymous425,
  Anonymous368,
  ThirdPartyUtil,
  Anonymous268,
  Anonymous066,
  Anonymous130,
  UrlClassifierStreamUpdater,
  Anonymous326,
  XULRuntime,
  Anonymous144,
  Anonymous070,
  Anonymous242,
  Anonymous156,
  Anonymous325,
  Anonymous398,
  Anonymous037,
  Anonymous161,
  Anonymous068,
  Anonymous292,
  Anonymous311,
  Anonymous381,
  IO,
  Anonymous296,
  Directory,
  Anonymous053,
  Anonymous165,
  Anonymous410,
  Anonymous138,
  Preferences,
  Anonymous180,
  UrlClassifierUtils,
  Anonymous220,
  HttpActivityDistributor,
  Anonymous320,
  Anonymous071,
  Anonymous397,
  Anonymous347,
  Anonymous434,
  Anonymous007,
  Anonymous204,
  Anonymous092,
  Anonymous185,
  Anonymous113,
  Anonymous036,
  Anonymous155,
  Anonymous443,
  Anonymous432,
  Anonymous362,
  Anonymous167,
  CacheStorage,
  Anonymous020,
  ServiceWorkerManager,
  Alerts,
  Anonymous047,
  Anonymous199,
  URLQueryStringStripper,
  Anonymous016,
  Anonymous353,
  Anonymous101,
  Anonymous285,
  Anonymous339,
  Anonymous043,
  Anonymous369,
  Anonymous193,
  Anonymous363,
  Anonymous141,
  Anonymous378,
  Anonymous184,
  Anonymous255,
  Anonymous126,
  Anonymous240,
  Anonymous107,
  Anonymous084,
  Anonymous022,
  Anonymous234,
  Anonymous168,
  Anonymous021,
  Anonymous190,
  Anonymous125,
  Anonymous372,
  Anonymous423,
  Anonymous316,
  Anonymous062,
  Anonymous152,
  Anonymous012,
  Anonymous365,
  Anonymous137,
  Anonymous223,
  Anonymous411,
  Anonymous032,
  Anonymous428,
  Anonymous002,
  Anonymous297,
  DBusHandlerApp,
  Anonymous315,
  History,
  Anonymous310,
  Anonymous318,
  Anonymous038,
  Anonymous060,
  Anonymous259,
  Anonymous408,
  Anonymous191,
  Anonymous142,
  Anonymous404,
  Anonymous309,
  Anonymous004,
  Anonymous430,
  Anonymous355,
  Anonymous074,
  Anonymous198,
  Anonymous214,
  Anonymous233,
  Anonymous342,
  Anonymous090,
  Anonymous228,
  Anonymous129,
  Anonymous029,
  Anonymous146,
  Anonymous019,
  Anonymous324,
  Anonymous027,
  Anonymous417,
  Anonymous175,
  Anonymous238,
  Anonymous399,
  Anonymous103,
  StreamTransport,
  Anonymous010,
  Anonymous247,
  Anonymous195,
  Anonymous388,
  Anonymous437,
  Anonymous153,
  Anonymous377,
  Anonymous212,
  Anonymous110,
  Anonymous406,
  Anonymous018,
  Anonymous245,
  Anonymous194,
  Anonymous088,
  Anonymous058,
  Anonymous052,
  Anonymous303,
  Anonymous157,
  Anonymous306,
  Anonymous333,
  Anonymous124,
  Anonymous323,
  Anonymous412,
  Anonymous400,
  Anonymous237,
  Anonymous094,
  Anonymous429,
  Anonymous042,
  Anonymous114,
  Anonymous025,
  Anonymous244,
  Anonymous109,
  DocLoader,
  Anonymous013,
  Anonymous300,
  Anonymous383,
  Anonymous235,
  Anonymous352,
  Anonymous061,
  Anonymous163,
  LoginReputation,
  Anonymous263,
  ChromeRegistry,
  Anonymous179,
  Anonymous121,
  Anonymous431,
  Anonymous118,
  Anonymous160,
  Anonymous187,
  Anonymous317,
  Anonymous140,
  Anonymous349,
  Anonymous116,
  Anonymous394,
  Anonymous403,
  ExtensionPolicy,

};

// May be added as a friend function to allow constructing services via
// private constructors and init methods.
nsresult CreateInstanceImpl(ModuleID aID, const nsIID& aIID, void** aResult);

class MOZ_STACK_CLASS StaticModuleHelper : public nsCOMPtr_helper {
 public:
  StaticModuleHelper(ModuleID aId, nsresult* aErrorPtr)
      : mId(aId), mErrorPtr(aErrorPtr) {}

 protected:
  nsresult SetResult(nsresult aRv) const {
    if (mErrorPtr) {
      *mErrorPtr = aRv;
    }
    return aRv;
  }

  ModuleID mId;
  nsresult* mErrorPtr;
};

class MOZ_STACK_CLASS GetServiceHelper final : public StaticModuleHelper {
 public:
  using StaticModuleHelper::StaticModuleHelper;

  nsresult NS_FASTCALL operator()(const nsIID& aIID,
                                  void** aResult) const override;
};

class MOZ_STACK_CLASS CreateInstanceHelper final : public StaticModuleHelper {
 public:
  using StaticModuleHelper::StaticModuleHelper;

  nsresult NS_FASTCALL operator()(const nsIID& aIID,
                                  void** aResult) const override;
};

class Components final {
 public:
  static const nsID& GetCID(ModuleID aID);
};

}  // namespace xpcom

namespace components {

namespace AddonContentPolicy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AddonContentPolicy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AddonContentPolicy, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AddonContentPolicy, aRv};
}
}  // namespace AddonContentPolicy

namespace AlertNotification {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AlertNotification);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AlertNotification, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AlertNotification, aRv};
}
}  // namespace AlertNotification

namespace Alerts {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Alerts);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Alerts, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Alerts, aRv};
}
}  // namespace Alerts

namespace AppStartup {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AppStartup);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AppStartup, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AppStartup, aRv};
}
}  // namespace AppStartup

namespace ApplicationReputation {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ApplicationReputation);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ApplicationReputation, aRv};
}
}  // namespace ApplicationReputation

namespace AsyncShutdown {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AsyncShutdown);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AsyncShutdown, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AsyncShutdown, aRv};
}
}  // namespace AsyncShutdown

namespace CacheStorage {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CacheStorage);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CacheStorage, aRv};
}
}  // namespace CacheStorage

namespace ChromeRegistry {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ChromeRegistry);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ChromeRegistry, aRv};
}
}  // namespace ChromeRegistry

namespace CookieBannerService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CookieBannerService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CookieBannerService, aRv};
}
}  // namespace CookieBannerService

namespace DBusHandlerApp {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DBusHandlerApp);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DBusHandlerApp, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DBusHandlerApp, aRv};
}
}  // namespace DBusHandlerApp

namespace DNS {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DNS);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DNS, aRv};
}
}  // namespace DNS

namespace Directory {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Directory);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Directory, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Directory, aRv};
}
}  // namespace Directory

namespace DocLoader {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DocLoader);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DocLoader, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DocLoader, aRv};
}
}  // namespace DocLoader

namespace DownloadPlatform {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DownloadPlatform);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DownloadPlatform, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DownloadPlatform, aRv};
}
}  // namespace DownloadPlatform

namespace ExtensionPolicy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ExtensionPolicy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExtensionPolicy, aRv};
}
}  // namespace ExtensionPolicy

namespace ExternalProtocolHandler {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ExternalProtocolHandler);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExternalProtocolHandler, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExternalProtocolHandler, aRv};
}
}  // namespace ExternalProtocolHandler

namespace FindService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::FindService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FindService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FindService, aRv};
}
}  // namespace FindService

namespace GfxInfo {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::GfxInfo);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::GfxInfo, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::GfxInfo, aRv};
}
}  // namespace GfxInfo

namespace History {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::History);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::History, aRv};
}
}  // namespace History

namespace HttpActivityDistributor {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::HttpActivityDistributor);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::HttpActivityDistributor, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::HttpActivityDistributor, aRv};
}
}  // namespace HttpActivityDistributor

namespace IO {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IO);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IO, aRv};
}
}  // namespace IO

namespace IdentityCredentialPromptService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IdentityCredentialPromptService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialPromptService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialPromptService, aRv};
}
}  // namespace IdentityCredentialPromptService

namespace IdentityCredentialStorageService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IdentityCredentialStorageService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialStorageService, aRv};
}
}  // namespace IdentityCredentialStorageService

namespace LoginReputation {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::LoginReputation);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::LoginReputation, aRv};
}
}  // namespace LoginReputation

namespace Observer {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Observer);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Observer, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Observer, aRv};
}
}  // namespace Observer

namespace PermissionManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PermissionManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PermissionManager, aRv};
}
}  // namespace PermissionManager

namespace Preferences {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Preferences);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Preferences, aRv};
}
}  // namespace Preferences

namespace Prefetch {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Prefetch);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Prefetch, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Prefetch, aRv};
}
}  // namespace Prefetch

namespace ServiceWorkerManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ServiceWorkerManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ServiceWorkerManager, aRv};
}
}  // namespace ServiceWorkerManager

namespace SocketTransport {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::SocketTransport);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SocketTransport, aRv};
}
}  // namespace SocketTransport

namespace StreamTransport {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::StreamTransport);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamTransport, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamTransport, aRv};
}
}  // namespace StreamTransport

namespace StringBundle {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::StringBundle);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StringBundle, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StringBundle, aRv};
}
}  // namespace StringBundle

namespace ThirdPartyUtil {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ThirdPartyUtil);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ThirdPartyUtil, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ThirdPartyUtil, aRv};
}
}  // namespace ThirdPartyUtil

namespace TypeAheadFind {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::TypeAheadFind);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TypeAheadFind, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TypeAheadFind, aRv};
}
}  // namespace TypeAheadFind

namespace URIFixup {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URIFixup);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URIFixup, aRv};
}
}  // namespace URIFixup

namespace URILoader {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URILoader);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URILoader, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URILoader, aRv};
}
}  // namespace URILoader

namespace URLQueryStringStripper {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URLQueryStringStripper);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URLQueryStringStripper, aRv};
}
}  // namespace URLQueryStringStripper

namespace UUIDGenerator {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UUIDGenerator);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UUIDGenerator, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UUIDGenerator, aRv};
}
}  // namespace UUIDGenerator

namespace UrlClassifierDB {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierDB);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierDB, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierDB, aRv};
}
}  // namespace UrlClassifierDB

namespace UrlClassifierPrefixSet {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet, aRv};
}
}  // namespace UrlClassifierPrefixSet

namespace UrlClassifierStreamUpdater {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater, aRv};
}
}  // namespace UrlClassifierStreamUpdater

namespace UrlClassifierUtils {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierUtils);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierUtils, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierUtils, aRv};
}
}  // namespace UrlClassifierUtils

namespace XULRuntime {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::XULRuntime);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::XULRuntime, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::XULRuntime, aRv};
}
}  // namespace XULRuntime

}  // namespace components

}  // namespace mozilla

#endif
