/* THIS FILE IS AUTOGENERATED FROM DOMParser.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_DOMParserBinding_h
#define mozilla_dom_DOMParserBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"

namespace mozilla {
namespace dom {

class DOMParser;
struct NativePropertyHooks;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class SupportedType : uint8_t {
  Text_html,
  Text_xml,
  Application_xml,
  Application_xhtml_xml,
  Image_svg_xml,
  EndGuard_
};

namespace SupportedTypeValues {
extern const EnumEntry strings[6];

static constexpr size_t Count = 5;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(SupportedType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(SupportedType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace SupportedTypeValues

bool
ToJSValue(JSContext* aCx, SupportedType aArgument, JS::MutableHandle<JS::Value> aValue);


namespace DOMParser_Binding {

  typedef mozilla::dom::DOMParser NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::DOMParser* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::DOMParser,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::DOMParser,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace DOMParser_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_DOMParserBinding_h
