/* THIS FILE IS AUTOGENERATED FROM MediaRecorder.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_MediaRecorderBinding_h
#define mozilla_dom_MediaRecorderBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"

namespace mozilla {
namespace dom {

class MediaRecorder;
struct MediaRecorderOptionsAtoms;
struct NativePropertyHooks;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class RecordingState : uint8_t {
  Inactive,
  Recording,
  Paused,
  EndGuard_
};

namespace RecordingStateValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(RecordingState::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(RecordingState stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace RecordingStateValues

bool
ToJSValue(JSContext* aCx, RecordingState aArgument, JS::MutableHandle<JS::Value> aValue);


struct MediaRecorderOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mAudioBitsPerSecond;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mBitsPerSecond;
  MOZ_INIT_OUTSIDE_CTOR nsString mMimeType;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mVideoBitsPerSecond;

  MediaRecorderOptions();

  explicit inline MediaRecorderOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  MediaRecorderOptions(MediaRecorderOptions&& aOther) = default;

  explicit inline MediaRecorderOptions(const MediaRecorderOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  MediaRecorderOptions&
  operator=(const MediaRecorderOptions& aOther);

  bool
  operator==(const MediaRecorderOptions& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, MediaRecorderOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastMediaRecorderOptions : public MediaRecorderOptions
{
  inline FastMediaRecorderOptions()
    : MediaRecorderOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace MediaRecorder_Binding {

  typedef mozilla::dom::MediaRecorder NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::MediaRecorder* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::MediaRecorder,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::MediaRecorder,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace MediaRecorder_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_MediaRecorderBinding_h
