/* This file was autogenerated by toolkit/crashreporter/generate_crash_reporter_sources.py. DO NOT EDIT */

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef CrashAnnotations_h
#define CrashAnnotations_h

#include <cstddef>
#include <cstdint>

namespace CrashReporter {

// Typed enum representing all crash annotations
enum class Annotation : uint32_t {
  AbortMessage = 0,
  Accessibility = 1,
  AccessibilityClient = 2,
  AccessibilityInProcClient = 3,
  AdapterDeviceID = 4,
  AdapterDriverVendor = 5,
  AdapterDriverVersion = 6,
  AdapterSubsysID = 7,
  AdapterVendorID = 8,
  additional_minidumps = 9,
  Addons = 10,
  Android_Board = 11,
  Android_Brand = 12,
  Android_CPU_ABI = 13,
  Android_CPU_ABI2 = 14,
  Android_Device = 15,
  Android_Display = 16,
  Android_Fingerprint = 17,
  Android_Hardware = 18,
  Android_Manufacturer = 19,
  Android_Model = 20,
  Android_PackageName = 21,
  Android_Version = 22,
  AppInitDLLs = 23,
  ApplicationBuildID = 24,
  AsyncShutdownTimeout = 25,
  AvailablePageFile = 26,
  AvailablePhysicalMemory = 27,
  AvailableSwapMemory = 28,
  AvailableVirtualMemory = 29,
  BackgroundTaskMode = 30,
  BackgroundTaskName = 31,
  BlockedDllList = 32,
  BlocklistInitFailed = 33,
  Breadcrumbs = 34,
  BuildID = 35,
  ContentSandboxCapabilities = 36,
  ContentSandboxCapable = 37,
  ContentSandboxEnabled = 38,
  ContentSandboxLevel = 39,
  ContentSandboxWin32kState = 40,
  CPUMicrocodeVersion = 41,
  CrashTime = 42,
  CycleCollector = 43,
  DesktopEnvironment = 44,
  DeviceResetReason = 45,
  DOMFissionEnabled = 46,
  DOMIPCEnabled = 47,
  DumperError = 48,
  EMCheckCompatibility = 49,
  EventLoopNestingLevel = 50,
  ExperimentalFeatures = 51,
  FontName = 52,
  GMPLibraryPath = 53,
  GMPPlugin = 54,
  GPUProcessLaunchCount = 55,
  GPUProcessStatus = 56,
  GpuSandboxLevel = 57,
  GraphicsCompileShader = 58,
  GraphicsCriticalError = 59,
  GraphicsDrawShader = 60,
  GraphicsNumActiveRenderers = 61,
  GraphicsNumRenderers = 62,
  GraphicsStartupTest = 63,
  Hang = 64,
  HasDeviceTouchScreen = 65,
  HeadlessMode = 66,
  InstallTime = 67,
  ipc_channel_error = 68,
  IpcCreatePipeCloExecErrno = 69,
  IpcCreatePipeFcntlErrno = 70,
  IpcCreatePipeSocketPairErrno = 71,
  IPCFatalErrorMsg = 72,
  IPCFatalErrorProtocol = 73,
  IPCMessageLargeBufferShmemFailureSize = 74,
  IPCMessageName = 75,
  IPCMessageSize = 76,
  IPCReadErrorReason = 77,
  IPCShutdownState = 78,
  IPCSystemError = 79,
  IsGarbageCollecting = 80,
  IsWayland = 81,
  IsWebRenderResourcePathOverridden = 82,
  JavaException = 83,
  JavaStackTrace = 84,
  JSActorMessage = 85,
  JSActorName = 86,
  JSLargeAllocationFailure = 87,
  JSModuleLoadError = 88,
  JSOutOfMemory = 89,
  LastInteractionDuration = 90,
  LastStartupWasCrash = 91,
  LauncherProcessState = 92,
  LinuxUnderMemoryPressure = 93,
  LowPhysicalMemoryEvents = 94,
  MacAvailableMemorySysctl = 95,
  MacMemoryPressure = 96,
  MacMemoryPressureCriticalTime = 97,
  MacMemoryPressureNormalTime = 98,
  MacMemoryPressureSysctl = 99,
  MacMemoryPressureWarningTime = 100,
  MainThreadRunnableName = 101,
  MozCrashReason = 102,
  Notes = 103,
  OOMAllocationSize = 104,
  PHCAllocStack = 105,
  PHCBaseAddress = 106,
  PHCFreeStack = 107,
  PHCKind = 108,
  PHCUsableSize = 109,
  PluginFilename = 110,
  PluginName = 111,
  PluginVersion = 112,
  ProcessType = 113,
  ProductID = 114,
  ProductName = 115,
  ProfilerChildShutdownPhase = 116,
  PurgeablePhysicalMemory = 117,
  QuotaManagerShutdownTimeout = 118,
  QuotaManagerStorageIsNetworkResource = 119,
  RDDProcessStatus = 120,
  ReleaseChannel = 121,
  RemoteType = 122,
  SafeMode = 123,
  SecondsSinceLastCrash = 124,
  ServerURL = 125,
  ShutdownProgress = 126,
  ShutdownReason = 127,
  StartupCacheValid = 128,
  StartupCrash = 129,
  StartupTime = 130,
  StorageConnectionNotClosed = 131,
  SubmittedFrom = 132,
  SystemMemoryUsePercentage = 133,
  TelemetryClientId = 134,
  TelemetryEnvironment = 135,
  TelemetryServerURL = 136,
  TelemetrySessionId = 137,
  TestKey = 138,
  TestUnicode = 139,
  TextureUsage = 140,
  Throttleable = 141,
  TotalPageFile = 142,
  TotalPhysicalMemory = 143,
  TotalVirtualMemory = 144,
  UnknownNetAddrSocketFamily = 145,
  UptimeTS = 146,
  URL = 147,
  URLSegments = 148,
  User32BeforeBlocklist = 149,
  useragent_locale = 150,
  UtilityActorsName = 151,
  UtilityProcessStatus = 152,
  Vendor = 153,
  Version = 154,
  VRProcessStatus = 155,
  WasmLibrarySandboxMallocFailed = 156,
  WindowsErrorReporting = 157,
  WindowsFileDialogErrorCode = 158,
  WindowsPackageFamilyName = 159,
  Winsock_LSP = 160,
  XPCOMSpinEventLoopStack = 161,
  Count = 162
};

// Stringified crash annotation names
const char* const kAnnotationStrings[] = {
  "AbortMessage",
  "Accessibility",
  "AccessibilityClient",
  "AccessibilityInProcClient",
  "AdapterDeviceID",
  "AdapterDriverVendor",
  "AdapterDriverVersion",
  "AdapterSubsysID",
  "AdapterVendorID",
  "additional_minidumps",
  "Add-ons",
  "Android_Board",
  "Android_Brand",
  "Android_CPU_ABI",
  "Android_CPU_ABI2",
  "Android_Device",
  "Android_Display",
  "Android_Fingerprint",
  "Android_Hardware",
  "Android_Manufacturer",
  "Android_Model",
  "Android_PackageName",
  "Android_Version",
  "AppInitDLLs",
  "ApplicationBuildID",
  "AsyncShutdownTimeout",
  "AvailablePageFile",
  "AvailablePhysicalMemory",
  "AvailableSwapMemory",
  "AvailableVirtualMemory",
  "BackgroundTaskMode",
  "BackgroundTaskName",
  "BlockedDllList",
  "BlocklistInitFailed",
  "Breadcrumbs",
  "BuildID",
  "ContentSandboxCapabilities",
  "ContentSandboxCapable",
  "ContentSandboxEnabled",
  "ContentSandboxLevel",
  "ContentSandboxWin32kState",
  "CPUMicrocodeVersion",
  "CrashTime",
  "CycleCollector",
  "DesktopEnvironment",
  "DeviceResetReason",
  "DOMFissionEnabled",
  "DOMIPCEnabled",
  "DumperError",
  "EMCheckCompatibility",
  "EventLoopNestingLevel",
  "ExperimentalFeatures",
  "FontName",
  "GMPLibraryPath",
  "GMPPlugin",
  "GPUProcessLaunchCount",
  "GPUProcessStatus",
  "GpuSandboxLevel",
  "GraphicsCompileShader",
  "GraphicsCriticalError",
  "GraphicsDrawShader",
  "GraphicsNumActiveRenderers",
  "GraphicsNumRenderers",
  "GraphicsStartupTest",
  "Hang",
  "HasDeviceTouchScreen",
  "HeadlessMode",
  "InstallTime",
  "ipc_channel_error",
  "IpcCreatePipeCloExecErrno",
  "IpcCreatePipeFcntlErrno",
  "IpcCreatePipeSocketPairErrno",
  "IPCFatalErrorMsg",
  "IPCFatalErrorProtocol",
  "IPCMessageLargeBufferShmemFailureSize",
  "IPCMessageName",
  "IPCMessageSize",
  "IPCReadErrorReason",
  "IPCShutdownState",
  "IPCSystemError",
  "IsGarbageCollecting",
  "IsWayland",
  "IsWebRenderResourcePathOverridden",
  "JavaException",
  "JavaStackTrace",
  "JSActorMessage",
  "JSActorName",
  "JSLargeAllocationFailure",
  "JSModuleLoadError",
  "JSOutOfMemory",
  "LastInteractionDuration",
  "LastStartupWasCrash",
  "LauncherProcessState",
  "LinuxUnderMemoryPressure",
  "LowPhysicalMemoryEvents",
  "MacAvailableMemorySysctl",
  "MacMemoryPressure",
  "MacMemoryPressureCriticalTime",
  "MacMemoryPressureNormalTime",
  "MacMemoryPressureSysctl",
  "MacMemoryPressureWarningTime",
  "MainThreadRunnableName",
  "MozCrashReason",
  "Notes",
  "OOMAllocationSize",
  "PHCAllocStack",
  "PHCBaseAddress",
  "PHCFreeStack",
  "PHCKind",
  "PHCUsableSize",
  "PluginFilename",
  "PluginName",
  "PluginVersion",
  "ProcessType",
  "ProductID",
  "ProductName",
  "ProfilerChildShutdownPhase",
  "PurgeablePhysicalMemory",
  "QuotaManagerShutdownTimeout",
  "QuotaManagerStorageIsNetworkResource",
  "RDDProcessStatus",
  "ReleaseChannel",
  "RemoteType",
  "SafeMode",
  "SecondsSinceLastCrash",
  "ServerURL",
  "ShutdownProgress",
  "ShutdownReason",
  "StartupCacheValid",
  "StartupCrash",
  "StartupTime",
  "StorageConnectionNotClosed",
  "SubmittedFrom",
  "SystemMemoryUsePercentage",
  "TelemetryClientId",
  "TelemetryEnvironment",
  "TelemetryServerURL",
  "TelemetrySessionId",
  "TestKey",
  "TestUnicode",
  "TextureUsage",
  "Throttleable",
  "TotalPageFile",
  "TotalPhysicalMemory",
  "TotalVirtualMemory",
  "UnknownNetAddrSocketFamily",
  "UptimeTS",
  "URL",
  "URLSegments",
  "User32BeforeBlocklist",
  "useragent_locale",
  "UtilityActorsName",
  "UtilityProcessStatus",
  "Vendor",
  "Version",
  "VRProcessStatus",
  "WasmLibrarySandboxMallocFailed",
  "WindowsErrorReporting",
  "WindowsFileDialogErrorCode",
  "WindowsPackageFamilyName",
  "Winsock_LSP",
  "XPCOMSpinEventLoopStack"
};

// Type of each annotation
enum class AnnotationType : uint8_t {
  String = 0,   // Any type of string, const char*, nsCString, etc...
  Boolean = 1,  // Stored as a byte
  U32 = 2,      // C/C++'s uint32_t or Rust's u32
  U64 = 3,      // C/C++'s uint64_t or Rust's u64
  USize = 4,    // C/C++'s size_t or Rust's usize
};

// Type of each annotation
const AnnotationType kAnnotationTypes[] = {
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::USize,
  AnnotationType::USize,
  AnnotationType::USize,
  AnnotationType::USize,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::Boolean,
  AnnotationType::Boolean,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::Boolean,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::USize,
  AnnotationType::USize,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::U32,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::Boolean,
  AnnotationType::Boolean,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U64,
  AnnotationType::Boolean,
  AnnotationType::U32,
  AnnotationType::Boolean,
  AnnotationType::U32,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::USize,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::USize,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::U64,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::Boolean,
  AnnotationType::U64,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::USize,
  AnnotationType::Boolean,
  AnnotationType::USize,
  AnnotationType::USize,
  AnnotationType::USize,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::Boolean,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String
};

// Allowlist of crash annotations that can be included in a crash ping
const Annotation kCrashPingAllowedList[] = {
  Annotation::AsyncShutdownTimeout,
  Annotation::AvailablePageFile,
  Annotation::AvailablePhysicalMemory,
  Annotation::AvailableSwapMemory,
  Annotation::AvailableVirtualMemory,
  Annotation::BackgroundTaskName,
  Annotation::BlockedDllList,
  Annotation::BlocklistInitFailed,
  Annotation::BuildID,
  Annotation::CrashTime,
  Annotation::DOMFissionEnabled,
  Annotation::EventLoopNestingLevel,
  Annotation::ExperimentalFeatures,
  Annotation::FontName,
  Annotation::GPUProcessLaunchCount,
  Annotation::Hang,
  Annotation::HeadlessMode,
  Annotation::ipc_channel_error,
  Annotation::IsGarbageCollecting,
  Annotation::LastInteractionDuration,
  Annotation::LowPhysicalMemoryEvents,
  Annotation::MainThreadRunnableName,
  Annotation::MozCrashReason,
  Annotation::OOMAllocationSize,
  Annotation::ProductID,
  Annotation::ProductName,
  Annotation::ProfilerChildShutdownPhase,
  Annotation::PurgeablePhysicalMemory,
  Annotation::QuotaManagerShutdownTimeout,
  Annotation::ReleaseChannel,
  Annotation::RemoteType,
  Annotation::SecondsSinceLastCrash,
  Annotation::ShutdownProgress,
  Annotation::ShutdownReason,
  Annotation::StartupCrash,
  Annotation::SystemMemoryUsePercentage,
  Annotation::TextureUsage,
  Annotation::TotalPageFile,
  Annotation::TotalPhysicalMemory,
  Annotation::TotalVirtualMemory,
  Annotation::UptimeTS,
  Annotation::User32BeforeBlocklist,
  Annotation::UtilityActorsName,
  Annotation::Version,
  Annotation::WindowsErrorReporting,
  Annotation::WindowsFileDialogErrorCode,
  Annotation::WindowsPackageFamilyName
};

// Annotations which should be skipped when they have specific values
struct AnnotationSkipValue {
  Annotation annotation;
  const char* value;
};

const AnnotationSkipValue kSkipIfList[] = {
  { Annotation::BlocklistInitFailed, "0" },
  { Annotation::EventLoopNestingLevel, "0" },
  { Annotation::IsGarbageCollecting, "0" },
  { Annotation::LowPhysicalMemoryEvents, "0" },
  { Annotation::OOMAllocationSize, "0" },
  { Annotation::TextureUsage, "0" },
  { Annotation::User32BeforeBlocklist, "0" }
};

/**
 * Return the type of a crash annotation.
 *
 * @param aAnnotation a crash annotation
 * @returns The type of this annotation
 */
static inline AnnotationType TypeOfAnnotation(Annotation aAnnotation) {
  return kAnnotationTypes[static_cast<uint32_t>(aAnnotation)];
}

/**
 * Return the string representation of a crash annotation.
 *
 * @param aAnnotation a crash annotation
 * @returns A constant string holding the annotation name
 */
static inline const char* AnnotationToString(Annotation aAnnotation) {
  return kAnnotationStrings[static_cast<uint32_t>(aAnnotation)];
}

/**
 * Converts a string to its corresponding crash annotation.
 *
 * @param aResult a reference where the annotation will be stored
 * @param aValue the string to be converted
 * @return true if the string was successfully converted, false if it did not
 *         correspond to any known annotation
 */
bool AnnotationFromString(Annotation& aResult, const char* aValue);

/**
 * Checks if the given crash annotation is allowed for inclusion in the crash
 * ping.
 *
 * @param aAnnotation the crash annotation to be checked
 * @return true if the annotation can be included in the crash ping, false
 *         otherwise
 */
bool IsAnnotationAllowedForPing(Annotation aAnnotation);

/**
 * Checks if the annotation should be included. Some annotations are skipped if
 * their value matches a specific one (like the value 0).
 *
 * @param aAnnotation the crash annotation to be checked
 * @param aValue the contents of the annotation as a string
 * @return true if the annotation should be included, false otherwise
 */
bool ShouldIncludeAnnotation(Annotation aAnnotation, const char* aValue);

/**
 * Abstract annotation writer, this is needed only for code that writes out
 * annotations in the exception handler.
 */
class AnnotationWriter {
 public:
  virtual void Write(Annotation aAnnotation, const char* aValue,
                     size_t aLen = 0) = 0;
  virtual void Write(Annotation aAnnotation, bool aValue) = 0;
  virtual void Write(Annotation aAnnotation, uint64_t aValue) = 0;
};

#ifdef XP_WIN

extern void RecordDllAnnotations(bool* aBlocklistInitFailed,
                                 bool* aUser32BeforeBlocklist);

#endif  // XP_WIN

}  // namespace CrashReporter

#endif  // CrashAnnotations_h
