#ifndef DOM_UNIONTYPES_H_
#define DOM_UNIONTYPES_H_

#include "js/RootingAPI.h"
#include "js/Value.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/TypedArray.h"
#include "mozilla/dom/UnionMember.h"

class nsGenericHTMLElement;
class nsINode;

namespace mozilla {
namespace dom {

class Blob;
class Directory;
class File;
class FormData;
class HTMLCanvasElement;
class HTMLOptGroupElement;
class HTMLOptionElement;
class OffscreenCanvas;
class OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String;
class OwningFileOrDirectory;
class OwningFileOrUSVStringOrFormData;
class OwningHTMLCanvasElementOrOffscreenCanvas;
class OwningHTMLElementOrLong;
class OwningHTMLOptionElementOrHTMLOptGroupElement;
class OwningNodeOrString;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {
void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningFileOrDirectory& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningFileOrUSVStringOrFormData& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningHTMLCanvasElementOrOffscreenCanvas& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningHTMLElementOrLong& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningHTMLOptionElementOrHTMLOptGroupElement& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningNodeOrString& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionUnlink(OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String& aUnion);

void
ImplCycleCollectionUnlink(OwningFileOrDirectory& aUnion);

void
ImplCycleCollectionUnlink(OwningFileOrUSVStringOrFormData& aUnion);

void
ImplCycleCollectionUnlink(OwningHTMLCanvasElementOrOffscreenCanvas& aUnion);

void
ImplCycleCollectionUnlink(OwningHTMLElementOrLong& aUnion);

void
ImplCycleCollectionUnlink(OwningHTMLOptionElementOrHTMLOptGroupElement& aUnion);

void
ImplCycleCollectionUnlink(OwningNodeOrString& aUnion);

class ArrayBufferViewOrArrayBuffer : public AllUnionBase,
                                     public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<ArrayBufferViewOrArrayBuffer, false, ArrayBufferView, ArrayBuffer>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eArrayBufferView,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eArrayBufferView = TypeOrUninit::eArrayBufferView,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<RootedSpiderMonkeyInterface<ArrayBufferView> > mArrayBufferView;
    UnionMember<RootedSpiderMonkeyInterface<ArrayBuffer> > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  ArrayBufferViewOrArrayBuffer(const ArrayBufferViewOrArrayBuffer&) = delete;
  ArrayBufferViewOrArrayBuffer& operator=(const ArrayBufferViewOrArrayBuffer&) = delete;
public:
  explicit inline ArrayBufferViewOrArrayBuffer()
    : mType(eUninitialized)
  {
  }

  inline ~ArrayBufferViewOrArrayBuffer()
  {
    Uninit();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  RawSetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  SetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    Uninit();
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  RawSetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  SetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    Uninit();
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eArrayBufferView: {
        DestroyArrayBufferView();
        break;
      }
      case eArrayBuffer: {
        DestroyArrayBuffer();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    mValue.mArrayBufferView.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    mValue.mArrayBuffer.Destroy();
    mType = eUninitialized;
  }
};

class ArrayBufferViewOrArrayBufferOrBlobOrUTF8String : public AllUnionBase,
                                                       public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<ArrayBufferViewOrArrayBufferOrBlobOrUTF8String, true, ArrayBufferView, ArrayBuffer>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eArrayBufferView,
    eArrayBuffer,
    eBlob,
    eUTF8String
  };
public:
  enum class Type
  {
    eArrayBufferView = TypeOrUninit::eArrayBufferView,
    eArrayBuffer = TypeOrUninit::eArrayBuffer,
    eBlob = TypeOrUninit::eBlob,
    eUTF8String = TypeOrUninit::eUTF8String
  };

private:
  union Value
  {
    UnionMember<RootedSpiderMonkeyInterface<ArrayBufferView> > mArrayBufferView;
    UnionMember<RootedSpiderMonkeyInterface<ArrayBuffer> > mArrayBuffer;
    UnionMember<NonNull<mozilla::dom::Blob> > mBlob;
    UnionMember<binding_detail::FakeString<char> > mUTF8String;

  };

  TypeOrUninit mType;
  Value mValue;

  ArrayBufferViewOrArrayBufferOrBlobOrUTF8String(const ArrayBufferViewOrArrayBufferOrBlobOrUTF8String&) = delete;
  ArrayBufferViewOrArrayBufferOrBlobOrUTF8String& operator=(const ArrayBufferViewOrArrayBufferOrBlobOrUTF8String&) = delete;
public:
  explicit inline ArrayBufferViewOrArrayBufferOrBlobOrUTF8String()
    : mType(eUninitialized)
  {
  }

  inline ~ArrayBufferViewOrArrayBufferOrBlobOrUTF8String()
  {
    Uninit();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  RawSetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  SetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    Uninit();
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  RawSetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  SetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    Uninit();
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Blob>&
  RawSetAsBlob()
  {
    if (mType == eBlob) {
      return mValue.mBlob.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBlob;
    return mValue.mBlob.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Blob>&
  SetAsBlob()
  {
    if (mType == eBlob) {
      return mValue.mBlob.Value();
    }
    Uninit();
    mType = eBlob;
    return mValue.mBlob.SetValue();
  }

  inline bool
  IsBlob() const
  {
    return mType == eBlob;
  }

  inline NonNull<mozilla::dom::Blob>&
  GetAsBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline mozilla::dom::Blob&
  GetAsBlob() const
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eArrayBufferView: {
        DestroyArrayBufferView();
        break;
      }
      case eArrayBuffer: {
        DestroyArrayBuffer();
        break;
      }
      case eBlob: {
        DestroyBlob();
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    mValue.mArrayBufferView.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    mValue.mArrayBuffer.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToBlob(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToBlob(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    mValue.mBlob.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }
};

class FileOrDirectory : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eFile,
    eDirectory
  };
public:
  enum class Type
  {
    eFile = TypeOrUninit::eFile,
    eDirectory = TypeOrUninit::eDirectory
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::File> > mFile;
    UnionMember<NonNull<mozilla::dom::Directory> > mDirectory;

  };

  TypeOrUninit mType;
  Value mValue;

  FileOrDirectory(const FileOrDirectory&) = delete;
  FileOrDirectory& operator=(const FileOrDirectory&) = delete;
public:
  explicit inline FileOrDirectory()
    : mType(eUninitialized)
  {
  }

  inline ~FileOrDirectory()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::File>&
  RawSetAsFile()
  {
    if (mType == eFile) {
      return mValue.mFile.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eFile;
    return mValue.mFile.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::File>&
  SetAsFile()
  {
    if (mType == eFile) {
      return mValue.mFile.Value();
    }
    Uninit();
    mType = eFile;
    return mValue.mFile.SetValue();
  }

  inline bool
  IsFile() const
  {
    return mType == eFile;
  }

  inline NonNull<mozilla::dom::File>&
  GetAsFile()
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  inline mozilla::dom::File&
  GetAsFile() const
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Directory>&
  RawSetAsDirectory()
  {
    if (mType == eDirectory) {
      return mValue.mDirectory.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDirectory;
    return mValue.mDirectory.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Directory>&
  SetAsDirectory()
  {
    if (mType == eDirectory) {
      return mValue.mDirectory.Value();
    }
    Uninit();
    mType = eDirectory;
    return mValue.mDirectory.SetValue();
  }

  inline bool
  IsDirectory() const
  {
    return mType == eDirectory;
  }

  inline NonNull<mozilla::dom::Directory>&
  GetAsDirectory()
  {
    MOZ_RELEASE_ASSERT(IsDirectory(), "Wrong type!");
    return mValue.mDirectory.Value();
  }

  inline mozilla::dom::Directory&
  GetAsDirectory() const
  {
    MOZ_RELEASE_ASSERT(IsDirectory(), "Wrong type!");
    return mValue.mDirectory.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eFile: {
        DestroyFile();
        break;
      }
      case eDirectory: {
        DestroyDirectory();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToFile(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFile(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyFile()
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    mValue.mFile.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToDirectory(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDirectory(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDirectory()
  {
    MOZ_RELEASE_ASSERT(IsDirectory(), "Wrong type!");
    mValue.mDirectory.Destroy();
    mType = eUninitialized;
  }
};

class FileOrUSVStringOrFormData : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eFile,
    eUSVString,
    eFormData
  };
public:
  enum class Type
  {
    eFile = TypeOrUninit::eFile,
    eUSVString = TypeOrUninit::eUSVString,
    eFormData = TypeOrUninit::eFormData
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::File> > mFile;
    UnionMember<binding_detail::FakeString<char16_t> > mUSVString;
    UnionMember<NonNull<mozilla::dom::FormData> > mFormData;

  };

  TypeOrUninit mType;
  Value mValue;

  FileOrUSVStringOrFormData(const FileOrUSVStringOrFormData&) = delete;
  FileOrUSVStringOrFormData& operator=(const FileOrUSVStringOrFormData&) = delete;
public:
  explicit inline FileOrUSVStringOrFormData()
    : mType(eUninitialized)
  {
  }

  inline ~FileOrUSVStringOrFormData()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::File>&
  RawSetAsFile()
  {
    if (mType == eFile) {
      return mValue.mFile.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eFile;
    return mValue.mFile.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::File>&
  SetAsFile()
  {
    if (mType == eFile) {
      return mValue.mFile.Value();
    }
    Uninit();
    mType = eFile;
    return mValue.mFile.SetValue();
  }

  inline bool
  IsFile() const
  {
    return mType == eFile;
  }

  inline NonNull<mozilla::dom::File>&
  GetAsFile()
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  inline mozilla::dom::File&
  GetAsFile() const
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsUSVString()
  {
    if (mType == eUSVString) {
      return mValue.mUSVString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUSVString;
    return mValue.mUSVString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsUSVString()
  {
    if (mType == eUSVString) {
      return mValue.mUSVString.Value();
    }
    Uninit();
    mType = eUSVString;
    return mValue.mUSVString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsUSVString().AssignLiteral(aData);
  }

  inline bool
  IsUSVString() const
  {
    return mType == eUSVString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline const nsAString&
  GetAsUSVString() const
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::FormData>&
  RawSetAsFormData()
  {
    if (mType == eFormData) {
      return mValue.mFormData.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eFormData;
    return mValue.mFormData.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::FormData>&
  SetAsFormData()
  {
    if (mType == eFormData) {
      return mValue.mFormData.Value();
    }
    Uninit();
    mType = eFormData;
    return mValue.mFormData.SetValue();
  }

  inline bool
  IsFormData() const
  {
    return mType == eFormData;
  }

  inline NonNull<mozilla::dom::FormData>&
  GetAsFormData()
  {
    MOZ_RELEASE_ASSERT(IsFormData(), "Wrong type!");
    return mValue.mFormData.Value();
  }

  inline mozilla::dom::FormData&
  GetAsFormData() const
  {
    MOZ_RELEASE_ASSERT(IsFormData(), "Wrong type!");
    return mValue.mFormData.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eFile: {
        DestroyFile();
        break;
      }
      case eUSVString: {
        DestroyUSVString();
        break;
      }
      case eFormData: {
        DestroyFormData();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToFile(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFile(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyFile()
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    mValue.mFile.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUSVString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    mValue.mUSVString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToFormData(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFormData(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyFormData()
  {
    MOZ_RELEASE_ASSERT(IsFormData(), "Wrong type!");
    mValue.mFormData.Destroy();
    mType = eUninitialized;
  }
};

class HTMLCanvasElementOrOffscreenCanvas : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLCanvasElement,
    eOffscreenCanvas
  };
public:
  enum class Type
  {
    eHTMLCanvasElement = TypeOrUninit::eHTMLCanvasElement,
    eOffscreenCanvas = TypeOrUninit::eOffscreenCanvas
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::HTMLCanvasElement> > mHTMLCanvasElement;
    UnionMember<NonNull<mozilla::dom::OffscreenCanvas> > mOffscreenCanvas;

  };

  TypeOrUninit mType;
  Value mValue;

  HTMLCanvasElementOrOffscreenCanvas(const HTMLCanvasElementOrOffscreenCanvas&) = delete;
  HTMLCanvasElementOrOffscreenCanvas& operator=(const HTMLCanvasElementOrOffscreenCanvas&) = delete;
public:
  explicit inline HTMLCanvasElementOrOffscreenCanvas()
    : mType(eUninitialized)
  {
  }

  inline ~HTMLCanvasElementOrOffscreenCanvas()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::HTMLCanvasElement>&
  RawSetAsHTMLCanvasElement()
  {
    if (mType == eHTMLCanvasElement) {
      return mValue.mHTMLCanvasElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLCanvasElement;
    return mValue.mHTMLCanvasElement.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::HTMLCanvasElement>&
  SetAsHTMLCanvasElement()
  {
    if (mType == eHTMLCanvasElement) {
      return mValue.mHTMLCanvasElement.Value();
    }
    Uninit();
    mType = eHTMLCanvasElement;
    return mValue.mHTMLCanvasElement.SetValue();
  }

  inline bool
  IsHTMLCanvasElement() const
  {
    return mType == eHTMLCanvasElement;
  }

  inline NonNull<mozilla::dom::HTMLCanvasElement>&
  GetAsHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  inline mozilla::dom::HTMLCanvasElement&
  GetAsHTMLCanvasElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::OffscreenCanvas>&
  RawSetAsOffscreenCanvas()
  {
    if (mType == eOffscreenCanvas) {
      return mValue.mOffscreenCanvas.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eOffscreenCanvas;
    return mValue.mOffscreenCanvas.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::OffscreenCanvas>&
  SetAsOffscreenCanvas()
  {
    if (mType == eOffscreenCanvas) {
      return mValue.mOffscreenCanvas.Value();
    }
    Uninit();
    mType = eOffscreenCanvas;
    return mValue.mOffscreenCanvas.SetValue();
  }

  inline bool
  IsOffscreenCanvas() const
  {
    return mType == eOffscreenCanvas;
  }

  inline NonNull<mozilla::dom::OffscreenCanvas>&
  GetAsOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  inline mozilla::dom::OffscreenCanvas&
  GetAsOffscreenCanvas() const
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eHTMLCanvasElement: {
        DestroyHTMLCanvasElement();
        break;
      }
      case eOffscreenCanvas: {
        DestroyOffscreenCanvas();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToHTMLCanvasElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLCanvasElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    mValue.mHTMLCanvasElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToOffscreenCanvas(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToOffscreenCanvas(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    mValue.mOffscreenCanvas.Destroy();
    mType = eUninitialized;
  }
};

class HTMLElementOrLong : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLElement,
    eLong
  };
public:
  enum class Type
  {
    eHTMLElement = TypeOrUninit::eHTMLElement,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<NonNull<nsGenericHTMLElement> > mHTMLElement;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  HTMLElementOrLong(const HTMLElementOrLong&) = delete;
  HTMLElementOrLong& operator=(const HTMLElementOrLong&) = delete;
public:
  explicit inline HTMLElementOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~HTMLElementOrLong()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<nsGenericHTMLElement>&
  RawSetAsHTMLElement()
  {
    if (mType == eHTMLElement) {
      return mValue.mHTMLElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLElement;
    return mValue.mHTMLElement.SetValue();
  }

  [[nodiscard]] inline NonNull<nsGenericHTMLElement>&
  SetAsHTMLElement()
  {
    if (mType == eHTMLElement) {
      return mValue.mHTMLElement.Value();
    }
    Uninit();
    mType = eHTMLElement;
    return mValue.mHTMLElement.SetValue();
  }

  inline bool
  IsHTMLElement() const
  {
    return mType == eHTMLElement;
  }

  inline NonNull<nsGenericHTMLElement>&
  GetAsHTMLElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLElement(), "Wrong type!");
    return mValue.mHTMLElement.Value();
  }

  inline nsGenericHTMLElement&
  GetAsHTMLElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLElement(), "Wrong type!");
    return mValue.mHTMLElement.Value();
  }

  [[nodiscard]] inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  [[nodiscard]] inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eHTMLElement: {
        DestroyHTMLElement();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToHTMLElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLElement(), "Wrong type!");
    mValue.mHTMLElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class HTMLOptionElementOrHTMLOptGroupElement : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLOptionElement,
    eHTMLOptGroupElement
  };
public:
  enum class Type
  {
    eHTMLOptionElement = TypeOrUninit::eHTMLOptionElement,
    eHTMLOptGroupElement = TypeOrUninit::eHTMLOptGroupElement
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::HTMLOptionElement> > mHTMLOptionElement;
    UnionMember<NonNull<mozilla::dom::HTMLOptGroupElement> > mHTMLOptGroupElement;

  };

  TypeOrUninit mType;
  Value mValue;

  HTMLOptionElementOrHTMLOptGroupElement(const HTMLOptionElementOrHTMLOptGroupElement&) = delete;
  HTMLOptionElementOrHTMLOptGroupElement& operator=(const HTMLOptionElementOrHTMLOptGroupElement&) = delete;
public:
  explicit inline HTMLOptionElementOrHTMLOptGroupElement()
    : mType(eUninitialized)
  {
  }

  inline ~HTMLOptionElementOrHTMLOptGroupElement()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::HTMLOptionElement>&
  RawSetAsHTMLOptionElement()
  {
    if (mType == eHTMLOptionElement) {
      return mValue.mHTMLOptionElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLOptionElement;
    return mValue.mHTMLOptionElement.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::HTMLOptionElement>&
  SetAsHTMLOptionElement()
  {
    if (mType == eHTMLOptionElement) {
      return mValue.mHTMLOptionElement.Value();
    }
    Uninit();
    mType = eHTMLOptionElement;
    return mValue.mHTMLOptionElement.SetValue();
  }

  inline bool
  IsHTMLOptionElement() const
  {
    return mType == eHTMLOptionElement;
  }

  inline NonNull<mozilla::dom::HTMLOptionElement>&
  GetAsHTMLOptionElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptionElement(), "Wrong type!");
    return mValue.mHTMLOptionElement.Value();
  }

  inline mozilla::dom::HTMLOptionElement&
  GetAsHTMLOptionElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptionElement(), "Wrong type!");
    return mValue.mHTMLOptionElement.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::HTMLOptGroupElement>&
  RawSetAsHTMLOptGroupElement()
  {
    if (mType == eHTMLOptGroupElement) {
      return mValue.mHTMLOptGroupElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLOptGroupElement;
    return mValue.mHTMLOptGroupElement.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::HTMLOptGroupElement>&
  SetAsHTMLOptGroupElement()
  {
    if (mType == eHTMLOptGroupElement) {
      return mValue.mHTMLOptGroupElement.Value();
    }
    Uninit();
    mType = eHTMLOptGroupElement;
    return mValue.mHTMLOptGroupElement.SetValue();
  }

  inline bool
  IsHTMLOptGroupElement() const
  {
    return mType == eHTMLOptGroupElement;
  }

  inline NonNull<mozilla::dom::HTMLOptGroupElement>&
  GetAsHTMLOptGroupElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptGroupElement(), "Wrong type!");
    return mValue.mHTMLOptGroupElement.Value();
  }

  inline mozilla::dom::HTMLOptGroupElement&
  GetAsHTMLOptGroupElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptGroupElement(), "Wrong type!");
    return mValue.mHTMLOptGroupElement.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eHTMLOptionElement: {
        DestroyHTMLOptionElement();
        break;
      }
      case eHTMLOptGroupElement: {
        DestroyHTMLOptGroupElement();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToHTMLOptionElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLOptionElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLOptionElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptionElement(), "Wrong type!");
    mValue.mHTMLOptionElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToHTMLOptGroupElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLOptGroupElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLOptGroupElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptGroupElement(), "Wrong type!");
    mValue.mHTMLOptGroupElement.Destroy();
    mType = eUninitialized;
  }
};

class MaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer : public AllUnionBase,
                                                           public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<MaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer, false, ArrayBufferView, ArrayBuffer>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eArrayBufferView,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eArrayBufferView = TypeOrUninit::eArrayBufferView,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<RootedSpiderMonkeyInterface<ArrayBufferView> > mArrayBufferView;
    UnionMember<RootedSpiderMonkeyInterface<ArrayBuffer> > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  MaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer(const MaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer&) = delete;
  MaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer& operator=(const MaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer&) = delete;
public:
  explicit inline MaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer()
    : mType(eUninitialized)
  {
  }

  inline ~MaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer()
  {
    Uninit();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  RawSetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  SetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    Uninit();
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  RawSetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  SetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    Uninit();
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eArrayBufferView: {
        DestroyArrayBufferView();
        break;
      }
      case eArrayBuffer: {
        DestroyArrayBuffer();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    mValue.mArrayBufferView.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    mValue.mArrayBuffer.Destroy();
    mType = eUninitialized;
  }
};

class NodeOrString : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eNode,
    eString
  };
public:
  enum class Type
  {
    eNode = TypeOrUninit::eNode,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<NonNull<nsINode> > mNode;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  NodeOrString(const NodeOrString&) = delete;
  NodeOrString& operator=(const NodeOrString&) = delete;
public:
  explicit inline NodeOrString()
    : mType(eUninitialized)
  {
  }

  inline ~NodeOrString()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<nsINode>&
  RawSetAsNode()
  {
    if (mType == eNode) {
      return mValue.mNode.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eNode;
    return mValue.mNode.SetValue();
  }

  [[nodiscard]] inline NonNull<nsINode>&
  SetAsNode()
  {
    if (mType == eNode) {
      return mValue.mNode.Value();
    }
    Uninit();
    mType = eNode;
    return mValue.mNode.SetValue();
  }

  inline bool
  IsNode() const
  {
    return mType == eNode;
  }

  inline NonNull<nsINode>&
  GetAsNode()
  {
    MOZ_RELEASE_ASSERT(IsNode(), "Wrong type!");
    return mValue.mNode.Value();
  }

  inline nsINode&
  GetAsNode() const
  {
    MOZ_RELEASE_ASSERT(IsNode(), "Wrong type!");
    return mValue.mNode.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eNode: {
        DestroyNode();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToNode(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToNode(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyNode()
  {
    MOZ_RELEASE_ASSERT(IsNode(), "Wrong type!");
    mValue.mNode.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};

class StringOrBooleanOrObject : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eBoolean,
    eObject
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eBoolean = TypeOrUninit::eBoolean,
    eObject = TypeOrUninit::eObject
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<bool > mBoolean;
    UnionMember<JS::Rooted<JSObject*> > mObject;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrBooleanOrObject(const StringOrBooleanOrObject&) = delete;
  StringOrBooleanOrObject& operator=(const StringOrBooleanOrObject&) = delete;
public:
  explicit inline StringOrBooleanOrObject()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrBooleanOrObject()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] inline bool&
  RawSetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  [[nodiscard]] inline bool&
  SetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(cx, obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (DOMString or boolean or object)");
      return false;
    }
    return true;
  }

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JS::Rooted<JSObject*>&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject*
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eBoolean: {
        DestroyBoolean();
        break;
      }
      case eObject: {
        DestroyObject();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    mValue.mBoolean.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    mValue.mObject.Destroy();
    mType = eUninitialized;
  }
};

class StringOrStringSequence : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eStringSequence
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eStringSequence = TypeOrUninit::eStringSequence
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<binding_detail::AutoSequence<nsString> > mStringSequence;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrStringSequence(const StringOrStringSequence&) = delete;
  StringOrStringSequence& operator=(const StringOrStringSequence&) = delete;
public:
  explicit inline StringOrStringSequence()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrStringSequence()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] inline binding_detail::AutoSequence<nsString>&
  RawSetAsStringSequence()
  {
    if (mType == eStringSequence) {
      return mValue.mStringSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eStringSequence;
    return mValue.mStringSequence.SetValue();
  }

  [[nodiscard]] inline binding_detail::AutoSequence<nsString>&
  SetAsStringSequence()
  {
    if (mType == eStringSequence) {
      return mValue.mStringSequence.Value();
    }
    Uninit();
    mType = eStringSequence;
    return mValue.mStringSequence.SetValue();
  }

  inline bool
  IsStringSequence() const
  {
    return mType == eStringSequence;
  }

  inline binding_detail::AutoSequence<nsString>&
  GetAsStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline const Sequence<nsString>&
  GetAsStringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eStringSequence: {
        DestroyStringSequence();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToStringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    mValue.mStringSequence.Destroy();
    mType = eUninitialized;
  }
};

class UTF8StringOrUTF8StringSequence : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eUTF8StringSequence
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eUTF8StringSequence = TypeOrUninit::eUTF8StringSequence
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char> > mUTF8String;
    UnionMember<binding_detail::AutoSequence<nsCString> > mUTF8StringSequence;

  };

  TypeOrUninit mType;
  Value mValue;

  UTF8StringOrUTF8StringSequence(const UTF8StringOrUTF8StringSequence&) = delete;
  UTF8StringOrUTF8StringSequence& operator=(const UTF8StringOrUTF8StringSequence&) = delete;
public:
  explicit inline UTF8StringOrUTF8StringSequence()
    : mType(eUninitialized)
  {
  }

  inline ~UTF8StringOrUTF8StringSequence()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  [[nodiscard]] inline binding_detail::AutoSequence<nsCString>&
  RawSetAsUTF8StringSequence()
  {
    if (mType == eUTF8StringSequence) {
      return mValue.mUTF8StringSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8StringSequence;
    return mValue.mUTF8StringSequence.SetValue();
  }

  [[nodiscard]] inline binding_detail::AutoSequence<nsCString>&
  SetAsUTF8StringSequence()
  {
    if (mType == eUTF8StringSequence) {
      return mValue.mUTF8StringSequence.Value();
    }
    Uninit();
    mType = eUTF8StringSequence;
    return mValue.mUTF8StringSequence.SetValue();
  }

  inline bool
  IsUTF8StringSequence() const
  {
    return mType == eUTF8StringSequence;
  }

  inline binding_detail::AutoSequence<nsCString>&
  GetAsUTF8StringSequence()
  {
    MOZ_RELEASE_ASSERT(IsUTF8StringSequence(), "Wrong type!");
    return mValue.mUTF8StringSequence.Value();
  }

  inline const Sequence<nsCString>&
  GetAsUTF8StringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8StringSequence(), "Wrong type!");
    return mValue.mUTF8StringSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
      case eUTF8StringSequence: {
        DestroyUTF8StringSequence();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUTF8StringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToUTF8StringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8StringSequence()
  {
    MOZ_RELEASE_ASSERT(IsUTF8StringSequence(), "Wrong type!");
    mValue.mUTF8StringSequence.Destroy();
    mType = eUninitialized;
  }
};

class OwningArrayBufferViewOrArrayBuffer : public AllOwningUnionBase,
                                           public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<OwningArrayBufferViewOrArrayBuffer, false, ArrayBufferView, ArrayBuffer>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eArrayBufferView,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eArrayBufferView = TypeOrUninit::eArrayBufferView,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<ArrayBufferView > mArrayBufferView;
    UnionMember<ArrayBuffer > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningArrayBufferViewOrArrayBuffer(const OwningArrayBufferViewOrArrayBuffer&) = delete;
  OwningArrayBufferViewOrArrayBuffer& operator=(const OwningArrayBufferViewOrArrayBuffer&) = delete;
public:
  explicit inline OwningArrayBufferViewOrArrayBuffer()
    : mType(eUninitialized)
  {
  }

  OwningArrayBufferViewOrArrayBuffer(OwningArrayBufferViewOrArrayBuffer&& aOther);

  inline ~OwningArrayBufferViewOrArrayBuffer()
  {
    Uninit();
  }

  [[nodiscard]] ArrayBufferView&
  RawSetAsArrayBufferView();

  [[nodiscard]] ArrayBufferView&
  SetAsArrayBufferView();

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline ArrayBufferView&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  [[nodiscard]] ArrayBuffer&
  RawSetAsArrayBuffer();

  [[nodiscard]] ArrayBuffer&
  SetAsArrayBuffer();

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline ArrayBuffer&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningArrayBufferViewOrArrayBuffer&
  operator=(OwningArrayBufferViewOrArrayBuffer&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBufferView();

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBuffer();
};

class OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String : public AllOwningUnionBase,
                                                             public UnionWithTypedArraysBase
{
  friend void ImplCycleCollectionUnlink(OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String& aUnion);
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String, true, ArrayBufferView, ArrayBuffer>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eArrayBufferView,
    eArrayBuffer,
    eBlob,
    eUTF8String
  };
public:
  enum class Type
  {
    eArrayBufferView = TypeOrUninit::eArrayBufferView,
    eArrayBuffer = TypeOrUninit::eArrayBuffer,
    eBlob = TypeOrUninit::eBlob,
    eUTF8String = TypeOrUninit::eUTF8String
  };

private:
  union Value
  {
    UnionMember<ArrayBufferView > mArrayBufferView;
    UnionMember<ArrayBuffer > mArrayBuffer;
    UnionMember<OwningNonNull<mozilla::dom::Blob> > mBlob;
    UnionMember<nsCString > mUTF8String;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String(const OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String&) = delete;
  OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String& operator=(const OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String&) = delete;
public:
  explicit inline OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String()
    : mType(eUninitialized)
  {
  }

  OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String(OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String&& aOther);

  inline ~OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String()
  {
    Uninit();
  }

  [[nodiscard]] ArrayBufferView&
  RawSetAsArrayBufferView();

  [[nodiscard]] ArrayBufferView&
  SetAsArrayBufferView();

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline ArrayBufferView&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  [[nodiscard]] ArrayBuffer&
  RawSetAsArrayBuffer();

  [[nodiscard]] ArrayBuffer&
  SetAsArrayBuffer();

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline ArrayBuffer&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::Blob>&
  RawSetAsBlob();

  [[nodiscard]] OwningNonNull<mozilla::dom::Blob>&
  SetAsBlob();

  inline bool
  IsBlob() const
  {
    return mType == eBlob;
  }

  inline OwningNonNull<mozilla::dom::Blob>&
  GetAsBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline OwningNonNull<mozilla::dom::Blob> const &
  GetAsBlob() const
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  [[nodiscard]] nsCString&
  RawSetAsUTF8String();

  [[nodiscard]] nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String&
  operator=(OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBufferView();

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBuffer();

  bool
  TrySetToBlob(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToBlob(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyBlob();

  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();
};

class OwningFileOrDirectory : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningFileOrDirectory& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eFile,
    eDirectory
  };
public:
  enum class Type
  {
    eFile = TypeOrUninit::eFile,
    eDirectory = TypeOrUninit::eDirectory
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::File> > mFile;
    UnionMember<OwningNonNull<mozilla::dom::Directory> > mDirectory;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningFileOrDirectory()
    : mType(eUninitialized)
  {
  }

  OwningFileOrDirectory(OwningFileOrDirectory&& aOther);

  explicit inline OwningFileOrDirectory(const OwningFileOrDirectory& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningFileOrDirectory()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::File>&
  RawSetAsFile();

  [[nodiscard]] OwningNonNull<mozilla::dom::File>&
  SetAsFile();

  inline bool
  IsFile() const
  {
    return mType == eFile;
  }

  inline OwningNonNull<mozilla::dom::File>&
  GetAsFile()
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  inline OwningNonNull<mozilla::dom::File> const &
  GetAsFile() const
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::Directory>&
  RawSetAsDirectory();

  [[nodiscard]] OwningNonNull<mozilla::dom::Directory>&
  SetAsDirectory();

  inline bool
  IsDirectory() const
  {
    return mType == eDirectory;
  }

  inline OwningNonNull<mozilla::dom::Directory>&
  GetAsDirectory()
  {
    MOZ_RELEASE_ASSERT(IsDirectory(), "Wrong type!");
    return mValue.mDirectory.Value();
  }

  inline OwningNonNull<mozilla::dom::Directory> const &
  GetAsDirectory() const
  {
    MOZ_RELEASE_ASSERT(IsDirectory(), "Wrong type!");
    return mValue.mDirectory.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningFileOrDirectory&
  operator=(OwningFileOrDirectory&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningFileOrDirectory&
  operator=(const OwningFileOrDirectory& aOther);

private:
  bool
  TrySetToFile(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFile(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyFile();

  bool
  TrySetToDirectory(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDirectory(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDirectory();
};

class OwningFileOrUSVStringOrFormData : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningFileOrUSVStringOrFormData& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eFile,
    eUSVString,
    eFormData
  };
public:
  enum class Type
  {
    eFile = TypeOrUninit::eFile,
    eUSVString = TypeOrUninit::eUSVString,
    eFormData = TypeOrUninit::eFormData
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::File> > mFile;
    UnionMember<nsString > mUSVString;
    UnionMember<OwningNonNull<mozilla::dom::FormData> > mFormData;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningFileOrUSVStringOrFormData()
    : mType(eUninitialized)
  {
  }

  OwningFileOrUSVStringOrFormData(OwningFileOrUSVStringOrFormData&& aOther);

  explicit inline OwningFileOrUSVStringOrFormData(const OwningFileOrUSVStringOrFormData& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningFileOrUSVStringOrFormData()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::File>&
  RawSetAsFile();

  [[nodiscard]] OwningNonNull<mozilla::dom::File>&
  SetAsFile();

  inline bool
  IsFile() const
  {
    return mType == eFile;
  }

  inline OwningNonNull<mozilla::dom::File>&
  GetAsFile()
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  inline OwningNonNull<mozilla::dom::File> const &
  GetAsFile() const
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  [[nodiscard]] nsString&
  RawSetAsUSVString();

  [[nodiscard]] nsString&
  SetAsUSVString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsUSVString().AssignLiteral(aData);
  }

  inline bool
  IsUSVString() const
  {
    return mType == eUSVString;
  }

  inline nsString&
  GetAsUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline nsString const &
  GetAsUSVString() const
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::FormData>&
  RawSetAsFormData();

  [[nodiscard]] OwningNonNull<mozilla::dom::FormData>&
  SetAsFormData();

  inline bool
  IsFormData() const
  {
    return mType == eFormData;
  }

  inline OwningNonNull<mozilla::dom::FormData>&
  GetAsFormData()
  {
    MOZ_RELEASE_ASSERT(IsFormData(), "Wrong type!");
    return mValue.mFormData.Value();
  }

  inline OwningNonNull<mozilla::dom::FormData> const &
  GetAsFormData() const
  {
    MOZ_RELEASE_ASSERT(IsFormData(), "Wrong type!");
    return mValue.mFormData.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningFileOrUSVStringOrFormData&
  operator=(OwningFileOrUSVStringOrFormData&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningFileOrUSVStringOrFormData&
  operator=(const OwningFileOrUSVStringOrFormData& aOther);

private:
  bool
  TrySetToFile(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFile(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyFile();

  bool
  TrySetToUSVString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUSVString();

  bool
  TrySetToFormData(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFormData(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyFormData();
};

class OwningHTMLCanvasElementOrOffscreenCanvas : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningHTMLCanvasElementOrOffscreenCanvas& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLCanvasElement,
    eOffscreenCanvas
  };
public:
  enum class Type
  {
    eHTMLCanvasElement = TypeOrUninit::eHTMLCanvasElement,
    eOffscreenCanvas = TypeOrUninit::eOffscreenCanvas
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::HTMLCanvasElement> > mHTMLCanvasElement;
    UnionMember<OwningNonNull<mozilla::dom::OffscreenCanvas> > mOffscreenCanvas;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningHTMLCanvasElementOrOffscreenCanvas()
    : mType(eUninitialized)
  {
  }

  OwningHTMLCanvasElementOrOffscreenCanvas(OwningHTMLCanvasElementOrOffscreenCanvas&& aOther);

  explicit inline OwningHTMLCanvasElementOrOffscreenCanvas(const OwningHTMLCanvasElementOrOffscreenCanvas& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningHTMLCanvasElementOrOffscreenCanvas()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  RawSetAsHTMLCanvasElement();

  [[nodiscard]] OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  SetAsHTMLCanvasElement();

  inline bool
  IsHTMLCanvasElement() const
  {
    return mType == eHTMLCanvasElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  GetAsHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLCanvasElement> const &
  GetAsHTMLCanvasElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::OffscreenCanvas>&
  RawSetAsOffscreenCanvas();

  [[nodiscard]] OwningNonNull<mozilla::dom::OffscreenCanvas>&
  SetAsOffscreenCanvas();

  inline bool
  IsOffscreenCanvas() const
  {
    return mType == eOffscreenCanvas;
  }

  inline OwningNonNull<mozilla::dom::OffscreenCanvas>&
  GetAsOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  inline OwningNonNull<mozilla::dom::OffscreenCanvas> const &
  GetAsOffscreenCanvas() const
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningHTMLCanvasElementOrOffscreenCanvas&
  operator=(OwningHTMLCanvasElementOrOffscreenCanvas&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningHTMLCanvasElementOrOffscreenCanvas&
  operator=(const OwningHTMLCanvasElementOrOffscreenCanvas& aOther);

private:
  bool
  TrySetToHTMLCanvasElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLCanvasElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLCanvasElement();

  bool
  TrySetToOffscreenCanvas(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToOffscreenCanvas(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyOffscreenCanvas();
};

class OwningHTMLElementOrLong : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningHTMLElementOrLong& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLElement,
    eLong
  };
public:
  enum class Type
  {
    eHTMLElement = TypeOrUninit::eHTMLElement,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<nsGenericHTMLElement> > mHTMLElement;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningHTMLElementOrLong()
    : mType(eUninitialized)
  {
  }

  OwningHTMLElementOrLong(OwningHTMLElementOrLong&& aOther);

  explicit inline OwningHTMLElementOrLong(const OwningHTMLElementOrLong& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningHTMLElementOrLong()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<nsGenericHTMLElement>&
  RawSetAsHTMLElement();

  [[nodiscard]] OwningNonNull<nsGenericHTMLElement>&
  SetAsHTMLElement();

  inline bool
  IsHTMLElement() const
  {
    return mType == eHTMLElement;
  }

  inline OwningNonNull<nsGenericHTMLElement>&
  GetAsHTMLElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLElement(), "Wrong type!");
    return mValue.mHTMLElement.Value();
  }

  inline OwningNonNull<nsGenericHTMLElement> const &
  GetAsHTMLElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLElement(), "Wrong type!");
    return mValue.mHTMLElement.Value();
  }

  [[nodiscard]] int32_t&
  RawSetAsLong();

  [[nodiscard]] int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningHTMLElementOrLong&
  operator=(OwningHTMLElementOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningHTMLElementOrLong&
  operator=(const OwningHTMLElementOrLong& aOther);

private:
  bool
  TrySetToHTMLElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLElement();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningHTMLOptionElementOrHTMLOptGroupElement : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningHTMLOptionElementOrHTMLOptGroupElement& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLOptionElement,
    eHTMLOptGroupElement
  };
public:
  enum class Type
  {
    eHTMLOptionElement = TypeOrUninit::eHTMLOptionElement,
    eHTMLOptGroupElement = TypeOrUninit::eHTMLOptGroupElement
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::HTMLOptionElement> > mHTMLOptionElement;
    UnionMember<OwningNonNull<mozilla::dom::HTMLOptGroupElement> > mHTMLOptGroupElement;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningHTMLOptionElementOrHTMLOptGroupElement()
    : mType(eUninitialized)
  {
  }

  OwningHTMLOptionElementOrHTMLOptGroupElement(OwningHTMLOptionElementOrHTMLOptGroupElement&& aOther);

  explicit inline OwningHTMLOptionElementOrHTMLOptGroupElement(const OwningHTMLOptionElementOrHTMLOptGroupElement& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningHTMLOptionElementOrHTMLOptGroupElement()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::HTMLOptionElement>&
  RawSetAsHTMLOptionElement();

  [[nodiscard]] OwningNonNull<mozilla::dom::HTMLOptionElement>&
  SetAsHTMLOptionElement();

  inline bool
  IsHTMLOptionElement() const
  {
    return mType == eHTMLOptionElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLOptionElement>&
  GetAsHTMLOptionElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptionElement(), "Wrong type!");
    return mValue.mHTMLOptionElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLOptionElement> const &
  GetAsHTMLOptionElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptionElement(), "Wrong type!");
    return mValue.mHTMLOptionElement.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::HTMLOptGroupElement>&
  RawSetAsHTMLOptGroupElement();

  [[nodiscard]] OwningNonNull<mozilla::dom::HTMLOptGroupElement>&
  SetAsHTMLOptGroupElement();

  inline bool
  IsHTMLOptGroupElement() const
  {
    return mType == eHTMLOptGroupElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLOptGroupElement>&
  GetAsHTMLOptGroupElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptGroupElement(), "Wrong type!");
    return mValue.mHTMLOptGroupElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLOptGroupElement> const &
  GetAsHTMLOptGroupElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptGroupElement(), "Wrong type!");
    return mValue.mHTMLOptGroupElement.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningHTMLOptionElementOrHTMLOptGroupElement&
  operator=(OwningHTMLOptionElementOrHTMLOptGroupElement&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningHTMLOptionElementOrHTMLOptGroupElement&
  operator=(const OwningHTMLOptionElementOrHTMLOptGroupElement& aOther);

private:
  bool
  TrySetToHTMLOptionElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLOptionElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLOptionElement();

  bool
  TrySetToHTMLOptGroupElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLOptGroupElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLOptGroupElement();
};

class OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer : public AllOwningUnionBase,
                                                                 public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer, false, ArrayBufferView, ArrayBuffer>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eArrayBufferView,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eArrayBufferView = TypeOrUninit::eArrayBufferView,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<ArrayBufferView > mArrayBufferView;
    UnionMember<ArrayBuffer > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer(const OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer&) = delete;
  OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer& operator=(const OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer&) = delete;
public:
  explicit inline OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer()
    : mType(eUninitialized)
  {
  }

  OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer(OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer&& aOther);

  inline ~OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer()
  {
    Uninit();
  }

  [[nodiscard]] ArrayBufferView&
  RawSetAsArrayBufferView();

  [[nodiscard]] ArrayBufferView&
  SetAsArrayBufferView();

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline ArrayBufferView&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  [[nodiscard]] ArrayBuffer&
  RawSetAsArrayBuffer();

  [[nodiscard]] ArrayBuffer&
  SetAsArrayBuffer();

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline ArrayBuffer&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer&
  operator=(OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBufferView();

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBuffer();
};

class OwningNodeOrString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningNodeOrString& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eNode,
    eString
  };
public:
  enum class Type
  {
    eNode = TypeOrUninit::eNode,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<nsINode> > mNode;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningNodeOrString()
    : mType(eUninitialized)
  {
  }

  OwningNodeOrString(OwningNodeOrString&& aOther);

  explicit inline OwningNodeOrString(const OwningNodeOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningNodeOrString()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<nsINode>&
  RawSetAsNode();

  [[nodiscard]] OwningNonNull<nsINode>&
  SetAsNode();

  inline bool
  IsNode() const
  {
    return mType == eNode;
  }

  inline OwningNonNull<nsINode>&
  GetAsNode()
  {
    MOZ_RELEASE_ASSERT(IsNode(), "Wrong type!");
    return mValue.mNode.Value();
  }

  inline OwningNonNull<nsINode> const &
  GetAsNode() const
  {
    MOZ_RELEASE_ASSERT(IsNode(), "Wrong type!");
    return mValue.mNode.Value();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningNodeOrString&
  operator=(OwningNodeOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningNodeOrString&
  operator=(const OwningNodeOrString& aOther);

private:
  bool
  TrySetToNode(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToNode(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyNode();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};

class OwningStringOrBooleanOrObject : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eBoolean,
    eObject
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eBoolean = TypeOrUninit::eBoolean,
    eObject = TypeOrUninit::eObject
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<bool > mBoolean;
    UnionMember<JSObject* > mObject;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningStringOrBooleanOrObject(const OwningStringOrBooleanOrObject&) = delete;
  OwningStringOrBooleanOrObject& operator=(const OwningStringOrBooleanOrObject&) = delete;
public:
  explicit inline OwningStringOrBooleanOrObject()
    : mType(eUninitialized)
  {
  }

  OwningStringOrBooleanOrObject(OwningStringOrBooleanOrObject&& aOther);

  inline ~OwningStringOrBooleanOrObject()
  {
    Uninit();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] bool&
  RawSetAsBoolean();

  [[nodiscard]] bool&
  SetAsBoolean();

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool const &
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (DOMString or boolean or object)");
      return false;
    }
    return true;
  }

  [[nodiscard]] JSObject*&
  RawSetAsObject();

  [[nodiscard]] JSObject*&
  SetAsObject();

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JSObject*&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject* const &
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningStringOrBooleanOrObject&
  operator=(OwningStringOrBooleanOrObject&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyBoolean();

  void
  DestroyObject();
};

class OwningStringOrStringSequence : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eStringSequence
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eStringSequence = TypeOrUninit::eStringSequence
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<Sequence<nsString> > mStringSequence;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningStringOrStringSequence()
    : mType(eUninitialized)
  {
  }

  OwningStringOrStringSequence(OwningStringOrStringSequence&& aOther);

  explicit inline OwningStringOrStringSequence(const OwningStringOrStringSequence& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningStringOrStringSequence()
  {
    Uninit();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] Sequence<nsString>&
  RawSetAsStringSequence();

  [[nodiscard]] Sequence<nsString>&
  SetAsStringSequence();

  inline bool
  IsStringSequence() const
  {
    return mType == eStringSequence;
  }

  inline Sequence<nsString>&
  GetAsStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline Sequence<nsString> const &
  GetAsStringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningStringOrStringSequence&
  operator=(OwningStringOrStringSequence&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningStringOrStringSequence&
  operator=(const OwningStringOrStringSequence& aOther);

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToStringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyStringSequence();
};

class OwningUTF8StringOrUTF8StringSequence : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eUTF8StringSequence
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eUTF8StringSequence = TypeOrUninit::eUTF8StringSequence
  };

private:
  union Value
  {
    UnionMember<nsCString > mUTF8String;
    UnionMember<Sequence<nsCString> > mUTF8StringSequence;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUTF8StringOrUTF8StringSequence()
    : mType(eUninitialized)
  {
  }

  OwningUTF8StringOrUTF8StringSequence(OwningUTF8StringOrUTF8StringSequence&& aOther);

  explicit inline OwningUTF8StringOrUTF8StringSequence(const OwningUTF8StringOrUTF8StringSequence& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUTF8StringOrUTF8StringSequence()
  {
    Uninit();
  }

  [[nodiscard]] nsCString&
  RawSetAsUTF8String();

  [[nodiscard]] nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  [[nodiscard]] Sequence<nsCString>&
  RawSetAsUTF8StringSequence();

  [[nodiscard]] Sequence<nsCString>&
  SetAsUTF8StringSequence();

  inline bool
  IsUTF8StringSequence() const
  {
    return mType == eUTF8StringSequence;
  }

  inline Sequence<nsCString>&
  GetAsUTF8StringSequence()
  {
    MOZ_RELEASE_ASSERT(IsUTF8StringSequence(), "Wrong type!");
    return mValue.mUTF8StringSequence.Value();
  }

  inline Sequence<nsCString> const &
  GetAsUTF8StringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8StringSequence(), "Wrong type!");
    return mValue.mUTF8StringSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningUTF8StringOrUTF8StringSequence&
  operator=(OwningUTF8StringOrUTF8StringSequence&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUTF8StringOrUTF8StringSequence&
  operator=(const OwningUTF8StringOrUTF8StringSequence& aOther);

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();

  bool
  TrySetToUTF8StringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToUTF8StringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8StringSequence();
};
} // namespace mozilla::dom


#endif // DOM_UNIONTYPES_H_
