/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM SpeechSynthesisEvent.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_SPEECHSYNTHESISEVENT_H_
#define DOM_SPEECHSYNTHESISEVENT_H_

#include "mozilla/Attributes.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Event.h"
#include "mozilla/dom/SpeechSynthesisEventBinding.h"

struct JSContext;
namespace mozilla::dom {

class SpeechSynthesisEvent : public Event
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS_INHERITED(SpeechSynthesisEvent, Event)

protected:
  virtual ~SpeechSynthesisEvent();
  explicit SpeechSynthesisEvent(mozilla::dom::EventTarget* aOwner);

  RefPtr<SpeechSynthesisUtterance> mUtterance;
  uint32_t mCharIndex;
  Nullable<uint32_t> mCharLength;
  float mElapsedTime;
  nsString mName;

public:
  SpeechSynthesisEvent* AsSpeechSynthesisEvent() override;

  JSObject* WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  static already_AddRefed<SpeechSynthesisEvent> Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const SpeechSynthesisEventInit& aEventInitDict);

  static already_AddRefed<SpeechSynthesisEvent> Constructor(const GlobalObject& aGlobal, const nsAString& aType, const SpeechSynthesisEventInit& aEventInitDict);

  SpeechSynthesisUtterance* Utterance() const;

  uint32_t CharIndex() const;

  Nullable<uint32_t> GetCharLength() const;

  float ElapsedTime() const;

  void GetName(nsString& aRetVal) const;
};

} // namespace mozilla::dom

#endif // DOM_SPEECHSYNTHESISEVENT_H_
