/* THIS FILE IS AUTOGENERATED FROM URL.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_URLBINDING_H_
#define DOM_URLBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class Blob;
class MediaSource;
struct NativePropertyHooks;
class OwningBlobOrMediaSource;
class ProtoAndIfaceCache;
class URL;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningBlobOrMediaSource& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningBlobOrMediaSource& aUnion);


class BlobOrMediaSource : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eBlob,
    eMediaSource
  };
public:
  enum class Type
  {
    eBlob = TypeOrUninit::eBlob,
    eMediaSource = TypeOrUninit::eMediaSource
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::Blob> > mBlob;
    UnionMember<NonNull<mozilla::dom::MediaSource> > mMediaSource;

  };

  TypeOrUninit mType;
  Value mValue;

  BlobOrMediaSource(const BlobOrMediaSource&) = delete;
  BlobOrMediaSource& operator=(const BlobOrMediaSource&) = delete;
public:
  explicit inline BlobOrMediaSource()
    : mType(eUninitialized)
  {
  }

  inline ~BlobOrMediaSource()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Blob>&
  RawSetAsBlob()
  {
    if (mType == eBlob) {
      return mValue.mBlob.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBlob;
    return mValue.mBlob.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Blob>&
  SetAsBlob()
  {
    if (mType == eBlob) {
      return mValue.mBlob.Value();
    }
    Uninit();
    mType = eBlob;
    return mValue.mBlob.SetValue();
  }

  inline bool
  IsBlob() const
  {
    return mType == eBlob;
  }

  inline NonNull<mozilla::dom::Blob>&
  GetAsBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline mozilla::dom::Blob&
  GetAsBlob() const
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::MediaSource>&
  RawSetAsMediaSource()
  {
    if (mType == eMediaSource) {
      return mValue.mMediaSource.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eMediaSource;
    return mValue.mMediaSource.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::MediaSource>&
  SetAsMediaSource()
  {
    if (mType == eMediaSource) {
      return mValue.mMediaSource.Value();
    }
    Uninit();
    mType = eMediaSource;
    return mValue.mMediaSource.SetValue();
  }

  inline bool
  IsMediaSource() const
  {
    return mType == eMediaSource;
  }

  inline NonNull<mozilla::dom::MediaSource>&
  GetAsMediaSource()
  {
    MOZ_RELEASE_ASSERT(IsMediaSource(), "Wrong type!");
    return mValue.mMediaSource.Value();
  }

  inline mozilla::dom::MediaSource&
  GetAsMediaSource() const
  {
    MOZ_RELEASE_ASSERT(IsMediaSource(), "Wrong type!");
    return mValue.mMediaSource.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eBlob: {
        DestroyBlob();
        break;
      }
      case eMediaSource: {
        DestroyMediaSource();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToBlob(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToBlob(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    mValue.mBlob.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToMediaSource(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToMediaSource(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyMediaSource()
  {
    MOZ_RELEASE_ASSERT(IsMediaSource(), "Wrong type!");
    mValue.mMediaSource.Destroy();
    mType = eUninitialized;
  }
};


class OwningBlobOrMediaSource : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningBlobOrMediaSource& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eBlob,
    eMediaSource
  };
public:
  enum class Type
  {
    eBlob = TypeOrUninit::eBlob,
    eMediaSource = TypeOrUninit::eMediaSource
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::Blob> > mBlob;
    UnionMember<OwningNonNull<mozilla::dom::MediaSource> > mMediaSource;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningBlobOrMediaSource()
    : mType(eUninitialized)
  {
  }

  OwningBlobOrMediaSource(OwningBlobOrMediaSource&& aOther);

  explicit inline OwningBlobOrMediaSource(const OwningBlobOrMediaSource& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningBlobOrMediaSource()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::Blob>&
  RawSetAsBlob();

  [[nodiscard]] OwningNonNull<mozilla::dom::Blob>&
  SetAsBlob();

  inline bool
  IsBlob() const
  {
    return mType == eBlob;
  }

  inline OwningNonNull<mozilla::dom::Blob>&
  GetAsBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline OwningNonNull<mozilla::dom::Blob> const &
  GetAsBlob() const
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::MediaSource>&
  RawSetAsMediaSource();

  [[nodiscard]] OwningNonNull<mozilla::dom::MediaSource>&
  SetAsMediaSource();

  inline bool
  IsMediaSource() const
  {
    return mType == eMediaSource;
  }

  inline OwningNonNull<mozilla::dom::MediaSource>&
  GetAsMediaSource()
  {
    MOZ_RELEASE_ASSERT(IsMediaSource(), "Wrong type!");
    return mValue.mMediaSource.Value();
  }

  inline OwningNonNull<mozilla::dom::MediaSource> const &
  GetAsMediaSource() const
  {
    MOZ_RELEASE_ASSERT(IsMediaSource(), "Wrong type!");
    return mValue.mMediaSource.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningBlobOrMediaSource&
  operator=(OwningBlobOrMediaSource&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningBlobOrMediaSource&
  operator=(const OwningBlobOrMediaSource& aOther);

private:
  bool
  TrySetToBlob(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToBlob(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyBlob();

  bool
  TrySetToMediaSource(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToMediaSource(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyMediaSource();
};


namespace URL_Binding {

  typedef mozilla::dom::URL NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::URL* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::URL,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace URL_Binding



} // namespace mozilla::dom

#endif // DOM_URLBINDING_H_
