#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSS = 858,
  CSS2Properties = 862,
  CSSAnimation = 877,
  CSSConditionRule = 890,
  CSSContainerRule = 907,
  CSSCounterStyleRule = 924,
  CSSCustomPropertyRegisteredEvent = 944,
  CSSFontFaceRule = 977,
  CSSFontFeatureValuesRule = 993,
  CSSFontPaletteValuesRule = 1018,
  CSSGroupingRule = 1043,
  CSSImportRule = 1059,
  CSSKeyframeRule = 1073,
  CSSKeyframesRule = 1089,
  CSSLayerBlockRule = 1106,
  CSSLayerStatementRule = 1124,
  CSSMarginRule = 1146,
  CSSMediaRule = 1160,
  CSSMozDocumentRule = 1173,
  CSSNamespaceRule = 1192,
  CSSPageRule = 1209,
  CSSPropertyRule = 1221,
  CSSPseudoElement = 1237,
  CSSRule = 1254,
  CSSRuleList = 1262,
  CSSScopeRule = 1274,
  CSSStartingStyleRule = 1287,
  CSSStyleDeclaration = 1308,
  CSSStyleRule = 1328,
  CSSStyleSheet = 1341,
  CSSSupportsRule = 1355,
  CSSTransition = 1371,
  Cache = 1385,
  CacheStorage = 1391,
  CallbackDebuggerNotification = 1404,
  CanonicalBrowsingContext = 1433,
  CanvasCaptureMediaStream = 1458,
  CanvasGradient = 1483,
  CanvasPattern = 1498,
  CanvasRenderingContext2D = 1512,
  CaretPosition = 1537,
  CaretStateChangedEvent = 1551,
  ChannelMergerNode = 1574,
  ChannelSplitterNode = 1592,
  ChannelWrapper = 1612,
  CharacterData = 1627,
  CheckerboardReportService = 1641,
  ChildProcessMessageManager = 1667,
  ChildSHistory = 1694,
  ChromeMessageBroadcaster = 1708,
  ChromeMessageSender = 1733,
  ChromeNodeList = 1753,
  ChromeUtils = 1768,
  ChromeWorker = 1780,
  Client = 1793,
  Clients = 1800,
  Clipboard = 1808,
  ClipboardEvent = 1818,
  ClipboardItem = 1833,
  ClonedErrorHolder = 1847,
  CloseEvent = 1865,
  CommandEvent = 1876,
  Comment = 1889,
  CompositionEvent = 1897,
  CompressionStream = 1914,
  ConsoleInstance = 1932,
  ConstantSourceNode = 1948,
  ContentFrameMessageManager = 1967,
  ContentProcessMessageManager = 1994,
  ContentVisibilityAutoStateChangeEvent = 2023,
  ConvolverNode = 2061,
  CountQueuingStrategy = 2075,
  CreateOfferRequest = 2096,
  Credential = 2115,
  CredentialsContainer = 2126,
  Crypto = 2147,
  CryptoKey = 2154,
  CustomElementRegistry = 2164,
  CustomEvent = 2186,
  CustomStateSet = 2198,
  DOMException = 2213,
  DOMImplementation = 2226,
  DOMLocalization = 2244,
  DOMMatrix = 2260,
  DOMMatrixReadOnly = 2270,
  DOMParser = 2288,
  DOMPoint = 2298,
  DOMPointReadOnly = 2307,
  DOMQuad = 2324,
  DOMRect = 2332,
  DOMRectList = 2340,
  DOMRectReadOnly = 2352,
  DOMStringList = 2368,
  DOMStringMap = 2382,
  DOMTokenList = 2395,
  DataTransfer = 2408,
  DataTransferItem = 2421,
  DataTransferItemList = 2438,
  DebuggerNotification = 2459,
  DebuggerNotificationObserver = 2480,
  DecompressionStream = 2509,
  DedicatedWorkerGlobalScope = 2529,
  DelayNode = 2556,
  DeprecationReportBody = 2566,
  DeviceAcceleration = 2588,
  DeviceLightEvent = 2607,
  DeviceMotionEvent = 2624,
  DeviceOrientationEvent = 2642,
  DeviceRotationRate = 2665,
  Directory = 2684,
  Document = 2694,
  DocumentFragment = 2703,
  DocumentL10n = 2720,
  DocumentTimeline = 2733,
  DocumentType = 2750,
  DominatorTree = 2763,
  DragEvent = 2777,
  DynamicsCompressorNode = 2787,
  EXT_blend_minmax = 2810,
  EXT_color_buffer_float = 2827,
  EXT_color_buffer_half_float = 2850,
  EXT_disjoint_timer_query = 2878,
  EXT_float_blend = 2903,
  EXT_frag_depth = 2919,
  EXT_sRGB = 2934,
  EXT_shader_texture_lod = 2943,
  EXT_texture_compression_bptc = 2966,
  EXT_texture_compression_rgtc = 2995,
  EXT_texture_filter_anisotropic = 3024,
  EXT_texture_norm16 = 3055,
  Element = 3074,
  ElementInternals = 3082,
  EncodedAudioChunk = 3099,
  EncodedVideoChunk = 3117,
  ErrorEvent = 3135,
  Event = 3146,
  EventCallbackDebuggerNotification = 3152,
  EventCounts = 3186,
  EventSource = 3198,
  EventTarget = 3210,
  Exception = 3222,
  ExtendableEvent = 3232,
  ExtendableMessageEvent = 3248,
  ExtensionAlarms = 3271,
  ExtensionBrowser = 3287,
  ExtensionBrowserSettings = 3304,
  ExtensionBrowserSettingsColorManagement = 3329,
  ExtensionDns = 3369,
  ExtensionEventManager = 3382,
  ExtensionMockAPI = 3404,
  ExtensionPort = 3421,
  ExtensionProxy = 3435,
  ExtensionRuntime = 3450,
  ExtensionScripting = 3467,
  ExtensionSetting = 3486,
  ExtensionTest = 3503,
  External = 3517,
  FeaturePolicy = 3526,
  FeaturePolicyViolationReportBody = 3540,
  FetchEvent = 3573,
  FetchObserver = 3584,
  File = 3598,
  FileList = 3603,
  FileReader = 3612,
  FileReaderSync = 3623,
  FileSystem = 3638,
  FileSystemDirectoryEntry = 3649,
  FileSystemDirectoryHandle = 3674,
  FileSystemDirectoryHandle_AsyncIterator = 3700,
  FileSystemDirectoryIterator = 3740,
  FileSystemDirectoryReader = 3768,
  FileSystemEntry = 3794,
  FileSystemFileEntry = 3810,
  FileSystemFileHandle = 3830,
  FileSystemHandle = 3851,
  FileSystemSyncAccessHandle = 3868,
  FileSystemWritableFileStream = 3895,
  Flex = 3924,
  FlexItemValues = 3929,
  FlexLineValues = 3944,
  FluentBundle = 3959,
  FluentBundleAsyncIterator = 3972,
  FluentBundleIterator = 3998,
  FluentPattern = 4019,
  FluentResource = 4033,
  FocusEvent = 4048,
  FontFace = 4059,
  FontFaceSet = 4068,
  FontFaceSetIterator = 4080,
  FontFaceSetLoadEvent = 4100,
  FormData = 4121,
  FormData_Iterator = 4130,
  FormDataEvent = 4148,
  FragmentDirective = 4162,
  FrameCrashedEvent = 4180,
  FrameLoader = 4198,
  GPU = 4210,
  GPUAdapter = 4214,
  GPUAdapterInfo = 4225,
  GPUBindGroup = 4240,
  GPUBindGroupLayout = 4253,
  GPUBuffer = 4272,
  GPUBufferUsage = 4282,
  GPUCanvasContext = 4297,
  GPUColorWrite = 4314,
  GPUCommandBuffer = 4328,
  GPUCommandEncoder = 4345,
  GPUCompilationInfo = 4363,
  GPUCompilationMessage = 4382,
  GPUComputePassEncoder = 4404,
  GPUComputePipeline = 4426,
  GPUDevice = 4445,
  GPUDeviceLostInfo = 4455,
  GPUError = 4473,
  GPUInternalError = 4482,
  GPUMapMode = 4499,
  GPUOutOfMemoryError = 4510,
  GPUPipelineLayout = 4530,
  GPUQuerySet = 4548,
  GPUQueue = 4560,
  GPURenderBundle = 4569,
  GPURenderBundleEncoder = 4585,
  GPURenderPassEncoder = 4608,
  GPURenderPipeline = 4629,
  GPUSampler = 4647,
  GPUShaderModule = 4658,
  GPUShaderStage = 4674,
  GPUSupportedFeatures = 4689,
  GPUSupportedLimits = 4710,
  GPUTexture = 4729,
  GPUTextureUsage = 4740,
  GPUTextureView = 4756,
  GPUUncapturedErrorEvent = 4771,
  GPUValidationError = 4795,
  GainNode = 4814,
  Gamepad = 4823,
  GamepadAxisMoveEvent = 4831,
  GamepadButton = 4852,
  GamepadButtonEvent = 4866,
  GamepadEvent = 4885,
  GamepadHapticActuator = 4898,
  GamepadLightIndicator = 4920,
  GamepadPose = 4942,
  GamepadServiceTest = 4954,
  GamepadTouch = 4973,
  Geolocation = 4986,
  GeolocationCoordinates = 4998,
  GeolocationPosition = 5021,
  GeolocationPositionError = 5041,
  GetUserMediaRequest = 5066,
  GleanBoolean = 5086,
  GleanCategory = 5099,
  GleanCounter = 5113,
  GleanCustomDistribution = 5126,
  GleanDatetime = 5150,
  GleanDenominator = 5164,
  GleanEvent = 5181,
  GleanImpl = 5192,
  GleanLabeled = 5202,
  GleanMemoryDistribution = 5215,
  GleanMetric = 5239,
  GleanNumerator = 5251,
  GleanObject = 5266,
  GleanPingsImpl = 5278,
  GleanQuantity = 5293,
  GleanRate = 5307,
  GleanString = 5317,
  GleanStringList = 5329,
  GleanText = 5345,
  GleanTimespan = 5355,
  GleanTimingDistribution = 5369,
  GleanUrl = 5393,
  GleanUuid = 5402,
  Grid = 5412,
  GridArea = 5417,
  GridDimension = 5426,
  GridLine = 5440,
  GridLines = 5449,
  GridTrack = 5459,
  GridTracks = 5469,
  HTMLAllCollection = 5480,
  HTMLAnchorElement = 5498,
  HTMLAreaElement = 5516,
  HTMLAudioElement = 5532,
  HTMLBRElement = 5549,
  HTMLBaseElement = 5563,
  HTMLBodyElement = 5579,
  HTMLButtonElement = 5595,
  HTMLCanvasElement = 5613,
  HTMLCollection = 5631,
  HTMLDListElement = 5646,
  HTMLDataElement = 5663,
  HTMLDataListElement = 5679,
  HTMLDetailsElement = 5699,
  HTMLDialogElement = 5718,
  HTMLDirectoryElement = 5736,
  HTMLDivElement = 5757,
  HTMLDocument = 5772,
  HTMLElement = 5785,
  HTMLEmbedElement = 5797,
  HTMLFieldSetElement = 5814,
  HTMLFontElement = 5834,
  HTMLFormControlsCollection = 5850,
  HTMLFormElement = 5877,
  HTMLFrameElement = 5893,
  HTMLFrameSetElement = 5910,
  HTMLHRElement = 5930,
  HTMLHeadElement = 5944,
  HTMLHeadingElement = 5960,
  HTMLHtmlElement = 5979,
  HTMLIFrameElement = 5995,
  HTMLImageElement = 6013,
  HTMLInputElement = 6030,
  HTMLLIElement = 6047,
  HTMLLabelElement = 6061,
  HTMLLegendElement = 6078,
  HTMLLinkElement = 6096,
  HTMLMapElement = 6112,
  HTMLMarqueeElement = 6127,
  HTMLMediaElement = 6146,
  HTMLMenuElement = 6163,
  HTMLMetaElement = 6179,
  HTMLMeterElement = 6195,
  HTMLModElement = 6212,
  HTMLOListElement = 6227,
  HTMLObjectElement = 6244,
  HTMLOptGroupElement = 6262,
  HTMLOptionElement = 6282,
  HTMLOptionsCollection = 6300,
  HTMLOutputElement = 6322,
  HTMLParagraphElement = 6340,
  HTMLParamElement = 6361,
  HTMLPictureElement = 6378,
  HTMLPreElement = 6397,
  HTMLProgressElement = 6412,
  HTMLQuoteElement = 6432,
  HTMLScriptElement = 6449,
  HTMLSelectElement = 6467,
  HTMLSlotElement = 6485,
  HTMLSourceElement = 6501,
  HTMLSpanElement = 6519,
  HTMLStyleElement = 6535,
  HTMLTableCaptionElement = 6552,
  HTMLTableCellElement = 6576,
  HTMLTableColElement = 6597,
  HTMLTableElement = 6617,
  HTMLTableRowElement = 6634,
  HTMLTableSectionElement = 6654,
  HTMLTemplateElement = 6678,
  HTMLTextAreaElement = 6698,
  HTMLTimeElement = 6718,
  HTMLTitleElement = 6734,
  HTMLTrackElement = 6751,
  HTMLUListElement = 6768,
  HTMLUnknownElement = 6785,
  HTMLVideoElement = 6804,
  HashChangeEvent = 6821,
  Headers = 6837,
  Headers_Iterator = 6845,
  HeapSnapshot = 6862,
  Highlight = 6875,
  HighlightRegistry = 6885,
  History = 6903,
  IDBCursor = 6911,
  IDBCursorWithValue = 6921,
  IDBDatabase = 6940,
  IDBFactory = 6952,
  IDBIndex = 6963,
  IDBKeyRange = 6972,
  IDBObjectStore = 6984,
  IDBOpenDBRequest = 6999,
  IDBRequest = 7016,
  IDBTransaction = 7027,
  IDBVersionChangeEvent = 7042,
  IIRFilterNode = 7064,
  IOUtils = 7078,
  IdentityCredential = 7086,
  IdleDeadline = 7105,
  Image = 7118,
  ImageBitmap = 7124,
  ImageBitmapRenderingContext = 7136,
  ImageCapture = 7164,
  ImageCaptureError = 7177,
  ImageCaptureErrorEvent = 7195,
  ImageData = 7218,
  ImageDocument = 7228,
  InputEvent = 7242,
  InspectorCSSParser = 7253,
  InspectorFontFace = 7272,
  InspectorUtils = 7290,
  InstallTriggerImpl = 7305,
  IntersectionObserver = 7324,
  IntersectionObserverEntry = 7345,
  IntlUtils = 7371,
  InvokeEvent = 7381,
  JSProcessActorChild = 7393,
  JSProcessActorParent = 7413,
  JSWindowActorChild = 7434,
  JSWindowActorParent = 7453,
  KeyEvent = 7473,
  KeyboardEvent = 7482,
  KeyframeEffect = 7496,
  L10nFileSource = 7511,
  L10nOverlays = 7526,
  L10nRegistry = 7539,
  LargestContentfulPaint = 7552,
  LegacyMozTCPSocket = 7575,
  Localization = 7594,
  Location = 7607,
  Lock = 7616,
  LockManager = 7621,
  MIDIAccess = 7633,
  MIDIConnectionEvent = 7644,
  MIDIInput = 7664,
  MIDIInputMap = 7674,
  MIDIMessageEvent = 7687,
  MIDIOutput = 7704,
  MIDIOutputMap = 7715,
  MIDIPort = 7729,
  MOZ_debug = 7738,
  MatchGlob = 7748,
  MatchPattern = 7758,
  MatchPatternSet = 7771,
  MathMLElement = 7787,
  MediaCapabilities = 7801,
  MediaCapabilitiesInfo = 7819,
  MediaControlService = 7841,
  MediaController = 7861,
  MediaDeviceInfo = 7877,
  MediaDevices = 7893,
  MediaElementAudioSourceNode = 7906,
  MediaEncryptedEvent = 7934,
  MediaError = 7954,
  MediaKeyError = 7965,
  MediaKeyMessageEvent = 7979,
  MediaKeySession = 8000,
  MediaKeyStatusMap = 8016,
  MediaKeyStatusMap_Iterator = 8034,
  MediaKeySystemAccess = 8061,
  MediaKeys = 8082,
  MediaList = 8092,
  MediaMetadata = 8102,
  MediaQueryList = 8116,
  MediaQueryListEvent = 8131,
  MediaRecorder = 8151,
  MediaRecorderErrorEvent = 8165,
  MediaSession = 8189,
  MediaSource = 8202,
  MediaStream = 8214,
  MediaStreamAudioDestinationNode = 8226,
  MediaStreamAudioSourceNode = 8258,
  MediaStreamError = 8285,
  MediaStreamEvent = 8302,
  MediaStreamTrack = 8319,
  MediaStreamTrackAudioSourceNode = 8336,
  MediaStreamTrackEvent = 8368,
  MerchantValidationEvent = 8390,
  MessageBroadcaster = 8414,
  MessageChannel = 8433,
  MessageEvent = 8448,
  MessageListenerManager = 8461,
  MessagePort = 8484,
  MessageSender = 8496,
  MimeType = 8510,
  MimeTypeArray = 8519,
  MouseEvent = 8533,
  MouseScrollEvent = 8544,
  MozCanvasPrintState = 8561,
  MozDocumentMatcher = 8581,
  MozDocumentObserver = 8600,
  MozQueryInterface = 8620,
  MozSharedMap = 8638,
  MozSharedMap_Iterator = 8651,
  MozSharedMapChangeEvent = 8673,
  MozStorageAsyncStatementParams = 8697,
  MozStorageStatementParams = 8728,
  MozStorageStatementRow = 8754,
  MozWritableSharedMap = 8777,
  MutationEvent = 8798,
  MutationObserver = 8812,
  MutationRecord = 8829,
  NamedNodeMap = 8844,
  NavigationPreloadManager = 8857,
  Navigator = 8882,
  NetworkInformation = 8892,
  Node = 8911,
  NodeFilter = 8916,
  NodeIterator = 8927,
  NodeList = 8940,
  Notification = 8949,
  NotificationEvent = 8962,
  NotifyPaintEvent = 8980,
  OES_draw_buffers_indexed = 8997,
  OES_element_index_uint = 9022,
  OES_fbo_render_mipmap = 9045,
  OES_standard_derivatives = 9067,
  OES_texture_float = 9092,
  OES_texture_float_linear = 9110,
  OES_texture_half_float = 9135,
  OES_texture_half_float_linear = 9158,
  OES_vertex_array_object = 9188,
  OVR_multiview2 = 9212,
  OfflineAudioCompletionEvent = 9227,
  OfflineAudioContext = 9255,
  OffscreenCanvas = 9275,
  OffscreenCanvasRenderingContext2D = 9291,
  Option = 9325,
  OscillatorNode = 9332,
  PageTransitionEvent = 9347,
  PaintRequest = 9367,
  PaintRequestList = 9380,
  PaintWorkletGlobalScope = 9397,
  PannerNode = 9421,
  ParentProcessMessageManager = 9432,
  Path2D = 9460,
  PathUtils = 9467,
  PaymentAddress = 9477,
  PaymentMethodChangeEvent = 9492,
  PaymentRequest = 9517,
  PaymentRequestUpdateEvent = 9532,
  PaymentResponse = 9558,
  Performance = 9574,
  PerformanceEntry = 9586,
  PerformanceEntryEvent = 9603,
  PerformanceEventTiming = 9625,
  PerformanceMark = 9648,
  PerformanceMeasure = 9664,
  PerformanceNavigation = 9683,
  PerformanceNavigationTiming = 9705,
  PerformanceObserver = 9733,
  PerformanceObserverEntryList = 9753,
  PerformancePaintTiming = 9782,
  PerformanceResourceTiming = 9805,
  PerformanceServerTiming = 9831,
  PerformanceTiming = 9855,
  PeriodicWave = 9873,
  PermissionStatus = 9886,
  Permissions = 9903,
  PlacesBookmark = 9915,
  PlacesBookmarkAddition = 9930,
  PlacesBookmarkChanged = 9953,
  PlacesBookmarkGuid = 9975,
  PlacesBookmarkKeyword = 9994,
  PlacesBookmarkMoved = 10016,
  PlacesBookmarkRemoved = 10036,
  PlacesBookmarkTags = 10058,
  PlacesBookmarkTime = 10077,
  PlacesBookmarkTitle = 10096,
  PlacesBookmarkUrl = 10116,
  PlacesEvent = 10134,
  PlacesEventCounts = 10146,
  PlacesFavicon = 10164,
  PlacesHistoryCleared = 10178,
  PlacesObservers = 10199,
  PlacesPurgeCaches = 10215,
  PlacesRanking = 10233,
  PlacesVisit = 10247,
  PlacesVisitRemoved = 10259,
  PlacesVisitTitle = 10278,
  PlacesWeakCallbackWrapper = 10295,
  Plugin = 10321,
  PluginArray = 10328,
  PluginCrashedEvent = 10340,
  PointerEvent = 10359,
  PopStateEvent = 10372,
  PopupBlockedEvent = 10386,
  PopupPositionedEvent = 10404,
  PositionStateEvent = 10425,
  PrecompiledScript = 10444,
  PrivateAttribution = 10462,
  ProcessMessageManager = 10481,
  ProcessingInstruction = 10503,
  ProgressEvent = 10525,
  PromiseDebugging = 10539,
  PromiseNativeHandler = 10556,
  PromiseRejectionEvent = 10577,
  PublicKeyCredential = 10599,
  PushEvent = 10619,
  PushManager = 10629,
  PushManagerImpl = 10641,
  PushMessageData = 10657,
  PushSubscription = 10673,
  PushSubscriptionOptions = 10690,
  RadioNodeList = 10714,
  Range = 10728,
  ReadableByteStreamController = 10734,
  ReadableStream = 10763,
  ReadableStream_AsyncIterator = 10778,
  ReadableStreamBYOBReader = 10807,
  ReadableStreamBYOBRequest = 10832,
  ReadableStreamDefaultController = 10858,
  ReadableStreamDefaultReader = 10890,
  Report = 10918,
  ReportBody = 10925,
  ReportingObserver = 10936,
  Request = 10954,
  ResizeObserver = 10962,
  ResizeObserverEntry = 10977,
  ResizeObserverSize = 10997,
  Response = 11016,
  SVGAElement = 11025,
  SVGAngle = 11037,
  SVGAnimateElement = 11046,
  SVGAnimateMotionElement = 11064,
  SVGAnimateTransformElement = 11088,
  SVGAnimatedAngle = 11115,
  SVGAnimatedBoolean = 11132,
  SVGAnimatedEnumeration = 11151,
  SVGAnimatedInteger = 11174,
  SVGAnimatedLength = 11193,
  SVGAnimatedLengthList = 11211,
  SVGAnimatedNumber = 11233,
  SVGAnimatedNumberList = 11251,
  SVGAnimatedPreserveAspectRatio = 11273,
  SVGAnimatedRect = 11304,
  SVGAnimatedString = 11320,
  SVGAnimatedTransformList = 11338,
  SVGAnimationElement = 11363,
  SVGCircleElement = 11383,
  SVGClipPathElement = 11400,
  SVGComponentTransferFunctionElement = 11419,
  SVGDefsElement = 11455,
  SVGDescElement = 11470,
  SVGElement = 11485,
  SVGEllipseElement = 11496,
  SVGFEBlendElement = 11514,
  SVGFEColorMatrixElement = 11532,
  SVGFEComponentTransferElement = 11556,
  SVGFECompositeElement = 11586,
  SVGFEConvolveMatrixElement = 11608,
  SVGFEDiffuseLightingElement = 11635,
  SVGFEDisplacementMapElement = 11663,
  SVGFEDistantLightElement = 11691,
  SVGFEDropShadowElement = 11716,
  SVGFEFloodElement = 11739,
  SVGFEFuncAElement = 11757,
  SVGFEFuncBElement = 11775,
  SVGFEFuncGElement = 11793,
  SVGFEFuncRElement = 11811,
  SVGFEGaussianBlurElement = 11829,
  SVGFEImageElement = 11854,
  SVGFEMergeElement = 11872,
  SVGFEMergeNodeElement = 11890,
  SVGFEMorphologyElement = 11912,
  SVGFEOffsetElement = 11935,
  SVGFEPointLightElement = 11954,
  SVGFESpecularLightingElement = 11977,
  SVGFESpotLightElement = 12006,
  SVGFETileElement = 12028,
  SVGFETurbulenceElement = 12045,
  SVGFilterElement = 12068,
  SVGForeignObjectElement = 12085,
  SVGGElement = 12109,
  SVGGeometryElement = 12121,
  SVGGradientElement = 12140,
  SVGGraphicsElement = 12159,
  SVGImageElement = 12178,
  SVGLength = 12194,
  SVGLengthList = 12204,
  SVGLineElement = 12218,
  SVGLinearGradientElement = 12233,
  SVGMPathElement = 12258,
  SVGMarkerElement = 12274,
  SVGMaskElement = 12291,
  SVGMatrix = 12306,
  SVGMetadataElement = 12316,
  SVGNumber = 12335,
  SVGNumberList = 12345,
  SVGPathElement = 12359,
  SVGPathSeg = 12374,
  SVGPathSegArcAbs = 12385,
  SVGPathSegArcRel = 12402,
  SVGPathSegClosePath = 12419,
  SVGPathSegCurvetoCubicAbs = 12439,
  SVGPathSegCurvetoCubicRel = 12465,
  SVGPathSegCurvetoCubicSmoothAbs = 12491,
  SVGPathSegCurvetoCubicSmoothRel = 12523,
  SVGPathSegCurvetoQuadraticAbs = 12555,
  SVGPathSegCurvetoQuadraticRel = 12585,
  SVGPathSegCurvetoQuadraticSmoothAbs = 12615,
  SVGPathSegCurvetoQuadraticSmoothRel = 12651,
  SVGPathSegLinetoAbs = 12687,
  SVGPathSegLinetoHorizontalAbs = 12707,
  SVGPathSegLinetoHorizontalRel = 12737,
  SVGPathSegLinetoRel = 12767,
  SVGPathSegLinetoVerticalAbs = 12787,
  SVGPathSegLinetoVerticalRel = 12815,
  SVGPathSegList = 12843,
  SVGPathSegMovetoAbs = 12858,
  SVGPathSegMovetoRel = 12878,
  SVGPatternElement = 12898,
  SVGPoint = 12916,
  SVGPointList = 12925,
  SVGPolygonElement = 12938,
  SVGPolylineElement = 12956,
  SVGPreserveAspectRatio = 12975,
  SVGRadialGradientElement = 12998,
  SVGRect = 13023,
  SVGRectElement = 13031,
  SVGSVGElement = 13046,
  SVGScriptElement = 13060,
  SVGSetElement = 13077,
  SVGStopElement = 13091,
  SVGStringList = 13106,
  SVGStyleElement = 13120,
  SVGSwitchElement = 13136,
  SVGSymbolElement = 13153,
  SVGTSpanElement = 13170,
  SVGTextContentElement = 13186,
  SVGTextElement = 13208,
  SVGTextPathElement = 13223,
  SVGTextPositioningElement = 13242,
  SVGTitleElement = 13268,
  SVGTransform = 13284,
  SVGTransformList = 13297,
  SVGUnitTypes = 13314,
  SVGUseElement = 13327,
  SVGViewElement = 13341,
  Sanitizer = 13356,
  Scheduler = 13366,
  Screen = 13376,
  ScreenLuminance = 13383,
  ScreenOrientation = 13399,
  ScriptProcessorNode = 13417,
  ScrollAreaEvent = 13437,
  ScrollViewChangeEvent = 13453,
  SecurityPolicyViolationEvent = 13475,
  Selection = 13504,
  ServiceWorker = 13514,
  ServiceWorkerContainer = 13528,
  ServiceWorkerGlobalScope = 13551,
  ServiceWorkerRegistration = 13576,
  SessionStoreFormData = 13602,
  SessionStoreScrollData = 13623,
  SessionStoreUtils = 13646,
  ShadowRealmGlobalScope = 13664,
  ShadowRoot = 13687,
  SharedWorker = 13698,
  SharedWorkerGlobalScope = 13711,
  SimpleGestureEvent = 13735,
  SourceBuffer = 13754,
  SourceBufferList = 13767,
  SpeechGrammar = 13784,
  SpeechGrammarList = 13798,
  SpeechRecognition = 13816,
  SpeechRecognitionAlternative = 13834,
  SpeechRecognitionError = 13863,
  SpeechRecognitionEvent = 13886,
  SpeechRecognitionResult = 13909,
  SpeechRecognitionResultList = 13933,
  SpeechSynthesis = 13961,
  SpeechSynthesisErrorEvent = 13977,
  SpeechSynthesisEvent = 14003,
  SpeechSynthesisUtterance = 14024,
  SpeechSynthesisVoice = 14049,
  StaticRange = 14070,
  StereoPannerNode = 14082,
  Storage = 14099,
  StorageEvent = 14107,
  StorageManager = 14120,
  StreamFilter = 14135,
  StreamFilterDataEvent = 14148,
  StructuredCloneHolder = 14170,
  StructuredCloneTester = 14192,
  StyleSheet = 14214,
  StyleSheetApplicableStateChangeEvent = 14225,
  StyleSheetList = 14262,
  StyleSheetRemovedEvent = 14277,
  SubmitEvent = 14300,
  SubtleCrypto = 14312,
  SyncMessageSender = 14325,
  SyncReadFile = 14343,
  TCPServerSocket = 14356,
  TCPServerSocketEvent = 14372,
  TCPSocket = 14393,
  TCPSocketErrorEvent = 14403,
  TCPSocketEvent = 14423,
  TaskController = 14438,
  TaskPriorityChangeEvent = 14453,
  TaskSignal = 14477,
  TelemetryStopwatch = 14488,
  TestUtils = 14507,
  TestingDeprecatedInterface = 14517,
  Text = 14544,
  TextClause = 14549,
  TextDecoder = 14560,
  TextDecoderStream = 14572,
  TextEncoder = 14590,
  TextEncoderStream = 14602,
  TextEvent = 14620,
  TextMetrics = 14630,
  TextTrack = 14642,
  TextTrackCue = 14652,
  TextTrackCueList = 14665,
  TextTrackList = 14682,
  TimeEvent = 14696,
  TimeRanges = 14706,
  ToggleEvent = 14717,
  Touch = 14729,
  TouchEvent = 14735,
  TouchList = 14746,
  TrackEvent = 14756,
  TransformStream = 14767,
  TransformStreamDefaultController = 14783,
  TransitionEvent = 14816,
  TreeColumn = 14832,
  TreeColumns = 14843,
  TreeContentView = 14855,
  TreeWalker = 14871,
  TrustedHTML = 14882,
  TrustedScript = 14894,
  TrustedScriptURL = 14908,
  TrustedTypePolicy = 14925,
  TrustedTypePolicyFactory = 14943,
  UDPMessageEvent = 14968,
  UDPSocket = 14984,
  UIEvent = 14994,
  URL = 15002,
  URLSearchParams = 15006,
  URLSearchParams_Iterator = 15022,
  UniFFIPointer = 15047,
  UniFFIScaffolding = 15061,
  UserActivation = 15079,
  UserInteraction = 15094,
  UserProximityEvent = 15110,
  VRDisplay = 15129,
  VRDisplayCapabilities = 15139,
  VRDisplayEvent = 15161,
  VREyeParameters = 15176,
  VRFieldOfView = 15192,
  VRFrameData = 15206,
  VRMockController = 15218,
  VRMockDisplay = 15235,
  VRPose = 15249,
  VRServiceTest = 15256,
  VRStageParameters = 15270,
  VTTCue = 15288,
  VTTRegion = 15295,
  ValidityState = 15305,
  VideoColorSpace = 15319,
  VideoDecoder = 15335,
  VideoEncoder = 15348,
  VideoFrame = 15361,
  VideoPlaybackQuality = 15372,
  VideoTrack = 15393,
  VideoTrackList = 15404,
  VisualViewport = 15419,
  WEBGL_color_buffer_float = 15434,
  WEBGL_compressed_texture_astc = 15459,
  WEBGL_compressed_texture_etc = 15489,
  WEBGL_compressed_texture_etc1 = 15518,
  WEBGL_compressed_texture_pvrtc = 15548,
  WEBGL_compressed_texture_s3tc = 15579,
  WEBGL_compressed_texture_s3tc_srgb = 15609,
  WEBGL_debug_renderer_info = 15644,
  WEBGL_debug_shaders = 15670,
  WEBGL_depth_texture = 15690,
  WEBGL_draw_buffers = 15710,
  WEBGL_explicit_present = 15729,
  WEBGL_lose_context = 15752,
  WEBGL_provoking_vertex = 15771,
  WakeLock = 15794,
  WakeLockSentinel = 15803,
  WaveShaperNode = 15820,
  WebExtensionContentScript = 15835,
  WebExtensionPolicy = 15861,
  WebGL2RenderingContext = 15880,
  WebGLActiveInfo = 15903,
  WebGLBuffer = 15919,
  WebGLContextEvent = 15931,
  WebGLFramebuffer = 15949,
  WebGLProgram = 15966,
  WebGLQuery = 15979,
  WebGLRenderbuffer = 15990,
  WebGLRenderingContext = 16008,
  WebGLSampler = 16030,
  WebGLShader = 16043,
  WebGLShaderPrecisionFormat = 16055,
  WebGLSync = 16082,
  WebGLTexture = 16092,
  WebGLTransformFeedback = 16105,
  WebGLUniformLocation = 16128,
  WebGLVertexArrayObject = 16149,
  WebKitCSSMatrix = 16172,
  WebSocket = 16188,
  WebTransport = 16198,
  WebTransportBidirectionalStream = 16211,
  WebTransportDatagramDuplexStream = 16243,
  WebTransportError = 16276,
  WebTransportReceiveStream = 16294,
  WebTransportSendStream = 16320,
  WheelEvent = 16343,
  Window = 16354,
  WindowClient = 16361,
  WindowContext = 16374,
  WindowGlobalChild = 16388,
  WindowGlobalParent = 16406,
  WindowRoot = 16425,
  Worker = 16436,
  WorkerDebuggerGlobalScope = 16443,
  WorkerGlobalScope = 16469,
  WorkerLocation = 16487,
  WorkerNavigator = 16502,
  WorkerTestUtils = 16518,
  Worklet = 16534,
  WorkletGlobalScope = 16542,
  WritableStream = 16561,
  WritableStreamDefaultController = 16576,
  WritableStreamDefaultWriter = 16608,
  XMLDocument = 16636,
  XMLHttpRequest = 16648,
  XMLHttpRequestEventTarget = 16663,
  XMLHttpRequestUpload = 16689,
  XMLSerializer = 16710,
  XPathEvaluator = 16724,
  XPathExpression = 16739,
  XPathResult = 16755,
  XRBoundedReferenceSpace = 16767,
  XRFrame = 16791,
  XRInputSource = 16799,
  XRInputSourceArray = 16813,
  XRInputSourceEvent = 16832,
  XRInputSourcesChangeEvent = 16851,
  XRPose = 16877,
  XRReferenceSpace = 16884,
  XRReferenceSpaceEvent = 16901,
  XRRenderState = 16923,
  XRRigidTransform = 16937,
  XRSession = 16954,
  XRSessionEvent = 16964,
  XRSpace = 16979,
  XRSystem = 16987,
  XRView = 16996,
  XRViewerPose = 17003,
  XRViewport = 17016,
  XRWebGLLayer = 17027,
  XSLTProcessor = 17040,
  XULCommandEvent = 17054,
  XULElement = 17070,
  XULFrameElement = 17081,
  XULMenuElement = 17097,
  XULPopupElement = 17112,
  XULResizerElement = 17128,
  XULTextElement = 17146,
  XULTreeElement = 17161,
  console = 17176,
  webkitSpeechGrammar = 17184,
  webkitSpeechGrammarList = 17204,
  webkitSpeechRecognition = 17228,
  webkitURL = 17252,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
