/* THIS FILE IS AUTOGENERATED FROM WindowOrWorkerGlobalScope.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_WINDOWORWORKERGLOBALSCOPEBINDING_H_
#define DOM_WINDOWORWORKERGLOBALSCOPEBINDING_H_

#include "FunctionBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

struct NativePropertyHooks;
class OwningFunctionOrTrustedScriptOrString;
class ProtoAndIfaceCache;
class TrustedScript;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningFunctionOrTrustedScriptOrString& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningFunctionOrTrustedScriptOrString& aUnion);


class FunctionOrTrustedScriptOrString : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eFunction,
    eTrustedScript,
    eString
  };
public:
  enum class Type
  {
    eFunction = TypeOrUninit::eFunction,
    eTrustedScript = TypeOrUninit::eTrustedScript,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<RootedCallback<OwningNonNull<binding_detail::FastFunction>> > mFunction;
    UnionMember<NonNull<mozilla::dom::TrustedScript> > mTrustedScript;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  FunctionOrTrustedScriptOrString(const FunctionOrTrustedScriptOrString&) = delete;
  FunctionOrTrustedScriptOrString& operator=(const FunctionOrTrustedScriptOrString&) = delete;
public:
  explicit inline FunctionOrTrustedScriptOrString()
    : mType(eUninitialized)
  {
  }

  inline ~FunctionOrTrustedScriptOrString()
  {
    Uninit();
  }

  [[nodiscard]] inline RootedCallback<OwningNonNull<binding_detail::FastFunction>>&
  RawSetAsFunction(JSContext* cx)
  {
    if (mType == eFunction) {
      return mValue.mFunction.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eFunction;
    return mValue.mFunction.SetValue(cx);
  }

  [[nodiscard]] inline RootedCallback<OwningNonNull<binding_detail::FastFunction>>&
  SetAsFunction(JSContext* cx)
  {
    if (mType == eFunction) {
      return mValue.mFunction.Value();
    }
    Uninit();
    mType = eFunction;
    return mValue.mFunction.SetValue(cx);
  }

  inline bool
  IsFunction() const
  {
    return mType == eFunction;
  }

  inline RootedCallback<OwningNonNull<binding_detail::FastFunction>>&
  GetAsFunction()
  {
    MOZ_RELEASE_ASSERT(IsFunction(), "Wrong type!");
    return mValue.mFunction.Value();
  }

  inline Function&
  GetAsFunction() const
  {
    MOZ_RELEASE_ASSERT(IsFunction(), "Wrong type!");
    return mValue.mFunction.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::TrustedScript>&
  RawSetAsTrustedScript()
  {
    if (mType == eTrustedScript) {
      return mValue.mTrustedScript.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eTrustedScript;
    return mValue.mTrustedScript.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::TrustedScript>&
  SetAsTrustedScript()
  {
    if (mType == eTrustedScript) {
      return mValue.mTrustedScript.Value();
    }
    Uninit();
    mType = eTrustedScript;
    return mValue.mTrustedScript.SetValue();
  }

  inline bool
  IsTrustedScript() const
  {
    return mType == eTrustedScript;
  }

  inline NonNull<mozilla::dom::TrustedScript>&
  GetAsTrustedScript()
  {
    MOZ_RELEASE_ASSERT(IsTrustedScript(), "Wrong type!");
    return mValue.mTrustedScript.Value();
  }

  inline mozilla::dom::TrustedScript&
  GetAsTrustedScript() const
  {
    MOZ_RELEASE_ASSERT(IsTrustedScript(), "Wrong type!");
    return mValue.mTrustedScript.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eFunction: {
        DestroyFunction();
        break;
      }
      case eTrustedScript: {
        DestroyTrustedScript();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToFunction(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFunction(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyFunction()
  {
    MOZ_RELEASE_ASSERT(IsFunction(), "Wrong type!");
    mValue.mFunction.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToTrustedScript(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTrustedScript(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyTrustedScript()
  {
    MOZ_RELEASE_ASSERT(IsTrustedScript(), "Wrong type!");
    mValue.mTrustedScript.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};


class OwningFunctionOrTrustedScriptOrString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningFunctionOrTrustedScriptOrString& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eFunction,
    eTrustedScript,
    eString
  };
public:
  enum class Type
  {
    eFunction = TypeOrUninit::eFunction,
    eTrustedScript = TypeOrUninit::eTrustedScript,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<Function> > mFunction;
    UnionMember<OwningNonNull<mozilla::dom::TrustedScript> > mTrustedScript;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningFunctionOrTrustedScriptOrString(const OwningFunctionOrTrustedScriptOrString&) = delete;
  OwningFunctionOrTrustedScriptOrString& operator=(const OwningFunctionOrTrustedScriptOrString&) = delete;
public:
  explicit inline OwningFunctionOrTrustedScriptOrString()
    : mType(eUninitialized)
  {
  }

  OwningFunctionOrTrustedScriptOrString(OwningFunctionOrTrustedScriptOrString&& aOther);

  inline ~OwningFunctionOrTrustedScriptOrString()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<Function>&
  RawSetAsFunction();

  [[nodiscard]] OwningNonNull<Function>&
  SetAsFunction();

  inline bool
  IsFunction() const
  {
    return mType == eFunction;
  }

  inline OwningNonNull<Function>&
  GetAsFunction()
  {
    MOZ_RELEASE_ASSERT(IsFunction(), "Wrong type!");
    return mValue.mFunction.Value();
  }

  inline OwningNonNull<Function> const &
  GetAsFunction() const
  {
    MOZ_RELEASE_ASSERT(IsFunction(), "Wrong type!");
    return mValue.mFunction.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::TrustedScript>&
  RawSetAsTrustedScript();

  [[nodiscard]] OwningNonNull<mozilla::dom::TrustedScript>&
  SetAsTrustedScript();

  inline bool
  IsTrustedScript() const
  {
    return mType == eTrustedScript;
  }

  inline OwningNonNull<mozilla::dom::TrustedScript>&
  GetAsTrustedScript()
  {
    MOZ_RELEASE_ASSERT(IsTrustedScript(), "Wrong type!");
    return mValue.mTrustedScript.Value();
  }

  inline OwningNonNull<mozilla::dom::TrustedScript> const &
  GetAsTrustedScript() const
  {
    MOZ_RELEASE_ASSERT(IsTrustedScript(), "Wrong type!");
    return mValue.mTrustedScript.Value();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningFunctionOrTrustedScriptOrString&
  operator=(OwningFunctionOrTrustedScriptOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToFunction(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFunction(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyFunction();

  bool
  TrySetToTrustedScript(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTrustedScript(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyTrustedScript();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};


} // namespace mozilla::dom

#endif // DOM_WINDOWORWORKERGLOBALSCOPEBINDING_H_
