/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/widget/nsIClipboard.idl
 */

#ifndef __gen_nsIClipboard_h__
#define __gen_nsIClipboard_h__


#include "nsISupports.h"

#include "nsITransferable.h"

#include "nsIClipboardOwner.h"

#include "nsTArray.h"

#include "js/GCAnnotations.h"

#include "mozilla/AlreadyAddRefed.h"
#include "mozilla/Assertions.h"
#include "mozilla/DebugOnly.h"

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIArray; /* forward declaration */

namespace mozilla {
namespace dom {
class WindowContext; /* webidl WindowContext */
} // namespace dom
} // namespace mozilla


/* starting interface:    nsIAsyncSetClipboardData */
#define NS_IASYNCSETCLIPBOARDDATA_IID_STR "801e2318-c8fa-11ed-afa1-0242ac120002"

#define NS_IASYNCSETCLIPBOARDDATA_IID \
  {0x801e2318, 0xc8fa, 0x11ed, \
    { 0xaf, 0xa1, 0x02, 0x42, 0xac, 0x12, 0x00, 0x02 }}

class NS_NO_VTABLE nsIAsyncSetClipboardData : public nsISupports {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_IASYNCSETCLIPBOARDDATA_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIAsyncSetClipboardData;

  /* void setData (in nsITransferable aTransferable, [optional] in nsIClipboardOwner aOwner); */
  NS_IMETHOD SetData(nsITransferable *aTransferable, nsIClipboardOwner *aOwner) = 0;

  /* void abort (in nsresult aReason); */
  NS_IMETHOD Abort(nsresult aReason) = 0;

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIASYNCSETCLIPBOARDDATA \
  NS_IMETHOD SetData(nsITransferable *aTransferable, nsIClipboardOwner *aOwner) override; \
  NS_IMETHOD Abort(nsresult aReason) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIASYNCSETCLIPBOARDDATA \
  nsresult SetData(nsITransferable *aTransferable, nsIClipboardOwner *aOwner); \
  nsresult Abort(nsresult aReason); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIASYNCSETCLIPBOARDDATA(_to) \
  NS_IMETHOD SetData(nsITransferable *aTransferable, nsIClipboardOwner *aOwner) override { return _to SetData(aTransferable, aOwner); } \
  NS_IMETHOD Abort(nsresult aReason) override { return _to Abort(aReason); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIASYNCSETCLIPBOARDDATA(_to) \
  NS_IMETHOD SetData(nsITransferable *aTransferable, nsIClipboardOwner *aOwner) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetData(aTransferable, aOwner); } \
  NS_IMETHOD Abort(nsresult aReason) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Abort(aReason); } 


/* starting interface:    nsIAsyncClipboardRequestCallback */
#define NS_IASYNCCLIPBOARDREQUESTCALLBACK_IID_STR "78f7c18e-c8fa-11ed-afa1-0242ac120002"

#define NS_IASYNCCLIPBOARDREQUESTCALLBACK_IID \
  {0x78f7c18e, 0xc8fa, 0x11ed, \
    { 0xaf, 0xa1, 0x02, 0x42, 0xac, 0x12, 0x00, 0x02 }}

class NS_NO_VTABLE nsIAsyncClipboardRequestCallback : public nsISupports {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_IASYNCCLIPBOARDREQUESTCALLBACK_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIAsyncClipboardRequestCallback;

  /* void onComplete (in nsresult aResult); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD OnComplete(nsresult aResult) = 0;

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIASYNCCLIPBOARDREQUESTCALLBACK \
  NS_IMETHOD OnComplete(nsresult aResult) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIASYNCCLIPBOARDREQUESTCALLBACK \
  nsresult OnComplete(nsresult aResult); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIASYNCCLIPBOARDREQUESTCALLBACK(_to) \
  NS_IMETHOD OnComplete(nsresult aResult) override { return _to OnComplete(aResult); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIASYNCCLIPBOARDREQUESTCALLBACK(_to) \
  NS_IMETHOD OnComplete(nsresult aResult) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OnComplete(aResult); } 


/* starting interface:    nsIClipboardDataSnapshot */
#define NS_ICLIPBOARDDATASNAPSHOT_IID_STR "c18ea2f7-6b6f-4a38-9ab3-a8781fdfcc39"

#define NS_ICLIPBOARDDATASNAPSHOT_IID \
  {0xc18ea2f7, 0x6b6f, 0x4a38, \
    { 0x9a, 0xb3, 0xa8, 0x78, 0x1f, 0xdf, 0xcc, 0x39 }}

class NS_NO_VTABLE nsIClipboardDataSnapshot : public nsISupports {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_ICLIPBOARDDATASNAPSHOT_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIClipboardDataSnapshot;

  /* readonly attribute boolean valid; */
  NS_IMETHOD GetValid(bool *aValid) = 0;

  /* readonly attribute Array<ACString> flavorList; */
  NS_IMETHOD GetFlavorList(nsTArray<nsCString >& aFlavorList) = 0;

  /* void getData (in nsITransferable aTransferable, in nsIAsyncClipboardRequestCallback aCallback); */
  NS_IMETHOD GetData(nsITransferable *aTransferable, nsIAsyncClipboardRequestCallback *aCallback) = 0;

  /* void getDataSync (in nsITransferable aTransferable); */
  NS_IMETHOD GetDataSync(nsITransferable *aTransferable) = 0;

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICLIPBOARDDATASNAPSHOT \
  NS_IMETHOD GetValid(bool *aValid) override; \
  NS_IMETHOD GetFlavorList(nsTArray<nsCString >& aFlavorList) override; \
  NS_IMETHOD GetData(nsITransferable *aTransferable, nsIAsyncClipboardRequestCallback *aCallback) override; \
  NS_IMETHOD GetDataSync(nsITransferable *aTransferable) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSICLIPBOARDDATASNAPSHOT \
  nsresult GetValid(bool *aValid); \
  nsresult GetFlavorList(nsTArray<nsCString >& aFlavorList); \
  nsresult GetData(nsITransferable *aTransferable, nsIAsyncClipboardRequestCallback *aCallback); \
  nsresult GetDataSync(nsITransferable *aTransferable); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICLIPBOARDDATASNAPSHOT(_to) \
  NS_IMETHOD GetValid(bool *aValid) override { return _to GetValid(aValid); } \
  NS_IMETHOD GetFlavorList(nsTArray<nsCString >& aFlavorList) override { return _to GetFlavorList(aFlavorList); } \
  NS_IMETHOD GetData(nsITransferable *aTransferable, nsIAsyncClipboardRequestCallback *aCallback) override { return _to GetData(aTransferable, aCallback); } \
  NS_IMETHOD GetDataSync(nsITransferable *aTransferable) override { return _to GetDataSync(aTransferable); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICLIPBOARDDATASNAPSHOT(_to) \
  NS_IMETHOD GetValid(bool *aValid) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetValid(aValid); } \
  NS_IMETHOD GetFlavorList(nsTArray<nsCString >& aFlavorList) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFlavorList(aFlavorList); } \
  NS_IMETHOD GetData(nsITransferable *aTransferable, nsIAsyncClipboardRequestCallback *aCallback) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetData(aTransferable, aCallback); } \
  NS_IMETHOD GetDataSync(nsITransferable *aTransferable) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDataSync(aTransferable); } 


/* starting interface:    nsIClipboardGetDataSnapshotCallback */
#define NS_ICLIPBOARDGETDATASNAPSHOTCALLBACK_IID_STR "ce23c1c4-58fd-4c33-8579-fa0796d9652c"

#define NS_ICLIPBOARDGETDATASNAPSHOTCALLBACK_IID \
  {0xce23c1c4, 0x58fd, 0x4c33, \
    { 0x85, 0x79, 0xfa, 0x07, 0x96, 0xd9, 0x65, 0x2c }}

class NS_NO_VTABLE nsIClipboardGetDataSnapshotCallback : public nsISupports {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_ICLIPBOARDGETDATASNAPSHOTCALLBACK_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIClipboardGetDataSnapshotCallback;

  /* void onSuccess (in nsIClipboardDataSnapshot aClipboardDataSnapshot); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD OnSuccess(nsIClipboardDataSnapshot *aClipboardDataSnapshot) = 0;

  /* void onError (in nsresult aResult); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD OnError(nsresult aResult) = 0;

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICLIPBOARDGETDATASNAPSHOTCALLBACK \
  NS_IMETHOD OnSuccess(nsIClipboardDataSnapshot *aClipboardDataSnapshot) override; \
  NS_IMETHOD OnError(nsresult aResult) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSICLIPBOARDGETDATASNAPSHOTCALLBACK \
  nsresult OnSuccess(nsIClipboardDataSnapshot *aClipboardDataSnapshot); \
  nsresult OnError(nsresult aResult); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICLIPBOARDGETDATASNAPSHOTCALLBACK(_to) \
  NS_IMETHOD OnSuccess(nsIClipboardDataSnapshot *aClipboardDataSnapshot) override { return _to OnSuccess(aClipboardDataSnapshot); } \
  NS_IMETHOD OnError(nsresult aResult) override { return _to OnError(aResult); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICLIPBOARDGETDATASNAPSHOTCALLBACK(_to) \
  NS_IMETHOD OnSuccess(nsIClipboardDataSnapshot *aClipboardDataSnapshot) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OnSuccess(aClipboardDataSnapshot); } \
  NS_IMETHOD OnError(nsresult aResult) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OnError(aResult); } 


/* starting interface:    nsIClipboard */
#define NS_ICLIPBOARD_IID_STR "ceaa0047-647f-4b8e-ad1c-aff9fa62aa51"

#define NS_ICLIPBOARD_IID \
  {0xceaa0047, 0x647f, 0x4b8e, \
    { 0xad, 0x1c, 0xaf, 0xf9, 0xfa, 0x62, 0xaa, 0x51 }}

class nsIClipboard : public nsISupports {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_ICLIPBOARD_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIClipboard;

  enum ClipboardType : uint32_t {
    kSelectionClipboard = 0,
    kGlobalClipboard = 1,
    kFindClipboard = 2,
    kSelectionCache = 3,
  };

     static const uint32_t kClipboardTypeCount = kSelectionCache + 1;
  /* void setData (in nsITransferable aTransferable, in nsIClipboardOwner anOwner, in nsIClipboard_ClipboardType aWhichClipboard, [optional] in WindowContext aSettingWindowContext); */
  NS_IMETHOD SetData(nsITransferable *aTransferable, nsIClipboardOwner *anOwner, nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aSettingWindowContext) = 0;

  /* nsIAsyncSetClipboardData asyncSetData (in nsIClipboard_ClipboardType aWhichClipboard, [optional] in WindowContext aSettingWindowContext, [optional] in nsIAsyncClipboardRequestCallback aCallback); */
  NS_IMETHOD AsyncSetData(nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aSettingWindowContext, nsIAsyncClipboardRequestCallback *aCallback, nsIAsyncSetClipboardData **_retval) = 0;

  /* void getData (in nsITransferable aTransferable, in nsIClipboard_ClipboardType aWhichClipboard, [optional] in WindowContext aRequestingWindowContext); */
  NS_IMETHOD GetData(nsITransferable *aTransferable, nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aRequestingWindowContext) = 0;

  /* void getDataSnapshot (in Array<ACString> aFlavorList, in nsIClipboard_ClipboardType aWhichClipboard, in WindowContext aRequestingWindowContext, in nsIPrincipal aRequestingPrincipal, in nsIClipboardGetDataSnapshotCallback aCallback); */
  NS_IMETHOD GetDataSnapshot(const nsTArray<nsCString >& aFlavorList, nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aRequestingWindowContext, nsIPrincipal *aRequestingPrincipal, nsIClipboardGetDataSnapshotCallback *aCallback) = 0;

  /* nsIClipboardDataSnapshot getDataSnapshotSync (in Array<ACString> aFlavorList, in nsIClipboard_ClipboardType aWhichClipboard, [optional] in WindowContext aRequestingWindowContext); */
  NS_IMETHOD GetDataSnapshotSync(const nsTArray<nsCString >& aFlavorList, nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aRequestingWindowContext, nsIClipboardDataSnapshot **_retval) = 0;

  /* void emptyClipboard (in nsIClipboard_ClipboardType aWhichClipboard); */
  NS_IMETHOD EmptyClipboard(nsIClipboard::ClipboardType aWhichClipboard) = 0;

  /* boolean hasDataMatchingFlavors (in Array<ACString> aFlavorList, in nsIClipboard_ClipboardType aWhichClipboard); */
  NS_IMETHOD HasDataMatchingFlavors(const nsTArray<nsCString >& aFlavorList, nsIClipboard::ClipboardType aWhichClipboard, bool *_retval) = 0;

  /* [infallible] boolean isClipboardTypeSupported (in nsIClipboard_ClipboardType aWhichClipboard); */
  NS_IMETHOD IsClipboardTypeSupported(nsIClipboard::ClipboardType aWhichClipboard, bool *_retval) = 0;

  inline bool  IsClipboardTypeSupported(nsIClipboard::ClipboardType aWhichClipboard)
  {
    bool result;
    mozilla::DebugOnly<nsresult> rv = IsClipboardTypeSupported(aWhichClipboard, &result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }
};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICLIPBOARD \
  NS_IMETHOD SetData(nsITransferable *aTransferable, nsIClipboardOwner *anOwner, nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aSettingWindowContext) override; \
  NS_IMETHOD AsyncSetData(nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aSettingWindowContext, nsIAsyncClipboardRequestCallback *aCallback, nsIAsyncSetClipboardData **_retval) override; \
  NS_IMETHOD GetData(nsITransferable *aTransferable, nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aRequestingWindowContext) override; \
  NS_IMETHOD GetDataSnapshot(const nsTArray<nsCString >& aFlavorList, nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aRequestingWindowContext, nsIPrincipal *aRequestingPrincipal, nsIClipboardGetDataSnapshotCallback *aCallback) override; \
  NS_IMETHOD GetDataSnapshotSync(const nsTArray<nsCString >& aFlavorList, nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aRequestingWindowContext, nsIClipboardDataSnapshot **_retval) override; \
  NS_IMETHOD EmptyClipboard(nsIClipboard::ClipboardType aWhichClipboard) override; \
  NS_IMETHOD HasDataMatchingFlavors(const nsTArray<nsCString >& aFlavorList, nsIClipboard::ClipboardType aWhichClipboard, bool *_retval) override; \
  NS_IMETHOD IsClipboardTypeSupported(nsIClipboard::ClipboardType aWhichClipboard, bool *_retval) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSICLIPBOARD \
  nsresult SetData(nsITransferable *aTransferable, nsIClipboardOwner *anOwner, nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aSettingWindowContext); \
  nsresult AsyncSetData(nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aSettingWindowContext, nsIAsyncClipboardRequestCallback *aCallback, nsIAsyncSetClipboardData **_retval); \
  nsresult GetData(nsITransferable *aTransferable, nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aRequestingWindowContext); \
  nsresult GetDataSnapshot(const nsTArray<nsCString >& aFlavorList, nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aRequestingWindowContext, nsIPrincipal *aRequestingPrincipal, nsIClipboardGetDataSnapshotCallback *aCallback); \
  nsresult GetDataSnapshotSync(const nsTArray<nsCString >& aFlavorList, nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aRequestingWindowContext, nsIClipboardDataSnapshot **_retval); \
  nsresult EmptyClipboard(nsIClipboard::ClipboardType aWhichClipboard); \
  nsresult HasDataMatchingFlavors(const nsTArray<nsCString >& aFlavorList, nsIClipboard::ClipboardType aWhichClipboard, bool *_retval); \
  nsresult IsClipboardTypeSupported(nsIClipboard::ClipboardType aWhichClipboard, bool *_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICLIPBOARD(_to) \
  NS_IMETHOD SetData(nsITransferable *aTransferable, nsIClipboardOwner *anOwner, nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aSettingWindowContext) override { return _to SetData(aTransferable, anOwner, aWhichClipboard, aSettingWindowContext); } \
  NS_IMETHOD AsyncSetData(nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aSettingWindowContext, nsIAsyncClipboardRequestCallback *aCallback, nsIAsyncSetClipboardData **_retval) override { return _to AsyncSetData(aWhichClipboard, aSettingWindowContext, aCallback, _retval); } \
  NS_IMETHOD GetData(nsITransferable *aTransferable, nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aRequestingWindowContext) override { return _to GetData(aTransferable, aWhichClipboard, aRequestingWindowContext); } \
  NS_IMETHOD GetDataSnapshot(const nsTArray<nsCString >& aFlavorList, nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aRequestingWindowContext, nsIPrincipal *aRequestingPrincipal, nsIClipboardGetDataSnapshotCallback *aCallback) override { return _to GetDataSnapshot(aFlavorList, aWhichClipboard, aRequestingWindowContext, aRequestingPrincipal, aCallback); } \
  NS_IMETHOD GetDataSnapshotSync(const nsTArray<nsCString >& aFlavorList, nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aRequestingWindowContext, nsIClipboardDataSnapshot **_retval) override { return _to GetDataSnapshotSync(aFlavorList, aWhichClipboard, aRequestingWindowContext, _retval); } \
  NS_IMETHOD EmptyClipboard(nsIClipboard::ClipboardType aWhichClipboard) override { return _to EmptyClipboard(aWhichClipboard); } \
  NS_IMETHOD HasDataMatchingFlavors(const nsTArray<nsCString >& aFlavorList, nsIClipboard::ClipboardType aWhichClipboard, bool *_retval) override { return _to HasDataMatchingFlavors(aFlavorList, aWhichClipboard, _retval); } \
  NS_IMETHOD IsClipboardTypeSupported(nsIClipboard::ClipboardType aWhichClipboard, bool *_retval) override { return _to IsClipboardTypeSupported(aWhichClipboard, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICLIPBOARD(_to) \
  NS_IMETHOD SetData(nsITransferable *aTransferable, nsIClipboardOwner *anOwner, nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aSettingWindowContext) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetData(aTransferable, anOwner, aWhichClipboard, aSettingWindowContext); } \
  NS_IMETHOD AsyncSetData(nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aSettingWindowContext, nsIAsyncClipboardRequestCallback *aCallback, nsIAsyncSetClipboardData **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->AsyncSetData(aWhichClipboard, aSettingWindowContext, aCallback, _retval); } \
  NS_IMETHOD GetData(nsITransferable *aTransferable, nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aRequestingWindowContext) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetData(aTransferable, aWhichClipboard, aRequestingWindowContext); } \
  NS_IMETHOD GetDataSnapshot(const nsTArray<nsCString >& aFlavorList, nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aRequestingWindowContext, nsIPrincipal *aRequestingPrincipal, nsIClipboardGetDataSnapshotCallback *aCallback) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDataSnapshot(aFlavorList, aWhichClipboard, aRequestingWindowContext, aRequestingPrincipal, aCallback); } \
  NS_IMETHOD GetDataSnapshotSync(const nsTArray<nsCString >& aFlavorList, nsIClipboard::ClipboardType aWhichClipboard, mozilla::dom::WindowContext *aRequestingWindowContext, nsIClipboardDataSnapshot **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDataSnapshotSync(aFlavorList, aWhichClipboard, aRequestingWindowContext, _retval); } \
  NS_IMETHOD EmptyClipboard(nsIClipboard::ClipboardType aWhichClipboard) override { return !_to ? NS_ERROR_NULL_POINTER : _to->EmptyClipboard(aWhichClipboard); } \
  NS_IMETHOD HasDataMatchingFlavors(const nsTArray<nsCString >& aFlavorList, nsIClipboard::ClipboardType aWhichClipboard, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->HasDataMatchingFlavors(aFlavorList, aWhichClipboard, _retval); } \
  NS_IMETHOD IsClipboardTypeSupported(nsIClipboard::ClipboardType aWhichClipboard, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->IsClipboardTypeSupported(aWhichClipboard, _retval); } 


#endif /* __gen_nsIClipboard_h__ */
