/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef midir_impl_ffi_generated_h
#define midir_impl_ffi_generated_h

/* Generated with cbindgen:0.26.0 */

/* DO NOT MODIFY THIS MANUALLY! This file was generated using cbindgen. See RunCbindgen.py */


#include <cstdarg>
#include <cstdint>
#include <cstdlib>
#include <ostream>
#include <new>
#include "nsStringFwd.h"
#include "nsTArrayForwardDeclare.h"

struct MidirWrapper;

using AddCallback = void(*)(const nsString *id, const nsString *name, bool input);

using RemoveCallback = AddCallback;

#if defined(XP_WIN)
struct GeckoTimeStamp {
  uint64_t gtc;
  uint64_t qpc;
  uint8_t is_null;
  uint8_t has_qpc;
};
#endif

#if !defined(XP_WIN)
struct GeckoTimeStamp {
  uint64_t value;
};
#endif

extern "C" {

/// Create the C++ wrapper that will be used to talk with midir.
///
/// This function will be exposed to C++
///
/// # Safety
///
/// This function deliberately leaks the wrapper because ownership is
/// transfered to the C++ code. Use [midir_impl_shutdown()] to free it.
MidirWrapper *midir_impl_init(AddCallback callback);

/// Refresh the list of ports.
///
/// This function will be exposed to C++
///
/// # Safety
///
/// `wrapper` must be the pointer returned by [midir_impl_init()].
void midir_impl_refresh(MidirWrapper *wrapper,
                        AddCallback add_callback,
                        RemoveCallback remove_callback);

/// Shutdown midir and free the C++ wrapper.
///
/// This function will be exposed to C++
///
/// # Safety
///
/// `wrapper` must be the pointer returned by [midir_impl_init()]. After this
/// has been called the wrapper object will be destoyed and cannot be accessed
/// anymore.
void midir_impl_shutdown(MidirWrapper *wrapper);

/// Open a MIDI port.
///
/// This function will be exposed to C++
///
/// # Safety
///
/// `wrapper` must be the pointer returned by [midir_impl_init()].
bool midir_impl_open_port(MidirWrapper *wrapper,
                          nsString *nsid,
                          GeckoTimeStamp *timestamp,
                          void (*callback)(const nsString *id,
                                           const uint8_t *data,
                                           uintptr_t length,
                                           const GeckoTimeStamp *timestamp,
                                           uint64_t micros));

/// Close a MIDI port.
///
/// This function will be exposed to C++
///
/// # Safety
///
/// `wrapper` must be the pointer returned by [midir_impl_init()].
void midir_impl_close_port(MidirWrapper *wrapper, nsString *id);

/// Send a message over a MIDI output port.
///
/// This function will be exposed to C++
///
/// # Safety
///
/// `wrapper` must be the pointer returned by [midir_impl_init()].
bool midir_impl_send(MidirWrapper *wrapper, const nsAString *id, const nsTArray<uint8_t> *data);

} // extern "C"

#endif // midir_impl_ffi_generated_h
