// -*- mode: C++ -*-

/* This file is auto-generated by run_glean_parser.py.
   It is only for internal use by types in
   toolkit/components/glean/bindings/private */

#include "mozilla/AppShutdown.h"
#include "mozilla/ClearOnShutdown.h"
#include "mozilla/glean/bindings/GleanJSMetricsLookup.h"
#include "mozilla/glean/bindings/jog/JOG.h"
#include "mozilla/Maybe.h"
#include "mozilla/Telemetry.h"
#include "nsIThread.h"
#include "nsThreadUtils.h"

#ifndef mozilla_glean_HistogramGifftMap_h
#define mozilla_glean_HistogramGifftMap_h

#define DYNAMIC_METRIC_BIT (26)
#define GLEAN_METRIC_ID(id) ((id) & ((1ULL << 27) - 1))

namespace mozilla::glean {

using Telemetry::HistogramID;


static Maybe<HistogramID> HistogramIdForMetric(uint32_t aId) {
  switch(aId) {
    case 223: { // performance.interaction.tab_switch_composite
      return Some(HistogramID::FX_TAB_SWITCH_COMPOSITE_E10S_MS);
    }
    case 224: { // performance.interaction.keypress_present_latency
      return Some(HistogramID::KEYPRESS_PRESENT_LATENCY);
    }
    case 225: { // performance.interaction.mouseup_click_present_latency
      return Some(HistogramID::MOUSEUP_FOLLOWED_BY_CLICK_PRESENT_LATENCY);
    }
    case 226: { // performance.page.total_content_page_load
      return Some(HistogramID::TOTAL_CONTENT_PAGE_LOAD_TIME);
    }
    case 227: { // performance.page.non_blank_paint
      return Some(HistogramID::TIME_TO_NON_BLANK_PAINT_MS);
    }
    case 2617: { // javascript.pageload.baseline_compile_time
      return Some(HistogramID::JS_PAGELOAD_BASELINE_COMPILE_MS);
    }
    case 2618: { // javascript.pageload.delazification_time
      return Some(HistogramID::JS_PAGELOAD_DELAZIFICATION_MS);
    }
    case 2619: { // javascript.pageload.execution_time
      return Some(HistogramID::JS_PAGELOAD_EXECUTION_MS);
    }
    case 2620: { // javascript.pageload.gc_time
      return Some(HistogramID::JS_PAGELOAD_GC_MS);
    }
    case 2621: { // javascript.pageload.parse_time
      return Some(HistogramID::JS_PAGELOAD_PARSE_MS);
    }
    case 2622: { // javascript.pageload.protect_time
      return Some(HistogramID::JS_PAGELOAD_PROTECT_MS);
    }
    case 2623: { // javascript.pageload.xdr_encode_time
      return Some(HistogramID::JS_PAGELOAD_XDR_ENCODING_MS);
    }
    case 2624: { // perf.largest_contentful_paint
      return Some(HistogramID::PERF_LARGEST_CONTENTFUL_PAINT_MS);
    }
    case 2625: { // perf.largest_contentful_paint_from_response_start
      return Some(HistogramID::PERF_LARGEST_CONTENTFUL_PAINT_FROM_RESPONSE_START_MS);
    }
    case 2627: { // performance.pageload.fcp
      return Some(HistogramID::PERF_FIRST_CONTENTFUL_PAINT_MS);
    }
    case 2628: { // performance.pageload.fcp_responsestart
      return Some(HistogramID::PERF_FIRST_CONTENTFUL_PAINT_FROM_RESPONSESTART_MS);
    }
    case 2629: { // performance.pageload.load_time
      return Some(HistogramID::PERF_PAGE_LOAD_TIME_MS);
    }
    case 2630: { // performance.pageload.load_time_responsestart
      return Some(HistogramID::PERF_PAGE_LOAD_TIME_FROM_RESPONSESTART_MS);
    }
    case 2632: { // performance.pageload.req_anim_frame_callback
      return Some(HistogramID::PERF_REQUEST_ANIMATION_CALLBACK_PAGELOAD_MS);
    }
    case 2633: { // performance.time.dom_complete
      return Some(HistogramID::TIME_TO_DOM_COMPLETE_MS);
    }
    case 2634: { // performance.time.dom_content_loaded_end
      return Some(HistogramID::TIME_TO_DOM_CONTENT_LOADED_END_MS);
    }
    case 2635: { // performance.time.dom_content_loaded_start
      return Some(HistogramID::TIME_TO_DOM_CONTENT_LOADED_START_MS);
    }
    case 2636: { // performance.time.dom_interactive
      return Some(HistogramID::TIME_TO_DOM_INTERACTIVE_MS);
    }
    case 2637: { // performance.time.load_event_end
      return Some(HistogramID::TIME_TO_LOAD_EVENT_END_MS);
    }
    case 2638: { // performance.time.load_event_start
      return Some(HistogramID::TIME_TO_LOAD_EVENT_START_MS);
    }
    case 2639: { // performance.time.response_start
      return Some(HistogramID::TIME_TO_RESPONSE_START_MS);
    }
    case 2660: { // gfx.composite_time
      return Some(HistogramID::COMPOSITE_TIME);
    }
    case 2661: { // gfx.scroll_present_latency
      return Some(HistogramID::SCROLL_PRESENT_LATENCY);
    }
    case 2671: { // gfx.checkerboard.duration
      return Some(HistogramID::CHECKERBOARD_DURATION);
    }
    case 2672: { // gfx.checkerboard.peak_pixel_count
      return Some(HistogramID::CHECKERBOARD_PEAK);
    }
    case 2673: { // gfx.checkerboard.potential_duration
      return Some(HistogramID::CHECKERBOARD_POTENTIAL_DURATION);
    }
    case 2674: { // gfx.checkerboard.severity
      return Some(HistogramID::CHECKERBOARD_SEVERITY);
    }
    case 2675: { // gfx.content.full_paint_time
      return Some(HistogramID::CONTENT_FULL_PAINT_TIME);
    }
    case 2676: { // gfx.content.paint_time
      return Some(HistogramID::CONTENT_PAINT_TIME);
    }
    case 2677: { // gfx.content.frame_time.from_paint
      return Some(HistogramID::CONTENT_FRAME_TIME);
    }
    case 2678: { // gfx.content.frame_time.from_vsync
      return Some(HistogramID::CONTENT_FRAME_TIME_VSYNC);
    }
    case 2680: { // gfx.content.frame_time.with_svg
      return Some(HistogramID::CONTENT_FRAME_TIME_WITH_SVG);
    }
    case 2681: { // gfx.content.frame_time.without_resource_upload
      return Some(HistogramID::CONTENT_FRAME_TIME_WITHOUT_RESOURCE_UPLOAD);
    }
    case 2682: { // gfx.content.frame_time.without_upload
      return Some(HistogramID::CONTENT_FRAME_TIME_WITHOUT_UPLOAD);
    }
    case 2694: { // paint.build_displaylist_time
      return Some(HistogramID::PAINT_BUILD_DISPLAYLIST_TIME);
    }
    case 2695: { // wr.framebuild_time
      return Some(HistogramID::WR_FRAMEBUILD_TIME);
    }
    case 2696: { // wr.gpu_wait_time
      return Some(HistogramID::WR_GPU_WAIT_TIME);
    }
    case 2697: { // wr.rasterize_blobs_time
      return Some(HistogramID::WR_RASTERIZE_BLOBS_TIME);
    }
    case 2698: { // wr.rasterize_glyphs_time
      return Some(HistogramID::WR_RASTERIZE_GLYPHS_TIME);
    }
    case 2699: { // wr.renderer_time
      return Some(HistogramID::WR_RENDERER_TIME);
    }
    case 2700: { // wr.renderer_time_no_sc
      return Some(HistogramID::WR_RENDERER_TIME_NO_SC_MS);
    }
    case 2701: { // wr.scenebuild_time
      return Some(HistogramID::WR_SCENEBUILD_TIME);
    }
    case 2702: { // wr.sceneswap_time
      return Some(HistogramID::WR_SCENESWAP_TIME);
    }
    case 2703: { // wr.texture_cache_update_time
      return Some(HistogramID::WR_TEXTURE_CACHE_UPDATE_TIME);
    }
    case 2704: { // wr.time_to_frame_build
      return Some(HistogramID::WR_TIME_TO_FRAME_BUILD_MS);
    }
    case 2705: { // wr.time_to_render_start
      return Some(HistogramID::WR_TIME_TO_RENDER_START_MS);
    }
    case 2736: { // performance.responsiveness.req_anim_frame_callback
      return Some(HistogramID::PERF_REQUEST_ANIMATION_CALLBACK_NON_PAGELOAD_MS);
    }
    case 2738: { // geckoview.document_site_origins
      return Some(HistogramID::FX_NUMBER_OF_UNIQUE_SITE_ORIGINS_ALL_TABS);
    }
    case 2739: { // geckoview.page_load_progress_time
      return Some(HistogramID::GV_PAGE_LOAD_PROGRESS_MS);
    }
    case 2740: { // geckoview.page_load_time
      return Some(HistogramID::GV_PAGE_LOAD_MS);
    }
    case 2741: { // geckoview.page_reload_time
      return Some(HistogramID::GV_PAGE_RELOAD_MS);
    }
    case 2742: { // geckoview.per_document_site_origins
      return Some(HistogramID::FX_NUMBER_OF_UNIQUE_SITE_ORIGINS_PER_DOCUMENT);
    }
    case 2754: { // networking.dns_failed_lookup_time
      return Some(HistogramID::DNS_FAILED_LOOKUP_TIME);
    }
    case 2755: { // networking.dns_lookup_time
      return Some(HistogramID::DNS_LOOKUP_TIME);
    }
    case 2758: { // networking.dns_renewal_time
      return Some(HistogramID::DNS_RENEWAL_TIME);
    }
    case 2759: { // networking.dns_renewal_time_for_ttl
      return Some(HistogramID::DNS_RENEWAL_TIME_FOR_TTL);
    }
    case 2760: { // networking.http_1_download_throughput
      return Some(HistogramID::NETWORKING_DOWNLOAD_THROUGHPUT_HTTP_1);
    }
    case 2761: { // networking.http_1_upload_throughput
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_1);
    }
    case 2762: { // networking.http_1_upload_throughput_100
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_1_100);
    }
    case 2763: { // networking.http_1_upload_throughput_10_50
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_1_10_50);
    }
    case 2764: { // networking.http_1_upload_throughput_50_100
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_1_50_100);
    }
    case 2765: { // networking.http_2_download_throughput
      return Some(HistogramID::NETWORKING_DOWNLOAD_THROUGHPUT_HTTP_2);
    }
    case 2766: { // networking.http_2_upload_throughput
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_2);
    }
    case 2767: { // networking.http_2_upload_throughput_100
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_2_100);
    }
    case 2768: { // networking.http_2_upload_throughput_10_50
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_2_10_50);
    }
    case 2769: { // networking.http_2_upload_throughput_50_100
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_2_50_100);
    }
    case 2770: { // networking.http_3_download_throughput
      return Some(HistogramID::NETWORKING_DOWNLOAD_THROUGHPUT_HTTP_3);
    }
    case 2771: { // networking.http_3_upload_throughput
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_3);
    }
    case 2772: { // networking.http_3_upload_throughput_100
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_3_100);
    }
    case 2773: { // networking.http_3_upload_throughput_10_50
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_3_10_50);
    }
    case 2774: { // networking.http_3_upload_throughput_50_100
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_3_50_100);
    }
    case 2786: { // networking.http_onstart_suspend_total_time
      return Some(HistogramID::HTTP_ONSTART_SUSPEND_TOTAL_TIME);
    }
    case 2803: { // network.cache_hit_time
      return Some(HistogramID::NETWORK_CACHE_V2_HIT_TIME_MS);
    }
    case 2810: { // network.font_download_end
      return Some(HistogramID::WEBFONT_DOWNLOAD_TIME_AFTER_START);
    }
    case 2933: { // extensions.apis.dnr.evaluate_rules_time
      return Some(HistogramID::WEBEXT_DNR_EVALUATE_RULES_MS);
    }
    case 2935: { // extensions.apis.dnr.startup_cache_read_size
      return Some(HistogramID::WEBEXT_DNR_STARTUPCACHE_READ_BYTES);
    }
    case 2936: { // extensions.apis.dnr.startup_cache_read_time
      return Some(HistogramID::WEBEXT_DNR_STARTUPCACHE_READ_MS);
    }
    case 2937: { // extensions.apis.dnr.startup_cache_write_size
      return Some(HistogramID::WEBEXT_DNR_STARTUPCACHE_WRITE_BYTES);
    }
    case 2938: { // extensions.apis.dnr.startup_cache_write_time
      return Some(HistogramID::WEBEXT_DNR_STARTUPCACHE_WRITE_MS);
    }
    case 2939: { // extensions.apis.dnr.validate_rules_time
      return Some(HistogramID::WEBEXT_DNR_VALIDATE_RULES_MS);
    }
    case 2995: { // test_only.what_time_is_it
      return Some(HistogramID::TELEMETRY_TEST_MIRROR_FOR_TIMING);
    }
    case 2998: { // test_only.ipc.a_custom_dist
      return Some(HistogramID::TELEMETRY_TEST_MIRROR_FOR_CUSTOM);
    }
    case 3001: { // test_only.ipc.a_memory_dist
      return Some(HistogramID::TELEMETRY_TEST_LINEAR);
    }
    case 3006: { // test_only.ipc.a_timing_dist
      return Some(HistogramID::TELEMETRY_TEST_EXPONENTIAL);
    }
    case 3207: { // fingerprinting.protection.canvas_noise_calculate_time
      return Some(HistogramID::FINGERPRINTING_PROTECTION_CANVAS_NOISE_CALCULATE_TIME_MS);
    }
    case 3221: { // search.service.startup_time
      return Some(HistogramID::SEARCH_SERVICE_INIT2_MS);
    }
    default: {
      if (MOZ_UNLIKELY(aId & (1 << DYNAMIC_METRIC_BIT))) {
        // Dynamic (runtime-registered) metric. Use its static (compiletime-
        // registered) metric's telemetry_mirror mapping.
        // ...if applicable.

        // Only JS can use dynamic (runtime-registered) metric ids.
        MOZ_ASSERT(NS_IsMainThread());

        auto metricName = JOG::GetMetricName(aId);
        // All of these should have names, but the storage only lasts until
        // XPCOMWillShutdown, so it might return `Nothing()`.
        if (metricName.isSome()) {
          auto maybeMetric = MetricByNameLookup(metricName.ref());
          if (maybeMetric.isSome()) {
            uint32_t staticId = GLEAN_METRIC_ID(maybeMetric.value());
            // Let's ensure we don't infinite loop, huh.
            MOZ_ASSERT(!(staticId & (1 << DYNAMIC_METRIC_BIT)));
            return HistogramIdForMetric(staticId);
          }
        }
      }
      return Nothing();
    }
  }
}

}  // namespace mozilla::glean

#undef GLEAN_METRIC_ID
#undef DYNAMIC_METRIC_BIT

#endif  // mozilla_glean_HistogramGifftMaps_h
