/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_Components_h
#define mozilla_Components_h

#include "nsCOMPtr.h"

struct nsID;

#define NS_IMPL_COMPONENT_FACTORY(iface) \
  template <>                            \
  already_AddRefed<nsISupports> mozCreateComponent<iface>()

template <typename T>
already_AddRefed<nsISupports> mozCreateComponent();

namespace mozilla {
namespace xpcom {

enum class ModuleID : uint16_t {
  Anonymous469,
  CacheStorage,
  Anonymous139,
  Anonymous108,
  Anonymous054,
  Anonymous379,
  Anonymous418,
  Anonymous424,
  Anonymous073,
  Anonymous039,
  Anonymous147,
  Anonymous361,
  Anonymous153,
  Anonymous033,
  Anonymous066,
  Anonymous427,
  Anonymous016,
  Anonymous115,
  Anonymous082,
  Anonymous334,
  Anonymous307,
  Anonymous101,
  Anonymous001,
  Anonymous262,
  Anonymous065,
  Anonymous202,
  Anonymous207,
  Anonymous317,
  Anonymous385,
  Anonymous229,
  Anonymous006,
  Anonymous333,
  UrlClassifierStreamUpdater,
  Anonymous364,
  Anonymous049,
  Anonymous235,
  Anonymous422,
  Anonymous291,
  Anonymous280,
  Anonymous208,
  Anonymous107,
  Anonymous180,
  Anonymous402,
  Anonymous354,
  Anonymous118,
  URLQueryStringStripper,
  Prefetch,
  Anonymous231,
  Anonymous282,
  Anonymous151,
  Anonymous308,
  Anonymous258,
  Anonymous104,
  Anonymous253,
  Anonymous152,
  Anonymous453,
  XULRuntime,
  Anonymous074,
  Anonymous010,
  Anonymous452,
  Anonymous370,
  Anonymous292,
  Anonymous327,
  Anonymous400,
  Anonymous141,
  ApplicationReputation,
  Anonymous406,
  Anonymous023,
  Anonymous096,
  Anonymous024,
  Anonymous269,
  Anonymous239,
  Anonymous133,
  Anonymous410,
  Anonymous348,
  Anonymous268,
  Anonymous456,
  Anonymous174,
  Anonymous382,
  Anonymous289,
  Anonymous026,
  Anonymous070,
  Anonymous445,
  Anonymous182,
  Anonymous358,
  Anonymous215,
  Anonymous412,
  Anonymous156,
  Anonymous411,
  Anonymous225,
  Anonymous228,
  Anonymous252,
  Anonymous027,
  Anonymous020,
  Anonymous137,
  Anonymous339,
  UrlClassifierPrefixSet,
  Anonymous103,
  Anonymous127,
  Observer,
  Anonymous442,
  Anonymous393,
  Anonymous206,
  Anonymous042,
  Anonymous048,
  Anonymous371,
  Anonymous136,
  Anonymous014,
  Anonymous395,
  Anonymous298,
  Anonymous476,
  Anonymous201,
  Anonymous218,
  AlertNotification,
  Anonymous232,
  Anonymous417,
  Anonymous192,
  Anonymous403,
  Anonymous080,
  Anonymous012,
  Anonymous128,
  Anonymous176,
  Anonymous183,
  Anonymous323,
  Anonymous441,
  IdentityCredentialStorageService,
  Anonymous472,
  Anonymous064,
  Anonymous022,
  Anonymous055,
  Anonymous271,
  Anonymous290,
  Anonymous263,
  Anonymous002,
  Anonymous169,
  Anonymous245,
  Anonymous287,
  Anonymous286,
  Anonymous338,
  Anonymous032,
  Anonymous105,
  Anonymous189,
  Anonymous260,
  Anonymous429,
  ExternalProtocolHandler,
  Anonymous081,
  Anonymous163,
  Anonymous420,
  Anonymous414,
  Anonymous458,
  Anonymous204,
  Anonymous467,
  Anonymous443,
  Anonymous347,
  Anonymous299,
  Anonymous460,
  Anonymous037,
  Anonymous109,
  Anonymous356,
  Anonymous374,
  Anonymous186,
  Anonymous140,
  Anonymous112,
  Anonymous362,
  Anonymous040,
  Anonymous111,
  Anonymous311,
  Anonymous399,
  Anonymous433,
  Anonymous264,
  Anonymous430,
  Anonymous143,
  Anonymous279,
  Anonymous383,
  Anonymous259,
  Anonymous057,
  Anonymous205,
  Anonymous378,
  Anonymous135,
  Anonymous063,
  Anonymous257,
  Anonymous044,
  Anonymous388,
  PermissionManager,
  IdentityCredentialPromptService,
  Anonymous313,
  ServiceWorkerManager,
  Anonymous278,
  Anonymous342,
  Anonymous413,
  Anonymous328,
  Anonymous401,
  Anonymous123,
  Anonymous071,
  Anonymous126,
  Anonymous360,
  HttpActivityDistributor,
  Anonymous335,
  Anonymous303,
  Anonymous373,
  Anonymous394,
  Anonymous301,
  Anonymous113,
  Anonymous369,
  Anonymous331,
  Anonymous247,
  Anonymous129,
  Anonymous021,
  Anonymous173,
  StringBundle,
  Anonymous478,
  Anonymous093,
  Anonymous477,
  Anonymous051,
  Anonymous416,
  Anonymous284,
  Anonymous187,
  Anonymous267,
  Anonymous095,
  CookieBannerService,
  Anonymous366,
  Anonymous094,
  Anonymous274,
  Anonymous415,
  Anonymous423,
  Anonymous030,
  Anonymous091,
  AppStartup,
  Anonymous446,
  Anonymous013,
  Anonymous213,
  ExtensionPolicy,
  Anonymous086,
  Anonymous233,
  Anonymous474,
  Anonymous309,
  AddonContentPolicy,
  Anonymous246,
  Anonymous045,
  Anonymous116,
  Anonymous314,
  DownloadPlatform,
  Anonymous050,
  Anonymous340,
  Anonymous031,
  LoginReputation,
  Anonymous172,
  Anonymous375,
  Anonymous377,
  Anonymous170,
  Anonymous351,
  Anonymous390,
  Anonymous214,
  ThirdPartyUtil,
  Anonymous146,
  Anonymous451,
  GfxInfo,
  Anonymous167,
  Anonymous134,
  Anonymous352,
  Anonymous121,
  Anonymous376,
  Anonymous330,
  Anonymous431,
  Anonymous470,
  Anonymous162,
  Anonymous248,
  Anonymous102,
  Anonymous175,
  Preferences,
  Anonymous166,
  Anonymous164,
  Anonymous387,
  Anonymous438,
  Anonymous466,
  Anonymous011,
  Anonymous320,
  Anonymous028,
  Anonymous436,
  Anonymous100,
  Anonymous197,
  Anonymous067,
  Anonymous344,
  Anonymous449,
  Anonymous473,
  Anonymous069,
  Directory,
  Anonymous221,
  Anonymous368,
  Anonymous346,
  Anonymous061,
  Anonymous222,
  Anonymous079,
  Anonymous459,
  Anonymous223,
  Anonymous120,
  Anonymous084,
  Anonymous077,
  Anonymous384,
  Anonymous332,
  Anonymous178,
  Anonymous237,
  IO,
  Anonymous367,
  Alerts,
  Anonymous015,
  Anonymous220,
  UrlClassifierUtils,
  Anonymous448,
  Anonymous043,
  Anonymous250,
  Anonymous089,
  Anonymous241,
  Anonymous380,
  Anonymous426,
  Anonymous266,
  Anonymous052,
  Anonymous198,
  Anonymous117,
  Anonymous149,
  Anonymous255,
  Anonymous193,
  Anonymous270,
  Anonymous457,
  Anonymous450,
  Anonymous029,
  Anonymous168,
  Anonymous035,
  Anonymous004,
  Anonymous236,
  Anonymous404,
  Anonymous194,
  Anonymous297,
  Anonymous336,
  Anonymous294,
  Anonymous386,
  Anonymous419,
  Anonymous341,
  Anonymous076,
  Anonymous148,
  Anonymous177,
  Anonymous144,
  Anonymous277,
  Anonymous160,
  Anonymous392,
  Anonymous398,
  Anonymous238,
  Anonymous212,
  Anonymous047,
  Anonymous343,
  Anonymous305,
  Anonymous471,
  Anonymous465,
  Anonymous097,
  Anonymous059,
  Anonymous281,
  Anonymous019,
  Anonymous234,
  Anonymous122,
  Anonymous025,
  Anonymous254,
  Anonymous428,
  Anonymous475,
  Anonymous240,
  Anonymous150,
  Anonymous283,
  URILoader,
  Anonymous179,
  Anonymous389,
  Anonymous285,
  StreamTransport,
  Anonymous242,
  Anonymous372,
  Anonymous408,
  Anonymous138,
  Anonymous302,
  DNS,
  Anonymous337,
  Anonymous087,
  Anonymous145,
  SocketTransport,
  Anonymous226,
  Anonymous132,
  Anonymous003,
  Anonymous158,
  Anonymous046,
  Anonymous265,
  Anonymous318,
  Anonymous244,
  Anonymous188,
  Anonymous315,
  Anonymous053,
  Anonymous324,
  ChromeRegistry,
  Anonymous130,
  Anonymous440,
  Anonymous041,
  Anonymous068,
  Anonymous272,
  Anonymous461,
  Anonymous210,
  Anonymous251,
  Anonymous181,
  Anonymous199,
  Anonymous216,
  Anonymous435,
  Anonymous421,
  Anonymous425,
  Anonymous454,
  Anonymous273,
  Anonymous131,
  Anonymous444,
  Anonymous345,
  Anonymous075,
  Anonymous391,
  Anonymous316,
  Anonymous209,
  Anonymous157,
  Anonymous165,
  Anonymous211,
  Anonymous230,
  Anonymous098,
  Anonymous397,
  Anonymous275,
  Anonymous353,
  Anonymous085,
  Anonymous200,
  Anonymous058,
  Anonymous437,
  Anonymous099,
  Anonymous159,
  Anonymous310,
  Anonymous191,
  TypeAheadFind,
  Anonymous088,
  Anonymous106,
  Anonymous306,
  Anonymous463,
  URIFixup,
  Anonymous155,
  Anonymous396,
  Anonymous056,
  Anonymous060,
  Anonymous009,
  Anonymous479,
  Anonymous365,
  Anonymous468,
  FindService,
  Anonymous319,
  Anonymous171,
  Anonymous217,
  Anonymous326,
  Anonymous072,
  AsyncShutdown,
  Anonymous455,
  Anonymous349,
  Anonymous322,
  Anonymous432,
  Anonymous219,
  Anonymous434,
  Anonymous447,
  Anonymous119,
  Anonymous184,
  Anonymous464,
  Anonymous325,
  Anonymous125,
  UrlClassifierDB,
  History,
  Anonymous110,
  Anonymous256,
  Anonymous350,
  Anonymous462,
  Anonymous062,
  Anonymous261,
  Anonymous005,
  Anonymous227,
  Anonymous036,
  Anonymous405,
  Anonymous161,
  UUIDGenerator,
  Anonymous078,
  Anonymous090,
  Anonymous224,
  Anonymous293,
  Anonymous114,
  Anonymous439,
  Anonymous142,
  Anonymous018,
  Anonymous083,
  Anonymous357,
  Anonymous008,
  Anonymous407,
  Anonymous300,
  Anonymous034,
  Anonymous000,
  Anonymous190,
  Anonymous295,
  Anonymous296,
  Anonymous288,
  Anonymous154,
  Anonymous007,
  Anonymous321,
  Anonymous092,
  Anonymous363,
  Anonymous276,
  Anonymous185,
  Anonymous409,
  Anonymous381,
  Anonymous038,
  Anonymous249,
  Anonymous017,
  Anonymous304,
  DocLoader,
  Anonymous312,
  Anonymous196,
  Anonymous355,
  Anonymous243,
  Anonymous203,
  Anonymous359,
  Anonymous195,
  Anonymous329,
  Anonymous124,

};

// May be added as a friend function to allow constructing services via
// private constructors and init methods.
nsresult CreateInstanceImpl(ModuleID aID, const nsIID& aIID, void** aResult);

class MOZ_STACK_CLASS StaticModuleHelper : public nsCOMPtr_helper {
 public:
  StaticModuleHelper(ModuleID aId, nsresult* aErrorPtr)
      : mId(aId), mErrorPtr(aErrorPtr) {}

 protected:
  nsresult SetResult(nsresult aRv) const {
    if (mErrorPtr) {
      *mErrorPtr = aRv;
    }
    return aRv;
  }

  ModuleID mId;
  nsresult* mErrorPtr;
};

class MOZ_STACK_CLASS GetServiceHelper final : public StaticModuleHelper {
 public:
  using StaticModuleHelper::StaticModuleHelper;

  nsresult NS_FASTCALL operator()(const nsIID& aIID,
                                  void** aResult) const override;
};

class MOZ_STACK_CLASS CreateInstanceHelper final : public StaticModuleHelper {
 public:
  using StaticModuleHelper::StaticModuleHelper;

  nsresult NS_FASTCALL operator()(const nsIID& aIID,
                                  void** aResult) const override;
};

class Components final {
 public:
  static const nsID& GetCID(ModuleID aID);
};

}  // namespace xpcom

namespace components {

namespace AddonContentPolicy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AddonContentPolicy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AddonContentPolicy, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AddonContentPolicy, aRv};
}
}  // namespace AddonContentPolicy

namespace AlertNotification {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AlertNotification);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AlertNotification, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AlertNotification, aRv};
}
}  // namespace AlertNotification

namespace Alerts {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Alerts);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Alerts, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Alerts, aRv};
}
}  // namespace Alerts

namespace AppStartup {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AppStartup);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AppStartup, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AppStartup, aRv};
}
}  // namespace AppStartup

namespace ApplicationReputation {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ApplicationReputation);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ApplicationReputation, aRv};
}
}  // namespace ApplicationReputation

namespace AsyncShutdown {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AsyncShutdown);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AsyncShutdown, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AsyncShutdown, aRv};
}
}  // namespace AsyncShutdown

namespace CacheStorage {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CacheStorage);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CacheStorage, aRv};
}
}  // namespace CacheStorage

namespace ChromeRegistry {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ChromeRegistry);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ChromeRegistry, aRv};
}
}  // namespace ChromeRegistry

namespace CookieBannerService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CookieBannerService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CookieBannerService, aRv};
}
}  // namespace CookieBannerService

namespace DNS {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DNS);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DNS, aRv};
}
}  // namespace DNS

namespace Directory {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Directory);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Directory, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Directory, aRv};
}
}  // namespace Directory

namespace DocLoader {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DocLoader);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DocLoader, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DocLoader, aRv};
}
}  // namespace DocLoader

namespace DownloadPlatform {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DownloadPlatform);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DownloadPlatform, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DownloadPlatform, aRv};
}
}  // namespace DownloadPlatform

namespace ExtensionPolicy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ExtensionPolicy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExtensionPolicy, aRv};
}
}  // namespace ExtensionPolicy

namespace ExternalProtocolHandler {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ExternalProtocolHandler);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExternalProtocolHandler, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExternalProtocolHandler, aRv};
}
}  // namespace ExternalProtocolHandler

namespace FindService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::FindService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FindService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FindService, aRv};
}
}  // namespace FindService

namespace GfxInfo {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::GfxInfo);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::GfxInfo, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::GfxInfo, aRv};
}
}  // namespace GfxInfo

namespace History {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::History);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::History, aRv};
}
}  // namespace History

namespace HttpActivityDistributor {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::HttpActivityDistributor);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::HttpActivityDistributor, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::HttpActivityDistributor, aRv};
}
}  // namespace HttpActivityDistributor

namespace IO {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IO);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IO, aRv};
}
}  // namespace IO

namespace IdentityCredentialPromptService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IdentityCredentialPromptService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialPromptService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialPromptService, aRv};
}
}  // namespace IdentityCredentialPromptService

namespace IdentityCredentialStorageService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IdentityCredentialStorageService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialStorageService, aRv};
}
}  // namespace IdentityCredentialStorageService

namespace LoginReputation {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::LoginReputation);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::LoginReputation, aRv};
}
}  // namespace LoginReputation

namespace Observer {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Observer);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Observer, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Observer, aRv};
}
}  // namespace Observer

namespace PermissionManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PermissionManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PermissionManager, aRv};
}
}  // namespace PermissionManager

namespace Preferences {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Preferences);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Preferences, aRv};
}
}  // namespace Preferences

namespace Prefetch {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Prefetch);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Prefetch, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Prefetch, aRv};
}
}  // namespace Prefetch

namespace ServiceWorkerManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ServiceWorkerManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ServiceWorkerManager, aRv};
}
}  // namespace ServiceWorkerManager

namespace SocketTransport {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::SocketTransport);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SocketTransport, aRv};
}
}  // namespace SocketTransport

namespace StreamTransport {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::StreamTransport);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamTransport, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamTransport, aRv};
}
}  // namespace StreamTransport

namespace StringBundle {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::StringBundle);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StringBundle, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StringBundle, aRv};
}
}  // namespace StringBundle

namespace ThirdPartyUtil {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ThirdPartyUtil);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ThirdPartyUtil, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ThirdPartyUtil, aRv};
}
}  // namespace ThirdPartyUtil

namespace TypeAheadFind {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::TypeAheadFind);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TypeAheadFind, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TypeAheadFind, aRv};
}
}  // namespace TypeAheadFind

namespace URIFixup {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URIFixup);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URIFixup, aRv};
}
}  // namespace URIFixup

namespace URILoader {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URILoader);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URILoader, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URILoader, aRv};
}
}  // namespace URILoader

namespace URLQueryStringStripper {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URLQueryStringStripper);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URLQueryStringStripper, aRv};
}
}  // namespace URLQueryStringStripper

namespace UUIDGenerator {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UUIDGenerator);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UUIDGenerator, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UUIDGenerator, aRv};
}
}  // namespace UUIDGenerator

namespace UrlClassifierDB {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierDB);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierDB, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierDB, aRv};
}
}  // namespace UrlClassifierDB

namespace UrlClassifierPrefixSet {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet, aRv};
}
}  // namespace UrlClassifierPrefixSet

namespace UrlClassifierStreamUpdater {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater, aRv};
}
}  // namespace UrlClassifierStreamUpdater

namespace UrlClassifierUtils {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierUtils);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierUtils, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierUtils, aRv};
}
}  // namespace UrlClassifierUtils

namespace XULRuntime {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::XULRuntime);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::XULRuntime, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::XULRuntime, aRv};
}
}  // namespace XULRuntime

}  // namespace components

}  // namespace mozilla

#endif
