/* THIS FILE IS AUTOGENERATED FROM AnimationEffect.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_AnimationEffectBinding_h
#define mozilla_dom_AnimationEffectBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionTypes.h"

namespace mozilla {
namespace dom {

class AnimationEffect;
struct ComputedEffectTimingAtoms;
struct EffectTimingAtoms;
struct NativePropertyHooks;
struct OptionalEffectTimingAtoms;
class OwningUnrestrictedDoubleOrString;
class ProtoAndIfaceCache;
class UnrestrictedDoubleOrString;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class FillMode : uint8_t {
  None,
  Forwards,
  Backwards,
  Both,
  Auto,
  EndGuard_
};

namespace FillModeValues {
extern const EnumEntry strings[6];

static constexpr size_t Count = 5;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(FillMode::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(FillMode stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace FillModeValues

bool
ToJSValue(JSContext* aCx, FillMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class PlaybackDirection : uint8_t {
  Normal,
  Reverse,
  Alternate,
  Alternate_reverse,
  EndGuard_
};

namespace PlaybackDirectionValues {
extern const EnumEntry strings[5];

static constexpr size_t Count = 4;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(PlaybackDirection::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(PlaybackDirection stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace PlaybackDirectionValues

bool
ToJSValue(JSContext* aCx, PlaybackDirection aArgument, JS::MutableHandle<JS::Value> aValue);


struct EffectTiming : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR double mDelay;
  MOZ_INIT_OUTSIDE_CTOR PlaybackDirection mDirection;
  MOZ_INIT_OUTSIDE_CTOR OwningUnrestrictedDoubleOrString mDuration;
  MOZ_INIT_OUTSIDE_CTOR nsCString mEasing;
  MOZ_INIT_OUTSIDE_CTOR double mEndDelay;
  MOZ_INIT_OUTSIDE_CTOR FillMode mFill;
  MOZ_INIT_OUTSIDE_CTOR double mIterationStart;
  MOZ_INIT_OUTSIDE_CTOR double mIterations;

  EffectTiming();

  explicit inline EffectTiming(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  EffectTiming(EffectTiming&& aOther) = default;

  explicit inline EffectTiming(const EffectTiming& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  EffectTiming&
  operator=(const EffectTiming& aOther);

private:
  static bool
  InitIds(JSContext* cx, EffectTimingAtoms* atomsCache);
};

namespace binding_detail {
struct FastEffectTiming : public EffectTiming
{
  inline FastEffectTiming()
    : EffectTiming(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct OptionalEffectTiming : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mDelay;
  MOZ_INIT_OUTSIDE_CTOR Optional<PlaybackDirection> mDirection;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningUnrestrictedDoubleOrString> mDuration;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsCString> mEasing;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mEndDelay;
  MOZ_INIT_OUTSIDE_CTOR Optional<FillMode> mFill;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mIterationStart;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mIterations;

  OptionalEffectTiming();

  explicit inline OptionalEffectTiming(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  OptionalEffectTiming(OptionalEffectTiming&& aOther) = default;

  explicit inline OptionalEffectTiming(const OptionalEffectTiming& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  OptionalEffectTiming&
  operator=(const OptionalEffectTiming& aOther);

private:
  static bool
  InitIds(JSContext* cx, OptionalEffectTimingAtoms* atomsCache);
};

namespace binding_detail {
struct FastOptionalEffectTiming : public OptionalEffectTiming
{
  inline FastOptionalEffectTiming()
    : OptionalEffectTiming(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ComputedEffectTiming : public EffectTiming
{
  MOZ_INIT_OUTSIDE_CTOR double mActiveDuration;
  MOZ_INIT_OUTSIDE_CTOR Nullable<double> mCurrentIteration;
  MOZ_INIT_OUTSIDE_CTOR double mEndTime;
  MOZ_INIT_OUTSIDE_CTOR Nullable<double> mLocalTime;
  MOZ_INIT_OUTSIDE_CTOR Nullable<double> mProgress;

  ComputedEffectTiming();

  explicit inline ComputedEffectTiming(const FastDictionaryInitializer& )
    : EffectTiming(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ComputedEffectTiming(ComputedEffectTiming&& aOther) = default;

  explicit inline ComputedEffectTiming(const ComputedEffectTiming& aOther)
    : EffectTiming(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  ComputedEffectTiming&
  operator=(const ComputedEffectTiming& aOther);

  bool
  operator==(const ComputedEffectTiming& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, ComputedEffectTimingAtoms* atomsCache);
};

namespace binding_detail {
struct FastComputedEffectTiming : public ComputedEffectTiming
{
  inline FastComputedEffectTiming()
    : ComputedEffectTiming(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace AnimationEffect_Binding {

  typedef mozilla::dom::AnimationEffect NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::AnimationEffect,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  JSObject*
  GetProtoObject(JSContext* aCx);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::AnimationEffect,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace AnimationEffect_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_AnimationEffectBinding_h
