#ifndef mozilla_dom_BindingNames_h
#define mozilla_dom_BindingNames_h

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioDestinationNode = 335,
  AudioListener = 356,
  AudioNode = 370,
  AudioParam = 380,
  AudioParamMap = 391,
  AudioProcessingEvent = 405,
  AudioScheduledSourceNode = 426,
  AudioTrack = 451,
  AudioTrackList = 462,
  AudioWorklet = 477,
  AudioWorkletGlobalScope = 490,
  AudioWorkletNode = 514,
  AudioWorkletProcessor = 531,
  AuthenticatorAssertionResponse = 553,
  AuthenticatorAttestationResponse = 584,
  AuthenticatorResponse = 617,
  BarProp = 639,
  BaseAudioContext = 647,
  BatteryManager = 664,
  BeforeUnloadEvent = 679,
  BiquadFilterNode = 697,
  Blob = 714,
  BlobEvent = 719,
  BroadcastChannel = 729,
  BrowsingContext = 746,
  BrowsingContextGroup = 762,
  ByteLengthQueuingStrategy = 783,
  CDATASection = 809,
  CSS = 822,
  CSS2Properties = 826,
  CSSAnimation = 841,
  CSSConditionRule = 854,
  CSSContainerRule = 871,
  CSSCounterStyleRule = 888,
  CSSFontFaceRule = 908,
  CSSFontFeatureValuesRule = 924,
  CSSFontPaletteValuesRule = 949,
  CSSGroupingRule = 974,
  CSSImportRule = 990,
  CSSKeyframeRule = 1004,
  CSSKeyframesRule = 1020,
  CSSLayerBlockRule = 1037,
  CSSLayerStatementRule = 1055,
  CSSMediaRule = 1077,
  CSSMozDocumentRule = 1090,
  CSSNamespaceRule = 1109,
  CSSPageRule = 1126,
  CSSPropertyRule = 1138,
  CSSPseudoElement = 1154,
  CSSRule = 1171,
  CSSRuleList = 1179,
  CSSStyleDeclaration = 1191,
  CSSStyleRule = 1211,
  CSSStyleSheet = 1224,
  CSSSupportsRule = 1238,
  CSSTransition = 1254,
  Cache = 1268,
  CacheStorage = 1274,
  CallbackDebuggerNotification = 1287,
  CanonicalBrowsingContext = 1316,
  CanvasCaptureMediaStream = 1341,
  CanvasGradient = 1366,
  CanvasPattern = 1381,
  CanvasRenderingContext2D = 1395,
  CaretPosition = 1420,
  CaretStateChangedEvent = 1434,
  ChannelMergerNode = 1457,
  ChannelSplitterNode = 1475,
  ChannelWrapper = 1495,
  CharacterData = 1510,
  CheckerboardReportService = 1524,
  ChildProcessMessageManager = 1550,
  ChildSHistory = 1577,
  ChromeMessageBroadcaster = 1591,
  ChromeMessageSender = 1616,
  ChromeNodeList = 1636,
  ChromeUtils = 1651,
  ChromeWorker = 1663,
  Client = 1676,
  Clients = 1683,
  Clipboard = 1691,
  ClipboardEvent = 1701,
  ClipboardItem = 1716,
  ClonedErrorHolder = 1730,
  CloseEvent = 1748,
  CommandEvent = 1759,
  Comment = 1772,
  CompositionEvent = 1780,
  CompressionStream = 1797,
  ConsoleInstance = 1815,
  ConstantSourceNode = 1831,
  ContentFrameMessageManager = 1850,
  ContentProcessMessageManager = 1877,
  ContentVisibilityAutoStateChangeEvent = 1906,
  ConvolverNode = 1944,
  CountQueuingStrategy = 1958,
  CreateOfferRequest = 1979,
  Credential = 1998,
  CredentialsContainer = 2009,
  Crypto = 2030,
  CryptoKey = 2037,
  CustomElementRegistry = 2047,
  CustomEvent = 2069,
  DOMException = 2081,
  DOMImplementation = 2094,
  DOMLocalization = 2112,
  DOMMatrix = 2128,
  DOMMatrixReadOnly = 2138,
  DOMParser = 2156,
  DOMPoint = 2166,
  DOMPointReadOnly = 2175,
  DOMQuad = 2192,
  DOMRect = 2200,
  DOMRectList = 2208,
  DOMRectReadOnly = 2220,
  DOMRequest = 2236,
  DOMStringList = 2247,
  DOMStringMap = 2261,
  DOMTokenList = 2274,
  DataTransfer = 2287,
  DataTransferItem = 2300,
  DataTransferItemList = 2317,
  DebuggerNotification = 2338,
  DebuggerNotificationObserver = 2359,
  DecompressionStream = 2388,
  DedicatedWorkerGlobalScope = 2408,
  DelayNode = 2435,
  DeprecationReportBody = 2445,
  DeviceAcceleration = 2467,
  DeviceLightEvent = 2486,
  DeviceMotionEvent = 2503,
  DeviceOrientationEvent = 2521,
  DeviceRotationRate = 2544,
  Directory = 2563,
  Document = 2573,
  DocumentFragment = 2582,
  DocumentL10n = 2599,
  DocumentTimeline = 2612,
  DocumentType = 2629,
  DominatorTree = 2642,
  DragEvent = 2656,
  DynamicsCompressorNode = 2666,
  EXT_blend_minmax = 2689,
  EXT_color_buffer_float = 2706,
  EXT_color_buffer_half_float = 2729,
  EXT_disjoint_timer_query = 2757,
  EXT_float_blend = 2782,
  EXT_frag_depth = 2798,
  EXT_sRGB = 2813,
  EXT_shader_texture_lod = 2822,
  EXT_texture_compression_bptc = 2845,
  EXT_texture_compression_rgtc = 2874,
  EXT_texture_filter_anisotropic = 2903,
  EXT_texture_norm16 = 2934,
  Element = 2953,
  ElementInternals = 2961,
  ErrorEvent = 2978,
  Event = 2989,
  EventCallbackDebuggerNotification = 2995,
  EventCounts = 3029,
  EventSource = 3041,
  EventTarget = 3053,
  Exception = 3065,
  ExtendableEvent = 3075,
  ExtendableMessageEvent = 3091,
  ExtensionAlarms = 3114,
  ExtensionBrowser = 3130,
  ExtensionBrowserSettings = 3147,
  ExtensionBrowserSettingsColorManagement = 3172,
  ExtensionDns = 3212,
  ExtensionEventManager = 3225,
  ExtensionMockAPI = 3247,
  ExtensionPort = 3264,
  ExtensionProxy = 3278,
  ExtensionRuntime = 3293,
  ExtensionScripting = 3310,
  ExtensionSetting = 3329,
  ExtensionTest = 3346,
  External = 3360,
  FeaturePolicy = 3369,
  FeaturePolicyViolationReportBody = 3383,
  FetchEvent = 3416,
  FetchObserver = 3427,
  File = 3441,
  FileList = 3446,
  FileReader = 3455,
  FileReaderSync = 3466,
  FileSystem = 3481,
  FileSystemDirectoryEntry = 3492,
  FileSystemDirectoryHandle = 3517,
  FileSystemDirectoryHandle_AsyncIterator = 3543,
  FileSystemDirectoryIterator = 3583,
  FileSystemDirectoryReader = 3611,
  FileSystemEntry = 3637,
  FileSystemFileEntry = 3653,
  FileSystemFileHandle = 3673,
  FileSystemHandle = 3694,
  FileSystemSyncAccessHandle = 3711,
  FileSystemWritableFileStream = 3738,
  Flex = 3767,
  FlexItemValues = 3772,
  FlexLineValues = 3787,
  FluentBundle = 3802,
  FluentBundleAsyncIterator = 3815,
  FluentBundleIterator = 3841,
  FluentPattern = 3862,
  FluentResource = 3876,
  FocusEvent = 3891,
  FontFace = 3902,
  FontFaceSet = 3911,
  FontFaceSetIterator = 3923,
  FontFaceSetLoadEvent = 3943,
  FormData = 3964,
  FormData_Iterator = 3973,
  FormDataEvent = 3991,
  FrameCrashedEvent = 4005,
  FrameLoader = 4023,
  GPU = 4035,
  GPUAdapter = 4039,
  GPUAdapterInfo = 4050,
  GPUBindGroup = 4065,
  GPUBindGroupLayout = 4078,
  GPUBuffer = 4097,
  GPUBufferUsage = 4107,
  GPUCanvasContext = 4122,
  GPUColorWrite = 4139,
  GPUCommandBuffer = 4153,
  GPUCommandEncoder = 4170,
  GPUCompilationInfo = 4188,
  GPUCompilationMessage = 4207,
  GPUComputePassEncoder = 4229,
  GPUComputePipeline = 4251,
  GPUDevice = 4270,
  GPUDeviceLostInfo = 4280,
  GPUMapMode = 4298,
  GPUOutOfMemoryError = 4309,
  GPUPipelineLayout = 4329,
  GPUQuerySet = 4347,
  GPUQueue = 4359,
  GPURenderBundle = 4368,
  GPURenderBundleEncoder = 4384,
  GPURenderPassEncoder = 4407,
  GPURenderPipeline = 4428,
  GPUSampler = 4446,
  GPUShaderModule = 4457,
  GPUShaderStage = 4473,
  GPUSupportedFeatures = 4488,
  GPUSupportedLimits = 4509,
  GPUTexture = 4528,
  GPUTextureUsage = 4539,
  GPUTextureView = 4555,
  GPUUncapturedErrorEvent = 4570,
  GPUValidationError = 4594,
  GainNode = 4613,
  Gamepad = 4622,
  GamepadAxisMoveEvent = 4630,
  GamepadButton = 4651,
  GamepadButtonEvent = 4665,
  GamepadEvent = 4684,
  GamepadHapticActuator = 4697,
  GamepadLightIndicator = 4719,
  GamepadPose = 4741,
  GamepadServiceTest = 4753,
  GamepadTouch = 4772,
  Geolocation = 4785,
  GeolocationCoordinates = 4797,
  GeolocationPosition = 4820,
  GeolocationPositionError = 4840,
  GetUserMediaRequest = 4865,
  GleanCategory = 4885,
  GleanImpl = 4899,
  GleanLabeled = 4909,
  GleanPingsImpl = 4922,
  Grid = 4937,
  GridArea = 4942,
  GridDimension = 4951,
  GridLine = 4965,
  GridLines = 4974,
  GridTrack = 4984,
  GridTracks = 4994,
  HTMLAllCollection = 5005,
  HTMLAnchorElement = 5023,
  HTMLAreaElement = 5041,
  HTMLAudioElement = 5057,
  HTMLBRElement = 5074,
  HTMLBaseElement = 5088,
  HTMLBodyElement = 5104,
  HTMLButtonElement = 5120,
  HTMLCanvasElement = 5138,
  HTMLCollection = 5156,
  HTMLDListElement = 5171,
  HTMLDataElement = 5188,
  HTMLDataListElement = 5204,
  HTMLDetailsElement = 5224,
  HTMLDialogElement = 5243,
  HTMLDirectoryElement = 5261,
  HTMLDivElement = 5282,
  HTMLDocument = 5297,
  HTMLElement = 5310,
  HTMLEmbedElement = 5322,
  HTMLFieldSetElement = 5339,
  HTMLFontElement = 5359,
  HTMLFormControlsCollection = 5375,
  HTMLFormElement = 5402,
  HTMLFrameElement = 5418,
  HTMLFrameSetElement = 5435,
  HTMLHRElement = 5455,
  HTMLHeadElement = 5469,
  HTMLHeadingElement = 5485,
  HTMLHtmlElement = 5504,
  HTMLIFrameElement = 5520,
  HTMLImageElement = 5538,
  HTMLInputElement = 5555,
  HTMLLIElement = 5572,
  HTMLLabelElement = 5586,
  HTMLLegendElement = 5603,
  HTMLLinkElement = 5621,
  HTMLMapElement = 5637,
  HTMLMarqueeElement = 5652,
  HTMLMediaElement = 5671,
  HTMLMenuElement = 5688,
  HTMLMetaElement = 5704,
  HTMLMeterElement = 5720,
  HTMLModElement = 5737,
  HTMLOListElement = 5752,
  HTMLObjectElement = 5769,
  HTMLOptGroupElement = 5787,
  HTMLOptionElement = 5807,
  HTMLOptionsCollection = 5825,
  HTMLOutputElement = 5847,
  HTMLParagraphElement = 5865,
  HTMLParamElement = 5886,
  HTMLPictureElement = 5903,
  HTMLPreElement = 5922,
  HTMLProgressElement = 5937,
  HTMLQuoteElement = 5957,
  HTMLScriptElement = 5974,
  HTMLSelectElement = 5992,
  HTMLSlotElement = 6010,
  HTMLSourceElement = 6026,
  HTMLSpanElement = 6044,
  HTMLStyleElement = 6060,
  HTMLTableCaptionElement = 6077,
  HTMLTableCellElement = 6101,
  HTMLTableColElement = 6122,
  HTMLTableElement = 6142,
  HTMLTableRowElement = 6159,
  HTMLTableSectionElement = 6179,
  HTMLTemplateElement = 6203,
  HTMLTextAreaElement = 6223,
  HTMLTimeElement = 6243,
  HTMLTitleElement = 6259,
  HTMLTrackElement = 6276,
  HTMLUListElement = 6293,
  HTMLUnknownElement = 6310,
  HTMLVideoElement = 6329,
  HashChangeEvent = 6346,
  Headers = 6362,
  Headers_Iterator = 6370,
  HeapSnapshot = 6387,
  Highlight = 6400,
  HighlightRegistry = 6410,
  History = 6428,
  IDBCursor = 6436,
  IDBCursorWithValue = 6446,
  IDBDatabase = 6465,
  IDBFactory = 6477,
  IDBIndex = 6488,
  IDBKeyRange = 6497,
  IDBLocaleAwareKeyRange = 6509,
  IDBObjectStore = 6532,
  IDBOpenDBRequest = 6547,
  IDBRequest = 6564,
  IDBTransaction = 6575,
  IDBVersionChangeEvent = 6590,
  IIRFilterNode = 6612,
  IOUtils = 6626,
  IdentityCredential = 6634,
  IdleDeadline = 6653,
  Image = 6666,
  ImageBitmap = 6672,
  ImageBitmapRenderingContext = 6684,
  ImageCapture = 6712,
  ImageCaptureError = 6725,
  ImageCaptureErrorEvent = 6743,
  ImageData = 6766,
  ImageDocument = 6776,
  InputEvent = 6790,
  InspectorFontFace = 6801,
  InspectorUtils = 6819,
  InstallTriggerImpl = 6834,
  IntersectionObserver = 6853,
  IntersectionObserverEntry = 6874,
  IntlUtils = 6900,
  JSProcessActorChild = 6910,
  JSProcessActorParent = 6930,
  JSWindowActorChild = 6951,
  JSWindowActorParent = 6970,
  KeyEvent = 6990,
  KeyboardEvent = 6999,
  KeyframeEffect = 7013,
  L10nFileSource = 7028,
  L10nOverlays = 7043,
  L10nRegistry = 7056,
  LargestContentfulPaint = 7069,
  LegacyMozTCPSocket = 7092,
  Localization = 7111,
  Location = 7124,
  Lock = 7133,
  LockManager = 7138,
  MIDIAccess = 7150,
  MIDIConnectionEvent = 7161,
  MIDIInput = 7181,
  MIDIInputMap = 7191,
  MIDIMessageEvent = 7204,
  MIDIOutput = 7221,
  MIDIOutputMap = 7232,
  MIDIPort = 7246,
  MOZ_debug = 7255,
  MatchGlob = 7265,
  MatchPattern = 7275,
  MatchPatternSet = 7288,
  MathMLElement = 7304,
  MediaCapabilities = 7318,
  MediaCapabilitiesInfo = 7336,
  MediaControlService = 7358,
  MediaController = 7378,
  MediaDeviceInfo = 7394,
  MediaDevices = 7410,
  MediaElementAudioSourceNode = 7423,
  MediaEncryptedEvent = 7451,
  MediaError = 7471,
  MediaKeyError = 7482,
  MediaKeyMessageEvent = 7496,
  MediaKeySession = 7517,
  MediaKeyStatusMap = 7533,
  MediaKeyStatusMap_Iterator = 7551,
  MediaKeySystemAccess = 7578,
  MediaKeys = 7599,
  MediaList = 7609,
  MediaMetadata = 7619,
  MediaQueryList = 7633,
  MediaQueryListEvent = 7648,
  MediaRecorder = 7668,
  MediaRecorderErrorEvent = 7682,
  MediaSession = 7706,
  MediaSource = 7719,
  MediaStream = 7731,
  MediaStreamAudioDestinationNode = 7743,
  MediaStreamAudioSourceNode = 7775,
  MediaStreamError = 7802,
  MediaStreamEvent = 7819,
  MediaStreamTrack = 7836,
  MediaStreamTrackAudioSourceNode = 7853,
  MediaStreamTrackEvent = 7885,
  MerchantValidationEvent = 7907,
  MessageBroadcaster = 7931,
  MessageChannel = 7950,
  MessageEvent = 7965,
  MessageListenerManager = 7978,
  MessagePort = 8001,
  MessageSender = 8013,
  MimeType = 8027,
  MimeTypeArray = 8036,
  MouseEvent = 8050,
  MouseScrollEvent = 8061,
  MozCanvasPrintState = 8078,
  MozDocumentMatcher = 8098,
  MozDocumentObserver = 8117,
  MozQueryInterface = 8137,
  MozSharedMap = 8155,
  MozSharedMap_Iterator = 8168,
  MozSharedMapChangeEvent = 8190,
  MozStorageAsyncStatementParams = 8214,
  MozStorageStatementParams = 8245,
  MozStorageStatementRow = 8271,
  MozWritableSharedMap = 8294,
  MutationEvent = 8315,
  MutationObserver = 8329,
  MutationRecord = 8346,
  NamedNodeMap = 8361,
  NavigationPreloadManager = 8374,
  Navigator = 8399,
  NetworkInformation = 8409,
  Node = 8428,
  NodeFilter = 8433,
  NodeIterator = 8444,
  NodeList = 8457,
  Notification = 8466,
  NotificationEvent = 8479,
  NotifyPaintEvent = 8497,
  OES_draw_buffers_indexed = 8514,
  OES_element_index_uint = 8539,
  OES_fbo_render_mipmap = 8562,
  OES_standard_derivatives = 8584,
  OES_texture_float = 8609,
  OES_texture_float_linear = 8627,
  OES_texture_half_float = 8652,
  OES_texture_half_float_linear = 8675,
  OES_vertex_array_object = 8705,
  OVR_multiview2 = 8729,
  OfflineAudioCompletionEvent = 8744,
  OfflineAudioContext = 8772,
  OffscreenCanvas = 8792,
  OffscreenCanvasRenderingContext2D = 8808,
  OnlyForUseInConstructor = 8842,
  Option = 8866,
  OscillatorNode = 8873,
  PageTransitionEvent = 8888,
  PaintRequest = 8908,
  PaintRequestList = 8921,
  PaintWorkletGlobalScope = 8938,
  PannerNode = 8962,
  ParentProcessMessageManager = 8973,
  Path2D = 9001,
  PathUtils = 9008,
  PaymentAddress = 9018,
  PaymentMethodChangeEvent = 9033,
  PaymentRequest = 9058,
  PaymentRequestUpdateEvent = 9073,
  PaymentResponse = 9099,
  PeerConnectionImpl = 9115,
  PeerConnectionObserver = 9134,
  Performance = 9157,
  PerformanceEntry = 9169,
  PerformanceEntryEvent = 9186,
  PerformanceEventTiming = 9208,
  PerformanceMark = 9231,
  PerformanceMeasure = 9247,
  PerformanceNavigation = 9266,
  PerformanceNavigationTiming = 9288,
  PerformanceObserver = 9316,
  PerformanceObserverEntryList = 9336,
  PerformancePaintTiming = 9365,
  PerformanceResourceTiming = 9388,
  PerformanceServerTiming = 9414,
  PerformanceTiming = 9438,
  PeriodicWave = 9456,
  PermissionStatus = 9469,
  Permissions = 9486,
  PlacesBookmark = 9498,
  PlacesBookmarkAddition = 9513,
  PlacesBookmarkChanged = 9536,
  PlacesBookmarkGuid = 9558,
  PlacesBookmarkKeyword = 9577,
  PlacesBookmarkMoved = 9599,
  PlacesBookmarkRemoved = 9619,
  PlacesBookmarkTags = 9641,
  PlacesBookmarkTime = 9660,
  PlacesBookmarkTitle = 9679,
  PlacesBookmarkUrl = 9699,
  PlacesEvent = 9717,
  PlacesFavicon = 9729,
  PlacesHistoryCleared = 9743,
  PlacesObservers = 9764,
  PlacesPurgeCaches = 9780,
  PlacesRanking = 9798,
  PlacesVisit = 9812,
  PlacesVisitRemoved = 9824,
  PlacesVisitTitle = 9843,
  PlacesWeakCallbackWrapper = 9860,
  Plugin = 9886,
  PluginArray = 9893,
  PluginCrashedEvent = 9905,
  PointerEvent = 9924,
  PopStateEvent = 9937,
  PopupBlockedEvent = 9951,
  PopupPositionedEvent = 9969,
  PositionStateEvent = 9990,
  PrecompiledScript = 10009,
  ProcessMessageManager = 10027,
  ProcessingInstruction = 10049,
  ProgressEvent = 10071,
  PromiseDebugging = 10085,
  PromiseNativeHandler = 10102,
  PromiseRejectionEvent = 10123,
  PublicKeyCredential = 10145,
  PushEvent = 10165,
  PushManager = 10175,
  PushManagerImpl = 10187,
  PushMessageData = 10203,
  PushSubscription = 10219,
  PushSubscriptionOptions = 10236,
  RTCCertificate = 10260,
  RTCDTMFSender = 10275,
  RTCDTMFToneChangeEvent = 10289,
  RTCDataChannel = 10312,
  RTCDataChannelEvent = 10327,
  RTCDtlsTransport = 10347,
  RTCIceCandidate = 10364,
  RTCIdentityProviderRegistrar = 10380,
  RTCPeerConnection = 10409,
  RTCPeerConnectionIceEvent = 10427,
  RTCPeerConnectionStatic = 10453,
  RTCRtpReceiver = 10477,
  RTCRtpSender = 10492,
  RTCRtpTransceiver = 10505,
  RTCSctpTransport = 10523,
  RTCSessionDescription = 10540,
  RTCStatsReport = 10562,
  RTCTrackEvent = 10577,
  RadioNodeList = 10591,
  Range = 10605,
  ReadableByteStreamController = 10611,
  ReadableStream = 10640,
  ReadableStream_AsyncIterator = 10655,
  ReadableStreamBYOBReader = 10684,
  ReadableStreamBYOBRequest = 10709,
  ReadableStreamDefaultController = 10735,
  ReadableStreamDefaultReader = 10767,
  Report = 10795,
  ReportBody = 10802,
  ReportingObserver = 10813,
  Request = 10831,
  ResizeObserver = 10839,
  ResizeObserverEntry = 10854,
  ResizeObserverSize = 10874,
  Response = 10893,
  SVGAElement = 10902,
  SVGAngle = 10914,
  SVGAnimateElement = 10923,
  SVGAnimateMotionElement = 10941,
  SVGAnimateTransformElement = 10965,
  SVGAnimatedAngle = 10992,
  SVGAnimatedBoolean = 11009,
  SVGAnimatedEnumeration = 11028,
  SVGAnimatedInteger = 11051,
  SVGAnimatedLength = 11070,
  SVGAnimatedLengthList = 11088,
  SVGAnimatedNumber = 11110,
  SVGAnimatedNumberList = 11128,
  SVGAnimatedPreserveAspectRatio = 11150,
  SVGAnimatedRect = 11181,
  SVGAnimatedString = 11197,
  SVGAnimatedTransformList = 11215,
  SVGAnimationElement = 11240,
  SVGCircleElement = 11260,
  SVGClipPathElement = 11277,
  SVGComponentTransferFunctionElement = 11296,
  SVGDefsElement = 11332,
  SVGDescElement = 11347,
  SVGElement = 11362,
  SVGEllipseElement = 11373,
  SVGFEBlendElement = 11391,
  SVGFEColorMatrixElement = 11409,
  SVGFEComponentTransferElement = 11433,
  SVGFECompositeElement = 11463,
  SVGFEConvolveMatrixElement = 11485,
  SVGFEDiffuseLightingElement = 11512,
  SVGFEDisplacementMapElement = 11540,
  SVGFEDistantLightElement = 11568,
  SVGFEDropShadowElement = 11593,
  SVGFEFloodElement = 11616,
  SVGFEFuncAElement = 11634,
  SVGFEFuncBElement = 11652,
  SVGFEFuncGElement = 11670,
  SVGFEFuncRElement = 11688,
  SVGFEGaussianBlurElement = 11706,
  SVGFEImageElement = 11731,
  SVGFEMergeElement = 11749,
  SVGFEMergeNodeElement = 11767,
  SVGFEMorphologyElement = 11789,
  SVGFEOffsetElement = 11812,
  SVGFEPointLightElement = 11831,
  SVGFESpecularLightingElement = 11854,
  SVGFESpotLightElement = 11883,
  SVGFETileElement = 11905,
  SVGFETurbulenceElement = 11922,
  SVGFilterElement = 11945,
  SVGForeignObjectElement = 11962,
  SVGGElement = 11986,
  SVGGeometryElement = 11998,
  SVGGradientElement = 12017,
  SVGGraphicsElement = 12036,
  SVGImageElement = 12055,
  SVGLength = 12071,
  SVGLengthList = 12081,
  SVGLineElement = 12095,
  SVGLinearGradientElement = 12110,
  SVGMPathElement = 12135,
  SVGMarkerElement = 12151,
  SVGMaskElement = 12168,
  SVGMatrix = 12183,
  SVGMetadataElement = 12193,
  SVGNumber = 12212,
  SVGNumberList = 12222,
  SVGPathElement = 12236,
  SVGPathSeg = 12251,
  SVGPathSegArcAbs = 12262,
  SVGPathSegArcRel = 12279,
  SVGPathSegClosePath = 12296,
  SVGPathSegCurvetoCubicAbs = 12316,
  SVGPathSegCurvetoCubicRel = 12342,
  SVGPathSegCurvetoCubicSmoothAbs = 12368,
  SVGPathSegCurvetoCubicSmoothRel = 12400,
  SVGPathSegCurvetoQuadraticAbs = 12432,
  SVGPathSegCurvetoQuadraticRel = 12462,
  SVGPathSegCurvetoQuadraticSmoothAbs = 12492,
  SVGPathSegCurvetoQuadraticSmoothRel = 12528,
  SVGPathSegLinetoAbs = 12564,
  SVGPathSegLinetoHorizontalAbs = 12584,
  SVGPathSegLinetoHorizontalRel = 12614,
  SVGPathSegLinetoRel = 12644,
  SVGPathSegLinetoVerticalAbs = 12664,
  SVGPathSegLinetoVerticalRel = 12692,
  SVGPathSegList = 12720,
  SVGPathSegMovetoAbs = 12735,
  SVGPathSegMovetoRel = 12755,
  SVGPatternElement = 12775,
  SVGPoint = 12793,
  SVGPointList = 12802,
  SVGPolygonElement = 12815,
  SVGPolylineElement = 12833,
  SVGPreserveAspectRatio = 12852,
  SVGRadialGradientElement = 12875,
  SVGRect = 12900,
  SVGRectElement = 12908,
  SVGSVGElement = 12923,
  SVGScriptElement = 12937,
  SVGSetElement = 12954,
  SVGStopElement = 12968,
  SVGStringList = 12983,
  SVGStyleElement = 12997,
  SVGSwitchElement = 13013,
  SVGSymbolElement = 13030,
  SVGTSpanElement = 13047,
  SVGTextContentElement = 13063,
  SVGTextElement = 13085,
  SVGTextPathElement = 13100,
  SVGTextPositioningElement = 13119,
  SVGTitleElement = 13145,
  SVGTransform = 13161,
  SVGTransformList = 13174,
  SVGUnitTypes = 13191,
  SVGUseElement = 13204,
  SVGViewElement = 13218,
  Sanitizer = 13233,
  Scheduler = 13243,
  Screen = 13253,
  ScreenLuminance = 13260,
  ScreenOrientation = 13276,
  ScriptProcessorNode = 13294,
  ScrollAreaEvent = 13314,
  ScrollViewChangeEvent = 13330,
  SecurityPolicyViolationEvent = 13352,
  Selection = 13381,
  ServiceWorker = 13391,
  ServiceWorkerContainer = 13405,
  ServiceWorkerGlobalScope = 13428,
  ServiceWorkerRegistration = 13453,
  SessionStoreFormData = 13479,
  SessionStoreScrollData = 13500,
  SessionStoreUtils = 13523,
  ShadowRealmGlobalScope = 13541,
  ShadowRoot = 13564,
  SharedWorker = 13575,
  SharedWorkerGlobalScope = 13588,
  SimpleGestureEvent = 13612,
  SourceBuffer = 13631,
  SourceBufferList = 13644,
  SpeechGrammar = 13661,
  SpeechGrammarList = 13675,
  SpeechRecognition = 13693,
  SpeechRecognitionAlternative = 13711,
  SpeechRecognitionError = 13740,
  SpeechRecognitionEvent = 13763,
  SpeechRecognitionResult = 13786,
  SpeechRecognitionResultList = 13810,
  SpeechSynthesis = 13838,
  SpeechSynthesisErrorEvent = 13854,
  SpeechSynthesisEvent = 13880,
  SpeechSynthesisUtterance = 13901,
  SpeechSynthesisVoice = 13926,
  StaticRange = 13947,
  StereoPannerNode = 13959,
  Storage = 13976,
  StorageEvent = 13984,
  StorageManager = 13997,
  StreamFilter = 14012,
  StreamFilterDataEvent = 14025,
  StructuredCloneHolder = 14047,
  StructuredCloneTester = 14069,
  StyleSheet = 14091,
  StyleSheetApplicableStateChangeEvent = 14102,
  StyleSheetList = 14139,
  SubmitEvent = 14154,
  SubtleCrypto = 14166,
  SyncMessageSender = 14179,
  SyncReadFile = 14197,
  TCPServerSocket = 14210,
  TCPServerSocketEvent = 14226,
  TCPSocket = 14247,
  TCPSocketErrorEvent = 14257,
  TCPSocketEvent = 14277,
  TaskController = 14292,
  TaskPriorityChangeEvent = 14307,
  TaskSignal = 14331,
  TelemetryStopwatch = 14342,
  TestAttributesOnTypes = 14361,
  TestCEReactionsInterface = 14383,
  TestCImplementedInterface = 14408,
  TestCImplementedInterface2 = 14434,
  TestChildInterface = 14461,
  TestConstructorForFuncInterface = 14480,
  TestConstructorForPrefInterface = 14512,
  TestConstructorForSCInterface = 14544,
  TestCppKeywordNamedMethodsInterface = 14574,
  TestDeprecatedInterface = 14610,
  TestExampleInterface = 14634,
  TestExampleProxyInterface = 14655,
  TestExampleThrowingConstructorInterface = 14681,
  TestExampleWorkerInterface = 14721,
  TestFuncConstructorForDifferentFuncInterface = 14748,
  TestFuncConstructorForInterface = 14793,
  TestFunctions = 14825,
  TestHTMLConstructorInterface = 14839,
  TestIndexedAndNamedGetterAndSetterInterface = 14868,
  TestIndexedAndNamedGetterInterface = 14912,
  TestIndexedAndNamedSetterInterface = 14947,
  TestIndexedGetterAndSetterAndNamedGetterInterface = 14982,
  TestIndexedGetterInterface = 15032,
  TestIndexedSetterInterface = 15059,
  TestInterface = 15086,
  TestInterfaceAsyncIterableDouble = 15100,
  TestInterfaceAsyncIterableDouble_AsyncIterator = 15133,
  TestInterfaceAsyncIterableDoubleUnion = 15180,
  TestInterfaceAsyncIterableDoubleUnion_AsyncIterator = 15218,
  TestInterfaceAsyncIterableSingle = 15270,
  TestInterfaceAsyncIterableSingle_AsyncIterator = 15303,
  TestInterfaceAsyncIterableSingleWithArgs = 15350,
  TestInterfaceAsyncIterableSingleWithArgs_AsyncIterator = 15391,
  TestInterfaceIterableDouble = 15446,
  TestInterfaceIterableDouble_Iterator = 15474,
  TestInterfaceIterableDoubleUnion = 15511,
  TestInterfaceIterableDoubleUnion_Iterator = 15544,
  TestInterfaceIterableSingle = 15586,
  TestInterfaceJS = 15614,
  TestInterfaceLength = 15630,
  TestInterfaceMaplike = 15650,
  TestInterfaceMaplikeJSObject = 15671,
  TestInterfaceMaplikeObject = 15700,
  TestInterfaceObservableArray = 15727,
  TestInterfaceSetlike = 15756,
  TestInterfaceSetlikeNode = 15777,
  TestInterfaceWithPromiseConstructorArg = 15802,
  TestJSImplInterface = 15841,
  TestJSImplInterface2 = 15861,
  TestJSImplInterface3 = 15882,
  TestJSImplInterface4 = 15903,
  TestJSImplInterface5 = 15924,
  TestJSImplInterface6 = 15945,
  TestJSImplNoInterfaceObject = 15966,
  TestNamedDeleterInterface = 15994,
  TestNamedDeleterWithRetvalInterface = 16020,
  TestNamedGetterInterface = 16056,
  TestNamedSetterInterface = 16081,
  TestNamespace = 16106,
  TestNonWrapperCacheInterface = 16120,
  TestParentInterface = 16149,
  TestPrefChromeOnlySCFuncConstructorForInterface = 16169,
  TestPrefConstructorForDifferentPrefInterface = 16217,
  TestPrefConstructorForInterface = 16262,
  TestProtoObjectHackedNamespace = 16294,
  TestRenamedInterface = 16325,
  TestRenamedNamespace = 16346,
  TestSCConstructorForInterface = 16367,
  TestSecureContextInterface = 16397,
  TestThrowingConstructorInterface = 16424,
  TestTrialInterface = 16457,
  TestUtils = 16476,
  TestWorkerExposedInterface = 16486,
  TestingDeprecatedInterface = 16513,
  Text = 16540,
  TextClause = 16545,
  TextDecoder = 16556,
  TextDecoderStream = 16568,
  TextEncoder = 16586,
  TextEncoderStream = 16598,
  TextMetrics = 16616,
  TextTrack = 16628,
  TextTrackCue = 16638,
  TextTrackCueList = 16651,
  TextTrackList = 16668,
  TimeEvent = 16682,
  TimeRanges = 16692,
  ToggleEvent = 16703,
  Touch = 16715,
  TouchEvent = 16721,
  TouchList = 16732,
  TrackEvent = 16742,
  TransformStream = 16753,
  TransformStreamDefaultController = 16769,
  TransitionEvent = 16802,
  TreeColumn = 16818,
  TreeColumns = 16829,
  TreeContentView = 16841,
  TreeWalker = 16857,
  UDPMessageEvent = 16868,
  UDPSocket = 16884,
  UIEvent = 16894,
  URL = 16902,
  URLSearchParams = 16906,
  URLSearchParams_Iterator = 16922,
  UniFFIPointer = 16947,
  UniFFIScaffolding = 16961,
  UserInteraction = 16979,
  UserProximityEvent = 16995,
  VRDisplay = 17014,
  VRDisplayCapabilities = 17024,
  VRDisplayEvent = 17046,
  VREyeParameters = 17061,
  VRFieldOfView = 17077,
  VRFrameData = 17091,
  VRMockController = 17103,
  VRMockDisplay = 17120,
  VRPose = 17134,
  VRServiceTest = 17141,
  VRStageParameters = 17155,
  VTTCue = 17173,
  VTTRegion = 17180,
  ValidityState = 17190,
  VideoColorSpace = 17204,
  VideoFrame = 17220,
  VideoPlaybackQuality = 17231,
  VideoTrack = 17252,
  VideoTrackList = 17263,
  VisualViewport = 17278,
  WEBGL_color_buffer_float = 17293,
  WEBGL_compressed_texture_astc = 17318,
  WEBGL_compressed_texture_etc = 17348,
  WEBGL_compressed_texture_etc1 = 17377,
  WEBGL_compressed_texture_pvrtc = 17407,
  WEBGL_compressed_texture_s3tc = 17438,
  WEBGL_compressed_texture_s3tc_srgb = 17468,
  WEBGL_debug_renderer_info = 17503,
  WEBGL_debug_shaders = 17529,
  WEBGL_depth_texture = 17549,
  WEBGL_draw_buffers = 17569,
  WEBGL_explicit_present = 17588,
  WEBGL_lose_context = 17611,
  WEBGL_provoking_vertex = 17630,
  WaveShaperNode = 17653,
  WebExtensionContentScript = 17668,
  WebExtensionPolicy = 17694,
  WebGL2RenderingContext = 17713,
  WebGLActiveInfo = 17736,
  WebGLBuffer = 17752,
  WebGLContextEvent = 17764,
  WebGLFramebuffer = 17782,
  WebGLProgram = 17799,
  WebGLQuery = 17812,
  WebGLRenderbuffer = 17823,
  WebGLRenderingContext = 17841,
  WebGLSampler = 17863,
  WebGLShader = 17876,
  WebGLShaderPrecisionFormat = 17888,
  WebGLSync = 17915,
  WebGLTexture = 17925,
  WebGLTransformFeedback = 17938,
  WebGLUniformLocation = 17961,
  WebGLVertexArrayObject = 17982,
  WebKitCSSMatrix = 18005,
  WebSocket = 18021,
  WebTransport = 18031,
  WebTransportBidirectionalStream = 18044,
  WebTransportDatagramDuplexStream = 18076,
  WebTransportError = 18109,
  WebTransportReceiveStream = 18127,
  WebTransportSendStream = 18153,
  WebrtcGlobalInformation = 18176,
  WheelEvent = 18200,
  Window = 18211,
  WindowClient = 18218,
  WindowContext = 18231,
  WindowGlobalChild = 18245,
  WindowGlobalParent = 18263,
  WindowRoot = 18282,
  Worker = 18293,
  WorkerDebuggerGlobalScope = 18300,
  WorkerGlobalScope = 18326,
  WorkerLocation = 18344,
  WorkerNavigator = 18359,
  WorkerTestUtils = 18375,
  Worklet = 18391,
  WorkletGlobalScope = 18399,
  WrapperCachedNonISupportsTestInterface = 18418,
  WritableStream = 18457,
  WritableStreamDefaultController = 18472,
  WritableStreamDefaultWriter = 18504,
  XMLDocument = 18532,
  XMLHttpRequest = 18544,
  XMLHttpRequestEventTarget = 18559,
  XMLHttpRequestUpload = 18585,
  XMLSerializer = 18606,
  XPathEvaluator = 18620,
  XPathExpression = 18635,
  XPathResult = 18651,
  XRBoundedReferenceSpace = 18663,
  XRFrame = 18687,
  XRInputSource = 18695,
  XRInputSourceArray = 18709,
  XRInputSourceEvent = 18728,
  XRInputSourcesChangeEvent = 18747,
  XRPose = 18773,
  XRReferenceSpace = 18780,
  XRReferenceSpaceEvent = 18797,
  XRRenderState = 18819,
  XRRigidTransform = 18833,
  XRSession = 18850,
  XRSessionEvent = 18860,
  XRSpace = 18875,
  XRSystem = 18883,
  XRView = 18892,
  XRViewerPose = 18899,
  XRViewport = 18912,
  XRWebGLLayer = 18923,
  XSLTProcessor = 18936,
  XULCommandEvent = 18950,
  XULElement = 18966,
  XULFrameElement = 18977,
  XULMenuElement = 18993,
  XULPopupElement = 19008,
  XULResizerElement = 19024,
  XULTextElement = 19042,
  XULTreeElement = 19057,
  console = 19072,
  webkitSpeechGrammar = 19080,
  webkitSpeechGrammarList = 19100,
  webkitSpeechRecognition = 19124,
  webkitURL = 19148,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // mozilla_dom_BindingNames_h
