/* THIS FILE IS AUTOGENERATED FROM CanvasRenderingContext2D.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_CanvasRenderingContext2DBinding_h
#define mozilla_dom_CanvasRenderingContext2DBinding_h

#include "CanvasPath.h"
#include "DOMPointBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Element.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class CanvasGradient;
class CanvasPath;
class CanvasPattern;
class CanvasRenderingContext2D;
struct ContextAttributes2DAtoms;
class Element;
class HTMLCanvasElement;
class HTMLImageElement;
class HTMLVideoElement;
struct HitRegionOptionsAtoms;
class ImageBitmap;
struct NativePropertyHooks;
class OffscreenCanvas;
class OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmap;
class OwningUTF8StringOrCanvasGradientOrCanvasPattern;
class ProtoAndIfaceCache;
class SVGImageElement;
class TextMetrics;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class CanvasWindingRule : uint8_t {
  Nonzero,
  Evenodd,
  EndGuard_
};

namespace CanvasWindingRuleValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(CanvasWindingRule::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(CanvasWindingRule stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace CanvasWindingRuleValues

bool
ToJSValue(JSContext* aCx, CanvasWindingRule aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmap& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningUTF8StringOrCanvasGradientOrCanvasPattern& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmap& aUnion);


void
ImplCycleCollectionUnlink(OwningUTF8StringOrCanvasGradientOrCanvasPattern& aUnion);


struct ContextAttributes2D : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mAlpha;
  MOZ_INIT_OUTSIDE_CTOR bool mWillReadFrequently;

  ContextAttributes2D();

  explicit inline ContextAttributes2D(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ContextAttributes2D(ContextAttributes2D&& aOther) = default;

  explicit inline ContextAttributes2D(const ContextAttributes2D& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ContextAttributes2D&
  operator=(const ContextAttributes2D& aOther);

  bool
  operator==(const ContextAttributes2D& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, ContextAttributes2DAtoms* atomsCache);
};

namespace binding_detail {
struct FastContextAttributes2D : public ContextAttributes2D
{
  inline FastContextAttributes2D()
    : ContextAttributes2D(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmap
{
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLImageElement,
    eSVGImageElement,
    eHTMLCanvasElement,
    eHTMLVideoElement,
    eOffscreenCanvas,
    eImageBitmap
  };
public:
  enum class Type
  {
    eHTMLImageElement = TypeOrUninit::eHTMLImageElement,
    eSVGImageElement = TypeOrUninit::eSVGImageElement,
    eHTMLCanvasElement = TypeOrUninit::eHTMLCanvasElement,
    eHTMLVideoElement = TypeOrUninit::eHTMLVideoElement,
    eOffscreenCanvas = TypeOrUninit::eOffscreenCanvas,
    eImageBitmap = TypeOrUninit::eImageBitmap
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::HTMLImageElement> > mHTMLImageElement;
    UnionMember<NonNull<mozilla::dom::SVGImageElement> > mSVGImageElement;
    UnionMember<NonNull<mozilla::dom::HTMLCanvasElement> > mHTMLCanvasElement;
    UnionMember<NonNull<mozilla::dom::HTMLVideoElement> > mHTMLVideoElement;
    UnionMember<NonNull<mozilla::dom::OffscreenCanvas> > mOffscreenCanvas;
    UnionMember<NonNull<mozilla::dom::ImageBitmap> > mImageBitmap;

  };

  TypeOrUninit mType;
  Value mValue;

  HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmap(const HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmap&) = delete;
  HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmap& operator=(const HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmap&) = delete;
public:
  explicit inline HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmap()
    : mType(eUninitialized)
  {
  }

  inline ~HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmap()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::HTMLImageElement>&
  RawSetAsHTMLImageElement()
  {
    if (mType == eHTMLImageElement) {
      return mValue.mHTMLImageElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLImageElement;
    return mValue.mHTMLImageElement.SetValue();
  }

  inline NonNull<mozilla::dom::HTMLImageElement>&
  SetAsHTMLImageElement()
  {
    if (mType == eHTMLImageElement) {
      return mValue.mHTMLImageElement.Value();
    }
    Uninit();
    mType = eHTMLImageElement;
    return mValue.mHTMLImageElement.SetValue();
  }

  inline bool
  IsHTMLImageElement() const
  {
    return mType == eHTMLImageElement;
  }

  inline NonNull<mozilla::dom::HTMLImageElement>&
  GetAsHTMLImageElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLImageElement(), "Wrong type!");
    return mValue.mHTMLImageElement.Value();
  }

  inline mozilla::dom::HTMLImageElement&
  GetAsHTMLImageElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLImageElement(), "Wrong type!");
    return mValue.mHTMLImageElement.Value();
  }

  inline NonNull<mozilla::dom::SVGImageElement>&
  RawSetAsSVGImageElement()
  {
    if (mType == eSVGImageElement) {
      return mValue.mSVGImageElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eSVGImageElement;
    return mValue.mSVGImageElement.SetValue();
  }

  inline NonNull<mozilla::dom::SVGImageElement>&
  SetAsSVGImageElement()
  {
    if (mType == eSVGImageElement) {
      return mValue.mSVGImageElement.Value();
    }
    Uninit();
    mType = eSVGImageElement;
    return mValue.mSVGImageElement.SetValue();
  }

  inline bool
  IsSVGImageElement() const
  {
    return mType == eSVGImageElement;
  }

  inline NonNull<mozilla::dom::SVGImageElement>&
  GetAsSVGImageElement()
  {
    MOZ_RELEASE_ASSERT(IsSVGImageElement(), "Wrong type!");
    return mValue.mSVGImageElement.Value();
  }

  inline mozilla::dom::SVGImageElement&
  GetAsSVGImageElement() const
  {
    MOZ_RELEASE_ASSERT(IsSVGImageElement(), "Wrong type!");
    return mValue.mSVGImageElement.Value();
  }

  inline NonNull<mozilla::dom::HTMLCanvasElement>&
  RawSetAsHTMLCanvasElement()
  {
    if (mType == eHTMLCanvasElement) {
      return mValue.mHTMLCanvasElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLCanvasElement;
    return mValue.mHTMLCanvasElement.SetValue();
  }

  inline NonNull<mozilla::dom::HTMLCanvasElement>&
  SetAsHTMLCanvasElement()
  {
    if (mType == eHTMLCanvasElement) {
      return mValue.mHTMLCanvasElement.Value();
    }
    Uninit();
    mType = eHTMLCanvasElement;
    return mValue.mHTMLCanvasElement.SetValue();
  }

  inline bool
  IsHTMLCanvasElement() const
  {
    return mType == eHTMLCanvasElement;
  }

  inline NonNull<mozilla::dom::HTMLCanvasElement>&
  GetAsHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  inline mozilla::dom::HTMLCanvasElement&
  GetAsHTMLCanvasElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  inline NonNull<mozilla::dom::HTMLVideoElement>&
  RawSetAsHTMLVideoElement()
  {
    if (mType == eHTMLVideoElement) {
      return mValue.mHTMLVideoElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLVideoElement;
    return mValue.mHTMLVideoElement.SetValue();
  }

  inline NonNull<mozilla::dom::HTMLVideoElement>&
  SetAsHTMLVideoElement()
  {
    if (mType == eHTMLVideoElement) {
      return mValue.mHTMLVideoElement.Value();
    }
    Uninit();
    mType = eHTMLVideoElement;
    return mValue.mHTMLVideoElement.SetValue();
  }

  inline bool
  IsHTMLVideoElement() const
  {
    return mType == eHTMLVideoElement;
  }

  inline NonNull<mozilla::dom::HTMLVideoElement>&
  GetAsHTMLVideoElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLVideoElement(), "Wrong type!");
    return mValue.mHTMLVideoElement.Value();
  }

  inline mozilla::dom::HTMLVideoElement&
  GetAsHTMLVideoElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLVideoElement(), "Wrong type!");
    return mValue.mHTMLVideoElement.Value();
  }

  inline NonNull<mozilla::dom::OffscreenCanvas>&
  RawSetAsOffscreenCanvas()
  {
    if (mType == eOffscreenCanvas) {
      return mValue.mOffscreenCanvas.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eOffscreenCanvas;
    return mValue.mOffscreenCanvas.SetValue();
  }

  inline NonNull<mozilla::dom::OffscreenCanvas>&
  SetAsOffscreenCanvas()
  {
    if (mType == eOffscreenCanvas) {
      return mValue.mOffscreenCanvas.Value();
    }
    Uninit();
    mType = eOffscreenCanvas;
    return mValue.mOffscreenCanvas.SetValue();
  }

  inline bool
  IsOffscreenCanvas() const
  {
    return mType == eOffscreenCanvas;
  }

  inline NonNull<mozilla::dom::OffscreenCanvas>&
  GetAsOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  inline mozilla::dom::OffscreenCanvas&
  GetAsOffscreenCanvas() const
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  inline NonNull<mozilla::dom::ImageBitmap>&
  RawSetAsImageBitmap()
  {
    if (mType == eImageBitmap) {
      return mValue.mImageBitmap.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eImageBitmap;
    return mValue.mImageBitmap.SetValue();
  }

  inline NonNull<mozilla::dom::ImageBitmap>&
  SetAsImageBitmap()
  {
    if (mType == eImageBitmap) {
      return mValue.mImageBitmap.Value();
    }
    Uninit();
    mType = eImageBitmap;
    return mValue.mImageBitmap.SetValue();
  }

  inline bool
  IsImageBitmap() const
  {
    return mType == eImageBitmap;
  }

  inline NonNull<mozilla::dom::ImageBitmap>&
  GetAsImageBitmap()
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  inline mozilla::dom::ImageBitmap&
  GetAsImageBitmap() const
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eHTMLImageElement: {
        DestroyHTMLImageElement();
        break;
      }
      case eSVGImageElement: {
        DestroySVGImageElement();
        break;
      }
      case eHTMLCanvasElement: {
        DestroyHTMLCanvasElement();
        break;
      }
      case eHTMLVideoElement: {
        DestroyHTMLVideoElement();
        break;
      }
      case eOffscreenCanvas: {
        DestroyOffscreenCanvas();
        break;
      }
      case eImageBitmap: {
        DestroyImageBitmap();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToHTMLImageElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLImageElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLImageElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLImageElement(), "Wrong type!");
    mValue.mHTMLImageElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToSVGImageElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSVGImageElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroySVGImageElement()
  {
    MOZ_RELEASE_ASSERT(IsSVGImageElement(), "Wrong type!");
    mValue.mSVGImageElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToHTMLCanvasElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLCanvasElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    mValue.mHTMLCanvasElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToHTMLVideoElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLVideoElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLVideoElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLVideoElement(), "Wrong type!");
    mValue.mHTMLVideoElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToOffscreenCanvas(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToOffscreenCanvas(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    mValue.mOffscreenCanvas.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToImageBitmap(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageBitmap(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyImageBitmap()
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    mValue.mImageBitmap.Destroy();
    mType = eUninitialized;
  }
};


class OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmap : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmap& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLImageElement,
    eSVGImageElement,
    eHTMLCanvasElement,
    eHTMLVideoElement,
    eOffscreenCanvas,
    eImageBitmap
  };
public:
  enum class Type
  {
    eHTMLImageElement = TypeOrUninit::eHTMLImageElement,
    eSVGImageElement = TypeOrUninit::eSVGImageElement,
    eHTMLCanvasElement = TypeOrUninit::eHTMLCanvasElement,
    eHTMLVideoElement = TypeOrUninit::eHTMLVideoElement,
    eOffscreenCanvas = TypeOrUninit::eOffscreenCanvas,
    eImageBitmap = TypeOrUninit::eImageBitmap
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::HTMLImageElement> > mHTMLImageElement;
    UnionMember<OwningNonNull<mozilla::dom::SVGImageElement> > mSVGImageElement;
    UnionMember<OwningNonNull<mozilla::dom::HTMLCanvasElement> > mHTMLCanvasElement;
    UnionMember<OwningNonNull<mozilla::dom::HTMLVideoElement> > mHTMLVideoElement;
    UnionMember<OwningNonNull<mozilla::dom::OffscreenCanvas> > mOffscreenCanvas;
    UnionMember<OwningNonNull<mozilla::dom::ImageBitmap> > mImageBitmap;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmap()
    : mType(eUninitialized)
  {
  }

  OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmap(OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmap&& aOther);

  explicit inline OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmap(const OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmap& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmap()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::HTMLImageElement>&
  RawSetAsHTMLImageElement();

  OwningNonNull<mozilla::dom::HTMLImageElement>&
  SetAsHTMLImageElement();

  inline bool
  IsHTMLImageElement() const
  {
    return mType == eHTMLImageElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLImageElement>&
  GetAsHTMLImageElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLImageElement(), "Wrong type!");
    return mValue.mHTMLImageElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLImageElement> const &
  GetAsHTMLImageElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLImageElement(), "Wrong type!");
    return mValue.mHTMLImageElement.Value();
  }

  OwningNonNull<mozilla::dom::SVGImageElement>&
  RawSetAsSVGImageElement();

  OwningNonNull<mozilla::dom::SVGImageElement>&
  SetAsSVGImageElement();

  inline bool
  IsSVGImageElement() const
  {
    return mType == eSVGImageElement;
  }

  inline OwningNonNull<mozilla::dom::SVGImageElement>&
  GetAsSVGImageElement()
  {
    MOZ_RELEASE_ASSERT(IsSVGImageElement(), "Wrong type!");
    return mValue.mSVGImageElement.Value();
  }

  inline OwningNonNull<mozilla::dom::SVGImageElement> const &
  GetAsSVGImageElement() const
  {
    MOZ_RELEASE_ASSERT(IsSVGImageElement(), "Wrong type!");
    return mValue.mSVGImageElement.Value();
  }

  OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  RawSetAsHTMLCanvasElement();

  OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  SetAsHTMLCanvasElement();

  inline bool
  IsHTMLCanvasElement() const
  {
    return mType == eHTMLCanvasElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  GetAsHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLCanvasElement> const &
  GetAsHTMLCanvasElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  OwningNonNull<mozilla::dom::HTMLVideoElement>&
  RawSetAsHTMLVideoElement();

  OwningNonNull<mozilla::dom::HTMLVideoElement>&
  SetAsHTMLVideoElement();

  inline bool
  IsHTMLVideoElement() const
  {
    return mType == eHTMLVideoElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLVideoElement>&
  GetAsHTMLVideoElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLVideoElement(), "Wrong type!");
    return mValue.mHTMLVideoElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLVideoElement> const &
  GetAsHTMLVideoElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLVideoElement(), "Wrong type!");
    return mValue.mHTMLVideoElement.Value();
  }

  OwningNonNull<mozilla::dom::OffscreenCanvas>&
  RawSetAsOffscreenCanvas();

  OwningNonNull<mozilla::dom::OffscreenCanvas>&
  SetAsOffscreenCanvas();

  inline bool
  IsOffscreenCanvas() const
  {
    return mType == eOffscreenCanvas;
  }

  inline OwningNonNull<mozilla::dom::OffscreenCanvas>&
  GetAsOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  inline OwningNonNull<mozilla::dom::OffscreenCanvas> const &
  GetAsOffscreenCanvas() const
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  OwningNonNull<mozilla::dom::ImageBitmap>&
  RawSetAsImageBitmap();

  OwningNonNull<mozilla::dom::ImageBitmap>&
  SetAsImageBitmap();

  inline bool
  IsImageBitmap() const
  {
    return mType == eImageBitmap;
  }

  inline OwningNonNull<mozilla::dom::ImageBitmap>&
  GetAsImageBitmap()
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  inline OwningNonNull<mozilla::dom::ImageBitmap> const &
  GetAsImageBitmap() const
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmap&
  operator=(OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmap&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmap&
  operator=(const OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmap& aOther);

private:
  bool
  TrySetToHTMLImageElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLImageElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLImageElement();

  bool
  TrySetToSVGImageElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSVGImageElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroySVGImageElement();

  bool
  TrySetToHTMLCanvasElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLCanvasElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLCanvasElement();

  bool
  TrySetToHTMLVideoElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLVideoElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLVideoElement();

  bool
  TrySetToOffscreenCanvas(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToOffscreenCanvas(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyOffscreenCanvas();

  bool
  TrySetToImageBitmap(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageBitmap(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyImageBitmap();
};


struct HitRegionOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR RefPtr<mozilla::dom::Element> mControl;
  MOZ_INIT_OUTSIDE_CTOR nsString mId;
  MOZ_INIT_OUTSIDE_CTOR RefPtr<mozilla::dom::CanvasPath> mPath;

  HitRegionOptions();

  explicit inline HitRegionOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  HitRegionOptions(HitRegionOptions&& aOther) = default;

  explicit inline HitRegionOptions(const HitRegionOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mControl, "mControl", aFlags);
    ImplCycleCollectionTraverse(aCallback, mPath, "mPath", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mControl);
    ImplCycleCollectionUnlink(mPath);
  }

  HitRegionOptions&
  operator=(const HitRegionOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, HitRegionOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastHitRegionOptions : public HitRegionOptions
{
  inline FastHitRegionOptions()
    : HitRegionOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class UTF8StringOrCanvasGradientOrCanvasPattern
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eCanvasGradient,
    eCanvasPattern
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eCanvasGradient = TypeOrUninit::eCanvasGradient,
    eCanvasPattern = TypeOrUninit::eCanvasPattern
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char> > mUTF8String;
    UnionMember<NonNull<mozilla::dom::CanvasGradient> > mCanvasGradient;
    UnionMember<NonNull<mozilla::dom::CanvasPattern> > mCanvasPattern;

  };

  TypeOrUninit mType;
  Value mValue;

  UTF8StringOrCanvasGradientOrCanvasPattern(const UTF8StringOrCanvasGradientOrCanvasPattern&) = delete;
  UTF8StringOrCanvasGradientOrCanvasPattern& operator=(const UTF8StringOrCanvasGradientOrCanvasPattern&) = delete;
public:
  explicit inline UTF8StringOrCanvasGradientOrCanvasPattern()
    : mType(eUninitialized)
  {
  }

  inline ~UTF8StringOrCanvasGradientOrCanvasPattern()
  {
    Uninit();
  }

  inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline NonNull<mozilla::dom::CanvasGradient>&
  RawSetAsCanvasGradient()
  {
    if (mType == eCanvasGradient) {
      return mValue.mCanvasGradient.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCanvasGradient;
    return mValue.mCanvasGradient.SetValue();
  }

  inline NonNull<mozilla::dom::CanvasGradient>&
  SetAsCanvasGradient()
  {
    if (mType == eCanvasGradient) {
      return mValue.mCanvasGradient.Value();
    }
    Uninit();
    mType = eCanvasGradient;
    return mValue.mCanvasGradient.SetValue();
  }

  inline bool
  IsCanvasGradient() const
  {
    return mType == eCanvasGradient;
  }

  inline NonNull<mozilla::dom::CanvasGradient>&
  GetAsCanvasGradient()
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    return mValue.mCanvasGradient.Value();
  }

  inline mozilla::dom::CanvasGradient&
  GetAsCanvasGradient() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    return mValue.mCanvasGradient.Value();
  }

  inline NonNull<mozilla::dom::CanvasPattern>&
  RawSetAsCanvasPattern()
  {
    if (mType == eCanvasPattern) {
      return mValue.mCanvasPattern.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCanvasPattern;
    return mValue.mCanvasPattern.SetValue();
  }

  inline NonNull<mozilla::dom::CanvasPattern>&
  SetAsCanvasPattern()
  {
    if (mType == eCanvasPattern) {
      return mValue.mCanvasPattern.Value();
    }
    Uninit();
    mType = eCanvasPattern;
    return mValue.mCanvasPattern.SetValue();
  }

  inline bool
  IsCanvasPattern() const
  {
    return mType == eCanvasPattern;
  }

  inline NonNull<mozilla::dom::CanvasPattern>&
  GetAsCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline mozilla::dom::CanvasPattern&
  GetAsCanvasPattern() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
      case eCanvasGradient: {
        DestroyCanvasGradient();
        break;
      }
      case eCanvasPattern: {
        DestroyCanvasPattern();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToCanvasGradient(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasGradient(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyCanvasGradient()
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    mValue.mCanvasGradient.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToCanvasPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    mValue.mCanvasPattern.Destroy();
    mType = eUninitialized;
  }
};


class OwningUTF8StringOrCanvasGradientOrCanvasPattern : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningUTF8StringOrCanvasGradientOrCanvasPattern& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eCanvasGradient,
    eCanvasPattern
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eCanvasGradient = TypeOrUninit::eCanvasGradient,
    eCanvasPattern = TypeOrUninit::eCanvasPattern
  };

private:
  union Value
  {
    UnionMember<nsCString > mUTF8String;
    UnionMember<OwningNonNull<mozilla::dom::CanvasGradient> > mCanvasGradient;
    UnionMember<OwningNonNull<mozilla::dom::CanvasPattern> > mCanvasPattern;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUTF8StringOrCanvasGradientOrCanvasPattern()
    : mType(eUninitialized)
  {
  }

  OwningUTF8StringOrCanvasGradientOrCanvasPattern(OwningUTF8StringOrCanvasGradientOrCanvasPattern&& aOther);

  explicit inline OwningUTF8StringOrCanvasGradientOrCanvasPattern(const OwningUTF8StringOrCanvasGradientOrCanvasPattern& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUTF8StringOrCanvasGradientOrCanvasPattern()
  {
    Uninit();
  }

  nsCString&
  RawSetAsUTF8String();

  nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  OwningNonNull<mozilla::dom::CanvasGradient>&
  RawSetAsCanvasGradient();

  OwningNonNull<mozilla::dom::CanvasGradient>&
  SetAsCanvasGradient();

  inline bool
  IsCanvasGradient() const
  {
    return mType == eCanvasGradient;
  }

  inline OwningNonNull<mozilla::dom::CanvasGradient>&
  GetAsCanvasGradient()
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    return mValue.mCanvasGradient.Value();
  }

  inline OwningNonNull<mozilla::dom::CanvasGradient> const &
  GetAsCanvasGradient() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    return mValue.mCanvasGradient.Value();
  }

  OwningNonNull<mozilla::dom::CanvasPattern>&
  RawSetAsCanvasPattern();

  OwningNonNull<mozilla::dom::CanvasPattern>&
  SetAsCanvasPattern();

  inline bool
  IsCanvasPattern() const
  {
    return mType == eCanvasPattern;
  }

  inline OwningNonNull<mozilla::dom::CanvasPattern>&
  GetAsCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline OwningNonNull<mozilla::dom::CanvasPattern> const &
  GetAsCanvasPattern() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningUTF8StringOrCanvasGradientOrCanvasPattern&
  operator=(OwningUTF8StringOrCanvasGradientOrCanvasPattern&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUTF8StringOrCanvasGradientOrCanvasPattern&
  operator=(const OwningUTF8StringOrCanvasGradientOrCanvasPattern& aOther);

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();

  bool
  TrySetToCanvasGradient(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasGradient(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyCanvasGradient();

  bool
  TrySetToCanvasPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyCanvasPattern();
};


class UnrestrictedDoubleOrDOMPointInit
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUnrestrictedDouble,
    eDOMPointInit
  };
public:
  enum class Type
  {
    eUnrestrictedDouble = TypeOrUninit::eUnrestrictedDouble,
    eDOMPointInit = TypeOrUninit::eDOMPointInit
  };

private:
  union Value
  {
    UnionMember<double > mUnrestrictedDouble;
    UnionMember<binding_detail::FastDOMPointInit > mDOMPointInit;

  };

  TypeOrUninit mType;
  Value mValue;

  UnrestrictedDoubleOrDOMPointInit(const UnrestrictedDoubleOrDOMPointInit&) = delete;
  UnrestrictedDoubleOrDOMPointInit& operator=(const UnrestrictedDoubleOrDOMPointInit&) = delete;
public:
  explicit inline UnrestrictedDoubleOrDOMPointInit()
    : mType(eUninitialized)
  {
  }

  inline ~UnrestrictedDoubleOrDOMPointInit()
  {
    Uninit();
  }

  inline double&
  RawSetAsUnrestrictedDouble()
  {
    if (mType == eUnrestrictedDouble) {
      return mValue.mUnrestrictedDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUnrestrictedDouble;
    return mValue.mUnrestrictedDouble.SetValue();
  }

  inline double&
  SetAsUnrestrictedDouble()
  {
    if (mType == eUnrestrictedDouble) {
      return mValue.mUnrestrictedDouble.Value();
    }
    Uninit();
    mType = eUnrestrictedDouble;
    return mValue.mUnrestrictedDouble.SetValue();
  }

  inline bool
  IsUnrestrictedDouble() const
  {
    return mType == eUnrestrictedDouble;
  }

  inline double&
  GetAsUnrestrictedDouble()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline double
  GetAsUnrestrictedDouble() const
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline binding_detail::FastDOMPointInit&
  RawSetAsDOMPointInit()
  {
    if (mType == eDOMPointInit) {
      return mValue.mDOMPointInit.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDOMPointInit;
    return mValue.mDOMPointInit.SetValue();
  }

  inline binding_detail::FastDOMPointInit&
  SetAsDOMPointInit()
  {
    if (mType == eDOMPointInit) {
      return mValue.mDOMPointInit.Value();
    }
    Uninit();
    mType = eDOMPointInit;
    return mValue.mDOMPointInit.SetValue();
  }

  inline bool
  IsDOMPointInit() const
  {
    return mType == eDOMPointInit;
  }

  inline binding_detail::FastDOMPointInit&
  GetAsDOMPointInit()
  {
    MOZ_RELEASE_ASSERT(IsDOMPointInit(), "Wrong type!");
    return mValue.mDOMPointInit.Value();
  }

  inline const DOMPointInit&
  GetAsDOMPointInit() const
  {
    MOZ_RELEASE_ASSERT(IsDOMPointInit(), "Wrong type!");
    return mValue.mDOMPointInit.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUnrestrictedDouble: {
        DestroyUnrestrictedDouble();
        break;
      }
      case eDOMPointInit: {
        DestroyDOMPointInit();
        break;
      }
    }
  }

private:
  bool
  TrySetToUnrestrictedDouble(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUnrestrictedDouble()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    mValue.mUnrestrictedDouble.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToDOMPointInit(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDOMPointInit(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDOMPointInit()
  {
    MOZ_RELEASE_ASSERT(IsDOMPointInit(), "Wrong type!");
    mValue.mDOMPointInit.Destroy();
    mType = eUninitialized;
  }
};


class OwningUnrestrictedDoubleOrDOMPointInit : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUnrestrictedDouble,
    eDOMPointInit
  };
public:
  enum class Type
  {
    eUnrestrictedDouble = TypeOrUninit::eUnrestrictedDouble,
    eDOMPointInit = TypeOrUninit::eDOMPointInit
  };

private:
  union Value
  {
    UnionMember<double > mUnrestrictedDouble;
    UnionMember<DOMPointInit > mDOMPointInit;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUnrestrictedDoubleOrDOMPointInit()
    : mType(eUninitialized)
  {
  }

  OwningUnrestrictedDoubleOrDOMPointInit(OwningUnrestrictedDoubleOrDOMPointInit&& aOther);

  explicit inline OwningUnrestrictedDoubleOrDOMPointInit(const OwningUnrestrictedDoubleOrDOMPointInit& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUnrestrictedDoubleOrDOMPointInit()
  {
    Uninit();
  }

  double&
  RawSetAsUnrestrictedDouble();

  double&
  SetAsUnrestrictedDouble();

  inline bool
  IsUnrestrictedDouble() const
  {
    return mType == eUnrestrictedDouble;
  }

  inline double&
  GetAsUnrestrictedDouble()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline double const &
  GetAsUnrestrictedDouble() const
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  DOMPointInit&
  RawSetAsDOMPointInit();

  DOMPointInit&
  SetAsDOMPointInit();

  inline bool
  IsDOMPointInit() const
  {
    return mType == eDOMPointInit;
  }

  inline DOMPointInit&
  GetAsDOMPointInit()
  {
    MOZ_RELEASE_ASSERT(IsDOMPointInit(), "Wrong type!");
    return mValue.mDOMPointInit.Value();
  }

  inline DOMPointInit const &
  GetAsDOMPointInit() const
  {
    MOZ_RELEASE_ASSERT(IsDOMPointInit(), "Wrong type!");
    return mValue.mDOMPointInit.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningUnrestrictedDoubleOrDOMPointInit&
  operator=(OwningUnrestrictedDoubleOrDOMPointInit&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUnrestrictedDoubleOrDOMPointInit&
  operator=(const OwningUnrestrictedDoubleOrDOMPointInit& aOther);

private:
  bool
  TrySetToUnrestrictedDouble(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUnrestrictedDouble();

  bool
  TrySetToDOMPointInit(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDOMPointInit(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDOMPointInit();
};


class UnrestrictedDoubleOrDOMPointInitOrUnrestrictedDoubleOrDOMPointInitSequence
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUnrestrictedDouble,
    eDOMPointInit,
    eUnrestrictedDoubleOrDOMPointInitSequence
  };
public:
  enum class Type
  {
    eUnrestrictedDouble = TypeOrUninit::eUnrestrictedDouble,
    eDOMPointInit = TypeOrUninit::eDOMPointInit,
    eUnrestrictedDoubleOrDOMPointInitSequence = TypeOrUninit::eUnrestrictedDoubleOrDOMPointInitSequence
  };

private:
  union Value
  {
    UnionMember<double > mUnrestrictedDouble;
    UnionMember<binding_detail::FastDOMPointInit > mDOMPointInit;
    UnionMember<binding_detail::AutoSequence<OwningUnrestrictedDoubleOrDOMPointInit> > mUnrestrictedDoubleOrDOMPointInitSequence;

  };

  TypeOrUninit mType;
  Value mValue;

  UnrestrictedDoubleOrDOMPointInitOrUnrestrictedDoubleOrDOMPointInitSequence(const UnrestrictedDoubleOrDOMPointInitOrUnrestrictedDoubleOrDOMPointInitSequence&) = delete;
  UnrestrictedDoubleOrDOMPointInitOrUnrestrictedDoubleOrDOMPointInitSequence& operator=(const UnrestrictedDoubleOrDOMPointInitOrUnrestrictedDoubleOrDOMPointInitSequence&) = delete;
public:
  explicit inline UnrestrictedDoubleOrDOMPointInitOrUnrestrictedDoubleOrDOMPointInitSequence()
    : mType(eUninitialized)
  {
  }

  inline ~UnrestrictedDoubleOrDOMPointInitOrUnrestrictedDoubleOrDOMPointInitSequence()
  {
    Uninit();
  }

  inline double&
  RawSetAsUnrestrictedDouble()
  {
    if (mType == eUnrestrictedDouble) {
      return mValue.mUnrestrictedDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUnrestrictedDouble;
    return mValue.mUnrestrictedDouble.SetValue();
  }

  inline double&
  SetAsUnrestrictedDouble()
  {
    if (mType == eUnrestrictedDouble) {
      return mValue.mUnrestrictedDouble.Value();
    }
    Uninit();
    mType = eUnrestrictedDouble;
    return mValue.mUnrestrictedDouble.SetValue();
  }

  inline bool
  IsUnrestrictedDouble() const
  {
    return mType == eUnrestrictedDouble;
  }

  inline double&
  GetAsUnrestrictedDouble()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline double
  GetAsUnrestrictedDouble() const
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline binding_detail::FastDOMPointInit&
  RawSetAsDOMPointInit()
  {
    if (mType == eDOMPointInit) {
      return mValue.mDOMPointInit.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDOMPointInit;
    return mValue.mDOMPointInit.SetValue();
  }

  inline binding_detail::FastDOMPointInit&
  SetAsDOMPointInit()
  {
    if (mType == eDOMPointInit) {
      return mValue.mDOMPointInit.Value();
    }
    Uninit();
    mType = eDOMPointInit;
    return mValue.mDOMPointInit.SetValue();
  }

  inline bool
  IsDOMPointInit() const
  {
    return mType == eDOMPointInit;
  }

  inline binding_detail::FastDOMPointInit&
  GetAsDOMPointInit()
  {
    MOZ_RELEASE_ASSERT(IsDOMPointInit(), "Wrong type!");
    return mValue.mDOMPointInit.Value();
  }

  inline const DOMPointInit&
  GetAsDOMPointInit() const
  {
    MOZ_RELEASE_ASSERT(IsDOMPointInit(), "Wrong type!");
    return mValue.mDOMPointInit.Value();
  }

  inline binding_detail::AutoSequence<OwningUnrestrictedDoubleOrDOMPointInit>&
  RawSetAsUnrestrictedDoubleOrDOMPointInitSequence()
  {
    if (mType == eUnrestrictedDoubleOrDOMPointInitSequence) {
      return mValue.mUnrestrictedDoubleOrDOMPointInitSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUnrestrictedDoubleOrDOMPointInitSequence;
    return mValue.mUnrestrictedDoubleOrDOMPointInitSequence.SetValue();
  }

  inline binding_detail::AutoSequence<OwningUnrestrictedDoubleOrDOMPointInit>&
  SetAsUnrestrictedDoubleOrDOMPointInitSequence()
  {
    if (mType == eUnrestrictedDoubleOrDOMPointInitSequence) {
      return mValue.mUnrestrictedDoubleOrDOMPointInitSequence.Value();
    }
    Uninit();
    mType = eUnrestrictedDoubleOrDOMPointInitSequence;
    return mValue.mUnrestrictedDoubleOrDOMPointInitSequence.SetValue();
  }

  inline bool
  IsUnrestrictedDoubleOrDOMPointInitSequence() const
  {
    return mType == eUnrestrictedDoubleOrDOMPointInitSequence;
  }

  inline binding_detail::AutoSequence<OwningUnrestrictedDoubleOrDOMPointInit>&
  GetAsUnrestrictedDoubleOrDOMPointInitSequence()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDoubleOrDOMPointInitSequence(), "Wrong type!");
    return mValue.mUnrestrictedDoubleOrDOMPointInitSequence.Value();
  }

  inline const Sequence<OwningUnrestrictedDoubleOrDOMPointInit>&
  GetAsUnrestrictedDoubleOrDOMPointInitSequence() const
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDoubleOrDOMPointInitSequence(), "Wrong type!");
    return mValue.mUnrestrictedDoubleOrDOMPointInitSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUnrestrictedDouble: {
        DestroyUnrestrictedDouble();
        break;
      }
      case eDOMPointInit: {
        DestroyDOMPointInit();
        break;
      }
      case eUnrestrictedDoubleOrDOMPointInitSequence: {
        DestroyUnrestrictedDoubleOrDOMPointInitSequence();
        break;
      }
    }
  }

private:
  bool
  TrySetToUnrestrictedDouble(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUnrestrictedDouble()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    mValue.mUnrestrictedDouble.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToDOMPointInit(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDOMPointInit(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDOMPointInit()
  {
    MOZ_RELEASE_ASSERT(IsDOMPointInit(), "Wrong type!");
    mValue.mDOMPointInit.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUnrestrictedDoubleOrDOMPointInitSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToUnrestrictedDoubleOrDOMPointInitSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUnrestrictedDoubleOrDOMPointInitSequence()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDoubleOrDOMPointInitSequence(), "Wrong type!");
    mValue.mUnrestrictedDoubleOrDOMPointInitSequence.Destroy();
    mType = eUninitialized;
  }
};


class OwningUnrestrictedDoubleOrDOMPointInitOrUnrestrictedDoubleOrDOMPointInitSequence : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUnrestrictedDouble,
    eDOMPointInit,
    eUnrestrictedDoubleOrDOMPointInitSequence
  };
public:
  enum class Type
  {
    eUnrestrictedDouble = TypeOrUninit::eUnrestrictedDouble,
    eDOMPointInit = TypeOrUninit::eDOMPointInit,
    eUnrestrictedDoubleOrDOMPointInitSequence = TypeOrUninit::eUnrestrictedDoubleOrDOMPointInitSequence
  };

private:
  union Value
  {
    UnionMember<double > mUnrestrictedDouble;
    UnionMember<DOMPointInit > mDOMPointInit;
    UnionMember<Sequence<OwningUnrestrictedDoubleOrDOMPointInit> > mUnrestrictedDoubleOrDOMPointInitSequence;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUnrestrictedDoubleOrDOMPointInitOrUnrestrictedDoubleOrDOMPointInitSequence()
    : mType(eUninitialized)
  {
  }

  OwningUnrestrictedDoubleOrDOMPointInitOrUnrestrictedDoubleOrDOMPointInitSequence(OwningUnrestrictedDoubleOrDOMPointInitOrUnrestrictedDoubleOrDOMPointInitSequence&& aOther);

  explicit inline OwningUnrestrictedDoubleOrDOMPointInitOrUnrestrictedDoubleOrDOMPointInitSequence(const OwningUnrestrictedDoubleOrDOMPointInitOrUnrestrictedDoubleOrDOMPointInitSequence& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUnrestrictedDoubleOrDOMPointInitOrUnrestrictedDoubleOrDOMPointInitSequence()
  {
    Uninit();
  }

  double&
  RawSetAsUnrestrictedDouble();

  double&
  SetAsUnrestrictedDouble();

  inline bool
  IsUnrestrictedDouble() const
  {
    return mType == eUnrestrictedDouble;
  }

  inline double&
  GetAsUnrestrictedDouble()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline double const &
  GetAsUnrestrictedDouble() const
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  DOMPointInit&
  RawSetAsDOMPointInit();

  DOMPointInit&
  SetAsDOMPointInit();

  inline bool
  IsDOMPointInit() const
  {
    return mType == eDOMPointInit;
  }

  inline DOMPointInit&
  GetAsDOMPointInit()
  {
    MOZ_RELEASE_ASSERT(IsDOMPointInit(), "Wrong type!");
    return mValue.mDOMPointInit.Value();
  }

  inline DOMPointInit const &
  GetAsDOMPointInit() const
  {
    MOZ_RELEASE_ASSERT(IsDOMPointInit(), "Wrong type!");
    return mValue.mDOMPointInit.Value();
  }

  Sequence<OwningUnrestrictedDoubleOrDOMPointInit>&
  RawSetAsUnrestrictedDoubleOrDOMPointInitSequence();

  Sequence<OwningUnrestrictedDoubleOrDOMPointInit>&
  SetAsUnrestrictedDoubleOrDOMPointInitSequence();

  inline bool
  IsUnrestrictedDoubleOrDOMPointInitSequence() const
  {
    return mType == eUnrestrictedDoubleOrDOMPointInitSequence;
  }

  inline Sequence<OwningUnrestrictedDoubleOrDOMPointInit>&
  GetAsUnrestrictedDoubleOrDOMPointInitSequence()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDoubleOrDOMPointInitSequence(), "Wrong type!");
    return mValue.mUnrestrictedDoubleOrDOMPointInitSequence.Value();
  }

  inline Sequence<OwningUnrestrictedDoubleOrDOMPointInit> const &
  GetAsUnrestrictedDoubleOrDOMPointInitSequence() const
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDoubleOrDOMPointInitSequence(), "Wrong type!");
    return mValue.mUnrestrictedDoubleOrDOMPointInitSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningUnrestrictedDoubleOrDOMPointInitOrUnrestrictedDoubleOrDOMPointInitSequence&
  operator=(OwningUnrestrictedDoubleOrDOMPointInitOrUnrestrictedDoubleOrDOMPointInitSequence&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUnrestrictedDoubleOrDOMPointInitOrUnrestrictedDoubleOrDOMPointInitSequence&
  operator=(const OwningUnrestrictedDoubleOrDOMPointInitOrUnrestrictedDoubleOrDOMPointInitSequence& aOther);

private:
  bool
  TrySetToUnrestrictedDouble(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUnrestrictedDouble();

  bool
  TrySetToDOMPointInit(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDOMPointInit(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDOMPointInit();

  bool
  TrySetToUnrestrictedDoubleOrDOMPointInitSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToUnrestrictedDoubleOrDOMPointInitSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUnrestrictedDoubleOrDOMPointInitSequence();
};


namespace CanvasGradient_Binding {

  typedef mozilla::dom::CanvasGradient NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::CanvasGradient* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::CanvasGradient,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::CanvasGradient,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace CanvasGradient_Binding



namespace CanvasPattern_Binding {

  typedef mozilla::dom::CanvasPattern NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::CanvasPattern* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::CanvasPattern,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::CanvasPattern,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace CanvasPattern_Binding



namespace CanvasRenderingContext2D_Binding {

  typedef mozilla::dom::CanvasRenderingContext2D NativeType;

  static const uint32_t DRAWWINDOW_DRAW_CARET = 1;
  static const uint32_t DRAWWINDOW_DO_NOT_FLUSH = 2;
  static const uint32_t DRAWWINDOW_DRAW_VIEW = 4;
  static const uint32_t DRAWWINDOW_USE_WIDGET_LAYERS = 8;
  static const uint32_t DRAWWINDOW_ASYNC_DECODE_IMAGES = 16;
  bool
  Wrap(JSContext* aCx, mozilla::dom::CanvasRenderingContext2D* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::CanvasRenderingContext2D,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::CanvasRenderingContext2D,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace CanvasRenderingContext2D_Binding



namespace Path2D_Binding {

  typedef mozilla::dom::CanvasPath NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::CanvasPath* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::Path2D,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::Path2D,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace Path2D_Binding



namespace TextMetrics_Binding {

  typedef mozilla::dom::TextMetrics NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::TextMetrics* aObject, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::TextMetrics,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::TextMetrics,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace TextMetrics_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_CanvasRenderingContext2DBinding_h
