/* THIS FILE IS AUTOGENERATED FROM FrameLoader.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_FrameLoaderBinding_h
#define mozilla_dom_FrameLoaderBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"

class nsFrameLoader;

namespace mozilla {
namespace dom {

struct NativePropertyHooks;
struct PrintPreviewSuccessInfoAtoms;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class PrintPreviewOrientation : uint8_t {
  Landscape,
  Portrait,
  Unspecified,
  EndGuard_
};

namespace PrintPreviewOrientationValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(PrintPreviewOrientation::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(PrintPreviewOrientation stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace PrintPreviewOrientationValues

bool
ToJSValue(JSContext* aCx, PrintPreviewOrientation aArgument, JS::MutableHandle<JS::Value> aValue);


struct PrintPreviewSuccessInfo : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mHasSelection;
  MOZ_INIT_OUTSIDE_CTOR bool mHasSelfSelection;
  MOZ_INIT_OUTSIDE_CTOR bool mIsEmpty;
  MOZ_INIT_OUTSIDE_CTOR PrintPreviewOrientation mOrientation;
  MOZ_INIT_OUTSIDE_CTOR Nullable<float> mPageHeight;
  MOZ_INIT_OUTSIDE_CTOR Nullable<float> mPageWidth;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mSheetCount;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mTotalPageCount;

  PrintPreviewSuccessInfo();

  explicit inline PrintPreviewSuccessInfo(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  PrintPreviewSuccessInfo(PrintPreviewSuccessInfo&& aOther) = default;

  explicit inline PrintPreviewSuccessInfo(const PrintPreviewSuccessInfo& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  PrintPreviewSuccessInfo&
  operator=(const PrintPreviewSuccessInfo& aOther);

private:
  static bool
  InitIds(JSContext* cx, PrintPreviewSuccessInfoAtoms* atomsCache);
};

namespace binding_detail {
struct FastPrintPreviewSuccessInfo : public PrintPreviewSuccessInfo
{
  inline FastPrintPreviewSuccessInfo()
    : PrintPreviewSuccessInfo(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace FrameLoader_Binding {

  typedef nsFrameLoader NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, nsFrameLoader* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::FrameLoader,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::FrameLoader,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace FrameLoader_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_FrameLoaderBinding_h
