/* THIS FILE IS AUTOGENERATED FROM IDBCursor.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_IDBCursorBinding_h
#define mozilla_dom_IDBCursorBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class IDBCursor;
class IDBIndex;
class IDBObjectStore;
struct NativePropertyHooks;
class OwningIDBObjectStoreOrIDBIndex;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class IDBCursorDirection : uint8_t {
  Next,
  Nextunique,
  Prev,
  Prevunique,
  EndGuard_
};

namespace IDBCursorDirectionValues {
extern const EnumEntry strings[5];

static constexpr size_t Count = 4;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(IDBCursorDirection::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(IDBCursorDirection stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace IDBCursorDirectionValues

bool
ToJSValue(JSContext* aCx, IDBCursorDirection aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningIDBObjectStoreOrIDBIndex& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningIDBObjectStoreOrIDBIndex& aUnion);


class IDBObjectStoreOrIDBIndex
{
  enum TypeOrUninit
  {
    eUninitialized,
    eIDBObjectStore,
    eIDBIndex
  };
public:
  enum class Type
  {
    eIDBObjectStore = TypeOrUninit::eIDBObjectStore,
    eIDBIndex = TypeOrUninit::eIDBIndex
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::IDBObjectStore> > mIDBObjectStore;
    UnionMember<NonNull<mozilla::dom::IDBIndex> > mIDBIndex;

  };

  TypeOrUninit mType;
  Value mValue;

  IDBObjectStoreOrIDBIndex(const IDBObjectStoreOrIDBIndex&) = delete;
  IDBObjectStoreOrIDBIndex& operator=(const IDBObjectStoreOrIDBIndex&) = delete;
public:
  explicit inline IDBObjectStoreOrIDBIndex()
    : mType(eUninitialized)
  {
  }

  inline ~IDBObjectStoreOrIDBIndex()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::IDBObjectStore>&
  RawSetAsIDBObjectStore()
  {
    if (mType == eIDBObjectStore) {
      return mValue.mIDBObjectStore.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eIDBObjectStore;
    return mValue.mIDBObjectStore.SetValue();
  }

  inline NonNull<mozilla::dom::IDBObjectStore>&
  SetAsIDBObjectStore()
  {
    if (mType == eIDBObjectStore) {
      return mValue.mIDBObjectStore.Value();
    }
    Uninit();
    mType = eIDBObjectStore;
    return mValue.mIDBObjectStore.SetValue();
  }

  inline bool
  IsIDBObjectStore() const
  {
    return mType == eIDBObjectStore;
  }

  inline NonNull<mozilla::dom::IDBObjectStore>&
  GetAsIDBObjectStore()
  {
    MOZ_RELEASE_ASSERT(IsIDBObjectStore(), "Wrong type!");
    return mValue.mIDBObjectStore.Value();
  }

  inline mozilla::dom::IDBObjectStore&
  GetAsIDBObjectStore() const
  {
    MOZ_RELEASE_ASSERT(IsIDBObjectStore(), "Wrong type!");
    return mValue.mIDBObjectStore.Value();
  }

  inline NonNull<mozilla::dom::IDBIndex>&
  RawSetAsIDBIndex()
  {
    if (mType == eIDBIndex) {
      return mValue.mIDBIndex.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eIDBIndex;
    return mValue.mIDBIndex.SetValue();
  }

  inline NonNull<mozilla::dom::IDBIndex>&
  SetAsIDBIndex()
  {
    if (mType == eIDBIndex) {
      return mValue.mIDBIndex.Value();
    }
    Uninit();
    mType = eIDBIndex;
    return mValue.mIDBIndex.SetValue();
  }

  inline bool
  IsIDBIndex() const
  {
    return mType == eIDBIndex;
  }

  inline NonNull<mozilla::dom::IDBIndex>&
  GetAsIDBIndex()
  {
    MOZ_RELEASE_ASSERT(IsIDBIndex(), "Wrong type!");
    return mValue.mIDBIndex.Value();
  }

  inline mozilla::dom::IDBIndex&
  GetAsIDBIndex() const
  {
    MOZ_RELEASE_ASSERT(IsIDBIndex(), "Wrong type!");
    return mValue.mIDBIndex.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eIDBObjectStore: {
        DestroyIDBObjectStore();
        break;
      }
      case eIDBIndex: {
        DestroyIDBIndex();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToIDBObjectStore(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToIDBObjectStore(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyIDBObjectStore()
  {
    MOZ_RELEASE_ASSERT(IsIDBObjectStore(), "Wrong type!");
    mValue.mIDBObjectStore.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToIDBIndex(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToIDBIndex(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyIDBIndex()
  {
    MOZ_RELEASE_ASSERT(IsIDBIndex(), "Wrong type!");
    mValue.mIDBIndex.Destroy();
    mType = eUninitialized;
  }
};


class OwningIDBObjectStoreOrIDBIndex : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningIDBObjectStoreOrIDBIndex& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eIDBObjectStore,
    eIDBIndex
  };
public:
  enum class Type
  {
    eIDBObjectStore = TypeOrUninit::eIDBObjectStore,
    eIDBIndex = TypeOrUninit::eIDBIndex
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::IDBObjectStore> > mIDBObjectStore;
    UnionMember<OwningNonNull<mozilla::dom::IDBIndex> > mIDBIndex;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningIDBObjectStoreOrIDBIndex()
    : mType(eUninitialized)
  {
  }

  OwningIDBObjectStoreOrIDBIndex(OwningIDBObjectStoreOrIDBIndex&& aOther);

  explicit inline OwningIDBObjectStoreOrIDBIndex(const OwningIDBObjectStoreOrIDBIndex& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningIDBObjectStoreOrIDBIndex()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::IDBObjectStore>&
  RawSetAsIDBObjectStore();

  OwningNonNull<mozilla::dom::IDBObjectStore>&
  SetAsIDBObjectStore();

  inline bool
  IsIDBObjectStore() const
  {
    return mType == eIDBObjectStore;
  }

  inline OwningNonNull<mozilla::dom::IDBObjectStore>&
  GetAsIDBObjectStore()
  {
    MOZ_RELEASE_ASSERT(IsIDBObjectStore(), "Wrong type!");
    return mValue.mIDBObjectStore.Value();
  }

  inline OwningNonNull<mozilla::dom::IDBObjectStore> const &
  GetAsIDBObjectStore() const
  {
    MOZ_RELEASE_ASSERT(IsIDBObjectStore(), "Wrong type!");
    return mValue.mIDBObjectStore.Value();
  }

  OwningNonNull<mozilla::dom::IDBIndex>&
  RawSetAsIDBIndex();

  OwningNonNull<mozilla::dom::IDBIndex>&
  SetAsIDBIndex();

  inline bool
  IsIDBIndex() const
  {
    return mType == eIDBIndex;
  }

  inline OwningNonNull<mozilla::dom::IDBIndex>&
  GetAsIDBIndex()
  {
    MOZ_RELEASE_ASSERT(IsIDBIndex(), "Wrong type!");
    return mValue.mIDBIndex.Value();
  }

  inline OwningNonNull<mozilla::dom::IDBIndex> const &
  GetAsIDBIndex() const
  {
    MOZ_RELEASE_ASSERT(IsIDBIndex(), "Wrong type!");
    return mValue.mIDBIndex.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningIDBObjectStoreOrIDBIndex&
  operator=(OwningIDBObjectStoreOrIDBIndex&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningIDBObjectStoreOrIDBIndex&
  operator=(const OwningIDBObjectStoreOrIDBIndex& aOther);

private:
  bool
  TrySetToIDBObjectStore(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToIDBObjectStore(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyIDBObjectStore();

  bool
  TrySetToIDBIndex(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToIDBIndex(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyIDBIndex();
};


namespace IDBCursor_Binding {

  typedef mozilla::dom::IDBCursor NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::IDBCursor* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::IDBCursor,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  JSObject*
  GetProtoObject(JSContext* aCx);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::IDBCursor,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace IDBCursor_Binding



namespace IDBCursorWithValue_Binding {

  typedef mozilla::dom::IDBCursor NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::IDBCursor* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::IDBCursorWithValue,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::IDBCursorWithValue,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace IDBCursorWithValue_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_IDBCursorBinding_h
