/* THIS FILE IS AUTOGENERATED FROM IOUtils.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_IOUtilsBinding_h
#define mozilla_dom_IOUtilsBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"

namespace mozilla {
namespace dom {

struct CopyOptionsAtoms;
struct FileInfoAtoms;
struct GetChildrenOptionsAtoms;
class IOUtils;
struct MakeDirectoryOptionsAtoms;
struct MoveOptionsAtoms;
struct NativePropertyHooks;
class ProtoAndIfaceCache;
struct ReadOptionsAtoms;
struct ReadUTF8OptionsAtoms;
struct RemoveOptionsAtoms;
class SyncReadFile;
struct WindowsFileAttributesAtoms;
struct WriteOptionsAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class WriteMode : uint8_t {
  Overwrite,
  Append,
  AppendOrCreate,
  Create,
  EndGuard_
};

namespace WriteModeValues {
extern const EnumEntry strings[5];

static constexpr size_t Count = 4;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(WriteMode::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(WriteMode stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace WriteModeValues

bool
ToJSValue(JSContext* aCx, WriteMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class FileType : uint8_t {
  Regular,
  Directory,
  Other,
  EndGuard_
};

namespace FileTypeValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(FileType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(FileType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace FileTypeValues

bool
ToJSValue(JSContext* aCx, FileType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class HashAlgorithm : uint8_t {
  Sha1,
  Sha256,
  Sha384,
  Sha512,
  EndGuard_
};

namespace HashAlgorithmValues {
extern const EnumEntry strings[5];

static constexpr size_t Count = 4;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(HashAlgorithm::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(HashAlgorithm stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace HashAlgorithmValues

bool
ToJSValue(JSContext* aCx, HashAlgorithm aArgument, JS::MutableHandle<JS::Value> aValue);


struct CopyOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mNoOverwrite;
  MOZ_INIT_OUTSIDE_CTOR bool mRecursive;

  CopyOptions();

  explicit inline CopyOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  CopyOptions(CopyOptions&& aOther) = default;

  explicit inline CopyOptions(const CopyOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  CopyOptions&
  operator=(const CopyOptions& aOther);

  bool
  operator==(const CopyOptions& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, CopyOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastCopyOptions : public CopyOptions
{
  inline FastCopyOptions()
    : CopyOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct FileInfo : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<int64_t> mCreationTime;
  MOZ_INIT_OUTSIDE_CTOR Optional<int64_t> mLastAccessed;
  MOZ_INIT_OUTSIDE_CTOR Optional<int64_t> mLastModified;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mPath;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mPermissions;
  MOZ_INIT_OUTSIDE_CTOR Optional<int64_t> mSize;
  MOZ_INIT_OUTSIDE_CTOR Optional<FileType> mType;

  FileInfo();

  explicit inline FileInfo(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  FileInfo(FileInfo&& aOther) = default;

  explicit inline FileInfo(const FileInfo& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  FileInfo&
  operator=(const FileInfo& aOther);

private:
  static bool
  InitIds(JSContext* cx, FileInfoAtoms* atomsCache);
};

namespace binding_detail {
struct FastFileInfo : public FileInfo
{
  inline FastFileInfo()
    : FileInfo(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GetChildrenOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mIgnoreAbsent;

  GetChildrenOptions();

  explicit inline GetChildrenOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GetChildrenOptions(GetChildrenOptions&& aOther) = default;

  explicit inline GetChildrenOptions(const GetChildrenOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GetChildrenOptions&
  operator=(const GetChildrenOptions& aOther);

  bool
  operator==(const GetChildrenOptions& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, GetChildrenOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastGetChildrenOptions : public GetChildrenOptions
{
  inline FastGetChildrenOptions()
    : GetChildrenOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MakeDirectoryOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mCreateAncestors;
  MOZ_INIT_OUTSIDE_CTOR bool mIgnoreExisting;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mPermissions;

  MakeDirectoryOptions();

  explicit inline MakeDirectoryOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  MakeDirectoryOptions(MakeDirectoryOptions&& aOther) = default;

  explicit inline MakeDirectoryOptions(const MakeDirectoryOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  MakeDirectoryOptions&
  operator=(const MakeDirectoryOptions& aOther);

  bool
  operator==(const MakeDirectoryOptions& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, MakeDirectoryOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastMakeDirectoryOptions : public MakeDirectoryOptions
{
  inline FastMakeDirectoryOptions()
    : MakeDirectoryOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MoveOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mNoOverwrite;

  MoveOptions();

  explicit inline MoveOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  MoveOptions(MoveOptions&& aOther) = default;

  explicit inline MoveOptions(const MoveOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  MoveOptions&
  operator=(const MoveOptions& aOther);

  bool
  operator==(const MoveOptions& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, MoveOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastMoveOptions : public MoveOptions
{
  inline FastMoveOptions()
    : MoveOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ReadUTF8Options : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mDecompress;

  ReadUTF8Options();

  explicit inline ReadUTF8Options(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ReadUTF8Options(ReadUTF8Options&& aOther) = default;

  explicit inline ReadUTF8Options(const ReadUTF8Options& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ReadUTF8Options&
  operator=(const ReadUTF8Options& aOther);

  bool
  operator==(const ReadUTF8Options& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, ReadUTF8OptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastReadUTF8Options : public ReadUTF8Options
{
  inline FastReadUTF8Options()
    : ReadUTF8Options(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RemoveOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mIgnoreAbsent;
  MOZ_INIT_OUTSIDE_CTOR bool mRecursive;
  MOZ_INIT_OUTSIDE_CTOR bool mRetryReadonly;

  RemoveOptions();

  explicit inline RemoveOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RemoveOptions(RemoveOptions&& aOther) = default;

  explicit inline RemoveOptions(const RemoveOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  RemoveOptions&
  operator=(const RemoveOptions& aOther);

  bool
  operator==(const RemoveOptions& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, RemoveOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastRemoveOptions : public RemoveOptions
{
  inline FastRemoveOptions()
    : RemoveOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct WindowsFileAttributes : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mHidden;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mReadOnly;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mSystem;

  WindowsFileAttributes();

  explicit inline WindowsFileAttributes(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  WindowsFileAttributes(WindowsFileAttributes&& aOther) = default;

  explicit inline WindowsFileAttributes(const WindowsFileAttributes& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  WindowsFileAttributes&
  operator=(const WindowsFileAttributes& aOther);

  bool
  operator==(const WindowsFileAttributes& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, WindowsFileAttributesAtoms* atomsCache);
};

namespace binding_detail {
struct FastWindowsFileAttributes : public WindowsFileAttributes
{
  inline FastWindowsFileAttributes()
    : WindowsFileAttributes(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct WriteOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mBackupFile;
  MOZ_INIT_OUTSIDE_CTOR bool mCompress;
  MOZ_INIT_OUTSIDE_CTOR bool mFlush;
  MOZ_INIT_OUTSIDE_CTOR WriteMode mMode;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mTmpPath;

  WriteOptions();

  explicit inline WriteOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  WriteOptions(WriteOptions&& aOther) = default;

  explicit inline WriteOptions(const WriteOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  WriteOptions&
  operator=(const WriteOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, WriteOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastWriteOptions : public WriteOptions
{
  inline FastWriteOptions()
    : WriteOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ReadOptions : public ReadUTF8Options
{
  MOZ_INIT_OUTSIDE_CTOR Nullable<uint32_t> mMaxBytes;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mOffset;

  ReadOptions();

  explicit inline ReadOptions(const FastDictionaryInitializer& )
    : ReadUTF8Options(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ReadOptions(ReadOptions&& aOther) = default;

  explicit inline ReadOptions(const ReadOptions& aOther)
    : ReadUTF8Options(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ReadOptions&
  operator=(const ReadOptions& aOther);

  bool
  operator==(const ReadOptions& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, ReadOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastReadOptions : public ReadOptions
{
  inline FastReadOptions()
    : ReadOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace IOUtils_Binding {

  typedef mozilla::dom::IOUtils NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::IOUtils,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace IOUtils_Binding



namespace SyncReadFile_Binding {

  typedef mozilla::dom::SyncReadFile NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::SyncReadFile* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::SyncReadFile,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::SyncReadFile,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace SyncReadFile_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_IOUtilsBinding_h
