/* THIS FILE IS AUTOGENERATED FROM ImageBitmap.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_ImageBitmapBinding_h
#define mozilla_dom_ImageBitmapBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class Blob;
class CanvasRenderingContext2D;
struct ChannelPixelLayoutAtoms;
class HTMLCanvasElement;
class HTMLImageElement;
class HTMLVideoElement;
class ImageBitmap;
struct ImageBitmapOptionsAtoms;
class ImageData;
struct NativePropertyHooks;
class OffscreenCanvas;
class OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData;
class ProtoAndIfaceCache;
class SVGImageElement;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class ImageBitmapFormat : uint8_t {
  RGBA32,
  BGRA32,
  RGB24,
  BGR24,
  GRAY8,
  YUV444P,
  YUV422P,
  YUV420P,
  YUV420SP_NV12,
  YUV420SP_NV21,
  HSV,
  Lab,
  DEPTH,
  EndGuard_
};

namespace ImageBitmapFormatValues {
extern const EnumEntry strings[14];

static constexpr size_t Count = 13;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(ImageBitmapFormat::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(ImageBitmapFormat stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace ImageBitmapFormatValues

bool
ToJSValue(JSContext* aCx, ImageBitmapFormat aArgument, JS::MutableHandle<JS::Value> aValue);


enum class ChannelPixelLayoutDataType : uint8_t {
  Uint8,
  Int8,
  Uint16,
  Int16,
  Uint32,
  Int32,
  Float32,
  Float64,
  EndGuard_
};

namespace ChannelPixelLayoutDataTypeValues {
extern const EnumEntry strings[9];

static constexpr size_t Count = 8;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(ChannelPixelLayoutDataType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(ChannelPixelLayoutDataType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace ChannelPixelLayoutDataTypeValues

bool
ToJSValue(JSContext* aCx, ChannelPixelLayoutDataType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class ImageOrientation : uint8_t {
  None,
  FlipY,
  From_image,
  EndGuard_
};

namespace ImageOrientationValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(ImageOrientation::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(ImageOrientation stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace ImageOrientationValues

bool
ToJSValue(JSContext* aCx, ImageOrientation aArgument, JS::MutableHandle<JS::Value> aValue);


enum class PremultiplyAlpha : uint8_t {
  None,
  Premultiply,
  Default,
  EndGuard_
};

namespace PremultiplyAlphaValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(PremultiplyAlpha::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(PremultiplyAlpha stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace PremultiplyAlphaValues

bool
ToJSValue(JSContext* aCx, PremultiplyAlpha aArgument, JS::MutableHandle<JS::Value> aValue);


enum class ColorSpaceConversion : uint8_t {
  None,
  Default,
  EndGuard_
};

namespace ColorSpaceConversionValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(ColorSpaceConversion::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(ColorSpaceConversion stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace ColorSpaceConversionValues

bool
ToJSValue(JSContext* aCx, ColorSpaceConversion aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData& aUnion);


struct ChannelPixelLayout : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR ChannelPixelLayoutDataType mDataType;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mHeight;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mOffset;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mSkip;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mStride;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mWidth;

  ChannelPixelLayout();

  explicit inline ChannelPixelLayout(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ChannelPixelLayout(ChannelPixelLayout&& aOther) = default;

  explicit inline ChannelPixelLayout(const ChannelPixelLayout& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ChannelPixelLayout&
  operator=(const ChannelPixelLayout& aOther);

private:
  static bool
  InitIds(JSContext* cx, ChannelPixelLayoutAtoms* atomsCache);
};

namespace binding_detail {
struct FastChannelPixelLayout : public ChannelPixelLayout
{
  inline FastChannelPixelLayout()
    : ChannelPixelLayout(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData
{
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLImageElement,
    eSVGImageElement,
    eHTMLCanvasElement,
    eHTMLVideoElement,
    eOffscreenCanvas,
    eImageBitmap,
    eBlob,
    eCanvasRenderingContext2D,
    eImageData
  };
public:
  enum class Type
  {
    eHTMLImageElement = TypeOrUninit::eHTMLImageElement,
    eSVGImageElement = TypeOrUninit::eSVGImageElement,
    eHTMLCanvasElement = TypeOrUninit::eHTMLCanvasElement,
    eHTMLVideoElement = TypeOrUninit::eHTMLVideoElement,
    eOffscreenCanvas = TypeOrUninit::eOffscreenCanvas,
    eImageBitmap = TypeOrUninit::eImageBitmap,
    eBlob = TypeOrUninit::eBlob,
    eCanvasRenderingContext2D = TypeOrUninit::eCanvasRenderingContext2D,
    eImageData = TypeOrUninit::eImageData
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::HTMLImageElement> > mHTMLImageElement;
    UnionMember<NonNull<mozilla::dom::SVGImageElement> > mSVGImageElement;
    UnionMember<NonNull<mozilla::dom::HTMLCanvasElement> > mHTMLCanvasElement;
    UnionMember<NonNull<mozilla::dom::HTMLVideoElement> > mHTMLVideoElement;
    UnionMember<NonNull<mozilla::dom::OffscreenCanvas> > mOffscreenCanvas;
    UnionMember<NonNull<mozilla::dom::ImageBitmap> > mImageBitmap;
    UnionMember<NonNull<mozilla::dom::Blob> > mBlob;
    UnionMember<NonNull<mozilla::dom::CanvasRenderingContext2D> > mCanvasRenderingContext2D;
    UnionMember<NonNull<mozilla::dom::ImageData> > mImageData;

  };

  TypeOrUninit mType;
  Value mValue;

  HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData(const HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData&) = delete;
  HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData& operator=(const HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData&) = delete;
public:
  explicit inline HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData()
    : mType(eUninitialized)
  {
  }

  inline ~HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::HTMLImageElement>&
  RawSetAsHTMLImageElement()
  {
    if (mType == eHTMLImageElement) {
      return mValue.mHTMLImageElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLImageElement;
    return mValue.mHTMLImageElement.SetValue();
  }

  inline NonNull<mozilla::dom::HTMLImageElement>&
  SetAsHTMLImageElement()
  {
    if (mType == eHTMLImageElement) {
      return mValue.mHTMLImageElement.Value();
    }
    Uninit();
    mType = eHTMLImageElement;
    return mValue.mHTMLImageElement.SetValue();
  }

  inline bool
  IsHTMLImageElement() const
  {
    return mType == eHTMLImageElement;
  }

  inline NonNull<mozilla::dom::HTMLImageElement>&
  GetAsHTMLImageElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLImageElement(), "Wrong type!");
    return mValue.mHTMLImageElement.Value();
  }

  inline mozilla::dom::HTMLImageElement&
  GetAsHTMLImageElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLImageElement(), "Wrong type!");
    return mValue.mHTMLImageElement.Value();
  }

  inline NonNull<mozilla::dom::SVGImageElement>&
  RawSetAsSVGImageElement()
  {
    if (mType == eSVGImageElement) {
      return mValue.mSVGImageElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eSVGImageElement;
    return mValue.mSVGImageElement.SetValue();
  }

  inline NonNull<mozilla::dom::SVGImageElement>&
  SetAsSVGImageElement()
  {
    if (mType == eSVGImageElement) {
      return mValue.mSVGImageElement.Value();
    }
    Uninit();
    mType = eSVGImageElement;
    return mValue.mSVGImageElement.SetValue();
  }

  inline bool
  IsSVGImageElement() const
  {
    return mType == eSVGImageElement;
  }

  inline NonNull<mozilla::dom::SVGImageElement>&
  GetAsSVGImageElement()
  {
    MOZ_RELEASE_ASSERT(IsSVGImageElement(), "Wrong type!");
    return mValue.mSVGImageElement.Value();
  }

  inline mozilla::dom::SVGImageElement&
  GetAsSVGImageElement() const
  {
    MOZ_RELEASE_ASSERT(IsSVGImageElement(), "Wrong type!");
    return mValue.mSVGImageElement.Value();
  }

  inline NonNull<mozilla::dom::HTMLCanvasElement>&
  RawSetAsHTMLCanvasElement()
  {
    if (mType == eHTMLCanvasElement) {
      return mValue.mHTMLCanvasElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLCanvasElement;
    return mValue.mHTMLCanvasElement.SetValue();
  }

  inline NonNull<mozilla::dom::HTMLCanvasElement>&
  SetAsHTMLCanvasElement()
  {
    if (mType == eHTMLCanvasElement) {
      return mValue.mHTMLCanvasElement.Value();
    }
    Uninit();
    mType = eHTMLCanvasElement;
    return mValue.mHTMLCanvasElement.SetValue();
  }

  inline bool
  IsHTMLCanvasElement() const
  {
    return mType == eHTMLCanvasElement;
  }

  inline NonNull<mozilla::dom::HTMLCanvasElement>&
  GetAsHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  inline mozilla::dom::HTMLCanvasElement&
  GetAsHTMLCanvasElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  inline NonNull<mozilla::dom::HTMLVideoElement>&
  RawSetAsHTMLVideoElement()
  {
    if (mType == eHTMLVideoElement) {
      return mValue.mHTMLVideoElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLVideoElement;
    return mValue.mHTMLVideoElement.SetValue();
  }

  inline NonNull<mozilla::dom::HTMLVideoElement>&
  SetAsHTMLVideoElement()
  {
    if (mType == eHTMLVideoElement) {
      return mValue.mHTMLVideoElement.Value();
    }
    Uninit();
    mType = eHTMLVideoElement;
    return mValue.mHTMLVideoElement.SetValue();
  }

  inline bool
  IsHTMLVideoElement() const
  {
    return mType == eHTMLVideoElement;
  }

  inline NonNull<mozilla::dom::HTMLVideoElement>&
  GetAsHTMLVideoElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLVideoElement(), "Wrong type!");
    return mValue.mHTMLVideoElement.Value();
  }

  inline mozilla::dom::HTMLVideoElement&
  GetAsHTMLVideoElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLVideoElement(), "Wrong type!");
    return mValue.mHTMLVideoElement.Value();
  }

  inline NonNull<mozilla::dom::OffscreenCanvas>&
  RawSetAsOffscreenCanvas()
  {
    if (mType == eOffscreenCanvas) {
      return mValue.mOffscreenCanvas.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eOffscreenCanvas;
    return mValue.mOffscreenCanvas.SetValue();
  }

  inline NonNull<mozilla::dom::OffscreenCanvas>&
  SetAsOffscreenCanvas()
  {
    if (mType == eOffscreenCanvas) {
      return mValue.mOffscreenCanvas.Value();
    }
    Uninit();
    mType = eOffscreenCanvas;
    return mValue.mOffscreenCanvas.SetValue();
  }

  inline bool
  IsOffscreenCanvas() const
  {
    return mType == eOffscreenCanvas;
  }

  inline NonNull<mozilla::dom::OffscreenCanvas>&
  GetAsOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  inline mozilla::dom::OffscreenCanvas&
  GetAsOffscreenCanvas() const
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  inline NonNull<mozilla::dom::ImageBitmap>&
  RawSetAsImageBitmap()
  {
    if (mType == eImageBitmap) {
      return mValue.mImageBitmap.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eImageBitmap;
    return mValue.mImageBitmap.SetValue();
  }

  inline NonNull<mozilla::dom::ImageBitmap>&
  SetAsImageBitmap()
  {
    if (mType == eImageBitmap) {
      return mValue.mImageBitmap.Value();
    }
    Uninit();
    mType = eImageBitmap;
    return mValue.mImageBitmap.SetValue();
  }

  inline bool
  IsImageBitmap() const
  {
    return mType == eImageBitmap;
  }

  inline NonNull<mozilla::dom::ImageBitmap>&
  GetAsImageBitmap()
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  inline mozilla::dom::ImageBitmap&
  GetAsImageBitmap() const
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  inline NonNull<mozilla::dom::Blob>&
  RawSetAsBlob()
  {
    if (mType == eBlob) {
      return mValue.mBlob.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBlob;
    return mValue.mBlob.SetValue();
  }

  inline NonNull<mozilla::dom::Blob>&
  SetAsBlob()
  {
    if (mType == eBlob) {
      return mValue.mBlob.Value();
    }
    Uninit();
    mType = eBlob;
    return mValue.mBlob.SetValue();
  }

  inline bool
  IsBlob() const
  {
    return mType == eBlob;
  }

  inline NonNull<mozilla::dom::Blob>&
  GetAsBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline mozilla::dom::Blob&
  GetAsBlob() const
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline NonNull<mozilla::dom::CanvasRenderingContext2D>&
  RawSetAsCanvasRenderingContext2D()
  {
    if (mType == eCanvasRenderingContext2D) {
      return mValue.mCanvasRenderingContext2D.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCanvasRenderingContext2D;
    return mValue.mCanvasRenderingContext2D.SetValue();
  }

  inline NonNull<mozilla::dom::CanvasRenderingContext2D>&
  SetAsCanvasRenderingContext2D()
  {
    if (mType == eCanvasRenderingContext2D) {
      return mValue.mCanvasRenderingContext2D.Value();
    }
    Uninit();
    mType = eCanvasRenderingContext2D;
    return mValue.mCanvasRenderingContext2D.SetValue();
  }

  inline bool
  IsCanvasRenderingContext2D() const
  {
    return mType == eCanvasRenderingContext2D;
  }

  inline NonNull<mozilla::dom::CanvasRenderingContext2D>&
  GetAsCanvasRenderingContext2D()
  {
    MOZ_RELEASE_ASSERT(IsCanvasRenderingContext2D(), "Wrong type!");
    return mValue.mCanvasRenderingContext2D.Value();
  }

  inline mozilla::dom::CanvasRenderingContext2D&
  GetAsCanvasRenderingContext2D() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasRenderingContext2D(), "Wrong type!");
    return mValue.mCanvasRenderingContext2D.Value();
  }

  inline NonNull<mozilla::dom::ImageData>&
  RawSetAsImageData()
  {
    if (mType == eImageData) {
      return mValue.mImageData.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eImageData;
    return mValue.mImageData.SetValue();
  }

  inline NonNull<mozilla::dom::ImageData>&
  SetAsImageData()
  {
    if (mType == eImageData) {
      return mValue.mImageData.Value();
    }
    Uninit();
    mType = eImageData;
    return mValue.mImageData.SetValue();
  }

  inline bool
  IsImageData() const
  {
    return mType == eImageData;
  }

  inline NonNull<mozilla::dom::ImageData>&
  GetAsImageData()
  {
    MOZ_RELEASE_ASSERT(IsImageData(), "Wrong type!");
    return mValue.mImageData.Value();
  }

  inline mozilla::dom::ImageData&
  GetAsImageData() const
  {
    MOZ_RELEASE_ASSERT(IsImageData(), "Wrong type!");
    return mValue.mImageData.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eHTMLImageElement: {
        DestroyHTMLImageElement();
        break;
      }
      case eSVGImageElement: {
        DestroySVGImageElement();
        break;
      }
      case eHTMLCanvasElement: {
        DestroyHTMLCanvasElement();
        break;
      }
      case eHTMLVideoElement: {
        DestroyHTMLVideoElement();
        break;
      }
      case eOffscreenCanvas: {
        DestroyOffscreenCanvas();
        break;
      }
      case eImageBitmap: {
        DestroyImageBitmap();
        break;
      }
      case eBlob: {
        DestroyBlob();
        break;
      }
      case eCanvasRenderingContext2D: {
        DestroyCanvasRenderingContext2D();
        break;
      }
      case eImageData: {
        DestroyImageData();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToHTMLImageElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLImageElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLImageElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLImageElement(), "Wrong type!");
    mValue.mHTMLImageElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToSVGImageElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSVGImageElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroySVGImageElement()
  {
    MOZ_RELEASE_ASSERT(IsSVGImageElement(), "Wrong type!");
    mValue.mSVGImageElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToHTMLCanvasElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLCanvasElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    mValue.mHTMLCanvasElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToHTMLVideoElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLVideoElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLVideoElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLVideoElement(), "Wrong type!");
    mValue.mHTMLVideoElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToOffscreenCanvas(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToOffscreenCanvas(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    mValue.mOffscreenCanvas.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToImageBitmap(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageBitmap(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyImageBitmap()
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    mValue.mImageBitmap.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToBlob(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToBlob(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    mValue.mBlob.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToCanvasRenderingContext2D(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasRenderingContext2D(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyCanvasRenderingContext2D()
  {
    MOZ_RELEASE_ASSERT(IsCanvasRenderingContext2D(), "Wrong type!");
    mValue.mCanvasRenderingContext2D.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToImageData(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageData(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyImageData()
  {
    MOZ_RELEASE_ASSERT(IsImageData(), "Wrong type!");
    mValue.mImageData.Destroy();
    mType = eUninitialized;
  }
};


class OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLImageElement,
    eSVGImageElement,
    eHTMLCanvasElement,
    eHTMLVideoElement,
    eOffscreenCanvas,
    eImageBitmap,
    eBlob,
    eCanvasRenderingContext2D,
    eImageData
  };
public:
  enum class Type
  {
    eHTMLImageElement = TypeOrUninit::eHTMLImageElement,
    eSVGImageElement = TypeOrUninit::eSVGImageElement,
    eHTMLCanvasElement = TypeOrUninit::eHTMLCanvasElement,
    eHTMLVideoElement = TypeOrUninit::eHTMLVideoElement,
    eOffscreenCanvas = TypeOrUninit::eOffscreenCanvas,
    eImageBitmap = TypeOrUninit::eImageBitmap,
    eBlob = TypeOrUninit::eBlob,
    eCanvasRenderingContext2D = TypeOrUninit::eCanvasRenderingContext2D,
    eImageData = TypeOrUninit::eImageData
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::HTMLImageElement> > mHTMLImageElement;
    UnionMember<OwningNonNull<mozilla::dom::SVGImageElement> > mSVGImageElement;
    UnionMember<OwningNonNull<mozilla::dom::HTMLCanvasElement> > mHTMLCanvasElement;
    UnionMember<OwningNonNull<mozilla::dom::HTMLVideoElement> > mHTMLVideoElement;
    UnionMember<OwningNonNull<mozilla::dom::OffscreenCanvas> > mOffscreenCanvas;
    UnionMember<OwningNonNull<mozilla::dom::ImageBitmap> > mImageBitmap;
    UnionMember<OwningNonNull<mozilla::dom::Blob> > mBlob;
    UnionMember<OwningNonNull<mozilla::dom::CanvasRenderingContext2D> > mCanvasRenderingContext2D;
    UnionMember<OwningNonNull<mozilla::dom::ImageData> > mImageData;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData()
    : mType(eUninitialized)
  {
  }

  OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData(OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData&& aOther);

  explicit inline OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData(const OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::HTMLImageElement>&
  RawSetAsHTMLImageElement();

  OwningNonNull<mozilla::dom::HTMLImageElement>&
  SetAsHTMLImageElement();

  inline bool
  IsHTMLImageElement() const
  {
    return mType == eHTMLImageElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLImageElement>&
  GetAsHTMLImageElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLImageElement(), "Wrong type!");
    return mValue.mHTMLImageElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLImageElement> const &
  GetAsHTMLImageElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLImageElement(), "Wrong type!");
    return mValue.mHTMLImageElement.Value();
  }

  OwningNonNull<mozilla::dom::SVGImageElement>&
  RawSetAsSVGImageElement();

  OwningNonNull<mozilla::dom::SVGImageElement>&
  SetAsSVGImageElement();

  inline bool
  IsSVGImageElement() const
  {
    return mType == eSVGImageElement;
  }

  inline OwningNonNull<mozilla::dom::SVGImageElement>&
  GetAsSVGImageElement()
  {
    MOZ_RELEASE_ASSERT(IsSVGImageElement(), "Wrong type!");
    return mValue.mSVGImageElement.Value();
  }

  inline OwningNonNull<mozilla::dom::SVGImageElement> const &
  GetAsSVGImageElement() const
  {
    MOZ_RELEASE_ASSERT(IsSVGImageElement(), "Wrong type!");
    return mValue.mSVGImageElement.Value();
  }

  OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  RawSetAsHTMLCanvasElement();

  OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  SetAsHTMLCanvasElement();

  inline bool
  IsHTMLCanvasElement() const
  {
    return mType == eHTMLCanvasElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  GetAsHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLCanvasElement> const &
  GetAsHTMLCanvasElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  OwningNonNull<mozilla::dom::HTMLVideoElement>&
  RawSetAsHTMLVideoElement();

  OwningNonNull<mozilla::dom::HTMLVideoElement>&
  SetAsHTMLVideoElement();

  inline bool
  IsHTMLVideoElement() const
  {
    return mType == eHTMLVideoElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLVideoElement>&
  GetAsHTMLVideoElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLVideoElement(), "Wrong type!");
    return mValue.mHTMLVideoElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLVideoElement> const &
  GetAsHTMLVideoElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLVideoElement(), "Wrong type!");
    return mValue.mHTMLVideoElement.Value();
  }

  OwningNonNull<mozilla::dom::OffscreenCanvas>&
  RawSetAsOffscreenCanvas();

  OwningNonNull<mozilla::dom::OffscreenCanvas>&
  SetAsOffscreenCanvas();

  inline bool
  IsOffscreenCanvas() const
  {
    return mType == eOffscreenCanvas;
  }

  inline OwningNonNull<mozilla::dom::OffscreenCanvas>&
  GetAsOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  inline OwningNonNull<mozilla::dom::OffscreenCanvas> const &
  GetAsOffscreenCanvas() const
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  OwningNonNull<mozilla::dom::ImageBitmap>&
  RawSetAsImageBitmap();

  OwningNonNull<mozilla::dom::ImageBitmap>&
  SetAsImageBitmap();

  inline bool
  IsImageBitmap() const
  {
    return mType == eImageBitmap;
  }

  inline OwningNonNull<mozilla::dom::ImageBitmap>&
  GetAsImageBitmap()
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  inline OwningNonNull<mozilla::dom::ImageBitmap> const &
  GetAsImageBitmap() const
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  OwningNonNull<mozilla::dom::Blob>&
  RawSetAsBlob();

  OwningNonNull<mozilla::dom::Blob>&
  SetAsBlob();

  inline bool
  IsBlob() const
  {
    return mType == eBlob;
  }

  inline OwningNonNull<mozilla::dom::Blob>&
  GetAsBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline OwningNonNull<mozilla::dom::Blob> const &
  GetAsBlob() const
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  OwningNonNull<mozilla::dom::CanvasRenderingContext2D>&
  RawSetAsCanvasRenderingContext2D();

  OwningNonNull<mozilla::dom::CanvasRenderingContext2D>&
  SetAsCanvasRenderingContext2D();

  inline bool
  IsCanvasRenderingContext2D() const
  {
    return mType == eCanvasRenderingContext2D;
  }

  inline OwningNonNull<mozilla::dom::CanvasRenderingContext2D>&
  GetAsCanvasRenderingContext2D()
  {
    MOZ_RELEASE_ASSERT(IsCanvasRenderingContext2D(), "Wrong type!");
    return mValue.mCanvasRenderingContext2D.Value();
  }

  inline OwningNonNull<mozilla::dom::CanvasRenderingContext2D> const &
  GetAsCanvasRenderingContext2D() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasRenderingContext2D(), "Wrong type!");
    return mValue.mCanvasRenderingContext2D.Value();
  }

  OwningNonNull<mozilla::dom::ImageData>&
  RawSetAsImageData();

  OwningNonNull<mozilla::dom::ImageData>&
  SetAsImageData();

  inline bool
  IsImageData() const
  {
    return mType == eImageData;
  }

  inline OwningNonNull<mozilla::dom::ImageData>&
  GetAsImageData()
  {
    MOZ_RELEASE_ASSERT(IsImageData(), "Wrong type!");
    return mValue.mImageData.Value();
  }

  inline OwningNonNull<mozilla::dom::ImageData> const &
  GetAsImageData() const
  {
    MOZ_RELEASE_ASSERT(IsImageData(), "Wrong type!");
    return mValue.mImageData.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData&
  operator=(OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData&
  operator=(const OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData& aOther);

private:
  bool
  TrySetToHTMLImageElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLImageElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLImageElement();

  bool
  TrySetToSVGImageElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSVGImageElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroySVGImageElement();

  bool
  TrySetToHTMLCanvasElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLCanvasElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLCanvasElement();

  bool
  TrySetToHTMLVideoElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLVideoElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLVideoElement();

  bool
  TrySetToOffscreenCanvas(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToOffscreenCanvas(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyOffscreenCanvas();

  bool
  TrySetToImageBitmap(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageBitmap(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyImageBitmap();

  bool
  TrySetToBlob(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToBlob(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyBlob();

  bool
  TrySetToCanvasRenderingContext2D(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasRenderingContext2D(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyCanvasRenderingContext2D();

  bool
  TrySetToImageData(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageData(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyImageData();
};


struct ImageBitmapOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR ColorSpaceConversion mColorSpaceConversion;
  MOZ_INIT_OUTSIDE_CTOR ImageOrientation mImageOrientation;
  MOZ_INIT_OUTSIDE_CTOR PremultiplyAlpha mPremultiplyAlpha;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mResizeHeight;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mResizeWidth;

  ImageBitmapOptions();

  explicit inline ImageBitmapOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ImageBitmapOptions(ImageBitmapOptions&& aOther) = default;

  explicit inline ImageBitmapOptions(const ImageBitmapOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ImageBitmapOptions&
  operator=(const ImageBitmapOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, ImageBitmapOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastImageBitmapOptions : public ImageBitmapOptions
{
  inline FastImageBitmapOptions()
    : ImageBitmapOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace ImageBitmap_Binding {

  typedef mozilla::dom::ImageBitmap NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::ImageBitmap* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::ImageBitmap,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::ImageBitmap,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace ImageBitmap_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_ImageBitmapBinding_h
