/* THIS FILE IS AUTOGENERATED FROM RTCPeerConnection.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_RTCPeerConnectionBinding_h
#define mozilla_dom_RTCPeerConnectionBinding_h

#include "RTCIceCandidateBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/DOMEventTargetHelper.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/TypedArray.h"
#include "mozilla/dom/UnionMember.h"
#include "nsWeakReference.h"

class nsDOMDataChannel;

namespace mozilla {

class DOMMediaStream;

namespace dom {

class DOMException;
class EventHandlerNonNull;
class MediaStreamTrack;
class MediaStreamTrackOrString;
struct NativePropertyHooks;
class ObjectOrString;
class OwningMediaStreamTrackOrString;
class OwningObjectOrString;
class OwningRTCIceCandidateInitOrRTCIceCandidate;
class Promise;
class ProtoAndIfaceCache;
struct RTCAnswerOptions;
struct RTCConfiguration;
struct RTCDataChannelInit;
struct RTCDataChannelInitAtoms;
class RTCIceCandidate;
class RTCIceCandidateInitOrRTCIceCandidate;
struct RTCIdentityProviderOptions;
struct RTCOfferOptions;
struct RTCOfferOptionsAtoms;
class RTCPeerConnection;
struct RTCPeerConnectionAtoms;
class RTCPeerConnectionErrorCallback;
class RTCRtpReceiver;
class RTCRtpSender;
class RTCRtpTransceiver;
struct RTCRtpTransceiverInit;
class RTCSctpTransport;
class RTCSessionDescription;
class RTCSessionDescriptionCallback;
struct RTCSessionDescriptionInit;
class RTCStatsCallback;
class RTCStatsReport;
class VoidFunction;
class mozPacketCallback;

} // namespace dom

} // namespace mozilla

namespace mozilla::dom {

enum class RTCSignalingState : uint8_t {
  Stable,
  Have_local_offer,
  Have_remote_offer,
  Have_local_pranswer,
  Have_remote_pranswer,
  Closed,
  EndGuard_
};

namespace RTCSignalingStateValues {
extern const EnumEntry strings[7];

static constexpr size_t Count = 6;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(RTCSignalingState::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(RTCSignalingState stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace RTCSignalingStateValues

bool
ToJSValue(JSContext* aCx, RTCSignalingState aArgument, JS::MutableHandle<JS::Value> aValue);


enum class RTCIceGatheringState : uint8_t {
  New,
  Gathering,
  Complete,
  EndGuard_
};

namespace RTCIceGatheringStateValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(RTCIceGatheringState::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(RTCIceGatheringState stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace RTCIceGatheringStateValues

bool
ToJSValue(JSContext* aCx, RTCIceGatheringState aArgument, JS::MutableHandle<JS::Value> aValue);


enum class RTCIceConnectionState : uint8_t {
  New,
  Checking,
  Connected,
  Completed,
  Failed,
  Disconnected,
  Closed,
  EndGuard_
};

namespace RTCIceConnectionStateValues {
extern const EnumEntry strings[8];

static constexpr size_t Count = 7;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(RTCIceConnectionState::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(RTCIceConnectionState stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace RTCIceConnectionStateValues

bool
ToJSValue(JSContext* aCx, RTCIceConnectionState aArgument, JS::MutableHandle<JS::Value> aValue);


enum class RTCPeerConnectionState : uint8_t {
  Closed,
  Failed,
  Disconnected,
  New,
  Connecting,
  Connected,
  EndGuard_
};

namespace RTCPeerConnectionStateValues {
extern const EnumEntry strings[7];

static constexpr size_t Count = 6;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(RTCPeerConnectionState::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(RTCPeerConnectionState stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace RTCPeerConnectionStateValues

bool
ToJSValue(JSContext* aCx, RTCPeerConnectionState aArgument, JS::MutableHandle<JS::Value> aValue);


enum class mozPacketDumpType : uint8_t {
  Rtp,
  Srtp,
  Rtcp,
  Srtcp,
  EndGuard_
};

namespace mozPacketDumpTypeValues {
extern const EnumEntry strings[5];

static constexpr size_t Count = 4;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(mozPacketDumpType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(mozPacketDumpType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace mozPacketDumpTypeValues

bool
ToJSValue(JSContext* aCx, mozPacketDumpType aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningMediaStreamTrackOrString& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningRTCIceCandidateInitOrRTCIceCandidate& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningMediaStreamTrackOrString& aUnion);


void
ImplCycleCollectionUnlink(OwningRTCIceCandidateInitOrRTCIceCandidate& aUnion);


class MediaStreamTrackOrString
{
  enum TypeOrUninit
  {
    eUninitialized,
    eMediaStreamTrack,
    eString
  };
public:
  enum class Type
  {
    eMediaStreamTrack = TypeOrUninit::eMediaStreamTrack,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::MediaStreamTrack> > mMediaStreamTrack;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  MediaStreamTrackOrString(const MediaStreamTrackOrString&) = delete;
  MediaStreamTrackOrString& operator=(const MediaStreamTrackOrString&) = delete;
public:
  explicit inline MediaStreamTrackOrString()
    : mType(eUninitialized)
  {
  }

  inline ~MediaStreamTrackOrString()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::MediaStreamTrack>&
  RawSetAsMediaStreamTrack()
  {
    if (mType == eMediaStreamTrack) {
      return mValue.mMediaStreamTrack.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eMediaStreamTrack;
    return mValue.mMediaStreamTrack.SetValue();
  }

  inline NonNull<mozilla::dom::MediaStreamTrack>&
  SetAsMediaStreamTrack()
  {
    if (mType == eMediaStreamTrack) {
      return mValue.mMediaStreamTrack.Value();
    }
    Uninit();
    mType = eMediaStreamTrack;
    return mValue.mMediaStreamTrack.SetValue();
  }

  inline bool
  IsMediaStreamTrack() const
  {
    return mType == eMediaStreamTrack;
  }

  inline NonNull<mozilla::dom::MediaStreamTrack>&
  GetAsMediaStreamTrack()
  {
    MOZ_RELEASE_ASSERT(IsMediaStreamTrack(), "Wrong type!");
    return mValue.mMediaStreamTrack.Value();
  }

  inline mozilla::dom::MediaStreamTrack&
  GetAsMediaStreamTrack() const
  {
    MOZ_RELEASE_ASSERT(IsMediaStreamTrack(), "Wrong type!");
    return mValue.mMediaStreamTrack.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eMediaStreamTrack: {
        DestroyMediaStreamTrack();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToMediaStreamTrack(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToMediaStreamTrack(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyMediaStreamTrack()
  {
    MOZ_RELEASE_ASSERT(IsMediaStreamTrack(), "Wrong type!");
    mValue.mMediaStreamTrack.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};


class OwningMediaStreamTrackOrString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningMediaStreamTrackOrString& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eMediaStreamTrack,
    eString
  };
public:
  enum class Type
  {
    eMediaStreamTrack = TypeOrUninit::eMediaStreamTrack,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::MediaStreamTrack> > mMediaStreamTrack;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningMediaStreamTrackOrString()
    : mType(eUninitialized)
  {
  }

  OwningMediaStreamTrackOrString(OwningMediaStreamTrackOrString&& aOther);

  explicit inline OwningMediaStreamTrackOrString(const OwningMediaStreamTrackOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningMediaStreamTrackOrString()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::MediaStreamTrack>&
  RawSetAsMediaStreamTrack();

  OwningNonNull<mozilla::dom::MediaStreamTrack>&
  SetAsMediaStreamTrack();

  inline bool
  IsMediaStreamTrack() const
  {
    return mType == eMediaStreamTrack;
  }

  inline OwningNonNull<mozilla::dom::MediaStreamTrack>&
  GetAsMediaStreamTrack()
  {
    MOZ_RELEASE_ASSERT(IsMediaStreamTrack(), "Wrong type!");
    return mValue.mMediaStreamTrack.Value();
  }

  inline OwningNonNull<mozilla::dom::MediaStreamTrack> const &
  GetAsMediaStreamTrack() const
  {
    MOZ_RELEASE_ASSERT(IsMediaStreamTrack(), "Wrong type!");
    return mValue.mMediaStreamTrack.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningMediaStreamTrackOrString&
  operator=(OwningMediaStreamTrackOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningMediaStreamTrackOrString&
  operator=(const OwningMediaStreamTrackOrString& aOther);

private:
  bool
  TrySetToMediaStreamTrack(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToMediaStreamTrack(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyMediaStreamTrack();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};


struct RTCDataChannelInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<uint16_t> mId;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint16_t> mMaxPacketLifeTime;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint16_t> mMaxRetransmitTime;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint16_t> mMaxRetransmits;
  MOZ_INIT_OUTSIDE_CTOR bool mNegotiated;
  MOZ_INIT_OUTSIDE_CTOR bool mOrdered;
  MOZ_INIT_OUTSIDE_CTOR nsString mProtocol;

  RTCDataChannelInit();

  explicit inline RTCDataChannelInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCDataChannelInit(RTCDataChannelInit&& aOther) = default;

  explicit inline RTCDataChannelInit(const RTCDataChannelInit& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCDataChannelInit&
  operator=(const RTCDataChannelInit& aOther);

  bool
  operator==(const RTCDataChannelInit& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, RTCDataChannelInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCDataChannelInit : public RTCDataChannelInit
{
  inline FastRTCDataChannelInit()
    : RTCDataChannelInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class RTCIceCandidateInitOrRTCIceCandidate
{
  enum TypeOrUninit
  {
    eUninitialized,
    eRTCIceCandidateInit,
    eRTCIceCandidate
  };
public:
  enum class Type
  {
    eRTCIceCandidateInit = TypeOrUninit::eRTCIceCandidateInit,
    eRTCIceCandidate = TypeOrUninit::eRTCIceCandidate
  };

private:
  union Value
  {
    UnionMember<binding_detail::FastRTCIceCandidateInit > mRTCIceCandidateInit;
    UnionMember<NonNull<mozilla::dom::RTCIceCandidate> > mRTCIceCandidate;

  };

  TypeOrUninit mType;
  Value mValue;

  RTCIceCandidateInitOrRTCIceCandidate(const RTCIceCandidateInitOrRTCIceCandidate&) = delete;
  RTCIceCandidateInitOrRTCIceCandidate& operator=(const RTCIceCandidateInitOrRTCIceCandidate&) = delete;
public:
  explicit inline RTCIceCandidateInitOrRTCIceCandidate()
    : mType(eUninitialized)
  {
  }

  inline ~RTCIceCandidateInitOrRTCIceCandidate()
  {
    Uninit();
  }

  inline binding_detail::FastRTCIceCandidateInit&
  RawSetAsRTCIceCandidateInit()
  {
    if (mType == eRTCIceCandidateInit) {
      return mValue.mRTCIceCandidateInit.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eRTCIceCandidateInit;
    return mValue.mRTCIceCandidateInit.SetValue();
  }

  inline binding_detail::FastRTCIceCandidateInit&
  SetAsRTCIceCandidateInit()
  {
    if (mType == eRTCIceCandidateInit) {
      return mValue.mRTCIceCandidateInit.Value();
    }
    Uninit();
    mType = eRTCIceCandidateInit;
    return mValue.mRTCIceCandidateInit.SetValue();
  }

  inline bool
  IsRTCIceCandidateInit() const
  {
    return mType == eRTCIceCandidateInit;
  }

  inline binding_detail::FastRTCIceCandidateInit&
  GetAsRTCIceCandidateInit()
  {
    MOZ_RELEASE_ASSERT(IsRTCIceCandidateInit(), "Wrong type!");
    return mValue.mRTCIceCandidateInit.Value();
  }

  inline const RTCIceCandidateInit&
  GetAsRTCIceCandidateInit() const
  {
    MOZ_RELEASE_ASSERT(IsRTCIceCandidateInit(), "Wrong type!");
    return mValue.mRTCIceCandidateInit.Value();
  }

  inline NonNull<mozilla::dom::RTCIceCandidate>&
  RawSetAsRTCIceCandidate()
  {
    if (mType == eRTCIceCandidate) {
      return mValue.mRTCIceCandidate.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eRTCIceCandidate;
    return mValue.mRTCIceCandidate.SetValue();
  }

  inline NonNull<mozilla::dom::RTCIceCandidate>&
  SetAsRTCIceCandidate()
  {
    if (mType == eRTCIceCandidate) {
      return mValue.mRTCIceCandidate.Value();
    }
    Uninit();
    mType = eRTCIceCandidate;
    return mValue.mRTCIceCandidate.SetValue();
  }

  inline bool
  IsRTCIceCandidate() const
  {
    return mType == eRTCIceCandidate;
  }

  inline NonNull<mozilla::dom::RTCIceCandidate>&
  GetAsRTCIceCandidate()
  {
    MOZ_RELEASE_ASSERT(IsRTCIceCandidate(), "Wrong type!");
    return mValue.mRTCIceCandidate.Value();
  }

  inline mozilla::dom::RTCIceCandidate&
  GetAsRTCIceCandidate() const
  {
    MOZ_RELEASE_ASSERT(IsRTCIceCandidate(), "Wrong type!");
    return mValue.mRTCIceCandidate.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eRTCIceCandidateInit: {
        DestroyRTCIceCandidateInit();
        break;
      }
      case eRTCIceCandidate: {
        DestroyRTCIceCandidate();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToRTCIceCandidateInit(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToRTCIceCandidateInit(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyRTCIceCandidateInit()
  {
    MOZ_RELEASE_ASSERT(IsRTCIceCandidateInit(), "Wrong type!");
    mValue.mRTCIceCandidateInit.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToRTCIceCandidate(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToRTCIceCandidate(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyRTCIceCandidate()
  {
    MOZ_RELEASE_ASSERT(IsRTCIceCandidate(), "Wrong type!");
    mValue.mRTCIceCandidate.Destroy();
    mType = eUninitialized;
  }
};


class OwningRTCIceCandidateInitOrRTCIceCandidate : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningRTCIceCandidateInitOrRTCIceCandidate& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eRTCIceCandidateInit,
    eRTCIceCandidate
  };
public:
  enum class Type
  {
    eRTCIceCandidateInit = TypeOrUninit::eRTCIceCandidateInit,
    eRTCIceCandidate = TypeOrUninit::eRTCIceCandidate
  };

private:
  union Value
  {
    UnionMember<RTCIceCandidateInit > mRTCIceCandidateInit;
    UnionMember<OwningNonNull<mozilla::dom::RTCIceCandidate> > mRTCIceCandidate;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningRTCIceCandidateInitOrRTCIceCandidate()
    : mType(eUninitialized)
  {
  }

  OwningRTCIceCandidateInitOrRTCIceCandidate(OwningRTCIceCandidateInitOrRTCIceCandidate&& aOther);

  explicit inline OwningRTCIceCandidateInitOrRTCIceCandidate(const OwningRTCIceCandidateInitOrRTCIceCandidate& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningRTCIceCandidateInitOrRTCIceCandidate()
  {
    Uninit();
  }

  RTCIceCandidateInit&
  RawSetAsRTCIceCandidateInit();

  RTCIceCandidateInit&
  SetAsRTCIceCandidateInit();

  inline bool
  IsRTCIceCandidateInit() const
  {
    return mType == eRTCIceCandidateInit;
  }

  inline RTCIceCandidateInit&
  GetAsRTCIceCandidateInit()
  {
    MOZ_RELEASE_ASSERT(IsRTCIceCandidateInit(), "Wrong type!");
    return mValue.mRTCIceCandidateInit.Value();
  }

  inline RTCIceCandidateInit const &
  GetAsRTCIceCandidateInit() const
  {
    MOZ_RELEASE_ASSERT(IsRTCIceCandidateInit(), "Wrong type!");
    return mValue.mRTCIceCandidateInit.Value();
  }

  OwningNonNull<mozilla::dom::RTCIceCandidate>&
  RawSetAsRTCIceCandidate();

  OwningNonNull<mozilla::dom::RTCIceCandidate>&
  SetAsRTCIceCandidate();

  inline bool
  IsRTCIceCandidate() const
  {
    return mType == eRTCIceCandidate;
  }

  inline OwningNonNull<mozilla::dom::RTCIceCandidate>&
  GetAsRTCIceCandidate()
  {
    MOZ_RELEASE_ASSERT(IsRTCIceCandidate(), "Wrong type!");
    return mValue.mRTCIceCandidate.Value();
  }

  inline OwningNonNull<mozilla::dom::RTCIceCandidate> const &
  GetAsRTCIceCandidate() const
  {
    MOZ_RELEASE_ASSERT(IsRTCIceCandidate(), "Wrong type!");
    return mValue.mRTCIceCandidate.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningRTCIceCandidateInitOrRTCIceCandidate&
  operator=(OwningRTCIceCandidateInitOrRTCIceCandidate&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningRTCIceCandidateInitOrRTCIceCandidate&
  operator=(const OwningRTCIceCandidateInitOrRTCIceCandidate& aOther);

private:
  bool
  TrySetToRTCIceCandidateInit(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToRTCIceCandidateInit(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyRTCIceCandidateInit();

  bool
  TrySetToRTCIceCandidate(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToRTCIceCandidate(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyRTCIceCandidate();
};


struct RTCOfferAnswerOptions : public DictionaryBase
{
  RTCOfferAnswerOptions();

  explicit inline RTCOfferAnswerOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCOfferAnswerOptions(RTCOfferAnswerOptions&& aOther) = default;

  explicit inline RTCOfferAnswerOptions(const RTCOfferAnswerOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCOfferAnswerOptions&
  operator=(const RTCOfferAnswerOptions& aOther);

  bool
  operator==(const RTCOfferAnswerOptions& aOther) const;
};

namespace binding_detail {
struct FastRTCOfferAnswerOptions : public RTCOfferAnswerOptions
{
  inline FastRTCOfferAnswerOptions()
    : RTCOfferAnswerOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class RTCPeerConnectionErrorCallback : public CallbackFunction
{
public:
  explicit inline RTCPeerConnectionErrorCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline RTCPeerConnectionErrorCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline RTCPeerConnectionErrorCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline RTCPeerConnectionErrorCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, DOMException& error, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "RTCPeerConnectionErrorCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, error, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(DOMException& error, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "RTCPeerConnectionErrorCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, error, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, DOMException& error, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, error, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(DOMException& error, const char* aExecutionReason = nullptr)
  {
    return Call(error, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const RTCPeerConnectionErrorCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, DOMException& error, ErrorResult& aRv);
};


namespace binding_detail {
class FastRTCPeerConnectionErrorCallback : public RTCPeerConnectionErrorCallback
{
public:
  explicit inline FastRTCPeerConnectionErrorCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : RTCPeerConnectionErrorCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    RTCPeerConnectionErrorCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    RTCPeerConnectionErrorCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


class RTCSessionDescriptionCallback : public CallbackFunction
{
public:
  explicit inline RTCSessionDescriptionCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline RTCSessionDescriptionCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline RTCSessionDescriptionCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline RTCSessionDescriptionCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, const RTCSessionDescriptionInit& description, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "RTCSessionDescriptionCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, description, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(const RTCSessionDescriptionInit& description, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "RTCSessionDescriptionCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, description, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, const RTCSessionDescriptionInit& description, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, description, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(const RTCSessionDescriptionInit& description, const char* aExecutionReason = nullptr)
  {
    return Call(description, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const RTCSessionDescriptionCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, const RTCSessionDescriptionInit& description, ErrorResult& aRv);
};


namespace binding_detail {
class FastRTCSessionDescriptionCallback : public RTCSessionDescriptionCallback
{
public:
  explicit inline FastRTCSessionDescriptionCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : RTCSessionDescriptionCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    RTCSessionDescriptionCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    RTCSessionDescriptionCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


class RTCStatsCallback : public CallbackFunction
{
public:
  explicit inline RTCStatsCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline RTCStatsCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline RTCStatsCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline RTCStatsCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, RTCStatsReport& report, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "RTCStatsCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, report, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(RTCStatsReport& report, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "RTCStatsCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, report, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, RTCStatsReport& report, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, report, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(RTCStatsReport& report, const char* aExecutionReason = nullptr)
  {
    return Call(report, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const RTCStatsCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, RTCStatsReport& report, ErrorResult& aRv);
};


namespace binding_detail {
class FastRTCStatsCallback : public RTCStatsCallback
{
public:
  explicit inline FastRTCStatsCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : RTCStatsCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    RTCStatsCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    RTCStatsCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


class mozPacketCallback : public CallbackFunction
{
public:
  explicit inline mozPacketCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline mozPacketCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline mozPacketCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline mozPacketCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, uint32_t level, mozPacketDumpType type, bool sending, JS::Handle<JSObject*> packet, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "mozPacketCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, level, type, sending, packet, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(uint32_t level, mozPacketDumpType type, bool sending, JS::Handle<JSObject*> packet, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "mozPacketCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, level, type, sending, packet, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, uint32_t level, mozPacketDumpType type, bool sending, JS::Handle<JSObject*> packet, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, level, type, sending, packet, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(uint32_t level, mozPacketDumpType type, bool sending, JS::Handle<JSObject*> packet, const char* aExecutionReason = nullptr)
  {
    return Call(level, type, sending, packet, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const mozPacketCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, uint32_t level, mozPacketDumpType type, bool sending, JS::Handle<JSObject*> packet, ErrorResult& aRv);
};


namespace binding_detail {
class FastmozPacketCallback : public mozPacketCallback
{
public:
  explicit inline FastmozPacketCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : mozPacketCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    mozPacketCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    mozPacketCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


struct RTCAnswerOptions : public RTCOfferAnswerOptions
{
  RTCAnswerOptions();

  explicit inline RTCAnswerOptions(const FastDictionaryInitializer& )
    : RTCOfferAnswerOptions(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCAnswerOptions(RTCAnswerOptions&& aOther) = default;

  explicit inline RTCAnswerOptions(const RTCAnswerOptions& aOther)
    : RTCOfferAnswerOptions(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCAnswerOptions&
  operator=(const RTCAnswerOptions& aOther);

  bool
  operator==(const RTCAnswerOptions& aOther) const;
};

namespace binding_detail {
struct FastRTCAnswerOptions : public RTCAnswerOptions
{
  inline FastRTCAnswerOptions()
    : RTCAnswerOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCOfferOptions : public RTCOfferAnswerOptions
{
  MOZ_INIT_OUTSIDE_CTOR bool mIceRestart;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mOfferToReceiveAudio;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mOfferToReceiveVideo;

  RTCOfferOptions();

  explicit inline RTCOfferOptions(const FastDictionaryInitializer& )
    : RTCOfferAnswerOptions(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCOfferOptions(RTCOfferOptions&& aOther) = default;

  explicit inline RTCOfferOptions(const RTCOfferOptions& aOther)
    : RTCOfferAnswerOptions(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCOfferOptions&
  operator=(const RTCOfferOptions& aOther);

  bool
  operator==(const RTCOfferOptions& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, RTCOfferOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCOfferOptions : public RTCOfferOptions
{
  inline FastRTCOfferOptions()
    : RTCOfferOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace RTCPeerConnection_Binding {

  typedef mozilla::dom::RTCPeerConnection NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::RTCPeerConnection* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::RTCPeerConnection,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::RTCPeerConnection,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace RTCPeerConnection_Binding



class RTCPeerConnectionJSImpl : public CallbackInterface
{
public:
  explicit inline RTCPeerConnectionJSImpl(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
  }

  explicit inline RTCPeerConnectionJSImpl(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackInterface(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  explicit inline RTCPeerConnectionJSImpl(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
  }

  void SetIdentityProvider(const nsAString& provider, const RTCIdentityProviderOptions& options, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> GetIdentityAssertion(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> CreateOffer(const RTCOfferOptions& options, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> CreateOffer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, const RTCOfferOptions& options, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> CreateAnswer(const RTCAnswerOptions& options, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> CreateAnswer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> SetLocalDescription(const RTCSessionDescriptionInit& description, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> SetLocalDescription(const RTCSessionDescriptionInit& description, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> SetRemoteDescription(const RTCSessionDescriptionInit& description, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> SetRemoteDescription(const RTCSessionDescriptionInit& description, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> AddIceCandidate(const RTCIceCandidateInitOrRTCIceCandidate& candidate, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> AddIceCandidate(RTCIceCandidate& candidate, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void RestartIce(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetConfiguration(RTCConfiguration& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void SetConfiguration(const RTCConfiguration& configuration, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetLocalStreams(nsTArray<RefPtr<DOMMediaStream>>& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetRemoteStreams(nsTArray<RefPtr<DOMMediaStream>>& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void AddStream(DOMMediaStream& stream, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<RTCRtpSender> AddTrack(MediaStreamTrack& track, const nsTArray<OwningNonNull<DOMMediaStream>>& streams, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void RemoveTrack(RTCRtpSender& sender, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<RTCRtpTransceiver> AddTransceiver(const MediaStreamTrackOrString& trackOrKind, const RTCRtpTransceiverInit& init, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetSenders(nsTArray<RefPtr<RTCRtpSender>>& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetReceivers(nsTArray<RefPtr<RTCRtpReceiver>>& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetTransceivers(nsTArray<RefPtr<RTCRtpTransceiver>>& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void MozSetPacketCallback(mozPacketCallback& callback, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void MozEnablePacketDump(uint32_t level, mozPacketDumpType type, bool sending, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void MozDisablePacketDump(uint32_t level, mozPacketDumpType type, bool sending, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void Close(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> GetStats(MediaStreamTrack* selector, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<nsDOMDataChannel> CreateDataChannel(const nsAString& label, const RTCDataChannelInit& dataChannelDict, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void __Init(const RTCConfiguration& configuration, const Optional<JS::Handle<JSObject*>>& constraints, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  inline bool
  operator==(const RTCPeerConnectionJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  already_AddRefed<RTCSessionDescription> GetLocalDescription(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<RTCSessionDescription> GetCurrentLocalDescription(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<RTCSessionDescription> GetPendingLocalDescription(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<RTCSessionDescription> GetRemoteDescription(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<RTCSessionDescription> GetCurrentRemoteDescription(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<RTCSessionDescription> GetPendingRemoteDescription(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  RTCSignalingState GetSignalingState(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  Nullable<bool> GetCanTrickleIceCandidates(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  RTCIceGatheringState GetIceGatheringState(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  RTCIceConnectionState GetIceConnectionState(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  RTCPeerConnectionState GetConnectionState(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> GetPeerIdentity(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetIdpLoginUrl(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetId(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnnegotiationneeded(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnicecandidate(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnsignalingstatechange(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnaddstream(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnaddtrack(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOntrack(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOniceconnectionstatechange(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnicegatheringstatechange(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnconnectionstatechange(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<RTCSctpTransport> GetSctp(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOndatachannel(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void SetId(const nsAString& arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void SetOnnegotiationneeded(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void SetOnicecandidate(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void SetOnsignalingstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void SetOnaddstream(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void SetOnaddtrack(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void SetOntrack(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void SetOniceconnectionstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void SetOnicegatheringstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void SetOnconnectionstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void SetOndatachannel(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

private:
  static bool
  InitIds(JSContext* cx, RTCPeerConnectionAtoms* atomsCache);
};


class RTCPeerConnection final : public mozilla::DOMEventTargetHelper
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(RTCPeerConnection, mozilla::DOMEventTargetHelper)

private:
  RefPtr<RTCPeerConnectionJSImpl> mImpl;
  nsCOMPtr<nsIGlobalObject> mParent;

public:
  RTCPeerConnection(JS::Handle<JSObject*> aJSImplObject, JS::Handle<JSObject*> aJSImplGlobal, nsIGlobalObject* aParent);

private:
  ~RTCPeerConnection();

public:
  nsISupports* GetParentObject() const;

  JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  static already_AddRefed<RTCPeerConnection> Constructor(const GlobalObject& global, JSContext* cx, const RTCConfiguration& configuration, const Optional<JS::Handle<JSObject*>>& constraints, ErrorResult& aRv, JS::Handle<JSObject*> aGivenProto = nullptr);

  void SetIdentityProvider(const nsAString& provider, const RTCIdentityProviderOptions& options, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> GetIdentityAssertion(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> CreateOffer(const RTCOfferOptions& options, ErrorResult& aRv, JS::Realm* aRealm = nullptr);
  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> CreateOffer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, const RTCOfferOptions& options, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> CreateAnswer(const RTCAnswerOptions& options, ErrorResult& aRv, JS::Realm* aRealm = nullptr);
  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> CreateAnswer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> SetLocalDescription(const RTCSessionDescriptionInit& description, ErrorResult& aRv, JS::Realm* aRealm = nullptr);
  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> SetLocalDescription(const RTCSessionDescriptionInit& description, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> SetRemoteDescription(const RTCSessionDescriptionInit& description, ErrorResult& aRv, JS::Realm* aRealm = nullptr);
  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> SetRemoteDescription(const RTCSessionDescriptionInit& description, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<RTCSessionDescription> GetLocalDescription(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<RTCSessionDescription> GetCurrentLocalDescription(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<RTCSessionDescription> GetPendingLocalDescription(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<RTCSessionDescription> GetRemoteDescription(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<RTCSessionDescription> GetCurrentRemoteDescription(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<RTCSessionDescription> GetPendingRemoteDescription(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  RTCSignalingState GetSignalingState(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> AddIceCandidate(const RTCIceCandidateInitOrRTCIceCandidate& candidate, ErrorResult& aRv, JS::Realm* aRealm = nullptr);
  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> AddIceCandidate(RTCIceCandidate& candidate, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  Nullable<bool> GetCanTrickleIceCandidates(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  RTCIceGatheringState GetIceGatheringState(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  RTCIceConnectionState GetIceConnectionState(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  RTCPeerConnectionState GetConnectionState(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void RestartIce(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> GetPeerIdentity(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void GetIdpLoginUrl(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void GetId(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void SetId(const nsAString& arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetConfiguration(RTCConfiguration& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void SetConfiguration(const RTCConfiguration& configuration, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetLocalStreams(nsTArray<RefPtr<DOMMediaStream>>& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetRemoteStreams(nsTArray<RefPtr<DOMMediaStream>>& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void AddStream(DOMMediaStream& stream, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<RTCRtpSender> AddTrack(MediaStreamTrack& track, const Sequence<OwningNonNull<DOMMediaStream>>& streams, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void RemoveTrack(RTCRtpSender& sender, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<RTCRtpTransceiver> AddTransceiver(const MediaStreamTrackOrString& trackOrKind, const RTCRtpTransceiverInit& init, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetSenders(nsTArray<RefPtr<RTCRtpSender>>& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetReceivers(nsTArray<RefPtr<RTCRtpReceiver>>& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetTransceivers(nsTArray<RefPtr<RTCRtpTransceiver>>& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void MozSetPacketCallback(mozPacketCallback& callback, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void MozEnablePacketDump(uint32_t level, mozPacketDumpType type, bool sending, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void MozDisablePacketDump(uint32_t level, mozPacketDumpType type, bool sending, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void Close(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnnegotiationneeded(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void SetOnnegotiationneeded(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnicecandidate(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void SetOnicecandidate(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnsignalingstatechange(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void SetOnsignalingstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnaddstream(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void SetOnaddstream(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnaddtrack(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void SetOnaddtrack(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOntrack(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void SetOntrack(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOniceconnectionstatechange(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void SetOniceconnectionstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnicegatheringstatechange(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void SetOnicegatheringstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnconnectionstatechange(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void SetOnconnectionstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> GetStats(MediaStreamTrack* selector, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<RTCSctpTransport> GetSctp(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<nsDOMDataChannel> CreateDataChannel(const nsAString& label, const RTCDataChannelInit& dataChannelDict, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOndatachannel(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void SetOndatachannel(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace mozilla::dom

#endif // mozilla_dom_RTCPeerConnectionBinding_h
