/* THIS FILE IS AUTOGENERATED FROM RTCStatsReport.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_RTCStatsReportBinding_h
#define mozilla_dom_RTCStatsReportBinding_h

#include "RTCConfigurationBinding.h"
#include "RTCDataChannelBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"

namespace mozilla {
namespace dom {

struct NativePropertyHooks;
class ProtoAndIfaceCache;
struct RTCBandwidthEstimationInternal;
struct RTCBandwidthEstimationInternalAtoms;
struct RTCCodecStats;
struct RTCCodecStatsAtoms;
struct RTCConfigurationInternal;
struct RTCConfigurationInternalAtoms;
struct RTCDataChannelStats;
struct RTCDataChannelStatsAtoms;
struct RTCIceCandidatePairStats;
struct RTCIceCandidatePairStatsAtoms;
struct RTCIceCandidateStats;
struct RTCIceCandidateStatsAtoms;
struct RTCIceServerInternal;
struct RTCIceServerInternalAtoms;
struct RTCInboundRtpStreamStats;
struct RTCInboundRtpStreamStatsAtoms;
struct RTCMediaSourceStats;
struct RTCMediaSourceStatsAtoms;
struct RTCOutboundRtpStreamStats;
struct RTCOutboundRtpStreamStatsAtoms;
struct RTCPeerConnectionStats;
struct RTCPeerConnectionStatsAtoms;
struct RTCRTPContributingSourceStats;
struct RTCRTPContributingSourceStatsAtoms;
struct RTCReceivedRtpStreamStatsAtoms;
struct RTCRemoteInboundRtpStreamStats;
struct RTCRemoteInboundRtpStreamStatsAtoms;
struct RTCRemoteOutboundRtpStreamStats;
struct RTCRemoteOutboundRtpStreamStatsAtoms;
struct RTCRtpStreamStatsAtoms;
struct RTCSdpHistoryEntryInternal;
struct RTCSdpHistoryEntryInternalAtoms;
struct RTCSdpHistoryInternalAtoms;
struct RTCSdpParsingErrorInternal;
struct RTCSdpParsingErrorInternalAtoms;
struct RTCSentRtpStreamStatsAtoms;
struct RTCStatsAtoms;
struct RTCStatsCollectionAtoms;
class RTCStatsReport;
struct RTCStatsReportInternalAtoms;
struct RTCVideoFrameHistoryEntryInternal;
struct RTCVideoFrameHistoryEntryInternalAtoms;
struct RTCVideoFrameHistoryInternal;
struct RTCVideoFrameHistoryInternalAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class RTCStatsType : uint8_t {
  Codec,
  Inbound_rtp,
  Outbound_rtp,
  Remote_inbound_rtp,
  Remote_outbound_rtp,
  Media_source,
  Peer_connection,
  Csrc,
  Data_channel,
  Session,
  Track,
  Transport,
  Candidate_pair,
  Local_candidate,
  Remote_candidate,
  EndGuard_
};

namespace RTCStatsTypeValues {
extern const EnumEntry strings[16];

static constexpr size_t Count = 15;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(RTCStatsType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(RTCStatsType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace RTCStatsTypeValues

bool
ToJSValue(JSContext* aCx, RTCStatsType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class RTCCodecType : uint8_t {
  Encode,
  Decode,
  EndGuard_
};

namespace RTCCodecTypeValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(RTCCodecType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(RTCCodecType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace RTCCodecTypeValues

bool
ToJSValue(JSContext* aCx, RTCCodecType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class RTCStatsIceCandidatePairState : uint8_t {
  Frozen,
  Waiting,
  Inprogress,
  Failed,
  Succeeded,
  Cancelled,
  EndGuard_
};

namespace RTCStatsIceCandidatePairStateValues {
extern const EnumEntry strings[7];

static constexpr size_t Count = 6;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(RTCStatsIceCandidatePairState::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(RTCStatsIceCandidatePairState stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace RTCStatsIceCandidatePairStateValues

bool
ToJSValue(JSContext* aCx, RTCStatsIceCandidatePairState aArgument, JS::MutableHandle<JS::Value> aValue);


enum class RTCIceCandidateType : uint8_t {
  Host,
  Srflx,
  Prflx,
  Relay,
  EndGuard_
};

namespace RTCIceCandidateTypeValues {
extern const EnumEntry strings[5];

static constexpr size_t Count = 4;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(RTCIceCandidateType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(RTCIceCandidateType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace RTCIceCandidateTypeValues

bool
ToJSValue(JSContext* aCx, RTCIceCandidateType aArgument, JS::MutableHandle<JS::Value> aValue);


struct RTCBandwidthEstimationInternal : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mMaxPaddingBps;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mPacerDelayMs;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mReceiveBandwidthBps;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mRttMs;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mSendBandwidthBps;
  MOZ_INIT_OUTSIDE_CTOR nsString mTrackIdentifier;

  RTCBandwidthEstimationInternal();

  explicit inline RTCBandwidthEstimationInternal(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCBandwidthEstimationInternal(RTCBandwidthEstimationInternal&& aOther) = default;

  explicit inline RTCBandwidthEstimationInternal(const RTCBandwidthEstimationInternal& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCBandwidthEstimationInternal&
  operator=(const RTCBandwidthEstimationInternal& aOther);

  bool
  operator==(const RTCBandwidthEstimationInternal& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, RTCBandwidthEstimationInternalAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCBandwidthEstimationInternal : public RTCBandwidthEstimationInternal
{
  inline FastRTCBandwidthEstimationInternal()
    : RTCBandwidthEstimationInternal(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCIceServerInternal : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mCredentialProvided;
  MOZ_INIT_OUTSIDE_CTOR Sequence<nsString> mUrls;
  MOZ_INIT_OUTSIDE_CTOR bool mUserNameProvided;

  RTCIceServerInternal();

  explicit inline RTCIceServerInternal(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCIceServerInternal(RTCIceServerInternal&& aOther) = default;

  explicit inline RTCIceServerInternal(const RTCIceServerInternal& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCIceServerInternal&
  operator=(const RTCIceServerInternal& aOther);

private:
  static bool
  InitIds(JSContext* cx, RTCIceServerInternalAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCIceServerInternal : public RTCIceServerInternal
{
  inline FastRTCIceServerInternal()
    : RTCIceServerInternal(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCSdpParsingErrorInternal : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mError;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mLineNumber;

  RTCSdpParsingErrorInternal();

  explicit inline RTCSdpParsingErrorInternal(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCSdpParsingErrorInternal(RTCSdpParsingErrorInternal&& aOther) = default;

  explicit inline RTCSdpParsingErrorInternal(const RTCSdpParsingErrorInternal& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCSdpParsingErrorInternal&
  operator=(const RTCSdpParsingErrorInternal& aOther);

  bool
  operator==(const RTCSdpParsingErrorInternal& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, RTCSdpParsingErrorInternalAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCSdpParsingErrorInternal : public RTCSdpParsingErrorInternal
{
  inline FastRTCSdpParsingErrorInternal()
    : RTCSdpParsingErrorInternal(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCStats : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mId;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mTimestamp;
  MOZ_INIT_OUTSIDE_CTOR Optional<RTCStatsType> mType;

  RTCStats();

  explicit inline RTCStats(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCStats(RTCStats&& aOther) = default;

  explicit inline RTCStats(const RTCStats& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCStats&
  operator=(const RTCStats& aOther);

private:
  static bool
  InitIds(JSContext* cx, RTCStatsAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCStats : public RTCStats
{
  inline FastRTCStats()
    : RTCStats(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCVideoFrameHistoryEntryInternal : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint64_t mConsecutiveFrames;
  MOZ_INIT_OUTSIDE_CTOR double mFirstFrameTimestamp;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mHeight;
  MOZ_INIT_OUTSIDE_CTOR double mLastFrameTimestamp;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mLocalSsrc;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mRemoteSsrc;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mRotationAngle;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mWidth;

  RTCVideoFrameHistoryEntryInternal();

  explicit inline RTCVideoFrameHistoryEntryInternal(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCVideoFrameHistoryEntryInternal(RTCVideoFrameHistoryEntryInternal&& aOther) = default;

  explicit inline RTCVideoFrameHistoryEntryInternal(const RTCVideoFrameHistoryEntryInternal& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCVideoFrameHistoryEntryInternal&
  operator=(const RTCVideoFrameHistoryEntryInternal& aOther);

  bool
  operator==(const RTCVideoFrameHistoryEntryInternal& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, RTCVideoFrameHistoryEntryInternalAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCVideoFrameHistoryEntryInternal : public RTCVideoFrameHistoryEntryInternal
{
  inline FastRTCVideoFrameHistoryEntryInternal()
    : RTCVideoFrameHistoryEntryInternal(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCCodecStats : public RTCStats
{
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mChannels;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mClockRate;
  MOZ_INIT_OUTSIDE_CTOR Optional<RTCCodecType> mCodecType;
  MOZ_INIT_OUTSIDE_CTOR nsString mMimeType;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mPayloadType;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mSdpFmtpLine;
  MOZ_INIT_OUTSIDE_CTOR nsString mTransportId;

  RTCCodecStats();

  explicit inline RTCCodecStats(const FastDictionaryInitializer& )
    : RTCStats(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCCodecStats(RTCCodecStats&& aOther) = default;

  explicit inline RTCCodecStats(const RTCCodecStats& aOther)
    : RTCStats(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCCodecStats&
  operator=(const RTCCodecStats& aOther);

private:
  static bool
  InitIds(JSContext* cx, RTCCodecStatsAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCCodecStats : public RTCCodecStats
{
  inline FastRTCCodecStats()
    : RTCCodecStats(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCConfigurationInternal : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<RTCBundlePolicy> mBundlePolicy;
  MOZ_INIT_OUTSIDE_CTOR bool mCertificatesProvided;
  MOZ_INIT_OUTSIDE_CTOR Sequence<RTCIceServerInternal> mIceServers;
  MOZ_INIT_OUTSIDE_CTOR Optional<RTCIceTransportPolicy> mIceTransportPolicy;
  MOZ_INIT_OUTSIDE_CTOR bool mPeerIdentityProvided;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mSdpSemantics;

  RTCConfigurationInternal();

  explicit inline RTCConfigurationInternal(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCConfigurationInternal(RTCConfigurationInternal&& aOther) = default;

  explicit inline RTCConfigurationInternal(const RTCConfigurationInternal& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCConfigurationInternal&
  operator=(const RTCConfigurationInternal& aOther);

private:
  static bool
  InitIds(JSContext* cx, RTCConfigurationInternalAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCConfigurationInternal : public RTCConfigurationInternal
{
  inline FastRTCConfigurationInternal()
    : RTCConfigurationInternal(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCDataChannelStats : public RTCStats
{
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mBytesReceived;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mBytesSent;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mDataChannelIdentifier;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mLabel;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mMessagesReceived;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mMessagesSent;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mProtocol;
  MOZ_INIT_OUTSIDE_CTOR Optional<RTCDataChannelState> mState;

  RTCDataChannelStats();

  explicit inline RTCDataChannelStats(const FastDictionaryInitializer& )
    : RTCStats(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCDataChannelStats(RTCDataChannelStats&& aOther) = default;

  explicit inline RTCDataChannelStats(const RTCDataChannelStats& aOther)
    : RTCStats(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCDataChannelStats&
  operator=(const RTCDataChannelStats& aOther);

private:
  static bool
  InitIds(JSContext* cx, RTCDataChannelStatsAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCDataChannelStats : public RTCDataChannelStats
{
  inline FastRTCDataChannelStats()
    : RTCDataChannelStats(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCIceCandidatePairStats : public RTCStats
{
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mBytesReceived;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mBytesSent;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mComponentId;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mLastPacketReceivedTimestamp;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mLastPacketSentTimestamp;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mLocalCandidateId;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mNominated;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mPriority;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mReadable;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mRemoteCandidateId;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mSelected;
  MOZ_INIT_OUTSIDE_CTOR Optional<RTCStatsIceCandidatePairState> mState;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mTransportId;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mWritable;

  RTCIceCandidatePairStats();

  explicit inline RTCIceCandidatePairStats(const FastDictionaryInitializer& )
    : RTCStats(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCIceCandidatePairStats(RTCIceCandidatePairStats&& aOther) = default;

  explicit inline RTCIceCandidatePairStats(const RTCIceCandidatePairStats& aOther)
    : RTCStats(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCIceCandidatePairStats&
  operator=(const RTCIceCandidatePairStats& aOther);

private:
  static bool
  InitIds(JSContext* cx, RTCIceCandidatePairStatsAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCIceCandidatePairStats : public RTCIceCandidatePairStats
{
  inline FastRTCIceCandidatePairStats()
    : RTCIceCandidatePairStats(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCIceCandidateStats : public RTCStats
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mAddress;
  MOZ_INIT_OUTSIDE_CTOR Optional<RTCIceCandidateType> mCandidateType;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mPort;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mPriority;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mProtocol;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mProxied;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mRelayProtocol;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mTransportId;

  RTCIceCandidateStats();

  explicit inline RTCIceCandidateStats(const FastDictionaryInitializer& )
    : RTCStats(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCIceCandidateStats(RTCIceCandidateStats&& aOther) = default;

  explicit inline RTCIceCandidateStats(const RTCIceCandidateStats& aOther)
    : RTCStats(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCIceCandidateStats&
  operator=(const RTCIceCandidateStats& aOther);

private:
  static bool
  InitIds(JSContext* cx, RTCIceCandidateStatsAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCIceCandidateStats : public RTCIceCandidateStats
{
  inline FastRTCIceCandidateStats()
    : RTCIceCandidateStats(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCMediaSourceStats : public RTCStats
{
  MOZ_INIT_OUTSIDE_CTOR nsString mKind;
  MOZ_INIT_OUTSIDE_CTOR nsString mTrackIdentifier;

  RTCMediaSourceStats();

  explicit inline RTCMediaSourceStats(const FastDictionaryInitializer& )
    : RTCStats(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCMediaSourceStats(RTCMediaSourceStats&& aOther) = default;

  explicit inline RTCMediaSourceStats(const RTCMediaSourceStats& aOther)
    : RTCStats(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCMediaSourceStats&
  operator=(const RTCMediaSourceStats& aOther);

  bool
  operator==(const RTCMediaSourceStats& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, RTCMediaSourceStatsAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCMediaSourceStats : public RTCMediaSourceStats
{
  inline FastRTCMediaSourceStats()
    : RTCMediaSourceStats(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCPeerConnectionStats : public RTCStats
{
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mDataChannelsClosed;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mDataChannelsOpened;

  RTCPeerConnectionStats();

  explicit inline RTCPeerConnectionStats(const FastDictionaryInitializer& )
    : RTCStats(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCPeerConnectionStats(RTCPeerConnectionStats&& aOther) = default;

  explicit inline RTCPeerConnectionStats(const RTCPeerConnectionStats& aOther)
    : RTCStats(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCPeerConnectionStats&
  operator=(const RTCPeerConnectionStats& aOther);

  bool
  operator==(const RTCPeerConnectionStats& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, RTCPeerConnectionStatsAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCPeerConnectionStats : public RTCPeerConnectionStats
{
  inline FastRTCPeerConnectionStats()
    : RTCPeerConnectionStats(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCRTPContributingSourceStats : public RTCStats
{
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mContributorSsrc;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mInboundRtpStreamId;

  RTCRTPContributingSourceStats();

  explicit inline RTCRTPContributingSourceStats(const FastDictionaryInitializer& )
    : RTCStats(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCRTPContributingSourceStats(RTCRTPContributingSourceStats&& aOther) = default;

  explicit inline RTCRTPContributingSourceStats(const RTCRTPContributingSourceStats& aOther)
    : RTCStats(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCRTPContributingSourceStats&
  operator=(const RTCRTPContributingSourceStats& aOther);

  bool
  operator==(const RTCRTPContributingSourceStats& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, RTCRTPContributingSourceStatsAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCRTPContributingSourceStats : public RTCRTPContributingSourceStats
{
  inline FastRTCRTPContributingSourceStats()
    : RTCRTPContributingSourceStats(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCRtpStreamStats : public RTCStats
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mCodecId;
  MOZ_INIT_OUTSIDE_CTOR nsString mKind;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mMediaType;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mSsrc;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mTransportId;

  RTCRtpStreamStats();

  explicit inline RTCRtpStreamStats(const FastDictionaryInitializer& )
    : RTCStats(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCRtpStreamStats(RTCRtpStreamStats&& aOther) = default;

  explicit inline RTCRtpStreamStats(const RTCRtpStreamStats& aOther)
    : RTCStats(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCRtpStreamStats&
  operator=(const RTCRtpStreamStats& aOther);

  bool
  operator==(const RTCRtpStreamStats& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, RTCRtpStreamStatsAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCRtpStreamStats : public RTCRtpStreamStats
{
  inline FastRTCRtpStreamStats()
    : RTCRtpStreamStats(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCSdpHistoryEntryInternal : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<RTCSdpParsingErrorInternal> mErrors;
  MOZ_INIT_OUTSIDE_CTOR bool mIsLocal;
  MOZ_INIT_OUTSIDE_CTOR nsString mSdp;
  MOZ_INIT_OUTSIDE_CTOR double mTimestamp;

  RTCSdpHistoryEntryInternal();

  explicit inline RTCSdpHistoryEntryInternal(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCSdpHistoryEntryInternal(RTCSdpHistoryEntryInternal&& aOther) = default;

  explicit inline RTCSdpHistoryEntryInternal(const RTCSdpHistoryEntryInternal& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCSdpHistoryEntryInternal&
  operator=(const RTCSdpHistoryEntryInternal& aOther);

private:
  static bool
  InitIds(JSContext* cx, RTCSdpHistoryEntryInternalAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCSdpHistoryEntryInternal : public RTCSdpHistoryEntryInternal
{
  inline FastRTCSdpHistoryEntryInternal()
    : RTCSdpHistoryEntryInternal(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCVideoFrameHistoryInternal : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<RTCVideoFrameHistoryEntryInternal> mEntries;
  MOZ_INIT_OUTSIDE_CTOR nsString mTrackIdentifier;

  RTCVideoFrameHistoryInternal();

  explicit inline RTCVideoFrameHistoryInternal(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCVideoFrameHistoryInternal(RTCVideoFrameHistoryInternal&& aOther) = default;

  explicit inline RTCVideoFrameHistoryInternal(const RTCVideoFrameHistoryInternal& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCVideoFrameHistoryInternal&
  operator=(const RTCVideoFrameHistoryInternal& aOther);

private:
  static bool
  InitIds(JSContext* cx, RTCVideoFrameHistoryInternalAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCVideoFrameHistoryInternal : public RTCVideoFrameHistoryInternal
{
  inline FastRTCVideoFrameHistoryInternal()
    : RTCVideoFrameHistoryInternal(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCReceivedRtpStreamStats : public RTCRtpStreamStats
{
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mDiscardedPackets;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mJitter;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mPacketsDiscarded;
  MOZ_INIT_OUTSIDE_CTOR Optional<int64_t> mPacketsLost;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mPacketsReceived;

  RTCReceivedRtpStreamStats();

  explicit inline RTCReceivedRtpStreamStats(const FastDictionaryInitializer& )
    : RTCRtpStreamStats(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCReceivedRtpStreamStats(RTCReceivedRtpStreamStats&& aOther) = default;

  explicit inline RTCReceivedRtpStreamStats(const RTCReceivedRtpStreamStats& aOther)
    : RTCRtpStreamStats(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCReceivedRtpStreamStats&
  operator=(const RTCReceivedRtpStreamStats& aOther);

  bool
  operator==(const RTCReceivedRtpStreamStats& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, RTCReceivedRtpStreamStatsAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCReceivedRtpStreamStats : public RTCReceivedRtpStreamStats
{
  inline FastRTCReceivedRtpStreamStats()
    : RTCReceivedRtpStreamStats(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCSdpHistoryInternal : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mPcid;
  MOZ_INIT_OUTSIDE_CTOR Sequence<RTCSdpHistoryEntryInternal> mSdpHistory;

  RTCSdpHistoryInternal();

  explicit inline RTCSdpHistoryInternal(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCSdpHistoryInternal(RTCSdpHistoryInternal&& aOther) = default;

  explicit inline RTCSdpHistoryInternal(const RTCSdpHistoryInternal& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCSdpHistoryInternal&
  operator=(const RTCSdpHistoryInternal& aOther);

private:
  static bool
  InitIds(JSContext* cx, RTCSdpHistoryInternalAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCSdpHistoryInternal : public RTCSdpHistoryInternal
{
  inline FastRTCSdpHistoryInternal()
    : RTCSdpHistoryInternal(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCSentRtpStreamStats : public RTCRtpStreamStats
{
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mBytesSent;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mPacketsSent;

  RTCSentRtpStreamStats();

  explicit inline RTCSentRtpStreamStats(const FastDictionaryInitializer& )
    : RTCRtpStreamStats(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCSentRtpStreamStats(RTCSentRtpStreamStats&& aOther) = default;

  explicit inline RTCSentRtpStreamStats(const RTCSentRtpStreamStats& aOther)
    : RTCRtpStreamStats(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCSentRtpStreamStats&
  operator=(const RTCSentRtpStreamStats& aOther);

  bool
  operator==(const RTCSentRtpStreamStats& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, RTCSentRtpStreamStatsAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCSentRtpStreamStats : public RTCSentRtpStreamStats
{
  inline FastRTCSentRtpStreamStats()
    : RTCSentRtpStreamStats(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCInboundRtpStreamStats : public RTCReceivedRtpStreamStats
{
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mAudioLevel;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mBytesReceived;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mConcealedSamples;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mConcealmentEvents;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mFecPacketsDiscarded;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mFecPacketsReceived;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mFirCount;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mFrameHeight;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mFrameWidth;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mFramesDecoded;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mFramesDropped;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mFramesPerSecond;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mFramesReceived;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mHeaderBytesReceived;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mInsertedSamplesForDeceleration;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mJitterBufferDelay;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mJitterBufferEmittedCount;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mLastPacketReceivedTimestamp;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mNackCount;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mPliCount;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mQpSum;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mRemoteId;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mRemovedSamplesForAcceleration;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mSilentConcealedSamples;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mTotalAudioEnergy;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mTotalDecodeTime;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mTotalInterFrameDelay;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mTotalProcessingDelay;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mTotalSamplesDuration;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mTotalSamplesReceived;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mTotalSquaredInterFrameDelay;
  MOZ_INIT_OUTSIDE_CTOR nsString mTrackIdentifier;

  RTCInboundRtpStreamStats();

  explicit inline RTCInboundRtpStreamStats(const FastDictionaryInitializer& )
    : RTCReceivedRtpStreamStats(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCInboundRtpStreamStats(RTCInboundRtpStreamStats&& aOther) = default;

  explicit inline RTCInboundRtpStreamStats(const RTCInboundRtpStreamStats& aOther)
    : RTCReceivedRtpStreamStats(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCInboundRtpStreamStats&
  operator=(const RTCInboundRtpStreamStats& aOther);

  bool
  operator==(const RTCInboundRtpStreamStats& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, RTCInboundRtpStreamStatsAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCInboundRtpStreamStats : public RTCInboundRtpStreamStats
{
  inline FastRTCInboundRtpStreamStats()
    : RTCInboundRtpStreamStats(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCOutboundRtpStreamStats : public RTCSentRtpStreamStats
{
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mFirCount;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mFrameHeight;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mFrameWidth;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mFramesEncoded;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mFramesSent;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mHeaderBytesSent;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mHugeFramesSent;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mNackCount;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mPliCount;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mQpSum;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mRemoteId;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mRetransmittedBytesSent;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mRetransmittedPacketsSent;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mTotalEncodeTime;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mTotalEncodedBytesTarget;

  RTCOutboundRtpStreamStats();

  explicit inline RTCOutboundRtpStreamStats(const FastDictionaryInitializer& )
    : RTCSentRtpStreamStats(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCOutboundRtpStreamStats(RTCOutboundRtpStreamStats&& aOther) = default;

  explicit inline RTCOutboundRtpStreamStats(const RTCOutboundRtpStreamStats& aOther)
    : RTCSentRtpStreamStats(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCOutboundRtpStreamStats&
  operator=(const RTCOutboundRtpStreamStats& aOther);

  bool
  operator==(const RTCOutboundRtpStreamStats& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, RTCOutboundRtpStreamStatsAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCOutboundRtpStreamStats : public RTCOutboundRtpStreamStats
{
  inline FastRTCOutboundRtpStreamStats()
    : RTCOutboundRtpStreamStats(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCRemoteInboundRtpStreamStats : public RTCReceivedRtpStreamStats
{
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mFractionLost;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mLocalId;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mRoundTripTime;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mRoundTripTimeMeasurements;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mTotalRoundTripTime;

  RTCRemoteInboundRtpStreamStats();

  explicit inline RTCRemoteInboundRtpStreamStats(const FastDictionaryInitializer& )
    : RTCReceivedRtpStreamStats(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCRemoteInboundRtpStreamStats(RTCRemoteInboundRtpStreamStats&& aOther) = default;

  explicit inline RTCRemoteInboundRtpStreamStats(const RTCRemoteInboundRtpStreamStats& aOther)
    : RTCReceivedRtpStreamStats(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCRemoteInboundRtpStreamStats&
  operator=(const RTCRemoteInboundRtpStreamStats& aOther);

  bool
  operator==(const RTCRemoteInboundRtpStreamStats& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, RTCRemoteInboundRtpStreamStatsAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCRemoteInboundRtpStreamStats : public RTCRemoteInboundRtpStreamStats
{
  inline FastRTCRemoteInboundRtpStreamStats()
    : RTCRemoteInboundRtpStreamStats(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCRemoteOutboundRtpStreamStats : public RTCSentRtpStreamStats
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mLocalId;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mRemoteTimestamp;

  RTCRemoteOutboundRtpStreamStats();

  explicit inline RTCRemoteOutboundRtpStreamStats(const FastDictionaryInitializer& )
    : RTCSentRtpStreamStats(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCRemoteOutboundRtpStreamStats(RTCRemoteOutboundRtpStreamStats&& aOther) = default;

  explicit inline RTCRemoteOutboundRtpStreamStats(const RTCRemoteOutboundRtpStreamStats& aOther)
    : RTCSentRtpStreamStats(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCRemoteOutboundRtpStreamStats&
  operator=(const RTCRemoteOutboundRtpStreamStats& aOther);

  bool
  operator==(const RTCRemoteOutboundRtpStreamStats& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, RTCRemoteOutboundRtpStreamStatsAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCRemoteOutboundRtpStreamStats : public RTCRemoteOutboundRtpStreamStats
{
  inline FastRTCRemoteOutboundRtpStreamStats()
    : RTCRemoteOutboundRtpStreamStats(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCStatsCollection : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<RTCBandwidthEstimationInternal> mBandwidthEstimations;
  MOZ_INIT_OUTSIDE_CTOR Sequence<RTCCodecStats> mCodecStats;
  MOZ_INIT_OUTSIDE_CTOR Sequence<RTCDataChannelStats> mDataChannelStats;
  MOZ_INIT_OUTSIDE_CTOR Sequence<RTCIceCandidatePairStats> mIceCandidatePairStats;
  MOZ_INIT_OUTSIDE_CTOR Sequence<RTCIceCandidateStats> mIceCandidateStats;
  MOZ_INIT_OUTSIDE_CTOR Sequence<RTCInboundRtpStreamStats> mInboundRtpStreamStats;
  MOZ_INIT_OUTSIDE_CTOR Sequence<RTCMediaSourceStats> mMediaSourceStats;
  MOZ_INIT_OUTSIDE_CTOR Sequence<RTCOutboundRtpStreamStats> mOutboundRtpStreamStats;
  MOZ_INIT_OUTSIDE_CTOR Sequence<RTCPeerConnectionStats> mPeerConnectionStats;
  MOZ_INIT_OUTSIDE_CTOR Sequence<nsString> mRawLocalCandidates;
  MOZ_INIT_OUTSIDE_CTOR Sequence<nsString> mRawRemoteCandidates;
  MOZ_INIT_OUTSIDE_CTOR Sequence<RTCRemoteInboundRtpStreamStats> mRemoteInboundRtpStreamStats;
  MOZ_INIT_OUTSIDE_CTOR Sequence<RTCRemoteOutboundRtpStreamStats> mRemoteOutboundRtpStreamStats;
  MOZ_INIT_OUTSIDE_CTOR Sequence<RTCRTPContributingSourceStats> mRtpContributingSourceStats;
  MOZ_INIT_OUTSIDE_CTOR Sequence<RTCIceCandidateStats> mTrickledIceCandidateStats;
  MOZ_INIT_OUTSIDE_CTOR Sequence<RTCVideoFrameHistoryInternal> mVideoFrameHistories;

  RTCStatsCollection();

  explicit inline RTCStatsCollection(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCStatsCollection(RTCStatsCollection&& aOther) = default;

  explicit inline RTCStatsCollection(const RTCStatsCollection& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCStatsCollection&
  operator=(const RTCStatsCollection& aOther);

private:
  static bool
  InitIds(JSContext* cx, RTCStatsCollectionAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCStatsCollection : public RTCStatsCollection
{
  inline FastRTCStatsCollection()
    : RTCStatsCollection(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCStatsReportInternal : public RTCStatsCollection
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mBrowserId;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mCallDurationMs;
  MOZ_INIT_OUTSIDE_CTOR bool mClosed;
  MOZ_INIT_OUTSIDE_CTOR Optional<RTCConfigurationInternal> mConfiguration;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mIceRestarts;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mIceRollbacks;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mJsepSessionErrors;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mOfferer;
  MOZ_INIT_OUTSIDE_CTOR nsString mPcid;
  MOZ_INIT_OUTSIDE_CTOR Sequence<RTCSdpHistoryEntryInternal> mSdpHistory;
  MOZ_INIT_OUTSIDE_CTOR double mTimestamp;

  RTCStatsReportInternal();

  explicit inline RTCStatsReportInternal(const FastDictionaryInitializer& )
    : RTCStatsCollection(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RTCStatsReportInternal(RTCStatsReportInternal&& aOther) = default;

  explicit inline RTCStatsReportInternal(const RTCStatsReportInternal& aOther)
    : RTCStatsCollection(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCStatsReportInternal&
  operator=(const RTCStatsReportInternal& aOther);

private:
  static bool
  InitIds(JSContext* cx, RTCStatsReportInternalAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCStatsReportInternal : public RTCStatsReportInternal
{
  inline FastRTCStatsReportInternal()
    : RTCStatsReportInternal(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace RTCStatsReport_Binding {

  typedef mozilla::dom::RTCStatsReport NativeType;

  namespace MaplikeHelpers {
  void
  Clear(mozilla::dom::RTCStatsReport* self, ErrorResult& aRv);
  bool
  Delete(mozilla::dom::RTCStatsReport* self, const nsAString& aKey, ErrorResult& aRv);
  bool
  Has(mozilla::dom::RTCStatsReport* self, const nsAString& aKey, ErrorResult& aRv);
  void
  Set(mozilla::dom::RTCStatsReport* self, const nsAString& aKey, JS::Handle<JSObject*> aValue, ErrorResult& aRv);
  void
  Get(mozilla::dom::RTCStatsReport* self, JSContext* cx, const nsAString& aKey, JS::MutableHandle<JSObject*> aRetVal, ErrorResult& aRv);
  } // namespace MaplikeHelpers

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::RTCStatsReport* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::RTCStatsReport,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::RTCStatsReport,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace RTCStatsReport_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_RTCStatsReportBinding_h
