/* THIS FILE IS AUTOGENERATED FROM Sanitizer.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_SanitizerBinding_h
#define mozilla_dom_SanitizerBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class Document;
class DocumentFragment;
struct NativePropertyHooks;
class OwningDocumentFragmentOrDocument;
class OwningStarOrStringOrSanitizerElementNamespaceSequence;
class OwningStringOrSanitizerElementNamespace;
class ProtoAndIfaceCache;
class Sanitizer;
struct SanitizerAttribute;
struct SanitizerAttributeAtoms;
struct SanitizerConfigAtoms;
struct SanitizerElementNamespaceAtoms;
class StarOrStringOrSanitizerElementNamespaceSequence;
class StringOrSanitizerElementNamespace;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class Star : uint8_t {
  _,
  EndGuard_
};

namespace StarValues {
extern const EnumEntry strings[2];

static constexpr size_t Count = 1;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(Star::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(Star stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace StarValues

bool
ToJSValue(JSContext* aCx, Star aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningDocumentFragmentOrDocument& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningDocumentFragmentOrDocument& aUnion);


class DocumentFragmentOrDocument
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDocumentFragment,
    eDocument
  };
public:
  enum class Type
  {
    eDocumentFragment = TypeOrUninit::eDocumentFragment,
    eDocument = TypeOrUninit::eDocument
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::DocumentFragment> > mDocumentFragment;
    UnionMember<NonNull<mozilla::dom::Document> > mDocument;

  };

  TypeOrUninit mType;
  Value mValue;

  DocumentFragmentOrDocument(const DocumentFragmentOrDocument&) = delete;
  DocumentFragmentOrDocument& operator=(const DocumentFragmentOrDocument&) = delete;
public:
  explicit inline DocumentFragmentOrDocument()
    : mType(eUninitialized)
  {
  }

  inline ~DocumentFragmentOrDocument()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::DocumentFragment>&
  RawSetAsDocumentFragment()
  {
    if (mType == eDocumentFragment) {
      return mValue.mDocumentFragment.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDocumentFragment;
    return mValue.mDocumentFragment.SetValue();
  }

  inline NonNull<mozilla::dom::DocumentFragment>&
  SetAsDocumentFragment()
  {
    if (mType == eDocumentFragment) {
      return mValue.mDocumentFragment.Value();
    }
    Uninit();
    mType = eDocumentFragment;
    return mValue.mDocumentFragment.SetValue();
  }

  inline bool
  IsDocumentFragment() const
  {
    return mType == eDocumentFragment;
  }

  inline NonNull<mozilla::dom::DocumentFragment>&
  GetAsDocumentFragment()
  {
    MOZ_RELEASE_ASSERT(IsDocumentFragment(), "Wrong type!");
    return mValue.mDocumentFragment.Value();
  }

  inline mozilla::dom::DocumentFragment&
  GetAsDocumentFragment() const
  {
    MOZ_RELEASE_ASSERT(IsDocumentFragment(), "Wrong type!");
    return mValue.mDocumentFragment.Value();
  }

  inline NonNull<mozilla::dom::Document>&
  RawSetAsDocument()
  {
    if (mType == eDocument) {
      return mValue.mDocument.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDocument;
    return mValue.mDocument.SetValue();
  }

  inline NonNull<mozilla::dom::Document>&
  SetAsDocument()
  {
    if (mType == eDocument) {
      return mValue.mDocument.Value();
    }
    Uninit();
    mType = eDocument;
    return mValue.mDocument.SetValue();
  }

  inline bool
  IsDocument() const
  {
    return mType == eDocument;
  }

  inline NonNull<mozilla::dom::Document>&
  GetAsDocument()
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  inline mozilla::dom::Document&
  GetAsDocument() const
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eDocumentFragment: {
        DestroyDocumentFragment();
        break;
      }
      case eDocument: {
        DestroyDocument();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToDocumentFragment(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDocumentFragment(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDocumentFragment()
  {
    MOZ_RELEASE_ASSERT(IsDocumentFragment(), "Wrong type!");
    mValue.mDocumentFragment.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToDocument(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDocument(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDocument()
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    mValue.mDocument.Destroy();
    mType = eUninitialized;
  }
};


class OwningDocumentFragmentOrDocument : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningDocumentFragmentOrDocument& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eDocumentFragment,
    eDocument
  };
public:
  enum class Type
  {
    eDocumentFragment = TypeOrUninit::eDocumentFragment,
    eDocument = TypeOrUninit::eDocument
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::DocumentFragment> > mDocumentFragment;
    UnionMember<OwningNonNull<mozilla::dom::Document> > mDocument;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningDocumentFragmentOrDocument()
    : mType(eUninitialized)
  {
  }

  OwningDocumentFragmentOrDocument(OwningDocumentFragmentOrDocument&& aOther);

  explicit inline OwningDocumentFragmentOrDocument(const OwningDocumentFragmentOrDocument& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningDocumentFragmentOrDocument()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::DocumentFragment>&
  RawSetAsDocumentFragment();

  OwningNonNull<mozilla::dom::DocumentFragment>&
  SetAsDocumentFragment();

  inline bool
  IsDocumentFragment() const
  {
    return mType == eDocumentFragment;
  }

  inline OwningNonNull<mozilla::dom::DocumentFragment>&
  GetAsDocumentFragment()
  {
    MOZ_RELEASE_ASSERT(IsDocumentFragment(), "Wrong type!");
    return mValue.mDocumentFragment.Value();
  }

  inline OwningNonNull<mozilla::dom::DocumentFragment> const &
  GetAsDocumentFragment() const
  {
    MOZ_RELEASE_ASSERT(IsDocumentFragment(), "Wrong type!");
    return mValue.mDocumentFragment.Value();
  }

  OwningNonNull<mozilla::dom::Document>&
  RawSetAsDocument();

  OwningNonNull<mozilla::dom::Document>&
  SetAsDocument();

  inline bool
  IsDocument() const
  {
    return mType == eDocument;
  }

  inline OwningNonNull<mozilla::dom::Document>&
  GetAsDocument()
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  inline OwningNonNull<mozilla::dom::Document> const &
  GetAsDocument() const
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningDocumentFragmentOrDocument&
  operator=(OwningDocumentFragmentOrDocument&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningDocumentFragmentOrDocument&
  operator=(const OwningDocumentFragmentOrDocument& aOther);

private:
  bool
  TrySetToDocumentFragment(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDocumentFragment(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDocumentFragment();

  bool
  TrySetToDocument(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDocument(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDocument();
};


struct SanitizerElementNamespace : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mName;
  MOZ_INIT_OUTSIDE_CTOR nsString mNamespace;

  SanitizerElementNamespace();

  explicit inline SanitizerElementNamespace(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SanitizerElementNamespace(SanitizerElementNamespace&& aOther) = default;

  explicit inline SanitizerElementNamespace(const SanitizerElementNamespace& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  SanitizerElementNamespace&
  operator=(const SanitizerElementNamespace& aOther);

  bool
  operator==(const SanitizerElementNamespace& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, SanitizerElementNamespaceAtoms* atomsCache);
};

namespace binding_detail {
struct FastSanitizerElementNamespace : public SanitizerElementNamespace
{
  inline FastSanitizerElementNamespace()
    : SanitizerElementNamespace(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class StringOrSanitizerElementNamespace
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eSanitizerElementNamespace
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eSanitizerElementNamespace = TypeOrUninit::eSanitizerElementNamespace
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<binding_detail::FastSanitizerElementNamespace > mSanitizerElementNamespace;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrSanitizerElementNamespace(const StringOrSanitizerElementNamespace&) = delete;
  StringOrSanitizerElementNamespace& operator=(const StringOrSanitizerElementNamespace&) = delete;
public:
  explicit inline StringOrSanitizerElementNamespace()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrSanitizerElementNamespace()
  {
    Uninit();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline binding_detail::FastSanitizerElementNamespace&
  RawSetAsSanitizerElementNamespace()
  {
    if (mType == eSanitizerElementNamespace) {
      return mValue.mSanitizerElementNamespace.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eSanitizerElementNamespace;
    return mValue.mSanitizerElementNamespace.SetValue();
  }

  inline binding_detail::FastSanitizerElementNamespace&
  SetAsSanitizerElementNamespace()
  {
    if (mType == eSanitizerElementNamespace) {
      return mValue.mSanitizerElementNamespace.Value();
    }
    Uninit();
    mType = eSanitizerElementNamespace;
    return mValue.mSanitizerElementNamespace.SetValue();
  }

  inline bool
  IsSanitizerElementNamespace() const
  {
    return mType == eSanitizerElementNamespace;
  }

  inline binding_detail::FastSanitizerElementNamespace&
  GetAsSanitizerElementNamespace()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespace(), "Wrong type!");
    return mValue.mSanitizerElementNamespace.Value();
  }

  inline const SanitizerElementNamespace&
  GetAsSanitizerElementNamespace() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespace(), "Wrong type!");
    return mValue.mSanitizerElementNamespace.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eSanitizerElementNamespace: {
        DestroySanitizerElementNamespace();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToSanitizerElementNamespace(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizerElementNamespace(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroySanitizerElementNamespace()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespace(), "Wrong type!");
    mValue.mSanitizerElementNamespace.Destroy();
    mType = eUninitialized;
  }
};


class OwningStringOrSanitizerElementNamespace : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eSanitizerElementNamespace
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eSanitizerElementNamespace = TypeOrUninit::eSanitizerElementNamespace
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<SanitizerElementNamespace > mSanitizerElementNamespace;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningStringOrSanitizerElementNamespace()
    : mType(eUninitialized)
  {
  }

  OwningStringOrSanitizerElementNamespace(OwningStringOrSanitizerElementNamespace&& aOther);

  explicit inline OwningStringOrSanitizerElementNamespace(const OwningStringOrSanitizerElementNamespace& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningStringOrSanitizerElementNamespace()
  {
    Uninit();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  SanitizerElementNamespace&
  RawSetAsSanitizerElementNamespace();

  SanitizerElementNamespace&
  SetAsSanitizerElementNamespace();

  inline bool
  IsSanitizerElementNamespace() const
  {
    return mType == eSanitizerElementNamespace;
  }

  inline SanitizerElementNamespace&
  GetAsSanitizerElementNamespace()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespace(), "Wrong type!");
    return mValue.mSanitizerElementNamespace.Value();
  }

  inline SanitizerElementNamespace const &
  GetAsSanitizerElementNamespace() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespace(), "Wrong type!");
    return mValue.mSanitizerElementNamespace.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningStringOrSanitizerElementNamespace&
  operator=(OwningStringOrSanitizerElementNamespace&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningStringOrSanitizerElementNamespace&
  operator=(const OwningStringOrSanitizerElementNamespace& aOther);

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToSanitizerElementNamespace(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizerElementNamespace(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroySanitizerElementNamespace();
};


class StarOrStringOrSanitizerElementNamespaceSequence
{
  enum TypeOrUninit
  {
    eUninitialized,
    eStar,
    eStringOrSanitizerElementNamespaceSequence
  };
public:
  enum class Type
  {
    eStar = TypeOrUninit::eStar,
    eStringOrSanitizerElementNamespaceSequence = TypeOrUninit::eStringOrSanitizerElementNamespaceSequence
  };

private:
  union Value
  {
    UnionMember<Star > mStar;
    UnionMember<binding_detail::AutoSequence<OwningStringOrSanitizerElementNamespace> > mStringOrSanitizerElementNamespaceSequence;

  };

  TypeOrUninit mType;
  Value mValue;

  StarOrStringOrSanitizerElementNamespaceSequence(const StarOrStringOrSanitizerElementNamespaceSequence&) = delete;
  StarOrStringOrSanitizerElementNamespaceSequence& operator=(const StarOrStringOrSanitizerElementNamespaceSequence&) = delete;
public:
  explicit inline StarOrStringOrSanitizerElementNamespaceSequence()
    : mType(eUninitialized)
  {
  }

  inline ~StarOrStringOrSanitizerElementNamespaceSequence()
  {
    Uninit();
  }

  inline Star&
  RawSetAsStar()
  {
    if (mType == eStar) {
      return mValue.mStar.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eStar;
    return mValue.mStar.SetValue();
  }

  inline Star&
  SetAsStar()
  {
    if (mType == eStar) {
      return mValue.mStar.Value();
    }
    Uninit();
    mType = eStar;
    return mValue.mStar.SetValue();
  }

  inline bool
  IsStar() const
  {
    return mType == eStar;
  }

  inline Star&
  GetAsStar()
  {
    MOZ_RELEASE_ASSERT(IsStar(), "Wrong type!");
    return mValue.mStar.Value();
  }

  inline Star
  GetAsStar() const
  {
    MOZ_RELEASE_ASSERT(IsStar(), "Wrong type!");
    return mValue.mStar.Value();
  }

  inline binding_detail::AutoSequence<OwningStringOrSanitizerElementNamespace>&
  RawSetAsStringOrSanitizerElementNamespaceSequence()
  {
    if (mType == eStringOrSanitizerElementNamespaceSequence) {
      return mValue.mStringOrSanitizerElementNamespaceSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eStringOrSanitizerElementNamespaceSequence;
    return mValue.mStringOrSanitizerElementNamespaceSequence.SetValue();
  }

  inline binding_detail::AutoSequence<OwningStringOrSanitizerElementNamespace>&
  SetAsStringOrSanitizerElementNamespaceSequence()
  {
    if (mType == eStringOrSanitizerElementNamespaceSequence) {
      return mValue.mStringOrSanitizerElementNamespaceSequence.Value();
    }
    Uninit();
    mType = eStringOrSanitizerElementNamespaceSequence;
    return mValue.mStringOrSanitizerElementNamespaceSequence.SetValue();
  }

  inline bool
  IsStringOrSanitizerElementNamespaceSequence() const
  {
    return mType == eStringOrSanitizerElementNamespaceSequence;
  }

  inline binding_detail::AutoSequence<OwningStringOrSanitizerElementNamespace>&
  GetAsStringOrSanitizerElementNamespaceSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringOrSanitizerElementNamespaceSequence(), "Wrong type!");
    return mValue.mStringOrSanitizerElementNamespaceSequence.Value();
  }

  inline const Sequence<OwningStringOrSanitizerElementNamespace>&
  GetAsStringOrSanitizerElementNamespaceSequence() const
  {
    MOZ_RELEASE_ASSERT(IsStringOrSanitizerElementNamespaceSequence(), "Wrong type!");
    return mValue.mStringOrSanitizerElementNamespaceSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eStar: {
        DestroyStar();
        break;
      }
      case eStringOrSanitizerElementNamespaceSequence: {
        DestroyStringOrSanitizerElementNamespaceSequence();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToStar(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStar(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyStar()
  {
    MOZ_RELEASE_ASSERT(IsStar(), "Wrong type!");
    mValue.mStar.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToStringOrSanitizerElementNamespaceSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringOrSanitizerElementNamespaceSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyStringOrSanitizerElementNamespaceSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringOrSanitizerElementNamespaceSequence(), "Wrong type!");
    mValue.mStringOrSanitizerElementNamespaceSequence.Destroy();
    mType = eUninitialized;
  }
};


class OwningStarOrStringOrSanitizerElementNamespaceSequence : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eStar,
    eStringOrSanitizerElementNamespaceSequence
  };
public:
  enum class Type
  {
    eStar = TypeOrUninit::eStar,
    eStringOrSanitizerElementNamespaceSequence = TypeOrUninit::eStringOrSanitizerElementNamespaceSequence
  };

private:
  union Value
  {
    UnionMember<Star > mStar;
    UnionMember<Sequence<OwningStringOrSanitizerElementNamespace> > mStringOrSanitizerElementNamespaceSequence;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningStarOrStringOrSanitizerElementNamespaceSequence()
    : mType(eUninitialized)
  {
  }

  OwningStarOrStringOrSanitizerElementNamespaceSequence(OwningStarOrStringOrSanitizerElementNamespaceSequence&& aOther);

  explicit inline OwningStarOrStringOrSanitizerElementNamespaceSequence(const OwningStarOrStringOrSanitizerElementNamespaceSequence& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningStarOrStringOrSanitizerElementNamespaceSequence()
  {
    Uninit();
  }

  Star&
  RawSetAsStar();

  Star&
  SetAsStar();

  inline bool
  IsStar() const
  {
    return mType == eStar;
  }

  inline Star&
  GetAsStar()
  {
    MOZ_RELEASE_ASSERT(IsStar(), "Wrong type!");
    return mValue.mStar.Value();
  }

  inline Star const &
  GetAsStar() const
  {
    MOZ_RELEASE_ASSERT(IsStar(), "Wrong type!");
    return mValue.mStar.Value();
  }

  Sequence<OwningStringOrSanitizerElementNamespace>&
  RawSetAsStringOrSanitizerElementNamespaceSequence();

  Sequence<OwningStringOrSanitizerElementNamespace>&
  SetAsStringOrSanitizerElementNamespaceSequence();

  inline bool
  IsStringOrSanitizerElementNamespaceSequence() const
  {
    return mType == eStringOrSanitizerElementNamespaceSequence;
  }

  inline Sequence<OwningStringOrSanitizerElementNamespace>&
  GetAsStringOrSanitizerElementNamespaceSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringOrSanitizerElementNamespaceSequence(), "Wrong type!");
    return mValue.mStringOrSanitizerElementNamespaceSequence.Value();
  }

  inline Sequence<OwningStringOrSanitizerElementNamespace> const &
  GetAsStringOrSanitizerElementNamespaceSequence() const
  {
    MOZ_RELEASE_ASSERT(IsStringOrSanitizerElementNamespaceSequence(), "Wrong type!");
    return mValue.mStringOrSanitizerElementNamespaceSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningStarOrStringOrSanitizerElementNamespaceSequence&
  operator=(OwningStarOrStringOrSanitizerElementNamespaceSequence&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningStarOrStringOrSanitizerElementNamespaceSequence&
  operator=(const OwningStarOrStringOrSanitizerElementNamespaceSequence& aOther);

private:
  bool
  TrySetToStar(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStar(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyStar();

  bool
  TrySetToStringOrSanitizerElementNamespaceSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringOrSanitizerElementNamespaceSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyStringOrSanitizerElementNamespaceSequence();
};


struct SanitizerAttribute : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR OwningStarOrStringOrSanitizerElementNamespaceSequence mElements;
  MOZ_INIT_OUTSIDE_CTOR nsString mName;
  MOZ_INIT_OUTSIDE_CTOR nsString mNamespace;

  SanitizerAttribute();

  explicit inline SanitizerAttribute(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SanitizerAttribute(SanitizerAttribute&& aOther) = default;

  explicit inline SanitizerAttribute(const SanitizerAttribute& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  SanitizerAttribute&
  operator=(const SanitizerAttribute& aOther);

private:
  static bool
  InitIds(JSContext* cx, SanitizerAttributeAtoms* atomsCache);
};

namespace binding_detail {
struct FastSanitizerAttribute : public SanitizerAttribute
{
  inline FastSanitizerAttribute()
    : SanitizerAttribute(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct SanitizerConfig : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<SanitizerAttribute>> mAllowAttributes;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mAllowComments;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mAllowCustomElements;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<OwningStringOrSanitizerElementNamespace>> mAllowElements;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mAllowUnknownMarkup;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<OwningStringOrSanitizerElementNamespace>> mBlockElements;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<SanitizerAttribute>> mDropAttributes;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<OwningStringOrSanitizerElementNamespace>> mDropElements;

  SanitizerConfig();

  explicit inline SanitizerConfig(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SanitizerConfig(SanitizerConfig&& aOther) = default;

  explicit inline SanitizerConfig(const SanitizerConfig& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  SanitizerConfig&
  operator=(const SanitizerConfig& aOther);

private:
  static bool
  InitIds(JSContext* cx, SanitizerConfigAtoms* atomsCache);
};

namespace binding_detail {
struct FastSanitizerConfig : public SanitizerConfig
{
  inline FastSanitizerConfig()
    : SanitizerConfig(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace Sanitizer_Binding {

  typedef mozilla::dom::Sanitizer NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::Sanitizer* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::Sanitizer,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::Sanitizer,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace Sanitizer_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_SanitizerBinding_h
