/* THIS FILE IS AUTOGENERATED FROM TestInterfaceJS.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_TestInterfaceJSBinding_h
#define mozilla_dom_TestInterfaceJSBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/DOMEventTargetHelper.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/Record.h"
#include "mozilla/dom/RootedDictionary.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/UnionMember.h"
#include "nsWeakReference.h"

namespace mozilla {
namespace dom {

class AnyCallback;
class EventHandlerNonNull;
class Function;
class Location;
class LocationOrTestInterfaceJS;
struct NativePropertyHooks;
class ObjectOrString;
class OwningLocationOrTestInterfaceJS;
class OwningObjectOrString;
class OwningStringOrTestInterfaceJSOrNull;
class OwningStringSequenceOrString;
class OwningTestInterfaceJSOrLong;
class OwningTestInterfaceJSOrNullOrString;
class OwningTestInterfaceJSUnionableDictionaryOrLong;
class Promise;
class ProtoAndIfaceCache;
class StringOrTestInterfaceJSOrNull;
class StringSequenceOrString;
class TestInterfaceJS;
struct TestInterfaceJSAtoms;
struct TestInterfaceJSDictionary;
class TestInterfaceJSOrLong;
class TestInterfaceJSOrNullOrString;
struct TestInterfaceJSUnionableDictionaryAtoms;
class TestInterfaceJSUnionableDictionaryOrLong;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningLocationOrTestInterfaceJS& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningStringOrTestInterfaceJSOrNull& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningTestInterfaceJSOrLong& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningTestInterfaceJSOrNullOrString& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningLocationOrTestInterfaceJS& aUnion);


void
ImplCycleCollectionUnlink(OwningStringOrTestInterfaceJSOrNull& aUnion);


void
ImplCycleCollectionUnlink(OwningTestInterfaceJSOrLong& aUnion);


void
ImplCycleCollectionUnlink(OwningTestInterfaceJSOrNullOrString& aUnion);


class LocationOrTestInterfaceJS
{
  enum TypeOrUninit
  {
    eUninitialized,
    eLocation,
    eTestInterfaceJS
  };
public:
  enum class Type
  {
    eLocation = TypeOrUninit::eLocation,
    eTestInterfaceJS = TypeOrUninit::eTestInterfaceJS
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::Location> > mLocation;
    UnionMember<NonNull<mozilla::dom::TestInterfaceJS> > mTestInterfaceJS;

  };

  TypeOrUninit mType;
  Value mValue;

  LocationOrTestInterfaceJS(const LocationOrTestInterfaceJS&) = delete;
  LocationOrTestInterfaceJS& operator=(const LocationOrTestInterfaceJS&) = delete;
public:
  explicit inline LocationOrTestInterfaceJS()
    : mType(eUninitialized)
  {
  }

  inline ~LocationOrTestInterfaceJS()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::Location>&
  RawSetAsLocation()
  {
    if (mType == eLocation) {
      return mValue.mLocation.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLocation;
    return mValue.mLocation.SetValue();
  }

  inline NonNull<mozilla::dom::Location>&
  SetAsLocation()
  {
    if (mType == eLocation) {
      return mValue.mLocation.Value();
    }
    Uninit();
    mType = eLocation;
    return mValue.mLocation.SetValue();
  }

  inline bool
  IsLocation() const
  {
    return mType == eLocation;
  }

  inline NonNull<mozilla::dom::Location>&
  GetAsLocation()
  {
    MOZ_RELEASE_ASSERT(IsLocation(), "Wrong type!");
    return mValue.mLocation.Value();
  }

  inline mozilla::dom::Location&
  GetAsLocation() const
  {
    MOZ_RELEASE_ASSERT(IsLocation(), "Wrong type!");
    return mValue.mLocation.Value();
  }

  inline NonNull<mozilla::dom::TestInterfaceJS>&
  RawSetAsTestInterfaceJS()
  {
    if (mType == eTestInterfaceJS) {
      return mValue.mTestInterfaceJS.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eTestInterfaceJS;
    return mValue.mTestInterfaceJS.SetValue();
  }

  inline NonNull<mozilla::dom::TestInterfaceJS>&
  SetAsTestInterfaceJS()
  {
    if (mType == eTestInterfaceJS) {
      return mValue.mTestInterfaceJS.Value();
    }
    Uninit();
    mType = eTestInterfaceJS;
    return mValue.mTestInterfaceJS.SetValue();
  }

  inline bool
  IsTestInterfaceJS() const
  {
    return mType == eTestInterfaceJS;
  }

  inline NonNull<mozilla::dom::TestInterfaceJS>&
  GetAsTestInterfaceJS()
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJS(), "Wrong type!");
    return mValue.mTestInterfaceJS.Value();
  }

  inline mozilla::dom::TestInterfaceJS&
  GetAsTestInterfaceJS() const
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJS(), "Wrong type!");
    return mValue.mTestInterfaceJS.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eLocation: {
        DestroyLocation();
        break;
      }
      case eTestInterfaceJS: {
        DestroyTestInterfaceJS();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToLocation(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToLocation(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLocation()
  {
    MOZ_RELEASE_ASSERT(IsLocation(), "Wrong type!");
    mValue.mLocation.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToTestInterfaceJS(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTestInterfaceJS(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyTestInterfaceJS()
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJS(), "Wrong type!");
    mValue.mTestInterfaceJS.Destroy();
    mType = eUninitialized;
  }
};


class OwningLocationOrTestInterfaceJS : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningLocationOrTestInterfaceJS& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eLocation,
    eTestInterfaceJS
  };
public:
  enum class Type
  {
    eLocation = TypeOrUninit::eLocation,
    eTestInterfaceJS = TypeOrUninit::eTestInterfaceJS
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::Location> > mLocation;
    UnionMember<OwningNonNull<mozilla::dom::TestInterfaceJS> > mTestInterfaceJS;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningLocationOrTestInterfaceJS()
    : mType(eUninitialized)
  {
  }

  OwningLocationOrTestInterfaceJS(OwningLocationOrTestInterfaceJS&& aOther);

  explicit inline OwningLocationOrTestInterfaceJS(const OwningLocationOrTestInterfaceJS& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningLocationOrTestInterfaceJS()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::Location>&
  RawSetAsLocation();

  OwningNonNull<mozilla::dom::Location>&
  SetAsLocation();

  inline bool
  IsLocation() const
  {
    return mType == eLocation;
  }

  inline OwningNonNull<mozilla::dom::Location>&
  GetAsLocation()
  {
    MOZ_RELEASE_ASSERT(IsLocation(), "Wrong type!");
    return mValue.mLocation.Value();
  }

  inline OwningNonNull<mozilla::dom::Location> const &
  GetAsLocation() const
  {
    MOZ_RELEASE_ASSERT(IsLocation(), "Wrong type!");
    return mValue.mLocation.Value();
  }

  OwningNonNull<mozilla::dom::TestInterfaceJS>&
  RawSetAsTestInterfaceJS();

  OwningNonNull<mozilla::dom::TestInterfaceJS>&
  SetAsTestInterfaceJS();

  inline bool
  IsTestInterfaceJS() const
  {
    return mType == eTestInterfaceJS;
  }

  inline OwningNonNull<mozilla::dom::TestInterfaceJS>&
  GetAsTestInterfaceJS()
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJS(), "Wrong type!");
    return mValue.mTestInterfaceJS.Value();
  }

  inline OwningNonNull<mozilla::dom::TestInterfaceJS> const &
  GetAsTestInterfaceJS() const
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJS(), "Wrong type!");
    return mValue.mTestInterfaceJS.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningLocationOrTestInterfaceJS&
  operator=(OwningLocationOrTestInterfaceJS&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningLocationOrTestInterfaceJS&
  operator=(const OwningLocationOrTestInterfaceJS& aOther);

private:
  bool
  TrySetToLocation(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToLocation(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLocation();

  bool
  TrySetToTestInterfaceJS(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTestInterfaceJS(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyTestInterfaceJS();
};


class StringOrTestInterfaceJSOrNull
{
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eString,
    eTestInterfaceJS
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eString = TypeOrUninit::eString,
    eTestInterfaceJS = TypeOrUninit::eTestInterfaceJS
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<NonNull<mozilla::dom::TestInterfaceJS> > mTestInterfaceJS;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrTestInterfaceJSOrNull(const StringOrTestInterfaceJSOrNull&) = delete;
  StringOrTestInterfaceJSOrNull& operator=(const StringOrTestInterfaceJSOrNull&) = delete;
public:
  explicit inline StringOrTestInterfaceJSOrNull()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrTestInterfaceJSOrNull()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline NonNull<mozilla::dom::TestInterfaceJS>&
  RawSetAsTestInterfaceJS()
  {
    if (mType == eTestInterfaceJS) {
      return mValue.mTestInterfaceJS.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eTestInterfaceJS;
    return mValue.mTestInterfaceJS.SetValue();
  }

  inline NonNull<mozilla::dom::TestInterfaceJS>&
  SetAsTestInterfaceJS()
  {
    if (mType == eTestInterfaceJS) {
      return mValue.mTestInterfaceJS.Value();
    }
    Uninit();
    mType = eTestInterfaceJS;
    return mValue.mTestInterfaceJS.SetValue();
  }

  inline bool
  IsTestInterfaceJS() const
  {
    return mType == eTestInterfaceJS;
  }

  inline NonNull<mozilla::dom::TestInterfaceJS>&
  GetAsTestInterfaceJS()
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJS(), "Wrong type!");
    return mValue.mTestInterfaceJS.Value();
  }

  inline mozilla::dom::TestInterfaceJS&
  GetAsTestInterfaceJS() const
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJS(), "Wrong type!");
    return mValue.mTestInterfaceJS.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eNull: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eTestInterfaceJS: {
        DestroyTestInterfaceJS();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToTestInterfaceJS(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTestInterfaceJS(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyTestInterfaceJS()
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJS(), "Wrong type!");
    mValue.mTestInterfaceJS.Destroy();
    mType = eUninitialized;
  }
};


class OwningStringOrTestInterfaceJSOrNull : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningStringOrTestInterfaceJSOrNull& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eString,
    eTestInterfaceJS
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eString = TypeOrUninit::eString,
    eTestInterfaceJS = TypeOrUninit::eTestInterfaceJS
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<OwningNonNull<mozilla::dom::TestInterfaceJS> > mTestInterfaceJS;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningStringOrTestInterfaceJSOrNull()
    : mType(eUninitialized)
  {
  }

  OwningStringOrTestInterfaceJSOrNull(OwningStringOrTestInterfaceJSOrNull&& aOther);

  explicit inline OwningStringOrTestInterfaceJSOrNull(const OwningStringOrTestInterfaceJSOrNull& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningStringOrTestInterfaceJSOrNull()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  OwningNonNull<mozilla::dom::TestInterfaceJS>&
  RawSetAsTestInterfaceJS();

  OwningNonNull<mozilla::dom::TestInterfaceJS>&
  SetAsTestInterfaceJS();

  inline bool
  IsTestInterfaceJS() const
  {
    return mType == eTestInterfaceJS;
  }

  inline OwningNonNull<mozilla::dom::TestInterfaceJS>&
  GetAsTestInterfaceJS()
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJS(), "Wrong type!");
    return mValue.mTestInterfaceJS.Value();
  }

  inline OwningNonNull<mozilla::dom::TestInterfaceJS> const &
  GetAsTestInterfaceJS() const
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJS(), "Wrong type!");
    return mValue.mTestInterfaceJS.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningStringOrTestInterfaceJSOrNull&
  operator=(OwningStringOrTestInterfaceJSOrNull&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningStringOrTestInterfaceJSOrNull&
  operator=(const OwningStringOrTestInterfaceJSOrNull& aOther);

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToTestInterfaceJS(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTestInterfaceJS(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyTestInterfaceJS();
};


class StringSequenceOrString
{
  enum TypeOrUninit
  {
    eUninitialized,
    eStringSequence,
    eString
  };
public:
  enum class Type
  {
    eStringSequence = TypeOrUninit::eStringSequence,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<binding_detail::AutoSequence<nsString> > mStringSequence;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  StringSequenceOrString(const StringSequenceOrString&) = delete;
  StringSequenceOrString& operator=(const StringSequenceOrString&) = delete;
public:
  explicit inline StringSequenceOrString()
    : mType(eUninitialized)
  {
  }

  inline ~StringSequenceOrString()
  {
    Uninit();
  }

  inline binding_detail::AutoSequence<nsString>&
  RawSetAsStringSequence()
  {
    if (mType == eStringSequence) {
      return mValue.mStringSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eStringSequence;
    return mValue.mStringSequence.SetValue();
  }

  inline binding_detail::AutoSequence<nsString>&
  SetAsStringSequence()
  {
    if (mType == eStringSequence) {
      return mValue.mStringSequence.Value();
    }
    Uninit();
    mType = eStringSequence;
    return mValue.mStringSequence.SetValue();
  }

  inline bool
  IsStringSequence() const
  {
    return mType == eStringSequence;
  }

  inline binding_detail::AutoSequence<nsString>&
  GetAsStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline const Sequence<nsString>&
  GetAsStringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eStringSequence: {
        DestroyStringSequence();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToStringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    mValue.mStringSequence.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};


class OwningStringSequenceOrString : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eStringSequence,
    eString
  };
public:
  enum class Type
  {
    eStringSequence = TypeOrUninit::eStringSequence,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<Sequence<nsString> > mStringSequence;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningStringSequenceOrString()
    : mType(eUninitialized)
  {
  }

  OwningStringSequenceOrString(OwningStringSequenceOrString&& aOther);

  explicit inline OwningStringSequenceOrString(const OwningStringSequenceOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningStringSequenceOrString()
  {
    Uninit();
  }

  Sequence<nsString>&
  RawSetAsStringSequence();

  Sequence<nsString>&
  SetAsStringSequence();

  inline bool
  IsStringSequence() const
  {
    return mType == eStringSequence;
  }

  inline Sequence<nsString>&
  GetAsStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline Sequence<nsString> const &
  GetAsStringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningStringSequenceOrString&
  operator=(OwningStringSequenceOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningStringSequenceOrString&
  operator=(const OwningStringSequenceOrString& aOther);

private:
  bool
  TrySetToStringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyStringSequence();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};


class TestInterfaceJSOrLong
{
  enum TypeOrUninit
  {
    eUninitialized,
    eTestInterfaceJS,
    eLong
  };
public:
  enum class Type
  {
    eTestInterfaceJS = TypeOrUninit::eTestInterfaceJS,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::TestInterfaceJS> > mTestInterfaceJS;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  TestInterfaceJSOrLong(const TestInterfaceJSOrLong&) = delete;
  TestInterfaceJSOrLong& operator=(const TestInterfaceJSOrLong&) = delete;
public:
  explicit inline TestInterfaceJSOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~TestInterfaceJSOrLong()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::TestInterfaceJS>&
  RawSetAsTestInterfaceJS()
  {
    if (mType == eTestInterfaceJS) {
      return mValue.mTestInterfaceJS.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eTestInterfaceJS;
    return mValue.mTestInterfaceJS.SetValue();
  }

  inline NonNull<mozilla::dom::TestInterfaceJS>&
  SetAsTestInterfaceJS()
  {
    if (mType == eTestInterfaceJS) {
      return mValue.mTestInterfaceJS.Value();
    }
    Uninit();
    mType = eTestInterfaceJS;
    return mValue.mTestInterfaceJS.SetValue();
  }

  inline bool
  IsTestInterfaceJS() const
  {
    return mType == eTestInterfaceJS;
  }

  inline NonNull<mozilla::dom::TestInterfaceJS>&
  GetAsTestInterfaceJS()
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJS(), "Wrong type!");
    return mValue.mTestInterfaceJS.Value();
  }

  inline mozilla::dom::TestInterfaceJS&
  GetAsTestInterfaceJS() const
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJS(), "Wrong type!");
    return mValue.mTestInterfaceJS.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eTestInterfaceJS: {
        DestroyTestInterfaceJS();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToTestInterfaceJS(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTestInterfaceJS(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyTestInterfaceJS()
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJS(), "Wrong type!");
    mValue.mTestInterfaceJS.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};


class OwningTestInterfaceJSOrLong : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningTestInterfaceJSOrLong& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eTestInterfaceJS,
    eLong
  };
public:
  enum class Type
  {
    eTestInterfaceJS = TypeOrUninit::eTestInterfaceJS,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::TestInterfaceJS> > mTestInterfaceJS;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningTestInterfaceJSOrLong()
    : mType(eUninitialized)
  {
  }

  OwningTestInterfaceJSOrLong(OwningTestInterfaceJSOrLong&& aOther);

  explicit inline OwningTestInterfaceJSOrLong(const OwningTestInterfaceJSOrLong& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningTestInterfaceJSOrLong()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::TestInterfaceJS>&
  RawSetAsTestInterfaceJS();

  OwningNonNull<mozilla::dom::TestInterfaceJS>&
  SetAsTestInterfaceJS();

  inline bool
  IsTestInterfaceJS() const
  {
    return mType == eTestInterfaceJS;
  }

  inline OwningNonNull<mozilla::dom::TestInterfaceJS>&
  GetAsTestInterfaceJS()
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJS(), "Wrong type!");
    return mValue.mTestInterfaceJS.Value();
  }

  inline OwningNonNull<mozilla::dom::TestInterfaceJS> const &
  GetAsTestInterfaceJS() const
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJS(), "Wrong type!");
    return mValue.mTestInterfaceJS.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningTestInterfaceJSOrLong&
  operator=(OwningTestInterfaceJSOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningTestInterfaceJSOrLong&
  operator=(const OwningTestInterfaceJSOrLong& aOther);

private:
  bool
  TrySetToTestInterfaceJS(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTestInterfaceJS(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyTestInterfaceJS();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};


class TestInterfaceJSOrNullOrString
{
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eTestInterfaceJS,
    eString
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eTestInterfaceJS = TypeOrUninit::eTestInterfaceJS,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::TestInterfaceJS> > mTestInterfaceJS;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  TestInterfaceJSOrNullOrString(const TestInterfaceJSOrNullOrString&) = delete;
  TestInterfaceJSOrNullOrString& operator=(const TestInterfaceJSOrNullOrString&) = delete;
public:
  explicit inline TestInterfaceJSOrNullOrString()
    : mType(eUninitialized)
  {
  }

  inline ~TestInterfaceJSOrNullOrString()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  inline NonNull<mozilla::dom::TestInterfaceJS>&
  RawSetAsTestInterfaceJS()
  {
    if (mType == eTestInterfaceJS) {
      return mValue.mTestInterfaceJS.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eTestInterfaceJS;
    return mValue.mTestInterfaceJS.SetValue();
  }

  inline NonNull<mozilla::dom::TestInterfaceJS>&
  SetAsTestInterfaceJS()
  {
    if (mType == eTestInterfaceJS) {
      return mValue.mTestInterfaceJS.Value();
    }
    Uninit();
    mType = eTestInterfaceJS;
    return mValue.mTestInterfaceJS.SetValue();
  }

  inline bool
  IsTestInterfaceJS() const
  {
    return mType == eTestInterfaceJS;
  }

  inline NonNull<mozilla::dom::TestInterfaceJS>&
  GetAsTestInterfaceJS()
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJS(), "Wrong type!");
    return mValue.mTestInterfaceJS.Value();
  }

  inline mozilla::dom::TestInterfaceJS&
  GetAsTestInterfaceJS() const
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJS(), "Wrong type!");
    return mValue.mTestInterfaceJS.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eNull: {
        break;
      }
      case eTestInterfaceJS: {
        DestroyTestInterfaceJS();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToTestInterfaceJS(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTestInterfaceJS(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyTestInterfaceJS()
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJS(), "Wrong type!");
    mValue.mTestInterfaceJS.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};


class OwningTestInterfaceJSOrNullOrString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningTestInterfaceJSOrNullOrString& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eTestInterfaceJS,
    eString
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eTestInterfaceJS = TypeOrUninit::eTestInterfaceJS,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::TestInterfaceJS> > mTestInterfaceJS;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningTestInterfaceJSOrNullOrString()
    : mType(eUninitialized)
  {
  }

  OwningTestInterfaceJSOrNullOrString(OwningTestInterfaceJSOrNullOrString&& aOther);

  explicit inline OwningTestInterfaceJSOrNullOrString(const OwningTestInterfaceJSOrNullOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningTestInterfaceJSOrNullOrString()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  OwningNonNull<mozilla::dom::TestInterfaceJS>&
  RawSetAsTestInterfaceJS();

  OwningNonNull<mozilla::dom::TestInterfaceJS>&
  SetAsTestInterfaceJS();

  inline bool
  IsTestInterfaceJS() const
  {
    return mType == eTestInterfaceJS;
  }

  inline OwningNonNull<mozilla::dom::TestInterfaceJS>&
  GetAsTestInterfaceJS()
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJS(), "Wrong type!");
    return mValue.mTestInterfaceJS.Value();
  }

  inline OwningNonNull<mozilla::dom::TestInterfaceJS> const &
  GetAsTestInterfaceJS() const
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJS(), "Wrong type!");
    return mValue.mTestInterfaceJS.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningTestInterfaceJSOrNullOrString&
  operator=(OwningTestInterfaceJSOrNullOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningTestInterfaceJSOrNullOrString&
  operator=(const OwningTestInterfaceJSOrNullOrString& aOther);

private:
  bool
  TrySetToTestInterfaceJS(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTestInterfaceJS(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyTestInterfaceJS();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};


struct TestInterfaceJSUnionableDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR JS::Value mAnyMember;
  MOZ_INIT_OUTSIDE_CTOR Optional<JSObject*> mObjectMember;

  TestInterfaceJSUnionableDictionary();

  explicit inline TestInterfaceJSUnionableDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  TestInterfaceJSUnionableDictionary(TestInterfaceJSUnionableDictionary&& aOther) = default;

private:
  TestInterfaceJSUnionableDictionary(const TestInterfaceJSUnionableDictionary&) = delete;
  TestInterfaceJSUnionableDictionary& operator=(const TestInterfaceJSUnionableDictionary&) = delete;

  static bool
  InitIds(JSContext* cx, TestInterfaceJSUnionableDictionaryAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastTestInterfaceJSUnionableDictionary : public TestInterfaceJSUnionableDictionary
{
  inline FastTestInterfaceJSUnionableDictionary()
    : TestInterfaceJSUnionableDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class TestInterfaceJSUnionableDictionaryOrLong
{
  enum TypeOrUninit
  {
    eUninitialized,
    eTestInterfaceJSUnionableDictionary,
    eLong
  };
public:
  enum class Type
  {
    eTestInterfaceJSUnionableDictionary = TypeOrUninit::eTestInterfaceJSUnionableDictionary,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<RootedDictionary<binding_detail::FastTestInterfaceJSUnionableDictionary> > mTestInterfaceJSUnionableDictionary;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  TestInterfaceJSUnionableDictionaryOrLong(const TestInterfaceJSUnionableDictionaryOrLong&) = delete;
  TestInterfaceJSUnionableDictionaryOrLong& operator=(const TestInterfaceJSUnionableDictionaryOrLong&) = delete;
public:
  explicit inline TestInterfaceJSUnionableDictionaryOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~TestInterfaceJSUnionableDictionaryOrLong()
  {
    Uninit();
  }

  inline RootedDictionary<binding_detail::FastTestInterfaceJSUnionableDictionary>&
  RawSetAsTestInterfaceJSUnionableDictionary(JSContext* cx)
  {
    if (mType == eTestInterfaceJSUnionableDictionary) {
      return mValue.mTestInterfaceJSUnionableDictionary.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eTestInterfaceJSUnionableDictionary;
    return mValue.mTestInterfaceJSUnionableDictionary.SetValue(cx);
  }

  inline RootedDictionary<binding_detail::FastTestInterfaceJSUnionableDictionary>&
  SetAsTestInterfaceJSUnionableDictionary(JSContext* cx)
  {
    if (mType == eTestInterfaceJSUnionableDictionary) {
      return mValue.mTestInterfaceJSUnionableDictionary.Value();
    }
    Uninit();
    mType = eTestInterfaceJSUnionableDictionary;
    return mValue.mTestInterfaceJSUnionableDictionary.SetValue(cx);
  }

  inline bool
  IsTestInterfaceJSUnionableDictionary() const
  {
    return mType == eTestInterfaceJSUnionableDictionary;
  }

  inline RootedDictionary<binding_detail::FastTestInterfaceJSUnionableDictionary>&
  GetAsTestInterfaceJSUnionableDictionary()
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJSUnionableDictionary(), "Wrong type!");
    return mValue.mTestInterfaceJSUnionableDictionary.Value();
  }

  inline const TestInterfaceJSUnionableDictionary&
  GetAsTestInterfaceJSUnionableDictionary() const
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJSUnionableDictionary(), "Wrong type!");
    return mValue.mTestInterfaceJSUnionableDictionary.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eTestInterfaceJSUnionableDictionary: {
        DestroyTestInterfaceJSUnionableDictionary();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToTestInterfaceJSUnionableDictionary(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTestInterfaceJSUnionableDictionary(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyTestInterfaceJSUnionableDictionary()
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJSUnionableDictionary(), "Wrong type!");
    mValue.mTestInterfaceJSUnionableDictionary.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};


class OwningTestInterfaceJSUnionableDictionaryOrLong : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eTestInterfaceJSUnionableDictionary,
    eLong
  };
public:
  enum class Type
  {
    eTestInterfaceJSUnionableDictionary = TypeOrUninit::eTestInterfaceJSUnionableDictionary,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<TestInterfaceJSUnionableDictionary > mTestInterfaceJSUnionableDictionary;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningTestInterfaceJSUnionableDictionaryOrLong(const OwningTestInterfaceJSUnionableDictionaryOrLong&) = delete;
  OwningTestInterfaceJSUnionableDictionaryOrLong& operator=(const OwningTestInterfaceJSUnionableDictionaryOrLong&) = delete;
public:
  explicit inline OwningTestInterfaceJSUnionableDictionaryOrLong()
    : mType(eUninitialized)
  {
  }

  OwningTestInterfaceJSUnionableDictionaryOrLong(OwningTestInterfaceJSUnionableDictionaryOrLong&& aOther);

  inline ~OwningTestInterfaceJSUnionableDictionaryOrLong()
  {
    Uninit();
  }

  TestInterfaceJSUnionableDictionary&
  RawSetAsTestInterfaceJSUnionableDictionary();

  TestInterfaceJSUnionableDictionary&
  SetAsTestInterfaceJSUnionableDictionary();

  inline bool
  IsTestInterfaceJSUnionableDictionary() const
  {
    return mType == eTestInterfaceJSUnionableDictionary;
  }

  inline TestInterfaceJSUnionableDictionary&
  GetAsTestInterfaceJSUnionableDictionary()
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJSUnionableDictionary(), "Wrong type!");
    return mValue.mTestInterfaceJSUnionableDictionary.Value();
  }

  inline TestInterfaceJSUnionableDictionary const &
  GetAsTestInterfaceJSUnionableDictionary() const
  {
    MOZ_RELEASE_ASSERT(IsTestInterfaceJSUnionableDictionary(), "Wrong type!");
    return mValue.mTestInterfaceJSUnionableDictionary.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningTestInterfaceJSUnionableDictionaryOrLong&
  operator=(OwningTestInterfaceJSUnionableDictionaryOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToTestInterfaceJSUnionableDictionary(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTestInterfaceJSUnionableDictionary(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyTestInterfaceJSUnionableDictionary();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};


namespace TestInterfaceJS_Binding {

  typedef mozilla::dom::TestInterfaceJS NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::TestInterfaceJS* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::TestInterfaceJS,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::TestInterfaceJS,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace TestInterfaceJS_Binding



class TestInterfaceJSJSImpl : public CallbackInterface
{
public:
  explicit inline TestInterfaceJSJSImpl(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
  }

  explicit inline TestInterfaceJSJSImpl(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackInterface(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  explicit inline TestInterfaceJSJSImpl(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
  }

  void GetDictionaryArg(TestInterfaceJSDictionary& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetDictionaryAttr(TestInterfaceJSDictionary& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void SetDictionaryAttr(const TestInterfaceJSDictionary& dict, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void PingPongAny(JS::Handle<JS::Value> arg, JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void PingPongObject(JS::Handle<JSObject*> obj, JS::MutableHandle<JSObject*> aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void PingPongObjectOrString(const ObjectOrString& objOrString, JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void PingPongDictionary(const TestInterfaceJSDictionary& dict, TestInterfaceJSDictionary& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  int32_t PingPongDictionaryOrLong(const TestInterfaceJSUnionableDictionaryOrLong& dictOrLong, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void PingPongRecord(const Record<nsString, JS::Value>& rec, nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  int32_t ObjectSequenceLength(const Sequence<JSObject*>& seq, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  int32_t AnySequenceLength(const Sequence<JS::Value>& seq, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetCallerPrincipal(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void ConvertSVS(const nsAString& svs, nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void PingPongUnion(const TestInterfaceJSOrLong& something, OwningTestInterfaceJSOrLong& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void PingPongUnionContainingNull(const TestInterfaceJSOrNullOrString& something, OwningStringOrTestInterfaceJSOrNull& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void PingPongNullableUnion(const Nullable<TestInterfaceJSOrLong>& something, Nullable<OwningTestInterfaceJSOrLong>& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void ReturnBadUnion(OwningLocationOrTestInterfaceJS& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void TestSequenceOverload(const Sequence<nsString>& arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void TestSequenceOverload(const nsAString& arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void TestSequenceUnion(const StringSequenceOrString& arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void TestThrowError(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void TestThrowDOMException(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void TestThrowTypeError(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void TestThrowCallbackError(Function& callback, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void TestThrowXraySelfHosted(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void TestThrowSelfHosted(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> TestPromiseWithThrowingChromePromiseInit(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> TestPromiseWithThrowingContentPromiseInit(Function& func, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> TestPromiseWithDOMExceptionThrowingPromiseInit(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> TestPromiseWithThrowingChromeThenFunction(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> TestPromiseWithThrowingContentThenFunction(AnyCallback& func, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> TestPromiseWithDOMExceptionThrowingThenFunction(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> TestPromiseWithThrowingChromeThenable(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> TestPromiseWithThrowingContentThenable(JS::Handle<JSObject*> thenable, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> TestPromiseWithDOMExceptionThrowingThenable(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void __Init(JS::Handle<JS::Value> anyArg, const Optional<JS::Handle<JSObject*>>& objectArg, const TestInterfaceJSDictionary& dictionaryArg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  inline bool
  operator==(const TestInterfaceJSJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  void GetAnyArg(JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetObjectArg(JS::MutableHandle<JSObject*> aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetAnyAttr(JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetObjectAttr(JS::MutableHandle<JSObject*> aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnsomething(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void SetAnyAttr(JS::Handle<JS::Value> arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void SetObjectAttr(JS::Handle<JSObject*> arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void SetOnsomething(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

private:
  static bool
  InitIds(JSContext* cx, TestInterfaceJSAtoms* atomsCache);
};


class TestInterfaceJS final : public mozilla::DOMEventTargetHelper
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(TestInterfaceJS, mozilla::DOMEventTargetHelper)

private:
  RefPtr<TestInterfaceJSJSImpl> mImpl;
  nsCOMPtr<nsIGlobalObject> mParent;

public:
  TestInterfaceJS(JS::Handle<JSObject*> aJSImplObject, JS::Handle<JSObject*> aJSImplGlobal, nsIGlobalObject* aParent);

private:
  ~TestInterfaceJS();

public:
  nsISupports* GetParentObject() const;

  JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  static already_AddRefed<TestInterfaceJS> Constructor(const GlobalObject& global, JSContext* cx, JS::Handle<JS::Value> anyArg, const Optional<JS::Handle<JSObject*>>& objectArg, const TestInterfaceJSDictionary& dictionaryArg, ErrorResult& aRv, JS::Handle<JSObject*> aGivenProto = nullptr);

  void GetAnyArg(JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void GetObjectArg(JS::MutableHandle<JSObject*> aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void GetDictionaryArg(TestInterfaceJSDictionary& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetAnyAttr(JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void SetAnyAttr(JS::Handle<JS::Value> arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetObjectAttr(JS::MutableHandle<JSObject*> aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void SetObjectAttr(JS::Handle<JSObject*> arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetDictionaryAttr(TestInterfaceJSDictionary& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void SetDictionaryAttr(const TestInterfaceJSDictionary& dict, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void PingPongAny(JS::Handle<JS::Value> arg, JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void PingPongObject(JS::Handle<JSObject*> obj, JS::MutableHandle<JSObject*> aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void PingPongObjectOrString(const ObjectOrString& objOrString, JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void PingPongDictionary(const TestInterfaceJSDictionary& dict, TestInterfaceJSDictionary& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  int32_t PingPongDictionaryOrLong(const TestInterfaceJSUnionableDictionaryOrLong& dictOrLong, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void PingPongRecord(const Record<nsString, JS::Value>& rec, nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  int32_t ObjectSequenceLength(const Sequence<JSObject*>& seq, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  int32_t AnySequenceLength(const Sequence<JS::Value>& seq, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetCallerPrincipal(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void ConvertSVS(const nsAString& svs, nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void PingPongUnion(const TestInterfaceJSOrLong& something, OwningTestInterfaceJSOrLong& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void PingPongUnionContainingNull(const TestInterfaceJSOrNullOrString& something, OwningStringOrTestInterfaceJSOrNull& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void PingPongNullableUnion(const Nullable<TestInterfaceJSOrLong>& something, Nullable<OwningTestInterfaceJSOrLong>& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void ReturnBadUnion(OwningLocationOrTestInterfaceJS& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void TestSequenceOverload(const Sequence<nsString>& arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);
  void TestSequenceOverload(const nsAString& arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void TestSequenceUnion(const StringSequenceOrString& arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void TestThrowError(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void TestThrowDOMException(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void TestThrowTypeError(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void TestThrowCallbackError(Function& callback, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void TestThrowXraySelfHosted(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void TestThrowSelfHosted(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> TestPromiseWithThrowingChromePromiseInit(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> TestPromiseWithThrowingContentPromiseInit(Function& func, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> TestPromiseWithDOMExceptionThrowingPromiseInit(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> TestPromiseWithThrowingChromeThenFunction(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> TestPromiseWithThrowingContentThenFunction(AnyCallback& func, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> TestPromiseWithDOMExceptionThrowingThenFunction(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> TestPromiseWithThrowingChromeThenable(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> TestPromiseWithThrowingContentThenable(JS::Handle<JSObject*> thenable, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> TestPromiseWithDOMExceptionThrowingThenable(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnsomething(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void SetOnsomething(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace mozilla::dom

#endif // mozilla_dom_TestInterfaceJSBinding_h
