#ifndef mozilla_dom_UnionTypes_h
#define mozilla_dom_UnionTypes_h

#include "CustomEventBinding.h"
#include "DOMParserBinding.h"
#include "EventBinding.h"
#include "EventHandlerBinding.h"
#include "js/RootingAPI.h"
#include "js/Value.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/ImageData.h"
#include "mozilla/dom/Record.h"
#include "mozilla/dom/RootedDictionary.h"
#include "mozilla/dom/RootedRecord.h"
#include "mozilla/dom/RootedSequence.h"
#include "mozilla/dom/TypedArray.h"
#include "mozilla/dom/UnionMember.h"

class nsGenericHTMLElement;
class nsINode;

namespace mozilla {
namespace dom {

class Blob;
class CanvasGradient;
class CanvasPattern;
class Directory;
class File;
class HTMLCanvasElement;
class HTMLOptGroupElement;
class HTMLOptionElement;
class OffscreenCanvas;
class OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String;
class OwningCanvasPatternOrCanvasGradient;
class OwningCanvasPatternOrNullOrCanvasGradient;
class OwningEventHandlerNonNullOrNullOrLong;
class OwningFileOrDirectory;
class OwningHTMLCanvasElementOrOffscreenCanvas;
class OwningHTMLElementOrLong;
class OwningHTMLOptionElementOrHTMLOptGroupElement;
class OwningImageDataOrNullSequenceOrLong;
class OwningImageDataOrNullSequenceSequenceOrLong;
class OwningImageDataSequenceOrLong;
class OwningImageDataSequenceSequenceOrLong;
class OwningNodeOrLongOrBoolean;
class OwningNodeOrString;
class OwningUndefinedOrCanvasPattern;
class OwningUndefinedOrCanvasPatternOrNull;
class OwningUndefinedOrNullOrCanvasPattern;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {
void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningCanvasPatternOrCanvasGradient& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningCanvasPatternOrNullOrCanvasGradient& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningEventHandlerNonNullOrNullOrLong& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningFileOrDirectory& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningHTMLCanvasElementOrOffscreenCanvas& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningHTMLElementOrLong& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningHTMLOptionElementOrHTMLOptGroupElement& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningImageDataOrNullSequenceOrLong& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningImageDataOrNullSequenceSequenceOrLong& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningImageDataSequenceOrLong& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningImageDataSequenceSequenceOrLong& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningNodeOrLongOrBoolean& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningNodeOrString& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningUndefinedOrCanvasPattern& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningUndefinedOrCanvasPatternOrNull& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningUndefinedOrNullOrCanvasPattern& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionUnlink(OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String& aUnion);

void
ImplCycleCollectionUnlink(OwningCanvasPatternOrCanvasGradient& aUnion);

void
ImplCycleCollectionUnlink(OwningCanvasPatternOrNullOrCanvasGradient& aUnion);

void
ImplCycleCollectionUnlink(OwningEventHandlerNonNullOrNullOrLong& aUnion);

void
ImplCycleCollectionUnlink(OwningFileOrDirectory& aUnion);

void
ImplCycleCollectionUnlink(OwningHTMLCanvasElementOrOffscreenCanvas& aUnion);

void
ImplCycleCollectionUnlink(OwningHTMLElementOrLong& aUnion);

void
ImplCycleCollectionUnlink(OwningHTMLOptionElementOrHTMLOptGroupElement& aUnion);

void
ImplCycleCollectionUnlink(OwningImageDataOrNullSequenceOrLong& aUnion);

void
ImplCycleCollectionUnlink(OwningImageDataOrNullSequenceSequenceOrLong& aUnion);

void
ImplCycleCollectionUnlink(OwningImageDataSequenceOrLong& aUnion);

void
ImplCycleCollectionUnlink(OwningImageDataSequenceSequenceOrLong& aUnion);

void
ImplCycleCollectionUnlink(OwningNodeOrLongOrBoolean& aUnion);

void
ImplCycleCollectionUnlink(OwningNodeOrString& aUnion);

void
ImplCycleCollectionUnlink(OwningUndefinedOrCanvasPattern& aUnion);

void
ImplCycleCollectionUnlink(OwningUndefinedOrCanvasPatternOrNull& aUnion);

void
ImplCycleCollectionUnlink(OwningUndefinedOrNullOrCanvasPattern& aUnion);

class ArrayBufferOrLong
{
  enum TypeOrUninit
  {
    eUninitialized,
    eArrayBuffer,
    eLong
  };
public:
  enum class Type
  {
    eArrayBuffer = TypeOrUninit::eArrayBuffer,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<RootedSpiderMonkeyInterface<ArrayBuffer> > mArrayBuffer;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  ArrayBufferOrLong(const ArrayBufferOrLong&) = delete;
  ArrayBufferOrLong& operator=(const ArrayBufferOrLong&) = delete;
public:
  explicit inline ArrayBufferOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~ArrayBufferOrLong()
  {
    Uninit();
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  RawSetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  SetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    Uninit();
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eArrayBuffer: {
        DestroyArrayBuffer();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    mValue.mArrayBuffer.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class ArrayBufferViewOrArrayBuffer
{
  enum TypeOrUninit
  {
    eUninitialized,
    eArrayBufferView,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eArrayBufferView = TypeOrUninit::eArrayBufferView,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<RootedSpiderMonkeyInterface<ArrayBufferView> > mArrayBufferView;
    UnionMember<RootedSpiderMonkeyInterface<ArrayBuffer> > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  ArrayBufferViewOrArrayBuffer(const ArrayBufferViewOrArrayBuffer&) = delete;
  ArrayBufferViewOrArrayBuffer& operator=(const ArrayBufferViewOrArrayBuffer&) = delete;
public:
  explicit inline ArrayBufferViewOrArrayBuffer()
    : mType(eUninitialized)
  {
  }

  inline ~ArrayBufferViewOrArrayBuffer()
  {
    Uninit();
  }

  inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  RawSetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  SetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    Uninit();
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  RawSetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  SetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    Uninit();
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eArrayBufferView: {
        DestroyArrayBufferView();
        break;
      }
      case eArrayBuffer: {
        DestroyArrayBuffer();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    mValue.mArrayBufferView.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    mValue.mArrayBuffer.Destroy();
    mType = eUninitialized;
  }
};

class ArrayBufferViewOrArrayBufferOrBlobOrUTF8String
{
  enum TypeOrUninit
  {
    eUninitialized,
    eArrayBufferView,
    eArrayBuffer,
    eBlob,
    eUTF8String
  };
public:
  enum class Type
  {
    eArrayBufferView = TypeOrUninit::eArrayBufferView,
    eArrayBuffer = TypeOrUninit::eArrayBuffer,
    eBlob = TypeOrUninit::eBlob,
    eUTF8String = TypeOrUninit::eUTF8String
  };

private:
  union Value
  {
    UnionMember<RootedSpiderMonkeyInterface<ArrayBufferView> > mArrayBufferView;
    UnionMember<RootedSpiderMonkeyInterface<ArrayBuffer> > mArrayBuffer;
    UnionMember<NonNull<mozilla::dom::Blob> > mBlob;
    UnionMember<binding_detail::FakeString<char> > mUTF8String;

  };

  TypeOrUninit mType;
  Value mValue;

  ArrayBufferViewOrArrayBufferOrBlobOrUTF8String(const ArrayBufferViewOrArrayBufferOrBlobOrUTF8String&) = delete;
  ArrayBufferViewOrArrayBufferOrBlobOrUTF8String& operator=(const ArrayBufferViewOrArrayBufferOrBlobOrUTF8String&) = delete;
public:
  explicit inline ArrayBufferViewOrArrayBufferOrBlobOrUTF8String()
    : mType(eUninitialized)
  {
  }

  inline ~ArrayBufferViewOrArrayBufferOrBlobOrUTF8String()
  {
    Uninit();
  }

  inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  RawSetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  SetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    Uninit();
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  RawSetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  SetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    Uninit();
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline NonNull<mozilla::dom::Blob>&
  RawSetAsBlob()
  {
    if (mType == eBlob) {
      return mValue.mBlob.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBlob;
    return mValue.mBlob.SetValue();
  }

  inline NonNull<mozilla::dom::Blob>&
  SetAsBlob()
  {
    if (mType == eBlob) {
      return mValue.mBlob.Value();
    }
    Uninit();
    mType = eBlob;
    return mValue.mBlob.SetValue();
  }

  inline bool
  IsBlob() const
  {
    return mType == eBlob;
  }

  inline NonNull<mozilla::dom::Blob>&
  GetAsBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline mozilla::dom::Blob&
  GetAsBlob() const
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eArrayBufferView: {
        DestroyArrayBufferView();
        break;
      }
      case eArrayBuffer: {
        DestroyArrayBuffer();
        break;
      }
      case eBlob: {
        DestroyBlob();
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    mValue.mArrayBufferView.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    mValue.mArrayBuffer.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToBlob(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToBlob(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    mValue.mBlob.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }
};

class ByteStringOrLong
{
  enum TypeOrUninit
  {
    eUninitialized,
    eByteString,
    eLong
  };
public:
  enum class Type
  {
    eByteString = TypeOrUninit::eByteString,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<nsCString > mByteString;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  ByteStringOrLong(const ByteStringOrLong&) = delete;
  ByteStringOrLong& operator=(const ByteStringOrLong&) = delete;
public:
  explicit inline ByteStringOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~ByteStringOrLong()
  {
    Uninit();
  }

  inline nsCString&
  RawSetAsByteString()
  {
    if (mType == eByteString) {
      return mValue.mByteString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eByteString;
    return mValue.mByteString.SetValue();
  }

  inline nsCString&
  SetAsByteString()
  {
    if (mType == eByteString) {
      return mValue.mByteString.Value();
    }
    Uninit();
    mType = eByteString;
    return mValue.mByteString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsByteString().AssignLiteral(aData);
  }

  inline bool
  IsByteString() const
  {
    return mType == eByteString;
  }

  inline nsCString&
  GetAsByteString()
  {
    MOZ_RELEASE_ASSERT(IsByteString(), "Wrong type!");
    return mValue.mByteString.Value();
  }

  inline const nsCString&
  GetAsByteString() const
  {
    MOZ_RELEASE_ASSERT(IsByteString(), "Wrong type!");
    return mValue.mByteString.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eByteString: {
        DestroyByteString();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToByteString(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToByteString(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyByteString()
  {
    MOZ_RELEASE_ASSERT(IsByteString(), "Wrong type!");
    mValue.mByteString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class CanvasPatternOrCanvasGradient
{
  enum TypeOrUninit
  {
    eUninitialized,
    eCanvasPattern,
    eCanvasGradient
  };
public:
  enum class Type
  {
    eCanvasPattern = TypeOrUninit::eCanvasPattern,
    eCanvasGradient = TypeOrUninit::eCanvasGradient
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::CanvasPattern> > mCanvasPattern;
    UnionMember<NonNull<mozilla::dom::CanvasGradient> > mCanvasGradient;

  };

  TypeOrUninit mType;
  Value mValue;

  CanvasPatternOrCanvasGradient(const CanvasPatternOrCanvasGradient&) = delete;
  CanvasPatternOrCanvasGradient& operator=(const CanvasPatternOrCanvasGradient&) = delete;
public:
  explicit inline CanvasPatternOrCanvasGradient()
    : mType(eUninitialized)
  {
  }

  inline ~CanvasPatternOrCanvasGradient()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::CanvasPattern>&
  RawSetAsCanvasPattern()
  {
    if (mType == eCanvasPattern) {
      return mValue.mCanvasPattern.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCanvasPattern;
    return mValue.mCanvasPattern.SetValue();
  }

  inline NonNull<mozilla::dom::CanvasPattern>&
  SetAsCanvasPattern()
  {
    if (mType == eCanvasPattern) {
      return mValue.mCanvasPattern.Value();
    }
    Uninit();
    mType = eCanvasPattern;
    return mValue.mCanvasPattern.SetValue();
  }

  inline bool
  IsCanvasPattern() const
  {
    return mType == eCanvasPattern;
  }

  inline NonNull<mozilla::dom::CanvasPattern>&
  GetAsCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline mozilla::dom::CanvasPattern&
  GetAsCanvasPattern() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline NonNull<mozilla::dom::CanvasGradient>&
  RawSetAsCanvasGradient()
  {
    if (mType == eCanvasGradient) {
      return mValue.mCanvasGradient.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCanvasGradient;
    return mValue.mCanvasGradient.SetValue();
  }

  inline NonNull<mozilla::dom::CanvasGradient>&
  SetAsCanvasGradient()
  {
    if (mType == eCanvasGradient) {
      return mValue.mCanvasGradient.Value();
    }
    Uninit();
    mType = eCanvasGradient;
    return mValue.mCanvasGradient.SetValue();
  }

  inline bool
  IsCanvasGradient() const
  {
    return mType == eCanvasGradient;
  }

  inline NonNull<mozilla::dom::CanvasGradient>&
  GetAsCanvasGradient()
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    return mValue.mCanvasGradient.Value();
  }

  inline mozilla::dom::CanvasGradient&
  GetAsCanvasGradient() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    return mValue.mCanvasGradient.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eCanvasPattern: {
        DestroyCanvasPattern();
        break;
      }
      case eCanvasGradient: {
        DestroyCanvasGradient();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToCanvasPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    mValue.mCanvasPattern.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToCanvasGradient(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasGradient(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyCanvasGradient()
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    mValue.mCanvasGradient.Destroy();
    mType = eUninitialized;
  }
};

class CanvasPatternOrNullOrCanvasGradient
{
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eCanvasPattern,
    eCanvasGradient
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eCanvasPattern = TypeOrUninit::eCanvasPattern,
    eCanvasGradient = TypeOrUninit::eCanvasGradient
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::CanvasPattern> > mCanvasPattern;
    UnionMember<NonNull<mozilla::dom::CanvasGradient> > mCanvasGradient;

  };

  TypeOrUninit mType;
  Value mValue;

  CanvasPatternOrNullOrCanvasGradient(const CanvasPatternOrNullOrCanvasGradient&) = delete;
  CanvasPatternOrNullOrCanvasGradient& operator=(const CanvasPatternOrNullOrCanvasGradient&) = delete;
public:
  explicit inline CanvasPatternOrNullOrCanvasGradient()
    : mType(eUninitialized)
  {
  }

  inline ~CanvasPatternOrNullOrCanvasGradient()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  inline NonNull<mozilla::dom::CanvasPattern>&
  RawSetAsCanvasPattern()
  {
    if (mType == eCanvasPattern) {
      return mValue.mCanvasPattern.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCanvasPattern;
    return mValue.mCanvasPattern.SetValue();
  }

  inline NonNull<mozilla::dom::CanvasPattern>&
  SetAsCanvasPattern()
  {
    if (mType == eCanvasPattern) {
      return mValue.mCanvasPattern.Value();
    }
    Uninit();
    mType = eCanvasPattern;
    return mValue.mCanvasPattern.SetValue();
  }

  inline bool
  IsCanvasPattern() const
  {
    return mType == eCanvasPattern;
  }

  inline NonNull<mozilla::dom::CanvasPattern>&
  GetAsCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline mozilla::dom::CanvasPattern&
  GetAsCanvasPattern() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline NonNull<mozilla::dom::CanvasGradient>&
  RawSetAsCanvasGradient()
  {
    if (mType == eCanvasGradient) {
      return mValue.mCanvasGradient.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCanvasGradient;
    return mValue.mCanvasGradient.SetValue();
  }

  inline NonNull<mozilla::dom::CanvasGradient>&
  SetAsCanvasGradient()
  {
    if (mType == eCanvasGradient) {
      return mValue.mCanvasGradient.Value();
    }
    Uninit();
    mType = eCanvasGradient;
    return mValue.mCanvasGradient.SetValue();
  }

  inline bool
  IsCanvasGradient() const
  {
    return mType == eCanvasGradient;
  }

  inline NonNull<mozilla::dom::CanvasGradient>&
  GetAsCanvasGradient()
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    return mValue.mCanvasGradient.Value();
  }

  inline mozilla::dom::CanvasGradient&
  GetAsCanvasGradient() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    return mValue.mCanvasGradient.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eNull: {
        break;
      }
      case eCanvasPattern: {
        DestroyCanvasPattern();
        break;
      }
      case eCanvasGradient: {
        DestroyCanvasGradient();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToCanvasPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    mValue.mCanvasPattern.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToCanvasGradient(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasGradient(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyCanvasGradient()
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    mValue.mCanvasGradient.Destroy();
    mType = eUninitialized;
  }
};

class CustomEventInitOrLong
{
  enum TypeOrUninit
  {
    eUninitialized,
    eCustomEventInit,
    eLong
  };
public:
  enum class Type
  {
    eCustomEventInit = TypeOrUninit::eCustomEventInit,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<RootedDictionary<binding_detail::FastCustomEventInit> > mCustomEventInit;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  CustomEventInitOrLong(const CustomEventInitOrLong&) = delete;
  CustomEventInitOrLong& operator=(const CustomEventInitOrLong&) = delete;
public:
  explicit inline CustomEventInitOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~CustomEventInitOrLong()
  {
    Uninit();
  }

  inline RootedDictionary<binding_detail::FastCustomEventInit>&
  RawSetAsCustomEventInit(JSContext* cx)
  {
    if (mType == eCustomEventInit) {
      return mValue.mCustomEventInit.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCustomEventInit;
    return mValue.mCustomEventInit.SetValue(cx);
  }

  inline RootedDictionary<binding_detail::FastCustomEventInit>&
  SetAsCustomEventInit(JSContext* cx)
  {
    if (mType == eCustomEventInit) {
      return mValue.mCustomEventInit.Value();
    }
    Uninit();
    mType = eCustomEventInit;
    return mValue.mCustomEventInit.SetValue(cx);
  }

  inline bool
  IsCustomEventInit() const
  {
    return mType == eCustomEventInit;
  }

  inline RootedDictionary<binding_detail::FastCustomEventInit>&
  GetAsCustomEventInit()
  {
    MOZ_RELEASE_ASSERT(IsCustomEventInit(), "Wrong type!");
    return mValue.mCustomEventInit.Value();
  }

  inline const CustomEventInit&
  GetAsCustomEventInit() const
  {
    MOZ_RELEASE_ASSERT(IsCustomEventInit(), "Wrong type!");
    return mValue.mCustomEventInit.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eCustomEventInit: {
        DestroyCustomEventInit();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToCustomEventInit(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCustomEventInit(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyCustomEventInit()
  {
    MOZ_RELEASE_ASSERT(IsCustomEventInit(), "Wrong type!");
    mValue.mCustomEventInit.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class DoubleOrByteString
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eByteString
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eByteString = TypeOrUninit::eByteString
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<nsCString > mByteString;

  };

  TypeOrUninit mType;
  Value mValue;

  DoubleOrByteString(const DoubleOrByteString&) = delete;
  DoubleOrByteString& operator=(const DoubleOrByteString&) = delete;
public:
  explicit inline DoubleOrByteString()
    : mType(eUninitialized)
  {
  }

  inline ~DoubleOrByteString()
  {
    Uninit();
  }

  inline double&
  RawSetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline double&
  SetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    Uninit();
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline nsCString&
  RawSetAsByteString()
  {
    if (mType == eByteString) {
      return mValue.mByteString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eByteString;
    return mValue.mByteString.SetValue();
  }

  inline nsCString&
  SetAsByteString()
  {
    if (mType == eByteString) {
      return mValue.mByteString.Value();
    }
    Uninit();
    mType = eByteString;
    return mValue.mByteString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsByteString().AssignLiteral(aData);
  }

  inline bool
  IsByteString() const
  {
    return mType == eByteString;
  }

  inline nsCString&
  GetAsByteString()
  {
    MOZ_RELEASE_ASSERT(IsByteString(), "Wrong type!");
    return mValue.mByteString.Value();
  }

  inline const nsCString&
  GetAsByteString() const
  {
    MOZ_RELEASE_ASSERT(IsByteString(), "Wrong type!");
    return mValue.mByteString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eDouble: {
        DestroyDouble();
        break;
      }
      case eByteString: {
        DestroyByteString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    mValue.mDouble.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToByteString(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToByteString(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyByteString()
  {
    MOZ_RELEASE_ASSERT(IsByteString(), "Wrong type!");
    mValue.mByteString.Destroy();
    mType = eUninitialized;
  }
};

class DoubleOrString
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eString
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  DoubleOrString(const DoubleOrString&) = delete;
  DoubleOrString& operator=(const DoubleOrString&) = delete;
public:
  explicit inline DoubleOrString()
    : mType(eUninitialized)
  {
  }

  inline ~DoubleOrString()
  {
    Uninit();
  }

  inline double&
  RawSetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline double&
  SetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    Uninit();
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eDouble: {
        DestroyDouble();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    mValue.mDouble.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};

class DoubleOrSupportedType
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eSupportedType
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eSupportedType = TypeOrUninit::eSupportedType
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<SupportedType > mSupportedType;

  };

  TypeOrUninit mType;
  Value mValue;

  DoubleOrSupportedType(const DoubleOrSupportedType&) = delete;
  DoubleOrSupportedType& operator=(const DoubleOrSupportedType&) = delete;
public:
  explicit inline DoubleOrSupportedType()
    : mType(eUninitialized)
  {
  }

  inline ~DoubleOrSupportedType()
  {
    Uninit();
  }

  inline double&
  RawSetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline double&
  SetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    Uninit();
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline SupportedType&
  RawSetAsSupportedType()
  {
    if (mType == eSupportedType) {
      return mValue.mSupportedType.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eSupportedType;
    return mValue.mSupportedType.SetValue();
  }

  inline SupportedType&
  SetAsSupportedType()
  {
    if (mType == eSupportedType) {
      return mValue.mSupportedType.Value();
    }
    Uninit();
    mType = eSupportedType;
    return mValue.mSupportedType.SetValue();
  }

  inline bool
  IsSupportedType() const
  {
    return mType == eSupportedType;
  }

  inline SupportedType&
  GetAsSupportedType()
  {
    MOZ_RELEASE_ASSERT(IsSupportedType(), "Wrong type!");
    return mValue.mSupportedType.Value();
  }

  inline SupportedType
  GetAsSupportedType() const
  {
    MOZ_RELEASE_ASSERT(IsSupportedType(), "Wrong type!");
    return mValue.mSupportedType.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eDouble: {
        DestroyDouble();
        break;
      }
      case eSupportedType: {
        DestroySupportedType();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    mValue.mDouble.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToSupportedType(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSupportedType(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroySupportedType()
  {
    MOZ_RELEASE_ASSERT(IsSupportedType(), "Wrong type!");
    mValue.mSupportedType.Destroy();
    mType = eUninitialized;
  }
};

class DoubleOrUSVString
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eUSVString
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eUSVString = TypeOrUninit::eUSVString
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<binding_detail::FakeString<char16_t> > mUSVString;

  };

  TypeOrUninit mType;
  Value mValue;

  DoubleOrUSVString(const DoubleOrUSVString&) = delete;
  DoubleOrUSVString& operator=(const DoubleOrUSVString&) = delete;
public:
  explicit inline DoubleOrUSVString()
    : mType(eUninitialized)
  {
  }

  inline ~DoubleOrUSVString()
  {
    Uninit();
  }

  inline double&
  RawSetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline double&
  SetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    Uninit();
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsUSVString()
  {
    if (mType == eUSVString) {
      return mValue.mUSVString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUSVString;
    return mValue.mUSVString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsUSVString()
  {
    if (mType == eUSVString) {
      return mValue.mUSVString.Value();
    }
    Uninit();
    mType = eUSVString;
    return mValue.mUSVString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsUSVString().AssignLiteral(aData);
  }

  inline bool
  IsUSVString() const
  {
    return mType == eUSVString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline const nsAString&
  GetAsUSVString() const
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eDouble: {
        DestroyDouble();
        break;
      }
      case eUSVString: {
        DestroyUSVString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    mValue.mDouble.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUSVString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    mValue.mUSVString.Destroy();
    mType = eUninitialized;
  }
};

class DoubleOrUTF8String
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eUTF8String
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eUTF8String = TypeOrUninit::eUTF8String
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<binding_detail::FakeString<char> > mUTF8String;

  };

  TypeOrUninit mType;
  Value mValue;

  DoubleOrUTF8String(const DoubleOrUTF8String&) = delete;
  DoubleOrUTF8String& operator=(const DoubleOrUTF8String&) = delete;
public:
  explicit inline DoubleOrUTF8String()
    : mType(eUninitialized)
  {
  }

  inline ~DoubleOrUTF8String()
  {
    Uninit();
  }

  inline double&
  RawSetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline double&
  SetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    Uninit();
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eDouble: {
        DestroyDouble();
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    mValue.mDouble.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }
};

class EventHandlerNonNullOrNullOrLong
{
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eEventHandlerNonNull,
    eLong
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eEventHandlerNonNull = TypeOrUninit::eEventHandlerNonNull,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<RootedCallback<OwningNonNull<binding_detail::FastEventHandlerNonNull>> > mEventHandlerNonNull;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  EventHandlerNonNullOrNullOrLong(const EventHandlerNonNullOrNullOrLong&) = delete;
  EventHandlerNonNullOrNullOrLong& operator=(const EventHandlerNonNullOrNullOrLong&) = delete;
public:
  explicit inline EventHandlerNonNullOrNullOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~EventHandlerNonNullOrNullOrLong()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  inline RootedCallback<OwningNonNull<binding_detail::FastEventHandlerNonNull>>&
  RawSetAsEventHandlerNonNull(JSContext* cx)
  {
    if (mType == eEventHandlerNonNull) {
      return mValue.mEventHandlerNonNull.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eEventHandlerNonNull;
    return mValue.mEventHandlerNonNull.SetValue(cx);
  }

  inline RootedCallback<OwningNonNull<binding_detail::FastEventHandlerNonNull>>&
  SetAsEventHandlerNonNull(JSContext* cx)
  {
    if (mType == eEventHandlerNonNull) {
      return mValue.mEventHandlerNonNull.Value();
    }
    Uninit();
    mType = eEventHandlerNonNull;
    return mValue.mEventHandlerNonNull.SetValue(cx);
  }

  inline bool
  IsEventHandlerNonNull() const
  {
    return mType == eEventHandlerNonNull;
  }

  inline RootedCallback<OwningNonNull<binding_detail::FastEventHandlerNonNull>>&
  GetAsEventHandlerNonNull()
  {
    MOZ_RELEASE_ASSERT(IsEventHandlerNonNull(), "Wrong type!");
    return mValue.mEventHandlerNonNull.Value();
  }

  inline EventHandlerNonNull&
  GetAsEventHandlerNonNull() const
  {
    MOZ_RELEASE_ASSERT(IsEventHandlerNonNull(), "Wrong type!");
    return mValue.mEventHandlerNonNull.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eNull: {
        break;
      }
      case eEventHandlerNonNull: {
        DestroyEventHandlerNonNull();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToEventHandlerNonNull(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToEventHandlerNonNull(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyEventHandlerNonNull()
  {
    MOZ_RELEASE_ASSERT(IsEventHandlerNonNull(), "Wrong type!");
    mValue.mEventHandlerNonNull.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class EventInitOrLong
{
  enum TypeOrUninit
  {
    eUninitialized,
    eEventInit,
    eLong
  };
public:
  enum class Type
  {
    eEventInit = TypeOrUninit::eEventInit,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<binding_detail::FastEventInit > mEventInit;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  EventInitOrLong(const EventInitOrLong&) = delete;
  EventInitOrLong& operator=(const EventInitOrLong&) = delete;
public:
  explicit inline EventInitOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~EventInitOrLong()
  {
    Uninit();
  }

  inline binding_detail::FastEventInit&
  RawSetAsEventInit()
  {
    if (mType == eEventInit) {
      return mValue.mEventInit.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eEventInit;
    return mValue.mEventInit.SetValue();
  }

  inline binding_detail::FastEventInit&
  SetAsEventInit()
  {
    if (mType == eEventInit) {
      return mValue.mEventInit.Value();
    }
    Uninit();
    mType = eEventInit;
    return mValue.mEventInit.SetValue();
  }

  inline bool
  IsEventInit() const
  {
    return mType == eEventInit;
  }

  inline binding_detail::FastEventInit&
  GetAsEventInit()
  {
    MOZ_RELEASE_ASSERT(IsEventInit(), "Wrong type!");
    return mValue.mEventInit.Value();
  }

  inline const EventInit&
  GetAsEventInit() const
  {
    MOZ_RELEASE_ASSERT(IsEventInit(), "Wrong type!");
    return mValue.mEventInit.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eEventInit: {
        DestroyEventInit();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToEventInit(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToEventInit(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyEventInit()
  {
    MOZ_RELEASE_ASSERT(IsEventInit(), "Wrong type!");
    mValue.mEventInit.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class EventInitOrStringSequence
{
  enum TypeOrUninit
  {
    eUninitialized,
    eEventInit,
    eStringSequence
  };
public:
  enum class Type
  {
    eEventInit = TypeOrUninit::eEventInit,
    eStringSequence = TypeOrUninit::eStringSequence
  };

private:
  union Value
  {
    UnionMember<binding_detail::FastEventInit > mEventInit;
    UnionMember<binding_detail::AutoSequence<nsString> > mStringSequence;

  };

  TypeOrUninit mType;
  Value mValue;

  EventInitOrStringSequence(const EventInitOrStringSequence&) = delete;
  EventInitOrStringSequence& operator=(const EventInitOrStringSequence&) = delete;
public:
  explicit inline EventInitOrStringSequence()
    : mType(eUninitialized)
  {
  }

  inline ~EventInitOrStringSequence()
  {
    Uninit();
  }

  inline binding_detail::FastEventInit&
  RawSetAsEventInit()
  {
    if (mType == eEventInit) {
      return mValue.mEventInit.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eEventInit;
    return mValue.mEventInit.SetValue();
  }

  inline binding_detail::FastEventInit&
  SetAsEventInit()
  {
    if (mType == eEventInit) {
      return mValue.mEventInit.Value();
    }
    Uninit();
    mType = eEventInit;
    return mValue.mEventInit.SetValue();
  }

  inline bool
  IsEventInit() const
  {
    return mType == eEventInit;
  }

  inline binding_detail::FastEventInit&
  GetAsEventInit()
  {
    MOZ_RELEASE_ASSERT(IsEventInit(), "Wrong type!");
    return mValue.mEventInit.Value();
  }

  inline const EventInit&
  GetAsEventInit() const
  {
    MOZ_RELEASE_ASSERT(IsEventInit(), "Wrong type!");
    return mValue.mEventInit.Value();
  }

  inline binding_detail::AutoSequence<nsString>&
  RawSetAsStringSequence()
  {
    if (mType == eStringSequence) {
      return mValue.mStringSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eStringSequence;
    return mValue.mStringSequence.SetValue();
  }

  inline binding_detail::AutoSequence<nsString>&
  SetAsStringSequence()
  {
    if (mType == eStringSequence) {
      return mValue.mStringSequence.Value();
    }
    Uninit();
    mType = eStringSequence;
    return mValue.mStringSequence.SetValue();
  }

  inline bool
  IsStringSequence() const
  {
    return mType == eStringSequence;
  }

  inline binding_detail::AutoSequence<nsString>&
  GetAsStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline const Sequence<nsString>&
  GetAsStringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eEventInit: {
        DestroyEventInit();
        break;
      }
      case eStringSequence: {
        DestroyStringSequence();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToEventInit(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToEventInit(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyEventInit()
  {
    MOZ_RELEASE_ASSERT(IsEventInit(), "Wrong type!");
    mValue.mEventInit.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToStringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    mValue.mStringSequence.Destroy();
    mType = eUninitialized;
  }
};

class FileOrDirectory
{
  enum TypeOrUninit
  {
    eUninitialized,
    eFile,
    eDirectory
  };
public:
  enum class Type
  {
    eFile = TypeOrUninit::eFile,
    eDirectory = TypeOrUninit::eDirectory
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::File> > mFile;
    UnionMember<NonNull<mozilla::dom::Directory> > mDirectory;

  };

  TypeOrUninit mType;
  Value mValue;

  FileOrDirectory(const FileOrDirectory&) = delete;
  FileOrDirectory& operator=(const FileOrDirectory&) = delete;
public:
  explicit inline FileOrDirectory()
    : mType(eUninitialized)
  {
  }

  inline ~FileOrDirectory()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::File>&
  RawSetAsFile()
  {
    if (mType == eFile) {
      return mValue.mFile.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eFile;
    return mValue.mFile.SetValue();
  }

  inline NonNull<mozilla::dom::File>&
  SetAsFile()
  {
    if (mType == eFile) {
      return mValue.mFile.Value();
    }
    Uninit();
    mType = eFile;
    return mValue.mFile.SetValue();
  }

  inline bool
  IsFile() const
  {
    return mType == eFile;
  }

  inline NonNull<mozilla::dom::File>&
  GetAsFile()
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  inline mozilla::dom::File&
  GetAsFile() const
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  inline NonNull<mozilla::dom::Directory>&
  RawSetAsDirectory()
  {
    if (mType == eDirectory) {
      return mValue.mDirectory.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDirectory;
    return mValue.mDirectory.SetValue();
  }

  inline NonNull<mozilla::dom::Directory>&
  SetAsDirectory()
  {
    if (mType == eDirectory) {
      return mValue.mDirectory.Value();
    }
    Uninit();
    mType = eDirectory;
    return mValue.mDirectory.SetValue();
  }

  inline bool
  IsDirectory() const
  {
    return mType == eDirectory;
  }

  inline NonNull<mozilla::dom::Directory>&
  GetAsDirectory()
  {
    MOZ_RELEASE_ASSERT(IsDirectory(), "Wrong type!");
    return mValue.mDirectory.Value();
  }

  inline mozilla::dom::Directory&
  GetAsDirectory() const
  {
    MOZ_RELEASE_ASSERT(IsDirectory(), "Wrong type!");
    return mValue.mDirectory.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eFile: {
        DestroyFile();
        break;
      }
      case eDirectory: {
        DestroyDirectory();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToFile(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFile(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyFile()
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    mValue.mFile.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToDirectory(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDirectory(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDirectory()
  {
    MOZ_RELEASE_ASSERT(IsDirectory(), "Wrong type!");
    mValue.mDirectory.Destroy();
    mType = eUninitialized;
  }
};

class FloatOrString
{
  enum TypeOrUninit
  {
    eUninitialized,
    eFloat,
    eString
  };
public:
  enum class Type
  {
    eFloat = TypeOrUninit::eFloat,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<float > mFloat;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  FloatOrString(const FloatOrString&) = delete;
  FloatOrString& operator=(const FloatOrString&) = delete;
public:
  explicit inline FloatOrString()
    : mType(eUninitialized)
  {
  }

  inline ~FloatOrString()
  {
    Uninit();
  }

  inline float&
  RawSetAsFloat()
  {
    if (mType == eFloat) {
      return mValue.mFloat.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eFloat;
    return mValue.mFloat.SetValue();
  }

  inline float&
  SetAsFloat()
  {
    if (mType == eFloat) {
      return mValue.mFloat.Value();
    }
    Uninit();
    mType = eFloat;
    return mValue.mFloat.SetValue();
  }

  inline bool
  IsFloat() const
  {
    return mType == eFloat;
  }

  inline float&
  GetAsFloat()
  {
    MOZ_RELEASE_ASSERT(IsFloat(), "Wrong type!");
    return mValue.mFloat.Value();
  }

  inline float
  GetAsFloat() const
  {
    MOZ_RELEASE_ASSERT(IsFloat(), "Wrong type!");
    return mValue.mFloat.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eFloat: {
        DestroyFloat();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToFloat(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFloat(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyFloat()
  {
    MOZ_RELEASE_ASSERT(IsFloat(), "Wrong type!");
    mValue.mFloat.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};

class HTMLCanvasElementOrOffscreenCanvas
{
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLCanvasElement,
    eOffscreenCanvas
  };
public:
  enum class Type
  {
    eHTMLCanvasElement = TypeOrUninit::eHTMLCanvasElement,
    eOffscreenCanvas = TypeOrUninit::eOffscreenCanvas
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::HTMLCanvasElement> > mHTMLCanvasElement;
    UnionMember<NonNull<mozilla::dom::OffscreenCanvas> > mOffscreenCanvas;

  };

  TypeOrUninit mType;
  Value mValue;

  HTMLCanvasElementOrOffscreenCanvas(const HTMLCanvasElementOrOffscreenCanvas&) = delete;
  HTMLCanvasElementOrOffscreenCanvas& operator=(const HTMLCanvasElementOrOffscreenCanvas&) = delete;
public:
  explicit inline HTMLCanvasElementOrOffscreenCanvas()
    : mType(eUninitialized)
  {
  }

  inline ~HTMLCanvasElementOrOffscreenCanvas()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::HTMLCanvasElement>&
  RawSetAsHTMLCanvasElement()
  {
    if (mType == eHTMLCanvasElement) {
      return mValue.mHTMLCanvasElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLCanvasElement;
    return mValue.mHTMLCanvasElement.SetValue();
  }

  inline NonNull<mozilla::dom::HTMLCanvasElement>&
  SetAsHTMLCanvasElement()
  {
    if (mType == eHTMLCanvasElement) {
      return mValue.mHTMLCanvasElement.Value();
    }
    Uninit();
    mType = eHTMLCanvasElement;
    return mValue.mHTMLCanvasElement.SetValue();
  }

  inline bool
  IsHTMLCanvasElement() const
  {
    return mType == eHTMLCanvasElement;
  }

  inline NonNull<mozilla::dom::HTMLCanvasElement>&
  GetAsHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  inline mozilla::dom::HTMLCanvasElement&
  GetAsHTMLCanvasElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  inline NonNull<mozilla::dom::OffscreenCanvas>&
  RawSetAsOffscreenCanvas()
  {
    if (mType == eOffscreenCanvas) {
      return mValue.mOffscreenCanvas.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eOffscreenCanvas;
    return mValue.mOffscreenCanvas.SetValue();
  }

  inline NonNull<mozilla::dom::OffscreenCanvas>&
  SetAsOffscreenCanvas()
  {
    if (mType == eOffscreenCanvas) {
      return mValue.mOffscreenCanvas.Value();
    }
    Uninit();
    mType = eOffscreenCanvas;
    return mValue.mOffscreenCanvas.SetValue();
  }

  inline bool
  IsOffscreenCanvas() const
  {
    return mType == eOffscreenCanvas;
  }

  inline NonNull<mozilla::dom::OffscreenCanvas>&
  GetAsOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  inline mozilla::dom::OffscreenCanvas&
  GetAsOffscreenCanvas() const
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eHTMLCanvasElement: {
        DestroyHTMLCanvasElement();
        break;
      }
      case eOffscreenCanvas: {
        DestroyOffscreenCanvas();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToHTMLCanvasElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLCanvasElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    mValue.mHTMLCanvasElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToOffscreenCanvas(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToOffscreenCanvas(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    mValue.mOffscreenCanvas.Destroy();
    mType = eUninitialized;
  }
};

class HTMLElementOrLong
{
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLElement,
    eLong
  };
public:
  enum class Type
  {
    eHTMLElement = TypeOrUninit::eHTMLElement,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<NonNull<nsGenericHTMLElement> > mHTMLElement;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  HTMLElementOrLong(const HTMLElementOrLong&) = delete;
  HTMLElementOrLong& operator=(const HTMLElementOrLong&) = delete;
public:
  explicit inline HTMLElementOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~HTMLElementOrLong()
  {
    Uninit();
  }

  inline NonNull<nsGenericHTMLElement>&
  RawSetAsHTMLElement()
  {
    if (mType == eHTMLElement) {
      return mValue.mHTMLElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLElement;
    return mValue.mHTMLElement.SetValue();
  }

  inline NonNull<nsGenericHTMLElement>&
  SetAsHTMLElement()
  {
    if (mType == eHTMLElement) {
      return mValue.mHTMLElement.Value();
    }
    Uninit();
    mType = eHTMLElement;
    return mValue.mHTMLElement.SetValue();
  }

  inline bool
  IsHTMLElement() const
  {
    return mType == eHTMLElement;
  }

  inline NonNull<nsGenericHTMLElement>&
  GetAsHTMLElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLElement(), "Wrong type!");
    return mValue.mHTMLElement.Value();
  }

  inline nsGenericHTMLElement&
  GetAsHTMLElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLElement(), "Wrong type!");
    return mValue.mHTMLElement.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eHTMLElement: {
        DestroyHTMLElement();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToHTMLElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLElement(), "Wrong type!");
    mValue.mHTMLElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class HTMLOptionElementOrHTMLOptGroupElement
{
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLOptionElement,
    eHTMLOptGroupElement
  };
public:
  enum class Type
  {
    eHTMLOptionElement = TypeOrUninit::eHTMLOptionElement,
    eHTMLOptGroupElement = TypeOrUninit::eHTMLOptGroupElement
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::HTMLOptionElement> > mHTMLOptionElement;
    UnionMember<NonNull<mozilla::dom::HTMLOptGroupElement> > mHTMLOptGroupElement;

  };

  TypeOrUninit mType;
  Value mValue;

  HTMLOptionElementOrHTMLOptGroupElement(const HTMLOptionElementOrHTMLOptGroupElement&) = delete;
  HTMLOptionElementOrHTMLOptGroupElement& operator=(const HTMLOptionElementOrHTMLOptGroupElement&) = delete;
public:
  explicit inline HTMLOptionElementOrHTMLOptGroupElement()
    : mType(eUninitialized)
  {
  }

  inline ~HTMLOptionElementOrHTMLOptGroupElement()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::HTMLOptionElement>&
  RawSetAsHTMLOptionElement()
  {
    if (mType == eHTMLOptionElement) {
      return mValue.mHTMLOptionElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLOptionElement;
    return mValue.mHTMLOptionElement.SetValue();
  }

  inline NonNull<mozilla::dom::HTMLOptionElement>&
  SetAsHTMLOptionElement()
  {
    if (mType == eHTMLOptionElement) {
      return mValue.mHTMLOptionElement.Value();
    }
    Uninit();
    mType = eHTMLOptionElement;
    return mValue.mHTMLOptionElement.SetValue();
  }

  inline bool
  IsHTMLOptionElement() const
  {
    return mType == eHTMLOptionElement;
  }

  inline NonNull<mozilla::dom::HTMLOptionElement>&
  GetAsHTMLOptionElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptionElement(), "Wrong type!");
    return mValue.mHTMLOptionElement.Value();
  }

  inline mozilla::dom::HTMLOptionElement&
  GetAsHTMLOptionElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptionElement(), "Wrong type!");
    return mValue.mHTMLOptionElement.Value();
  }

  inline NonNull<mozilla::dom::HTMLOptGroupElement>&
  RawSetAsHTMLOptGroupElement()
  {
    if (mType == eHTMLOptGroupElement) {
      return mValue.mHTMLOptGroupElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLOptGroupElement;
    return mValue.mHTMLOptGroupElement.SetValue();
  }

  inline NonNull<mozilla::dom::HTMLOptGroupElement>&
  SetAsHTMLOptGroupElement()
  {
    if (mType == eHTMLOptGroupElement) {
      return mValue.mHTMLOptGroupElement.Value();
    }
    Uninit();
    mType = eHTMLOptGroupElement;
    return mValue.mHTMLOptGroupElement.SetValue();
  }

  inline bool
  IsHTMLOptGroupElement() const
  {
    return mType == eHTMLOptGroupElement;
  }

  inline NonNull<mozilla::dom::HTMLOptGroupElement>&
  GetAsHTMLOptGroupElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptGroupElement(), "Wrong type!");
    return mValue.mHTMLOptGroupElement.Value();
  }

  inline mozilla::dom::HTMLOptGroupElement&
  GetAsHTMLOptGroupElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptGroupElement(), "Wrong type!");
    return mValue.mHTMLOptGroupElement.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eHTMLOptionElement: {
        DestroyHTMLOptionElement();
        break;
      }
      case eHTMLOptGroupElement: {
        DestroyHTMLOptGroupElement();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToHTMLOptionElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLOptionElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLOptionElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptionElement(), "Wrong type!");
    mValue.mHTMLOptionElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToHTMLOptGroupElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLOptGroupElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLOptGroupElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptGroupElement(), "Wrong type!");
    mValue.mHTMLOptGroupElement.Destroy();
    mType = eUninitialized;
  }
};

class ImageDataOrNullSequenceOrLong
{
  enum TypeOrUninit
  {
    eUninitialized,
    eImageDataOrNullSequence,
    eLong
  };
public:
  enum class Type
  {
    eImageDataOrNullSequence = TypeOrUninit::eImageDataOrNullSequence,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<binding_detail::AutoSequence<RefPtr<mozilla::dom::ImageData>> > mImageDataOrNullSequence;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  ImageDataOrNullSequenceOrLong(const ImageDataOrNullSequenceOrLong&) = delete;
  ImageDataOrNullSequenceOrLong& operator=(const ImageDataOrNullSequenceOrLong&) = delete;
public:
  explicit inline ImageDataOrNullSequenceOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~ImageDataOrNullSequenceOrLong()
  {
    Uninit();
  }

  inline binding_detail::AutoSequence<RefPtr<mozilla::dom::ImageData>>&
  RawSetAsImageDataOrNullSequence()
  {
    if (mType == eImageDataOrNullSequence) {
      return mValue.mImageDataOrNullSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eImageDataOrNullSequence;
    return mValue.mImageDataOrNullSequence.SetValue();
  }

  inline binding_detail::AutoSequence<RefPtr<mozilla::dom::ImageData>>&
  SetAsImageDataOrNullSequence()
  {
    if (mType == eImageDataOrNullSequence) {
      return mValue.mImageDataOrNullSequence.Value();
    }
    Uninit();
    mType = eImageDataOrNullSequence;
    return mValue.mImageDataOrNullSequence.SetValue();
  }

  inline bool
  IsImageDataOrNullSequence() const
  {
    return mType == eImageDataOrNullSequence;
  }

  inline binding_detail::AutoSequence<RefPtr<mozilla::dom::ImageData>>&
  GetAsImageDataOrNullSequence()
  {
    MOZ_RELEASE_ASSERT(IsImageDataOrNullSequence(), "Wrong type!");
    return mValue.mImageDataOrNullSequence.Value();
  }

  inline const Sequence<RefPtr<mozilla::dom::ImageData>>&
  GetAsImageDataOrNullSequence() const
  {
    MOZ_RELEASE_ASSERT(IsImageDataOrNullSequence(), "Wrong type!");
    return mValue.mImageDataOrNullSequence.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eImageDataOrNullSequence: {
        DestroyImageDataOrNullSequence();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToImageDataOrNullSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageDataOrNullSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyImageDataOrNullSequence()
  {
    MOZ_RELEASE_ASSERT(IsImageDataOrNullSequence(), "Wrong type!");
    mValue.mImageDataOrNullSequence.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class ImageDataOrNullSequenceSequenceOrLong
{
  enum TypeOrUninit
  {
    eUninitialized,
    eImageDataOrNullSequenceSequence,
    eLong
  };
public:
  enum class Type
  {
    eImageDataOrNullSequenceSequence = TypeOrUninit::eImageDataOrNullSequenceSequence,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<binding_detail::AutoSequence<Sequence<RefPtr<mozilla::dom::ImageData>>> > mImageDataOrNullSequenceSequence;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  ImageDataOrNullSequenceSequenceOrLong(const ImageDataOrNullSequenceSequenceOrLong&) = delete;
  ImageDataOrNullSequenceSequenceOrLong& operator=(const ImageDataOrNullSequenceSequenceOrLong&) = delete;
public:
  explicit inline ImageDataOrNullSequenceSequenceOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~ImageDataOrNullSequenceSequenceOrLong()
  {
    Uninit();
  }

  inline binding_detail::AutoSequence<Sequence<RefPtr<mozilla::dom::ImageData>>>&
  RawSetAsImageDataOrNullSequenceSequence()
  {
    if (mType == eImageDataOrNullSequenceSequence) {
      return mValue.mImageDataOrNullSequenceSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eImageDataOrNullSequenceSequence;
    return mValue.mImageDataOrNullSequenceSequence.SetValue();
  }

  inline binding_detail::AutoSequence<Sequence<RefPtr<mozilla::dom::ImageData>>>&
  SetAsImageDataOrNullSequenceSequence()
  {
    if (mType == eImageDataOrNullSequenceSequence) {
      return mValue.mImageDataOrNullSequenceSequence.Value();
    }
    Uninit();
    mType = eImageDataOrNullSequenceSequence;
    return mValue.mImageDataOrNullSequenceSequence.SetValue();
  }

  inline bool
  IsImageDataOrNullSequenceSequence() const
  {
    return mType == eImageDataOrNullSequenceSequence;
  }

  inline binding_detail::AutoSequence<Sequence<RefPtr<mozilla::dom::ImageData>>>&
  GetAsImageDataOrNullSequenceSequence()
  {
    MOZ_RELEASE_ASSERT(IsImageDataOrNullSequenceSequence(), "Wrong type!");
    return mValue.mImageDataOrNullSequenceSequence.Value();
  }

  inline const Sequence<Sequence<RefPtr<mozilla::dom::ImageData>>>&
  GetAsImageDataOrNullSequenceSequence() const
  {
    MOZ_RELEASE_ASSERT(IsImageDataOrNullSequenceSequence(), "Wrong type!");
    return mValue.mImageDataOrNullSequenceSequence.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eImageDataOrNullSequenceSequence: {
        DestroyImageDataOrNullSequenceSequence();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToImageDataOrNullSequenceSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageDataOrNullSequenceSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyImageDataOrNullSequenceSequence()
  {
    MOZ_RELEASE_ASSERT(IsImageDataOrNullSequenceSequence(), "Wrong type!");
    mValue.mImageDataOrNullSequenceSequence.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class ImageDataSequenceOrLong
{
  enum TypeOrUninit
  {
    eUninitialized,
    eImageDataSequence,
    eLong
  };
public:
  enum class Type
  {
    eImageDataSequence = TypeOrUninit::eImageDataSequence,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<binding_detail::AutoSequence<OwningNonNull<mozilla::dom::ImageData>> > mImageDataSequence;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  ImageDataSequenceOrLong(const ImageDataSequenceOrLong&) = delete;
  ImageDataSequenceOrLong& operator=(const ImageDataSequenceOrLong&) = delete;
public:
  explicit inline ImageDataSequenceOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~ImageDataSequenceOrLong()
  {
    Uninit();
  }

  inline binding_detail::AutoSequence<OwningNonNull<mozilla::dom::ImageData>>&
  RawSetAsImageDataSequence()
  {
    if (mType == eImageDataSequence) {
      return mValue.mImageDataSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eImageDataSequence;
    return mValue.mImageDataSequence.SetValue();
  }

  inline binding_detail::AutoSequence<OwningNonNull<mozilla::dom::ImageData>>&
  SetAsImageDataSequence()
  {
    if (mType == eImageDataSequence) {
      return mValue.mImageDataSequence.Value();
    }
    Uninit();
    mType = eImageDataSequence;
    return mValue.mImageDataSequence.SetValue();
  }

  inline bool
  IsImageDataSequence() const
  {
    return mType == eImageDataSequence;
  }

  inline binding_detail::AutoSequence<OwningNonNull<mozilla::dom::ImageData>>&
  GetAsImageDataSequence()
  {
    MOZ_RELEASE_ASSERT(IsImageDataSequence(), "Wrong type!");
    return mValue.mImageDataSequence.Value();
  }

  inline const Sequence<OwningNonNull<mozilla::dom::ImageData>>&
  GetAsImageDataSequence() const
  {
    MOZ_RELEASE_ASSERT(IsImageDataSequence(), "Wrong type!");
    return mValue.mImageDataSequence.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eImageDataSequence: {
        DestroyImageDataSequence();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToImageDataSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageDataSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyImageDataSequence()
  {
    MOZ_RELEASE_ASSERT(IsImageDataSequence(), "Wrong type!");
    mValue.mImageDataSequence.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class ImageDataSequenceSequenceOrLong
{
  enum TypeOrUninit
  {
    eUninitialized,
    eImageDataSequenceSequence,
    eLong
  };
public:
  enum class Type
  {
    eImageDataSequenceSequence = TypeOrUninit::eImageDataSequenceSequence,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<binding_detail::AutoSequence<Sequence<OwningNonNull<mozilla::dom::ImageData>>> > mImageDataSequenceSequence;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  ImageDataSequenceSequenceOrLong(const ImageDataSequenceSequenceOrLong&) = delete;
  ImageDataSequenceSequenceOrLong& operator=(const ImageDataSequenceSequenceOrLong&) = delete;
public:
  explicit inline ImageDataSequenceSequenceOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~ImageDataSequenceSequenceOrLong()
  {
    Uninit();
  }

  inline binding_detail::AutoSequence<Sequence<OwningNonNull<mozilla::dom::ImageData>>>&
  RawSetAsImageDataSequenceSequence()
  {
    if (mType == eImageDataSequenceSequence) {
      return mValue.mImageDataSequenceSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eImageDataSequenceSequence;
    return mValue.mImageDataSequenceSequence.SetValue();
  }

  inline binding_detail::AutoSequence<Sequence<OwningNonNull<mozilla::dom::ImageData>>>&
  SetAsImageDataSequenceSequence()
  {
    if (mType == eImageDataSequenceSequence) {
      return mValue.mImageDataSequenceSequence.Value();
    }
    Uninit();
    mType = eImageDataSequenceSequence;
    return mValue.mImageDataSequenceSequence.SetValue();
  }

  inline bool
  IsImageDataSequenceSequence() const
  {
    return mType == eImageDataSequenceSequence;
  }

  inline binding_detail::AutoSequence<Sequence<OwningNonNull<mozilla::dom::ImageData>>>&
  GetAsImageDataSequenceSequence()
  {
    MOZ_RELEASE_ASSERT(IsImageDataSequenceSequence(), "Wrong type!");
    return mValue.mImageDataSequenceSequence.Value();
  }

  inline const Sequence<Sequence<OwningNonNull<mozilla::dom::ImageData>>>&
  GetAsImageDataSequenceSequence() const
  {
    MOZ_RELEASE_ASSERT(IsImageDataSequenceSequence(), "Wrong type!");
    return mValue.mImageDataSequenceSequence.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eImageDataSequenceSequence: {
        DestroyImageDataSequenceSequence();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToImageDataSequenceSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageDataSequenceSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyImageDataSequenceSequence()
  {
    MOZ_RELEASE_ASSERT(IsImageDataSequenceSequence(), "Wrong type!");
    mValue.mImageDataSequenceSequence.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class LongOrBoolean
{
  enum TypeOrUninit
  {
    eUninitialized,
    eLong,
    eBoolean
  };
public:
  enum class Type
  {
    eLong = TypeOrUninit::eLong,
    eBoolean = TypeOrUninit::eBoolean
  };

private:
  union Value
  {
    UnionMember<int32_t > mLong;
    UnionMember<bool > mBoolean;

  };

  TypeOrUninit mType;
  Value mValue;

  LongOrBoolean(const LongOrBoolean&) = delete;
  LongOrBoolean& operator=(const LongOrBoolean&) = delete;
public:
  explicit inline LongOrBoolean()
    : mType(eUninitialized)
  {
  }

  inline ~LongOrBoolean()
  {
    Uninit();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline bool&
  RawSetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool&
  SetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    Uninit();
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
      case eBoolean: {
        DestroyBoolean();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    mValue.mBoolean.Destroy();
    mType = eUninitialized;
  }
};

class LongOrStringAnyRecord
{
  enum TypeOrUninit
  {
    eUninitialized,
    eLong,
    eStringAnyRecord
  };
public:
  enum class Type
  {
    eLong = TypeOrUninit::eLong,
    eStringAnyRecord = TypeOrUninit::eStringAnyRecord
  };

private:
  union Value
  {
    UnionMember<int32_t > mLong;
    UnionMember<RootedRecord<nsString, JS::Value> > mStringAnyRecord;

  };

  TypeOrUninit mType;
  Value mValue;

  LongOrStringAnyRecord(const LongOrStringAnyRecord&) = delete;
  LongOrStringAnyRecord& operator=(const LongOrStringAnyRecord&) = delete;
public:
  explicit inline LongOrStringAnyRecord()
    : mType(eUninitialized)
  {
  }

  inline ~LongOrStringAnyRecord()
  {
    Uninit();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline RootedRecord<nsString, JS::Value>&
  RawSetAsStringAnyRecord(JSContext* cx)
  {
    if (mType == eStringAnyRecord) {
      return mValue.mStringAnyRecord.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eStringAnyRecord;
    return mValue.mStringAnyRecord.SetValue(cx);
  }

  inline RootedRecord<nsString, JS::Value>&
  SetAsStringAnyRecord(JSContext* cx)
  {
    if (mType == eStringAnyRecord) {
      return mValue.mStringAnyRecord.Value();
    }
    Uninit();
    mType = eStringAnyRecord;
    return mValue.mStringAnyRecord.SetValue(cx);
  }

  inline bool
  IsStringAnyRecord() const
  {
    return mType == eStringAnyRecord;
  }

  inline RootedRecord<nsString, JS::Value>&
  GetAsStringAnyRecord()
  {
    MOZ_RELEASE_ASSERT(IsStringAnyRecord(), "Wrong type!");
    return mValue.mStringAnyRecord.Value();
  }

  inline const Record<nsString, JS::Value>&
  GetAsStringAnyRecord() const
  {
    MOZ_RELEASE_ASSERT(IsStringAnyRecord(), "Wrong type!");
    return mValue.mStringAnyRecord.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
      case eStringAnyRecord: {
        DestroyStringAnyRecord();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToStringAnyRecord(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringAnyRecord(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyStringAnyRecord()
  {
    MOZ_RELEASE_ASSERT(IsStringAnyRecord(), "Wrong type!");
    mValue.mStringAnyRecord.Destroy();
    mType = eUninitialized;
  }
};

class LongSequenceOrLong
{
  enum TypeOrUninit
  {
    eUninitialized,
    eLongSequence,
    eLong
  };
public:
  enum class Type
  {
    eLongSequence = TypeOrUninit::eLongSequence,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<binding_detail::AutoSequence<int32_t> > mLongSequence;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  LongSequenceOrLong(const LongSequenceOrLong&) = delete;
  LongSequenceOrLong& operator=(const LongSequenceOrLong&) = delete;
public:
  explicit inline LongSequenceOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~LongSequenceOrLong()
  {
    Uninit();
  }

  inline binding_detail::AutoSequence<int32_t>&
  RawSetAsLongSequence()
  {
    if (mType == eLongSequence) {
      return mValue.mLongSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLongSequence;
    return mValue.mLongSequence.SetValue();
  }

  inline binding_detail::AutoSequence<int32_t>&
  SetAsLongSequence()
  {
    if (mType == eLongSequence) {
      return mValue.mLongSequence.Value();
    }
    Uninit();
    mType = eLongSequence;
    return mValue.mLongSequence.SetValue();
  }

  inline bool
  IsLongSequence() const
  {
    return mType == eLongSequence;
  }

  inline binding_detail::AutoSequence<int32_t>&
  GetAsLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsLongSequence(), "Wrong type!");
    return mValue.mLongSequence.Value();
  }

  inline const Sequence<int32_t>&
  GetAsLongSequence() const
  {
    MOZ_RELEASE_ASSERT(IsLongSequence(), "Wrong type!");
    return mValue.mLongSequence.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eLongSequence: {
        DestroyLongSequence();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToLongSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToLongSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsLongSequence(), "Wrong type!");
    mValue.mLongSequence.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class LongSequenceOrNullOrLong
{
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eLongSequence,
    eLong
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eLongSequence = TypeOrUninit::eLongSequence,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<binding_detail::AutoSequence<int32_t> > mLongSequence;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  LongSequenceOrNullOrLong(const LongSequenceOrNullOrLong&) = delete;
  LongSequenceOrNullOrLong& operator=(const LongSequenceOrNullOrLong&) = delete;
public:
  explicit inline LongSequenceOrNullOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~LongSequenceOrNullOrLong()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  inline binding_detail::AutoSequence<int32_t>&
  RawSetAsLongSequence()
  {
    if (mType == eLongSequence) {
      return mValue.mLongSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLongSequence;
    return mValue.mLongSequence.SetValue();
  }

  inline binding_detail::AutoSequence<int32_t>&
  SetAsLongSequence()
  {
    if (mType == eLongSequence) {
      return mValue.mLongSequence.Value();
    }
    Uninit();
    mType = eLongSequence;
    return mValue.mLongSequence.SetValue();
  }

  inline bool
  IsLongSequence() const
  {
    return mType == eLongSequence;
  }

  inline binding_detail::AutoSequence<int32_t>&
  GetAsLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsLongSequence(), "Wrong type!");
    return mValue.mLongSequence.Value();
  }

  inline const Sequence<int32_t>&
  GetAsLongSequence() const
  {
    MOZ_RELEASE_ASSERT(IsLongSequence(), "Wrong type!");
    return mValue.mLongSequence.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eNull: {
        break;
      }
      case eLongSequence: {
        DestroyLongSequence();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToLongSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToLongSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsLongSequence(), "Wrong type!");
    mValue.mLongSequence.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class MaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer
{
  enum TypeOrUninit
  {
    eUninitialized,
    eArrayBufferView,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eArrayBufferView = TypeOrUninit::eArrayBufferView,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<RootedSpiderMonkeyInterface<ArrayBufferView> > mArrayBufferView;
    UnionMember<RootedSpiderMonkeyInterface<ArrayBuffer> > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  MaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer(const MaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer&) = delete;
  MaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer& operator=(const MaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer&) = delete;
public:
  explicit inline MaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer()
    : mType(eUninitialized)
  {
  }

  inline ~MaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer()
  {
    Uninit();
  }

  inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  RawSetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  SetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    Uninit();
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  RawSetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  SetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    Uninit();
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eArrayBufferView: {
        DestroyArrayBufferView();
        break;
      }
      case eArrayBuffer: {
        DestroyArrayBuffer();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    mValue.mArrayBufferView.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    mValue.mArrayBuffer.Destroy();
    mType = eUninitialized;
  }
};

class NodeOrLongOrBoolean
{
  enum TypeOrUninit
  {
    eUninitialized,
    eNode,
    eLong,
    eBoolean
  };
public:
  enum class Type
  {
    eNode = TypeOrUninit::eNode,
    eLong = TypeOrUninit::eLong,
    eBoolean = TypeOrUninit::eBoolean
  };

private:
  union Value
  {
    UnionMember<NonNull<nsINode> > mNode;
    UnionMember<int32_t > mLong;
    UnionMember<bool > mBoolean;

  };

  TypeOrUninit mType;
  Value mValue;

  NodeOrLongOrBoolean(const NodeOrLongOrBoolean&) = delete;
  NodeOrLongOrBoolean& operator=(const NodeOrLongOrBoolean&) = delete;
public:
  explicit inline NodeOrLongOrBoolean()
    : mType(eUninitialized)
  {
  }

  inline ~NodeOrLongOrBoolean()
  {
    Uninit();
  }

  inline NonNull<nsINode>&
  RawSetAsNode()
  {
    if (mType == eNode) {
      return mValue.mNode.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eNode;
    return mValue.mNode.SetValue();
  }

  inline NonNull<nsINode>&
  SetAsNode()
  {
    if (mType == eNode) {
      return mValue.mNode.Value();
    }
    Uninit();
    mType = eNode;
    return mValue.mNode.SetValue();
  }

  inline bool
  IsNode() const
  {
    return mType == eNode;
  }

  inline NonNull<nsINode>&
  GetAsNode()
  {
    MOZ_RELEASE_ASSERT(IsNode(), "Wrong type!");
    return mValue.mNode.Value();
  }

  inline nsINode&
  GetAsNode() const
  {
    MOZ_RELEASE_ASSERT(IsNode(), "Wrong type!");
    return mValue.mNode.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline bool&
  RawSetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool&
  SetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    Uninit();
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eNode: {
        DestroyNode();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
      case eBoolean: {
        DestroyBoolean();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToNode(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToNode(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyNode()
  {
    MOZ_RELEASE_ASSERT(IsNode(), "Wrong type!");
    mValue.mNode.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    mValue.mBoolean.Destroy();
    mType = eUninitialized;
  }
};

class NodeOrString
{
  enum TypeOrUninit
  {
    eUninitialized,
    eNode,
    eString
  };
public:
  enum class Type
  {
    eNode = TypeOrUninit::eNode,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<NonNull<nsINode> > mNode;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  NodeOrString(const NodeOrString&) = delete;
  NodeOrString& operator=(const NodeOrString&) = delete;
public:
  explicit inline NodeOrString()
    : mType(eUninitialized)
  {
  }

  inline ~NodeOrString()
  {
    Uninit();
  }

  inline NonNull<nsINode>&
  RawSetAsNode()
  {
    if (mType == eNode) {
      return mValue.mNode.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eNode;
    return mValue.mNode.SetValue();
  }

  inline NonNull<nsINode>&
  SetAsNode()
  {
    if (mType == eNode) {
      return mValue.mNode.Value();
    }
    Uninit();
    mType = eNode;
    return mValue.mNode.SetValue();
  }

  inline bool
  IsNode() const
  {
    return mType == eNode;
  }

  inline NonNull<nsINode>&
  GetAsNode()
  {
    MOZ_RELEASE_ASSERT(IsNode(), "Wrong type!");
    return mValue.mNode.Value();
  }

  inline nsINode&
  GetAsNode() const
  {
    MOZ_RELEASE_ASSERT(IsNode(), "Wrong type!");
    return mValue.mNode.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eNode: {
        DestroyNode();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToNode(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToNode(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyNode()
  {
    MOZ_RELEASE_ASSERT(IsNode(), "Wrong type!");
    mValue.mNode.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};

class ObjectOrBoolean
{
  enum TypeOrUninit
  {
    eUninitialized,
    eObject,
    eBoolean
  };
public:
  enum class Type
  {
    eObject = TypeOrUninit::eObject,
    eBoolean = TypeOrUninit::eBoolean
  };

private:
  union Value
  {
    UnionMember<JS::Rooted<JSObject*> > mObject;
    UnionMember<bool > mBoolean;

  };

  TypeOrUninit mType;
  Value mValue;

  ObjectOrBoolean(const ObjectOrBoolean&) = delete;
  ObjectOrBoolean& operator=(const ObjectOrBoolean&) = delete;
public:
  explicit inline ObjectOrBoolean()
    : mType(eUninitialized)
  {
  }

  inline ~ObjectOrBoolean()
  {
    Uninit();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(cx, obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (object or boolean)");
      return false;
    }
    return true;
  }

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JS::Rooted<JSObject*>&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject*
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline bool&
  RawSetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool&
  SetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eObject: {
        DestroyObject();
        break;
      }
      case eBoolean: {
        DestroyBoolean();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    mValue.mObject.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    mValue.mBoolean.Destroy();
    mType = eUninitialized;
  }
};

class ObjectOrLong
{
  enum TypeOrUninit
  {
    eUninitialized,
    eObject,
    eLong
  };
public:
  enum class Type
  {
    eObject = TypeOrUninit::eObject,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<JS::Rooted<JSObject*> > mObject;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  ObjectOrLong(const ObjectOrLong&) = delete;
  ObjectOrLong& operator=(const ObjectOrLong&) = delete;
public:
  explicit inline ObjectOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~ObjectOrLong()
  {
    Uninit();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(cx, obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (object or long)");
      return false;
    }
    return true;
  }

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JS::Rooted<JSObject*>&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject*
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eObject: {
        DestroyObject();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    mValue.mObject.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class ObjectOrLongOrBoolean
{
  enum TypeOrUninit
  {
    eUninitialized,
    eObject,
    eLong,
    eBoolean
  };
public:
  enum class Type
  {
    eObject = TypeOrUninit::eObject,
    eLong = TypeOrUninit::eLong,
    eBoolean = TypeOrUninit::eBoolean
  };

private:
  union Value
  {
    UnionMember<JS::Rooted<JSObject*> > mObject;
    UnionMember<int32_t > mLong;
    UnionMember<bool > mBoolean;

  };

  TypeOrUninit mType;
  Value mValue;

  ObjectOrLongOrBoolean(const ObjectOrLongOrBoolean&) = delete;
  ObjectOrLongOrBoolean& operator=(const ObjectOrLongOrBoolean&) = delete;
public:
  explicit inline ObjectOrLongOrBoolean()
    : mType(eUninitialized)
  {
  }

  inline ~ObjectOrLongOrBoolean()
  {
    Uninit();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(cx, obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (object or long or boolean)");
      return false;
    }
    return true;
  }

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JS::Rooted<JSObject*>&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject*
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline bool&
  RawSetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool&
  SetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eObject: {
        DestroyObject();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
      case eBoolean: {
        DestroyBoolean();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    mValue.mObject.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    mValue.mBoolean.Destroy();
    mType = eUninitialized;
  }
};

class ObjectOrLongOrNull
{
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eObject,
    eLong
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eObject = TypeOrUninit::eObject,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<JS::Rooted<JSObject*> > mObject;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  ObjectOrLongOrNull(const ObjectOrLongOrNull&) = delete;
  ObjectOrLongOrNull& operator=(const ObjectOrLongOrNull&) = delete;
public:
  explicit inline ObjectOrLongOrNull()
    : mType(eUninitialized)
  {
  }

  inline ~ObjectOrLongOrNull()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(cx, obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (object or long?)");
      return false;
    }
    return true;
  }

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JS::Rooted<JSObject*>&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject*
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eNull: {
        break;
      }
      case eObject: {
        DestroyObject();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    mValue.mObject.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class ObjectOrNullOrLong
{
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eObject,
    eLong
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eObject = TypeOrUninit::eObject,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<JS::Rooted<JSObject*> > mObject;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  ObjectOrNullOrLong(const ObjectOrNullOrLong&) = delete;
  ObjectOrNullOrLong& operator=(const ObjectOrNullOrLong&) = delete;
public:
  explicit inline ObjectOrNullOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~ObjectOrNullOrLong()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(cx, obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (object? or long)");
      return false;
    }
    return true;
  }

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JS::Rooted<JSObject*>&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject*
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eNull: {
        break;
      }
      case eObject: {
        DestroyObject();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    mValue.mObject.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class ObjectOrString
{
  enum TypeOrUninit
  {
    eUninitialized,
    eObject,
    eString
  };
public:
  enum class Type
  {
    eObject = TypeOrUninit::eObject,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<JS::Rooted<JSObject*> > mObject;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  ObjectOrString(const ObjectOrString&) = delete;
  ObjectOrString& operator=(const ObjectOrString&) = delete;
public:
  explicit inline ObjectOrString()
    : mType(eUninitialized)
  {
  }

  inline ~ObjectOrString()
  {
    Uninit();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(cx, obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (object or DOMString)");
      return false;
    }
    return true;
  }

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JS::Rooted<JSObject*>&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject*
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eObject: {
        DestroyObject();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    mValue.mObject.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};

class ObjectOrStringOrBoolean
{
  enum TypeOrUninit
  {
    eUninitialized,
    eObject,
    eString,
    eBoolean
  };
public:
  enum class Type
  {
    eObject = TypeOrUninit::eObject,
    eString = TypeOrUninit::eString,
    eBoolean = TypeOrUninit::eBoolean
  };

private:
  union Value
  {
    UnionMember<JS::Rooted<JSObject*> > mObject;
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<bool > mBoolean;

  };

  TypeOrUninit mType;
  Value mValue;

  ObjectOrStringOrBoolean(const ObjectOrStringOrBoolean&) = delete;
  ObjectOrStringOrBoolean& operator=(const ObjectOrStringOrBoolean&) = delete;
public:
  explicit inline ObjectOrStringOrBoolean()
    : mType(eUninitialized)
  {
  }

  inline ~ObjectOrStringOrBoolean()
  {
    Uninit();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(cx, obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (object or DOMString or boolean)");
      return false;
    }
    return true;
  }

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JS::Rooted<JSObject*>&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject*
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline bool&
  RawSetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool&
  SetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eObject: {
        DestroyObject();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eBoolean: {
        DestroyBoolean();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    mValue.mObject.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    mValue.mBoolean.Destroy();
    mType = eUninitialized;
  }
};

class ObjectOrStringOrLong
{
  enum TypeOrUninit
  {
    eUninitialized,
    eObject,
    eString,
    eLong
  };
public:
  enum class Type
  {
    eObject = TypeOrUninit::eObject,
    eString = TypeOrUninit::eString,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<JS::Rooted<JSObject*> > mObject;
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  ObjectOrStringOrLong(const ObjectOrStringOrLong&) = delete;
  ObjectOrStringOrLong& operator=(const ObjectOrStringOrLong&) = delete;
public:
  explicit inline ObjectOrStringOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~ObjectOrStringOrLong()
  {
    Uninit();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(cx, obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (object or DOMString or long)");
      return false;
    }
    return true;
  }

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JS::Rooted<JSObject*>&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject*
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eObject: {
        DestroyObject();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    mValue.mObject.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class ObjectOrStringOrLongOrBoolean
{
  enum TypeOrUninit
  {
    eUninitialized,
    eObject,
    eString,
    eLong,
    eBoolean
  };
public:
  enum class Type
  {
    eObject = TypeOrUninit::eObject,
    eString = TypeOrUninit::eString,
    eLong = TypeOrUninit::eLong,
    eBoolean = TypeOrUninit::eBoolean
  };

private:
  union Value
  {
    UnionMember<JS::Rooted<JSObject*> > mObject;
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<int32_t > mLong;
    UnionMember<bool > mBoolean;

  };

  TypeOrUninit mType;
  Value mValue;

  ObjectOrStringOrLongOrBoolean(const ObjectOrStringOrLongOrBoolean&) = delete;
  ObjectOrStringOrLongOrBoolean& operator=(const ObjectOrStringOrLongOrBoolean&) = delete;
public:
  explicit inline ObjectOrStringOrLongOrBoolean()
    : mType(eUninitialized)
  {
  }

  inline ~ObjectOrStringOrLongOrBoolean()
  {
    Uninit();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(cx, obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (object or DOMString or long or boolean)");
      return false;
    }
    return true;
  }

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JS::Rooted<JSObject*>&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject*
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline bool&
  RawSetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool&
  SetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eObject: {
        DestroyObject();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
      case eBoolean: {
        DestroyBoolean();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    mValue.mObject.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    mValue.mBoolean.Destroy();
    mType = eUninitialized;
  }
};

class ObjectSequenceOrLong
{
  enum TypeOrUninit
  {
    eUninitialized,
    eObjectSequence,
    eLong
  };
public:
  enum class Type
  {
    eObjectSequence = TypeOrUninit::eObjectSequence,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<binding_detail::RootedAutoSequence<JSObject*> > mObjectSequence;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  ObjectSequenceOrLong(const ObjectSequenceOrLong&) = delete;
  ObjectSequenceOrLong& operator=(const ObjectSequenceOrLong&) = delete;
public:
  explicit inline ObjectSequenceOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~ObjectSequenceOrLong()
  {
    Uninit();
  }

  inline binding_detail::RootedAutoSequence<JSObject*>&
  RawSetAsObjectSequence(JSContext* cx)
  {
    if (mType == eObjectSequence) {
      return mValue.mObjectSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eObjectSequence;
    return mValue.mObjectSequence.SetValue(cx);
  }

  inline binding_detail::RootedAutoSequence<JSObject*>&
  SetAsObjectSequence(JSContext* cx)
  {
    if (mType == eObjectSequence) {
      return mValue.mObjectSequence.Value();
    }
    Uninit();
    mType = eObjectSequence;
    return mValue.mObjectSequence.SetValue(cx);
  }

  inline bool
  IsObjectSequence() const
  {
    return mType == eObjectSequence;
  }

  inline binding_detail::RootedAutoSequence<JSObject*>&
  GetAsObjectSequence()
  {
    MOZ_RELEASE_ASSERT(IsObjectSequence(), "Wrong type!");
    return mValue.mObjectSequence.Value();
  }

  inline const Sequence<JSObject*>&
  GetAsObjectSequence() const
  {
    MOZ_RELEASE_ASSERT(IsObjectSequence(), "Wrong type!");
    return mValue.mObjectSequence.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eObjectSequence: {
        DestroyObjectSequence();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToObjectSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToObjectSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyObjectSequence()
  {
    MOZ_RELEASE_ASSERT(IsObjectSequence(), "Wrong type!");
    mValue.mObjectSequence.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class StringLongRecordOrLong
{
  enum TypeOrUninit
  {
    eUninitialized,
    eStringLongRecord,
    eLong
  };
public:
  enum class Type
  {
    eStringLongRecord = TypeOrUninit::eStringLongRecord,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<Record<nsString, int32_t> > mStringLongRecord;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  StringLongRecordOrLong(const StringLongRecordOrLong&) = delete;
  StringLongRecordOrLong& operator=(const StringLongRecordOrLong&) = delete;
public:
  explicit inline StringLongRecordOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~StringLongRecordOrLong()
  {
    Uninit();
  }

  inline Record<nsString, int32_t>&
  RawSetAsStringLongRecord()
  {
    if (mType == eStringLongRecord) {
      return mValue.mStringLongRecord.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eStringLongRecord;
    return mValue.mStringLongRecord.SetValue();
  }

  inline Record<nsString, int32_t>&
  SetAsStringLongRecord()
  {
    if (mType == eStringLongRecord) {
      return mValue.mStringLongRecord.Value();
    }
    Uninit();
    mType = eStringLongRecord;
    return mValue.mStringLongRecord.SetValue();
  }

  inline bool
  IsStringLongRecord() const
  {
    return mType == eStringLongRecord;
  }

  inline Record<nsString, int32_t>&
  GetAsStringLongRecord()
  {
    MOZ_RELEASE_ASSERT(IsStringLongRecord(), "Wrong type!");
    return mValue.mStringLongRecord.Value();
  }

  inline const Record<nsString, int32_t>&
  GetAsStringLongRecord() const
  {
    MOZ_RELEASE_ASSERT(IsStringLongRecord(), "Wrong type!");
    return mValue.mStringLongRecord.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eStringLongRecord: {
        DestroyStringLongRecord();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToStringLongRecord(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringLongRecord(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyStringLongRecord()
  {
    MOZ_RELEASE_ASSERT(IsStringLongRecord(), "Wrong type!");
    mValue.mStringLongRecord.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class StringObjectRecordOrLong
{
  enum TypeOrUninit
  {
    eUninitialized,
    eStringObjectRecord,
    eLong
  };
public:
  enum class Type
  {
    eStringObjectRecord = TypeOrUninit::eStringObjectRecord,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<RootedRecord<nsString, JSObject*> > mStringObjectRecord;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  StringObjectRecordOrLong(const StringObjectRecordOrLong&) = delete;
  StringObjectRecordOrLong& operator=(const StringObjectRecordOrLong&) = delete;
public:
  explicit inline StringObjectRecordOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~StringObjectRecordOrLong()
  {
    Uninit();
  }

  inline RootedRecord<nsString, JSObject*>&
  RawSetAsStringObjectRecord(JSContext* cx)
  {
    if (mType == eStringObjectRecord) {
      return mValue.mStringObjectRecord.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eStringObjectRecord;
    return mValue.mStringObjectRecord.SetValue(cx);
  }

  inline RootedRecord<nsString, JSObject*>&
  SetAsStringObjectRecord(JSContext* cx)
  {
    if (mType == eStringObjectRecord) {
      return mValue.mStringObjectRecord.Value();
    }
    Uninit();
    mType = eStringObjectRecord;
    return mValue.mStringObjectRecord.SetValue(cx);
  }

  inline bool
  IsStringObjectRecord() const
  {
    return mType == eStringObjectRecord;
  }

  inline RootedRecord<nsString, JSObject*>&
  GetAsStringObjectRecord()
  {
    MOZ_RELEASE_ASSERT(IsStringObjectRecord(), "Wrong type!");
    return mValue.mStringObjectRecord.Value();
  }

  inline const Record<nsString, JSObject*>&
  GetAsStringObjectRecord() const
  {
    MOZ_RELEASE_ASSERT(IsStringObjectRecord(), "Wrong type!");
    return mValue.mStringObjectRecord.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eStringObjectRecord: {
        DestroyStringObjectRecord();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToStringObjectRecord(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringObjectRecord(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyStringObjectRecord()
  {
    MOZ_RELEASE_ASSERT(IsStringObjectRecord(), "Wrong type!");
    mValue.mStringObjectRecord.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class StringOrArrayBuffer
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<RootedSpiderMonkeyInterface<ArrayBuffer> > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrArrayBuffer(const StringOrArrayBuffer&) = delete;
  StringOrArrayBuffer& operator=(const StringOrArrayBuffer&) = delete;
public:
  explicit inline StringOrArrayBuffer()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrArrayBuffer()
  {
    Uninit();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  RawSetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  SetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    Uninit();
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eArrayBuffer: {
        DestroyArrayBuffer();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    mValue.mArrayBuffer.Destroy();
    mType = eUninitialized;
  }
};

class StringOrBooleanOrObject
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eBoolean,
    eObject
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eBoolean = TypeOrUninit::eBoolean,
    eObject = TypeOrUninit::eObject
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<bool > mBoolean;
    UnionMember<JS::Rooted<JSObject*> > mObject;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrBooleanOrObject(const StringOrBooleanOrObject&) = delete;
  StringOrBooleanOrObject& operator=(const StringOrBooleanOrObject&) = delete;
public:
  explicit inline StringOrBooleanOrObject()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrBooleanOrObject()
  {
    Uninit();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline bool&
  RawSetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool&
  SetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(cx, obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (DOMString or boolean or object)");
      return false;
    }
    return true;
  }

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JS::Rooted<JSObject*>&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject*
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eBoolean: {
        DestroyBoolean();
        break;
      }
      case eObject: {
        DestroyObject();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    mValue.mBoolean.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    mValue.mObject.Destroy();
    mType = eUninitialized;
  }
};

class StringOrLong
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eLong
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrLong(const StringOrLong&) = delete;
  StringOrLong& operator=(const StringOrLong&) = delete;
public:
  explicit inline StringOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrLong()
  {
    Uninit();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class StringOrMaybeSharedArrayBuffer
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<RootedSpiderMonkeyInterface<ArrayBuffer> > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrMaybeSharedArrayBuffer(const StringOrMaybeSharedArrayBuffer&) = delete;
  StringOrMaybeSharedArrayBuffer& operator=(const StringOrMaybeSharedArrayBuffer&) = delete;
public:
  explicit inline StringOrMaybeSharedArrayBuffer()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrMaybeSharedArrayBuffer()
  {
    Uninit();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  RawSetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  SetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    Uninit();
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eArrayBuffer: {
        DestroyArrayBuffer();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    mValue.mArrayBuffer.Destroy();
    mType = eUninitialized;
  }
};

class StringOrObject
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eObject
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eObject = TypeOrUninit::eObject
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<JS::Rooted<JSObject*> > mObject;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrObject(const StringOrObject&) = delete;
  StringOrObject& operator=(const StringOrObject&) = delete;
public:
  explicit inline StringOrObject()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrObject()
  {
    Uninit();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(cx, obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (DOMString or object)");
      return false;
    }
    return true;
  }

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JS::Rooted<JSObject*>&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject*
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eObject: {
        DestroyObject();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    mValue.mObject.Destroy();
    mType = eUninitialized;
  }
};

class StringOrStringSequence
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eStringSequence
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eStringSequence = TypeOrUninit::eStringSequence
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<binding_detail::AutoSequence<nsString> > mStringSequence;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrStringSequence(const StringOrStringSequence&) = delete;
  StringOrStringSequence& operator=(const StringOrStringSequence&) = delete;
public:
  explicit inline StringOrStringSequence()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrStringSequence()
  {
    Uninit();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline binding_detail::AutoSequence<nsString>&
  RawSetAsStringSequence()
  {
    if (mType == eStringSequence) {
      return mValue.mStringSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eStringSequence;
    return mValue.mStringSequence.SetValue();
  }

  inline binding_detail::AutoSequence<nsString>&
  SetAsStringSequence()
  {
    if (mType == eStringSequence) {
      return mValue.mStringSequence.Value();
    }
    Uninit();
    mType = eStringSequence;
    return mValue.mStringSequence.SetValue();
  }

  inline bool
  IsStringSequence() const
  {
    return mType == eStringSequence;
  }

  inline binding_detail::AutoSequence<nsString>&
  GetAsStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline const Sequence<nsString>&
  GetAsStringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eStringSequence: {
        DestroyStringSequence();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToStringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    mValue.mStringSequence.Destroy();
    mType = eUninitialized;
  }
};

class StringSequenceOrEventInit
{
  enum TypeOrUninit
  {
    eUninitialized,
    eStringSequence,
    eEventInit
  };
public:
  enum class Type
  {
    eStringSequence = TypeOrUninit::eStringSequence,
    eEventInit = TypeOrUninit::eEventInit
  };

private:
  union Value
  {
    UnionMember<binding_detail::AutoSequence<nsString> > mStringSequence;
    UnionMember<binding_detail::FastEventInit > mEventInit;

  };

  TypeOrUninit mType;
  Value mValue;

  StringSequenceOrEventInit(const StringSequenceOrEventInit&) = delete;
  StringSequenceOrEventInit& operator=(const StringSequenceOrEventInit&) = delete;
public:
  explicit inline StringSequenceOrEventInit()
    : mType(eUninitialized)
  {
  }

  inline ~StringSequenceOrEventInit()
  {
    Uninit();
  }

  inline binding_detail::AutoSequence<nsString>&
  RawSetAsStringSequence()
  {
    if (mType == eStringSequence) {
      return mValue.mStringSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eStringSequence;
    return mValue.mStringSequence.SetValue();
  }

  inline binding_detail::AutoSequence<nsString>&
  SetAsStringSequence()
  {
    if (mType == eStringSequence) {
      return mValue.mStringSequence.Value();
    }
    Uninit();
    mType = eStringSequence;
    return mValue.mStringSequence.SetValue();
  }

  inline bool
  IsStringSequence() const
  {
    return mType == eStringSequence;
  }

  inline binding_detail::AutoSequence<nsString>&
  GetAsStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline const Sequence<nsString>&
  GetAsStringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline binding_detail::FastEventInit&
  RawSetAsEventInit()
  {
    if (mType == eEventInit) {
      return mValue.mEventInit.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eEventInit;
    return mValue.mEventInit.SetValue();
  }

  inline binding_detail::FastEventInit&
  SetAsEventInit()
  {
    if (mType == eEventInit) {
      return mValue.mEventInit.Value();
    }
    Uninit();
    mType = eEventInit;
    return mValue.mEventInit.SetValue();
  }

  inline bool
  IsEventInit() const
  {
    return mType == eEventInit;
  }

  inline binding_detail::FastEventInit&
  GetAsEventInit()
  {
    MOZ_RELEASE_ASSERT(IsEventInit(), "Wrong type!");
    return mValue.mEventInit.Value();
  }

  inline const EventInit&
  GetAsEventInit() const
  {
    MOZ_RELEASE_ASSERT(IsEventInit(), "Wrong type!");
    return mValue.mEventInit.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eStringSequence: {
        DestroyStringSequence();
        break;
      }
      case eEventInit: {
        DestroyEventInit();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToStringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    mValue.mStringSequence.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToEventInit(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToEventInit(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyEventInit()
  {
    MOZ_RELEASE_ASSERT(IsEventInit(), "Wrong type!");
    mValue.mEventInit.Destroy();
    mType = eUninitialized;
  }
};

class StringSequenceOrStringStringRecord
{
  enum TypeOrUninit
  {
    eUninitialized,
    eStringSequence,
    eStringStringRecord
  };
public:
  enum class Type
  {
    eStringSequence = TypeOrUninit::eStringSequence,
    eStringStringRecord = TypeOrUninit::eStringStringRecord
  };

private:
  union Value
  {
    UnionMember<binding_detail::AutoSequence<nsString> > mStringSequence;
    UnionMember<Record<nsString, nsString> > mStringStringRecord;

  };

  TypeOrUninit mType;
  Value mValue;

  StringSequenceOrStringStringRecord(const StringSequenceOrStringStringRecord&) = delete;
  StringSequenceOrStringStringRecord& operator=(const StringSequenceOrStringStringRecord&) = delete;
public:
  explicit inline StringSequenceOrStringStringRecord()
    : mType(eUninitialized)
  {
  }

  inline ~StringSequenceOrStringStringRecord()
  {
    Uninit();
  }

  inline binding_detail::AutoSequence<nsString>&
  RawSetAsStringSequence()
  {
    if (mType == eStringSequence) {
      return mValue.mStringSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eStringSequence;
    return mValue.mStringSequence.SetValue();
  }

  inline binding_detail::AutoSequence<nsString>&
  SetAsStringSequence()
  {
    if (mType == eStringSequence) {
      return mValue.mStringSequence.Value();
    }
    Uninit();
    mType = eStringSequence;
    return mValue.mStringSequence.SetValue();
  }

  inline bool
  IsStringSequence() const
  {
    return mType == eStringSequence;
  }

  inline binding_detail::AutoSequence<nsString>&
  GetAsStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline const Sequence<nsString>&
  GetAsStringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline Record<nsString, nsString>&
  RawSetAsStringStringRecord()
  {
    if (mType == eStringStringRecord) {
      return mValue.mStringStringRecord.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eStringStringRecord;
    return mValue.mStringStringRecord.SetValue();
  }

  inline Record<nsString, nsString>&
  SetAsStringStringRecord()
  {
    if (mType == eStringStringRecord) {
      return mValue.mStringStringRecord.Value();
    }
    Uninit();
    mType = eStringStringRecord;
    return mValue.mStringStringRecord.SetValue();
  }

  inline bool
  IsStringStringRecord() const
  {
    return mType == eStringStringRecord;
  }

  inline Record<nsString, nsString>&
  GetAsStringStringRecord()
  {
    MOZ_RELEASE_ASSERT(IsStringStringRecord(), "Wrong type!");
    return mValue.mStringStringRecord.Value();
  }

  inline const Record<nsString, nsString>&
  GetAsStringStringRecord() const
  {
    MOZ_RELEASE_ASSERT(IsStringStringRecord(), "Wrong type!");
    return mValue.mStringStringRecord.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eStringSequence: {
        DestroyStringSequence();
        break;
      }
      case eStringStringRecord: {
        DestroyStringStringRecord();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToStringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    mValue.mStringSequence.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToStringStringRecord(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringStringRecord(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyStringStringRecord()
  {
    MOZ_RELEASE_ASSERT(IsStringStringRecord(), "Wrong type!");
    mValue.mStringStringRecord.Destroy();
    mType = eUninitialized;
  }
};

class StringStringRecordOrString
{
  enum TypeOrUninit
  {
    eUninitialized,
    eStringStringRecord,
    eString
  };
public:
  enum class Type
  {
    eStringStringRecord = TypeOrUninit::eStringStringRecord,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<Record<nsString, nsString> > mStringStringRecord;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  StringStringRecordOrString(const StringStringRecordOrString&) = delete;
  StringStringRecordOrString& operator=(const StringStringRecordOrString&) = delete;
public:
  explicit inline StringStringRecordOrString()
    : mType(eUninitialized)
  {
  }

  inline ~StringStringRecordOrString()
  {
    Uninit();
  }

  inline Record<nsString, nsString>&
  RawSetAsStringStringRecord()
  {
    if (mType == eStringStringRecord) {
      return mValue.mStringStringRecord.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eStringStringRecord;
    return mValue.mStringStringRecord.SetValue();
  }

  inline Record<nsString, nsString>&
  SetAsStringStringRecord()
  {
    if (mType == eStringStringRecord) {
      return mValue.mStringStringRecord.Value();
    }
    Uninit();
    mType = eStringStringRecord;
    return mValue.mStringStringRecord.SetValue();
  }

  inline bool
  IsStringStringRecord() const
  {
    return mType == eStringStringRecord;
  }

  inline Record<nsString, nsString>&
  GetAsStringStringRecord()
  {
    MOZ_RELEASE_ASSERT(IsStringStringRecord(), "Wrong type!");
    return mValue.mStringStringRecord.Value();
  }

  inline const Record<nsString, nsString>&
  GetAsStringStringRecord() const
  {
    MOZ_RELEASE_ASSERT(IsStringStringRecord(), "Wrong type!");
    return mValue.mStringStringRecord.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eStringStringRecord: {
        DestroyStringStringRecord();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToStringStringRecord(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringStringRecord(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyStringStringRecord()
  {
    MOZ_RELEASE_ASSERT(IsStringStringRecord(), "Wrong type!");
    mValue.mStringStringRecord.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};

class StringStringRecordOrStringSequence
{
  enum TypeOrUninit
  {
    eUninitialized,
    eStringStringRecord,
    eStringSequence
  };
public:
  enum class Type
  {
    eStringStringRecord = TypeOrUninit::eStringStringRecord,
    eStringSequence = TypeOrUninit::eStringSequence
  };

private:
  union Value
  {
    UnionMember<Record<nsString, nsString> > mStringStringRecord;
    UnionMember<binding_detail::AutoSequence<nsString> > mStringSequence;

  };

  TypeOrUninit mType;
  Value mValue;

  StringStringRecordOrStringSequence(const StringStringRecordOrStringSequence&) = delete;
  StringStringRecordOrStringSequence& operator=(const StringStringRecordOrStringSequence&) = delete;
public:
  explicit inline StringStringRecordOrStringSequence()
    : mType(eUninitialized)
  {
  }

  inline ~StringStringRecordOrStringSequence()
  {
    Uninit();
  }

  inline Record<nsString, nsString>&
  RawSetAsStringStringRecord()
  {
    if (mType == eStringStringRecord) {
      return mValue.mStringStringRecord.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eStringStringRecord;
    return mValue.mStringStringRecord.SetValue();
  }

  inline Record<nsString, nsString>&
  SetAsStringStringRecord()
  {
    if (mType == eStringStringRecord) {
      return mValue.mStringStringRecord.Value();
    }
    Uninit();
    mType = eStringStringRecord;
    return mValue.mStringStringRecord.SetValue();
  }

  inline bool
  IsStringStringRecord() const
  {
    return mType == eStringStringRecord;
  }

  inline Record<nsString, nsString>&
  GetAsStringStringRecord()
  {
    MOZ_RELEASE_ASSERT(IsStringStringRecord(), "Wrong type!");
    return mValue.mStringStringRecord.Value();
  }

  inline const Record<nsString, nsString>&
  GetAsStringStringRecord() const
  {
    MOZ_RELEASE_ASSERT(IsStringStringRecord(), "Wrong type!");
    return mValue.mStringStringRecord.Value();
  }

  inline binding_detail::AutoSequence<nsString>&
  RawSetAsStringSequence()
  {
    if (mType == eStringSequence) {
      return mValue.mStringSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eStringSequence;
    return mValue.mStringSequence.SetValue();
  }

  inline binding_detail::AutoSequence<nsString>&
  SetAsStringSequence()
  {
    if (mType == eStringSequence) {
      return mValue.mStringSequence.Value();
    }
    Uninit();
    mType = eStringSequence;
    return mValue.mStringSequence.SetValue();
  }

  inline bool
  IsStringSequence() const
  {
    return mType == eStringSequence;
  }

  inline binding_detail::AutoSequence<nsString>&
  GetAsStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline const Sequence<nsString>&
  GetAsStringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eStringStringRecord: {
        DestroyStringStringRecord();
        break;
      }
      case eStringSequence: {
        DestroyStringSequence();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToStringStringRecord(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringStringRecord(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyStringStringRecord()
  {
    MOZ_RELEASE_ASSERT(IsStringStringRecord(), "Wrong type!");
    mValue.mStringStringRecord.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToStringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    mValue.mStringSequence.Destroy();
    mType = eUninitialized;
  }
};

class SupportedTypeOrObject
{
  enum TypeOrUninit
  {
    eUninitialized,
    eSupportedType,
    eObject
  };
public:
  enum class Type
  {
    eSupportedType = TypeOrUninit::eSupportedType,
    eObject = TypeOrUninit::eObject
  };

private:
  union Value
  {
    UnionMember<SupportedType > mSupportedType;
    UnionMember<JS::Rooted<JSObject*> > mObject;

  };

  TypeOrUninit mType;
  Value mValue;

  SupportedTypeOrObject(const SupportedTypeOrObject&) = delete;
  SupportedTypeOrObject& operator=(const SupportedTypeOrObject&) = delete;
public:
  explicit inline SupportedTypeOrObject()
    : mType(eUninitialized)
  {
  }

  inline ~SupportedTypeOrObject()
  {
    Uninit();
  }

  inline SupportedType&
  RawSetAsSupportedType()
  {
    if (mType == eSupportedType) {
      return mValue.mSupportedType.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eSupportedType;
    return mValue.mSupportedType.SetValue();
  }

  inline SupportedType&
  SetAsSupportedType()
  {
    if (mType == eSupportedType) {
      return mValue.mSupportedType.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eSupportedType;
    return mValue.mSupportedType.SetValue();
  }

  inline bool
  IsSupportedType() const
  {
    return mType == eSupportedType;
  }

  inline SupportedType&
  GetAsSupportedType()
  {
    MOZ_RELEASE_ASSERT(IsSupportedType(), "Wrong type!");
    return mValue.mSupportedType.Value();
  }

  inline SupportedType
  GetAsSupportedType() const
  {
    MOZ_RELEASE_ASSERT(IsSupportedType(), "Wrong type!");
    return mValue.mSupportedType.Value();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(cx, obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (SupportedType or object)");
      return false;
    }
    return true;
  }

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JS::Rooted<JSObject*>&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject*
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eSupportedType: {
        DestroySupportedType();
        break;
      }
      case eObject: {
        DestroyObject();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToSupportedType(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSupportedType(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroySupportedType()
  {
    MOZ_RELEASE_ASSERT(IsSupportedType(), "Wrong type!");
    mValue.mSupportedType.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    mValue.mObject.Destroy();
    mType = eUninitialized;
  }
};

class USVStringOrLong
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUSVString,
    eLong
  };
public:
  enum class Type
  {
    eUSVString = TypeOrUninit::eUSVString,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mUSVString;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  USVStringOrLong(const USVStringOrLong&) = delete;
  USVStringOrLong& operator=(const USVStringOrLong&) = delete;
public:
  explicit inline USVStringOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~USVStringOrLong()
  {
    Uninit();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsUSVString()
  {
    if (mType == eUSVString) {
      return mValue.mUSVString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUSVString;
    return mValue.mUSVString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsUSVString()
  {
    if (mType == eUSVString) {
      return mValue.mUSVString.Value();
    }
    Uninit();
    mType = eUSVString;
    return mValue.mUSVString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsUSVString().AssignLiteral(aData);
  }

  inline bool
  IsUSVString() const
  {
    return mType == eUSVString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline const nsAString&
  GetAsUSVString() const
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUSVString: {
        DestroyUSVString();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToUSVString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    mValue.mUSVString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class UTF8StringOrLong
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eLong
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char> > mUTF8String;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  UTF8StringOrLong(const UTF8StringOrLong&) = delete;
  UTF8StringOrLong& operator=(const UTF8StringOrLong&) = delete;
public:
  explicit inline UTF8StringOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~UTF8StringOrLong()
  {
    Uninit();
  }

  inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class UTF8StringOrUTF8StringSequence
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eUTF8StringSequence
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eUTF8StringSequence = TypeOrUninit::eUTF8StringSequence
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char> > mUTF8String;
    UnionMember<binding_detail::AutoSequence<nsCString> > mUTF8StringSequence;

  };

  TypeOrUninit mType;
  Value mValue;

  UTF8StringOrUTF8StringSequence(const UTF8StringOrUTF8StringSequence&) = delete;
  UTF8StringOrUTF8StringSequence& operator=(const UTF8StringOrUTF8StringSequence&) = delete;
public:
  explicit inline UTF8StringOrUTF8StringSequence()
    : mType(eUninitialized)
  {
  }

  inline ~UTF8StringOrUTF8StringSequence()
  {
    Uninit();
  }

  inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline binding_detail::AutoSequence<nsCString>&
  RawSetAsUTF8StringSequence()
  {
    if (mType == eUTF8StringSequence) {
      return mValue.mUTF8StringSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8StringSequence;
    return mValue.mUTF8StringSequence.SetValue();
  }

  inline binding_detail::AutoSequence<nsCString>&
  SetAsUTF8StringSequence()
  {
    if (mType == eUTF8StringSequence) {
      return mValue.mUTF8StringSequence.Value();
    }
    Uninit();
    mType = eUTF8StringSequence;
    return mValue.mUTF8StringSequence.SetValue();
  }

  inline bool
  IsUTF8StringSequence() const
  {
    return mType == eUTF8StringSequence;
  }

  inline binding_detail::AutoSequence<nsCString>&
  GetAsUTF8StringSequence()
  {
    MOZ_RELEASE_ASSERT(IsUTF8StringSequence(), "Wrong type!");
    return mValue.mUTF8StringSequence.Value();
  }

  inline const Sequence<nsCString>&
  GetAsUTF8StringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8StringSequence(), "Wrong type!");
    return mValue.mUTF8StringSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
      case eUTF8StringSequence: {
        DestroyUTF8StringSequence();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUTF8StringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToUTF8StringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8StringSequence()
  {
    MOZ_RELEASE_ASSERT(IsUTF8StringSequence(), "Wrong type!");
    mValue.mUTF8StringSequence.Destroy();
    mType = eUninitialized;
  }
};

class UndefinedOrCanvasPattern
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUndefined,
    eCanvasPattern
  };
public:
  enum class Type
  {
    eUndefined = TypeOrUninit::eUndefined,
    eCanvasPattern = TypeOrUninit::eCanvasPattern
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::CanvasPattern> > mCanvasPattern;

  };

  TypeOrUninit mType;
  Value mValue;

  UndefinedOrCanvasPattern(const UndefinedOrCanvasPattern&) = delete;
  UndefinedOrCanvasPattern& operator=(const UndefinedOrCanvasPattern&) = delete;
public:
  explicit inline UndefinedOrCanvasPattern()
    : mType(eUninitialized)
  {
  }

  inline ~UndefinedOrCanvasPattern()
  {
    Uninit();
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  inline NonNull<mozilla::dom::CanvasPattern>&
  RawSetAsCanvasPattern()
  {
    if (mType == eCanvasPattern) {
      return mValue.mCanvasPattern.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCanvasPattern;
    return mValue.mCanvasPattern.SetValue();
  }

  inline NonNull<mozilla::dom::CanvasPattern>&
  SetAsCanvasPattern()
  {
    if (mType == eCanvasPattern) {
      return mValue.mCanvasPattern.Value();
    }
    Uninit();
    mType = eCanvasPattern;
    return mValue.mCanvasPattern.SetValue();
  }

  inline bool
  IsCanvasPattern() const
  {
    return mType == eCanvasPattern;
  }

  inline NonNull<mozilla::dom::CanvasPattern>&
  GetAsCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline mozilla::dom::CanvasPattern&
  GetAsCanvasPattern() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUndefined: {
        break;
      }
      case eCanvasPattern: {
        DestroyCanvasPattern();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToCanvasPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    mValue.mCanvasPattern.Destroy();
    mType = eUninitialized;
  }
};

class UndefinedOrCanvasPatternOrNull
{
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eUndefined,
    eCanvasPattern
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eUndefined = TypeOrUninit::eUndefined,
    eCanvasPattern = TypeOrUninit::eCanvasPattern
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::CanvasPattern> > mCanvasPattern;

  };

  TypeOrUninit mType;
  Value mValue;

  UndefinedOrCanvasPatternOrNull(const UndefinedOrCanvasPatternOrNull&) = delete;
  UndefinedOrCanvasPatternOrNull& operator=(const UndefinedOrCanvasPatternOrNull&) = delete;
public:
  explicit inline UndefinedOrCanvasPatternOrNull()
    : mType(eUninitialized)
  {
  }

  inline ~UndefinedOrCanvasPatternOrNull()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  inline NonNull<mozilla::dom::CanvasPattern>&
  RawSetAsCanvasPattern()
  {
    if (mType == eCanvasPattern) {
      return mValue.mCanvasPattern.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCanvasPattern;
    return mValue.mCanvasPattern.SetValue();
  }

  inline NonNull<mozilla::dom::CanvasPattern>&
  SetAsCanvasPattern()
  {
    if (mType == eCanvasPattern) {
      return mValue.mCanvasPattern.Value();
    }
    Uninit();
    mType = eCanvasPattern;
    return mValue.mCanvasPattern.SetValue();
  }

  inline bool
  IsCanvasPattern() const
  {
    return mType == eCanvasPattern;
  }

  inline NonNull<mozilla::dom::CanvasPattern>&
  GetAsCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline mozilla::dom::CanvasPattern&
  GetAsCanvasPattern() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eNull: {
        break;
      }
      case eUndefined: {
        break;
      }
      case eCanvasPattern: {
        DestroyCanvasPattern();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToCanvasPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    mValue.mCanvasPattern.Destroy();
    mType = eUninitialized;
  }
};

class UndefinedOrNullOrCanvasPattern
{
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eUndefined,
    eCanvasPattern
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eUndefined = TypeOrUninit::eUndefined,
    eCanvasPattern = TypeOrUninit::eCanvasPattern
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::CanvasPattern> > mCanvasPattern;

  };

  TypeOrUninit mType;
  Value mValue;

  UndefinedOrNullOrCanvasPattern(const UndefinedOrNullOrCanvasPattern&) = delete;
  UndefinedOrNullOrCanvasPattern& operator=(const UndefinedOrNullOrCanvasPattern&) = delete;
public:
  explicit inline UndefinedOrNullOrCanvasPattern()
    : mType(eUninitialized)
  {
  }

  inline ~UndefinedOrNullOrCanvasPattern()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  inline NonNull<mozilla::dom::CanvasPattern>&
  RawSetAsCanvasPattern()
  {
    if (mType == eCanvasPattern) {
      return mValue.mCanvasPattern.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCanvasPattern;
    return mValue.mCanvasPattern.SetValue();
  }

  inline NonNull<mozilla::dom::CanvasPattern>&
  SetAsCanvasPattern()
  {
    if (mType == eCanvasPattern) {
      return mValue.mCanvasPattern.Value();
    }
    Uninit();
    mType = eCanvasPattern;
    return mValue.mCanvasPattern.SetValue();
  }

  inline bool
  IsCanvasPattern() const
  {
    return mType == eCanvasPattern;
  }

  inline NonNull<mozilla::dom::CanvasPattern>&
  GetAsCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline mozilla::dom::CanvasPattern&
  GetAsCanvasPattern() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eNull: {
        break;
      }
      case eUndefined: {
        break;
      }
      case eCanvasPattern: {
        DestroyCanvasPattern();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToCanvasPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    mValue.mCanvasPattern.Destroy();
    mType = eUninitialized;
  }
};

class UnrestrictedDoubleOrString
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUnrestrictedDouble,
    eString
  };
public:
  enum class Type
  {
    eUnrestrictedDouble = TypeOrUninit::eUnrestrictedDouble,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<double > mUnrestrictedDouble;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  UnrestrictedDoubleOrString(const UnrestrictedDoubleOrString&) = delete;
  UnrestrictedDoubleOrString& operator=(const UnrestrictedDoubleOrString&) = delete;
public:
  explicit inline UnrestrictedDoubleOrString()
    : mType(eUninitialized)
  {
  }

  inline ~UnrestrictedDoubleOrString()
  {
    Uninit();
  }

  inline double&
  RawSetAsUnrestrictedDouble()
  {
    if (mType == eUnrestrictedDouble) {
      return mValue.mUnrestrictedDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUnrestrictedDouble;
    return mValue.mUnrestrictedDouble.SetValue();
  }

  inline double&
  SetAsUnrestrictedDouble()
  {
    if (mType == eUnrestrictedDouble) {
      return mValue.mUnrestrictedDouble.Value();
    }
    Uninit();
    mType = eUnrestrictedDouble;
    return mValue.mUnrestrictedDouble.SetValue();
  }

  inline bool
  IsUnrestrictedDouble() const
  {
    return mType == eUnrestrictedDouble;
  }

  inline double&
  GetAsUnrestrictedDouble()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline double
  GetAsUnrestrictedDouble() const
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUnrestrictedDouble: {
        DestroyUnrestrictedDouble();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToUnrestrictedDouble(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUnrestrictedDouble()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    mValue.mUnrestrictedDouble.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};

class UnrestrictedFloatOrString
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUnrestrictedFloat,
    eString
  };
public:
  enum class Type
  {
    eUnrestrictedFloat = TypeOrUninit::eUnrestrictedFloat,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<float > mUnrestrictedFloat;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  UnrestrictedFloatOrString(const UnrestrictedFloatOrString&) = delete;
  UnrestrictedFloatOrString& operator=(const UnrestrictedFloatOrString&) = delete;
public:
  explicit inline UnrestrictedFloatOrString()
    : mType(eUninitialized)
  {
  }

  inline ~UnrestrictedFloatOrString()
  {
    Uninit();
  }

  inline float&
  RawSetAsUnrestrictedFloat()
  {
    if (mType == eUnrestrictedFloat) {
      return mValue.mUnrestrictedFloat.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUnrestrictedFloat;
    return mValue.mUnrestrictedFloat.SetValue();
  }

  inline float&
  SetAsUnrestrictedFloat()
  {
    if (mType == eUnrestrictedFloat) {
      return mValue.mUnrestrictedFloat.Value();
    }
    Uninit();
    mType = eUnrestrictedFloat;
    return mValue.mUnrestrictedFloat.SetValue();
  }

  inline bool
  IsUnrestrictedFloat() const
  {
    return mType == eUnrestrictedFloat;
  }

  inline float&
  GetAsUnrestrictedFloat()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedFloat(), "Wrong type!");
    return mValue.mUnrestrictedFloat.Value();
  }

  inline float
  GetAsUnrestrictedFloat() const
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedFloat(), "Wrong type!");
    return mValue.mUnrestrictedFloat.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUnrestrictedFloat: {
        DestroyUnrestrictedFloat();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToUnrestrictedFloat(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUnrestrictedFloat()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedFloat(), "Wrong type!");
    mValue.mUnrestrictedFloat.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};

class OwningArrayBufferOrLong : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eArrayBuffer,
    eLong
  };
public:
  enum class Type
  {
    eArrayBuffer = TypeOrUninit::eArrayBuffer,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<ArrayBuffer > mArrayBuffer;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningArrayBufferOrLong(const OwningArrayBufferOrLong&) = delete;
  OwningArrayBufferOrLong& operator=(const OwningArrayBufferOrLong&) = delete;
public:
  explicit inline OwningArrayBufferOrLong()
    : mType(eUninitialized)
  {
  }

  OwningArrayBufferOrLong(OwningArrayBufferOrLong&& aOther);

  inline ~OwningArrayBufferOrLong()
  {
    Uninit();
  }

  ArrayBuffer&
  RawSetAsArrayBuffer();

  ArrayBuffer&
  SetAsArrayBuffer();

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline ArrayBuffer&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningArrayBufferOrLong&
  operator=(OwningArrayBufferOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBuffer();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningArrayBufferViewOrArrayBuffer : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eArrayBufferView,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eArrayBufferView = TypeOrUninit::eArrayBufferView,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<ArrayBufferView > mArrayBufferView;
    UnionMember<ArrayBuffer > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningArrayBufferViewOrArrayBuffer(const OwningArrayBufferViewOrArrayBuffer&) = delete;
  OwningArrayBufferViewOrArrayBuffer& operator=(const OwningArrayBufferViewOrArrayBuffer&) = delete;
public:
  explicit inline OwningArrayBufferViewOrArrayBuffer()
    : mType(eUninitialized)
  {
  }

  OwningArrayBufferViewOrArrayBuffer(OwningArrayBufferViewOrArrayBuffer&& aOther);

  inline ~OwningArrayBufferViewOrArrayBuffer()
  {
    Uninit();
  }

  ArrayBufferView&
  RawSetAsArrayBufferView();

  ArrayBufferView&
  SetAsArrayBufferView();

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline ArrayBufferView&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  ArrayBuffer&
  RawSetAsArrayBuffer();

  ArrayBuffer&
  SetAsArrayBuffer();

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline ArrayBuffer&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningArrayBufferViewOrArrayBuffer&
  operator=(OwningArrayBufferViewOrArrayBuffer&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBufferView();

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBuffer();
};

class OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eArrayBufferView,
    eArrayBuffer,
    eBlob,
    eUTF8String
  };
public:
  enum class Type
  {
    eArrayBufferView = TypeOrUninit::eArrayBufferView,
    eArrayBuffer = TypeOrUninit::eArrayBuffer,
    eBlob = TypeOrUninit::eBlob,
    eUTF8String = TypeOrUninit::eUTF8String
  };

private:
  union Value
  {
    UnionMember<ArrayBufferView > mArrayBufferView;
    UnionMember<ArrayBuffer > mArrayBuffer;
    UnionMember<OwningNonNull<mozilla::dom::Blob> > mBlob;
    UnionMember<nsCString > mUTF8String;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String(const OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String&) = delete;
  OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String& operator=(const OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String&) = delete;
public:
  explicit inline OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String()
    : mType(eUninitialized)
  {
  }

  OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String(OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String&& aOther);

  inline ~OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String()
  {
    Uninit();
  }

  ArrayBufferView&
  RawSetAsArrayBufferView();

  ArrayBufferView&
  SetAsArrayBufferView();

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline ArrayBufferView&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  ArrayBuffer&
  RawSetAsArrayBuffer();

  ArrayBuffer&
  SetAsArrayBuffer();

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline ArrayBuffer&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  OwningNonNull<mozilla::dom::Blob>&
  RawSetAsBlob();

  OwningNonNull<mozilla::dom::Blob>&
  SetAsBlob();

  inline bool
  IsBlob() const
  {
    return mType == eBlob;
  }

  inline OwningNonNull<mozilla::dom::Blob>&
  GetAsBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline OwningNonNull<mozilla::dom::Blob> const &
  GetAsBlob() const
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  nsCString&
  RawSetAsUTF8String();

  nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String&
  operator=(OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBufferView();

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBuffer();

  bool
  TrySetToBlob(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToBlob(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyBlob();

  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();
};

class OwningByteStringOrLong : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eByteString,
    eLong
  };
public:
  enum class Type
  {
    eByteString = TypeOrUninit::eByteString,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<nsCString > mByteString;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningByteStringOrLong()
    : mType(eUninitialized)
  {
  }

  OwningByteStringOrLong(OwningByteStringOrLong&& aOther);

  explicit inline OwningByteStringOrLong(const OwningByteStringOrLong& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningByteStringOrLong()
  {
    Uninit();
  }

  nsCString&
  RawSetAsByteString();

  nsCString&
  SetAsByteString();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsByteString().AssignLiteral(aData);
  }

  inline bool
  IsByteString() const
  {
    return mType == eByteString;
  }

  inline nsCString&
  GetAsByteString()
  {
    MOZ_RELEASE_ASSERT(IsByteString(), "Wrong type!");
    return mValue.mByteString.Value();
  }

  inline nsCString const &
  GetAsByteString() const
  {
    MOZ_RELEASE_ASSERT(IsByteString(), "Wrong type!");
    return mValue.mByteString.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningByteStringOrLong&
  operator=(OwningByteStringOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningByteStringOrLong&
  operator=(const OwningByteStringOrLong& aOther);

private:
  bool
  TrySetToByteString(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToByteString(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyByteString();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningCanvasPatternOrCanvasGradient : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningCanvasPatternOrCanvasGradient& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eCanvasPattern,
    eCanvasGradient
  };
public:
  enum class Type
  {
    eCanvasPattern = TypeOrUninit::eCanvasPattern,
    eCanvasGradient = TypeOrUninit::eCanvasGradient
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::CanvasPattern> > mCanvasPattern;
    UnionMember<OwningNonNull<mozilla::dom::CanvasGradient> > mCanvasGradient;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningCanvasPatternOrCanvasGradient()
    : mType(eUninitialized)
  {
  }

  OwningCanvasPatternOrCanvasGradient(OwningCanvasPatternOrCanvasGradient&& aOther);

  explicit inline OwningCanvasPatternOrCanvasGradient(const OwningCanvasPatternOrCanvasGradient& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningCanvasPatternOrCanvasGradient()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::CanvasPattern>&
  RawSetAsCanvasPattern();

  OwningNonNull<mozilla::dom::CanvasPattern>&
  SetAsCanvasPattern();

  inline bool
  IsCanvasPattern() const
  {
    return mType == eCanvasPattern;
  }

  inline OwningNonNull<mozilla::dom::CanvasPattern>&
  GetAsCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline OwningNonNull<mozilla::dom::CanvasPattern> const &
  GetAsCanvasPattern() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  OwningNonNull<mozilla::dom::CanvasGradient>&
  RawSetAsCanvasGradient();

  OwningNonNull<mozilla::dom::CanvasGradient>&
  SetAsCanvasGradient();

  inline bool
  IsCanvasGradient() const
  {
    return mType == eCanvasGradient;
  }

  inline OwningNonNull<mozilla::dom::CanvasGradient>&
  GetAsCanvasGradient()
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    return mValue.mCanvasGradient.Value();
  }

  inline OwningNonNull<mozilla::dom::CanvasGradient> const &
  GetAsCanvasGradient() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    return mValue.mCanvasGradient.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningCanvasPatternOrCanvasGradient&
  operator=(OwningCanvasPatternOrCanvasGradient&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningCanvasPatternOrCanvasGradient&
  operator=(const OwningCanvasPatternOrCanvasGradient& aOther);

private:
  bool
  TrySetToCanvasPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyCanvasPattern();

  bool
  TrySetToCanvasGradient(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasGradient(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyCanvasGradient();
};

class OwningCanvasPatternOrNullOrCanvasGradient : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningCanvasPatternOrNullOrCanvasGradient& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eCanvasPattern,
    eCanvasGradient
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eCanvasPattern = TypeOrUninit::eCanvasPattern,
    eCanvasGradient = TypeOrUninit::eCanvasGradient
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::CanvasPattern> > mCanvasPattern;
    UnionMember<OwningNonNull<mozilla::dom::CanvasGradient> > mCanvasGradient;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningCanvasPatternOrNullOrCanvasGradient()
    : mType(eUninitialized)
  {
  }

  OwningCanvasPatternOrNullOrCanvasGradient(OwningCanvasPatternOrNullOrCanvasGradient&& aOther);

  explicit inline OwningCanvasPatternOrNullOrCanvasGradient(const OwningCanvasPatternOrNullOrCanvasGradient& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningCanvasPatternOrNullOrCanvasGradient()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  OwningNonNull<mozilla::dom::CanvasPattern>&
  RawSetAsCanvasPattern();

  OwningNonNull<mozilla::dom::CanvasPattern>&
  SetAsCanvasPattern();

  inline bool
  IsCanvasPattern() const
  {
    return mType == eCanvasPattern;
  }

  inline OwningNonNull<mozilla::dom::CanvasPattern>&
  GetAsCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline OwningNonNull<mozilla::dom::CanvasPattern> const &
  GetAsCanvasPattern() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  OwningNonNull<mozilla::dom::CanvasGradient>&
  RawSetAsCanvasGradient();

  OwningNonNull<mozilla::dom::CanvasGradient>&
  SetAsCanvasGradient();

  inline bool
  IsCanvasGradient() const
  {
    return mType == eCanvasGradient;
  }

  inline OwningNonNull<mozilla::dom::CanvasGradient>&
  GetAsCanvasGradient()
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    return mValue.mCanvasGradient.Value();
  }

  inline OwningNonNull<mozilla::dom::CanvasGradient> const &
  GetAsCanvasGradient() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    return mValue.mCanvasGradient.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningCanvasPatternOrNullOrCanvasGradient&
  operator=(OwningCanvasPatternOrNullOrCanvasGradient&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningCanvasPatternOrNullOrCanvasGradient&
  operator=(const OwningCanvasPatternOrNullOrCanvasGradient& aOther);

private:
  bool
  TrySetToCanvasPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyCanvasPattern();

  bool
  TrySetToCanvasGradient(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasGradient(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyCanvasGradient();
};

class OwningCustomEventInitOrLong : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eCustomEventInit,
    eLong
  };
public:
  enum class Type
  {
    eCustomEventInit = TypeOrUninit::eCustomEventInit,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<CustomEventInit > mCustomEventInit;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningCustomEventInitOrLong(const OwningCustomEventInitOrLong&) = delete;
  OwningCustomEventInitOrLong& operator=(const OwningCustomEventInitOrLong&) = delete;
public:
  explicit inline OwningCustomEventInitOrLong()
    : mType(eUninitialized)
  {
  }

  OwningCustomEventInitOrLong(OwningCustomEventInitOrLong&& aOther);

  inline ~OwningCustomEventInitOrLong()
  {
    Uninit();
  }

  CustomEventInit&
  RawSetAsCustomEventInit();

  CustomEventInit&
  SetAsCustomEventInit();

  inline bool
  IsCustomEventInit() const
  {
    return mType == eCustomEventInit;
  }

  inline CustomEventInit&
  GetAsCustomEventInit()
  {
    MOZ_RELEASE_ASSERT(IsCustomEventInit(), "Wrong type!");
    return mValue.mCustomEventInit.Value();
  }

  inline CustomEventInit const &
  GetAsCustomEventInit() const
  {
    MOZ_RELEASE_ASSERT(IsCustomEventInit(), "Wrong type!");
    return mValue.mCustomEventInit.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningCustomEventInitOrLong&
  operator=(OwningCustomEventInitOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToCustomEventInit(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCustomEventInit(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyCustomEventInit();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningDoubleOrByteString : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eByteString
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eByteString = TypeOrUninit::eByteString
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<nsCString > mByteString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningDoubleOrByteString()
    : mType(eUninitialized)
  {
  }

  OwningDoubleOrByteString(OwningDoubleOrByteString&& aOther);

  explicit inline OwningDoubleOrByteString(const OwningDoubleOrByteString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningDoubleOrByteString()
  {
    Uninit();
  }

  double&
  RawSetAsDouble();

  double&
  SetAsDouble();

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double const &
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  nsCString&
  RawSetAsByteString();

  nsCString&
  SetAsByteString();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsByteString().AssignLiteral(aData);
  }

  inline bool
  IsByteString() const
  {
    return mType == eByteString;
  }

  inline nsCString&
  GetAsByteString()
  {
    MOZ_RELEASE_ASSERT(IsByteString(), "Wrong type!");
    return mValue.mByteString.Value();
  }

  inline nsCString const &
  GetAsByteString() const
  {
    MOZ_RELEASE_ASSERT(IsByteString(), "Wrong type!");
    return mValue.mByteString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningDoubleOrByteString&
  operator=(OwningDoubleOrByteString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningDoubleOrByteString&
  operator=(const OwningDoubleOrByteString& aOther);

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDouble();

  bool
  TrySetToByteString(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToByteString(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyByteString();
};

class OwningDoubleOrString : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eString
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningDoubleOrString()
    : mType(eUninitialized)
  {
  }

  OwningDoubleOrString(OwningDoubleOrString&& aOther);

  explicit inline OwningDoubleOrString(const OwningDoubleOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningDoubleOrString()
  {
    Uninit();
  }

  double&
  RawSetAsDouble();

  double&
  SetAsDouble();

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double const &
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningDoubleOrString&
  operator=(OwningDoubleOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningDoubleOrString&
  operator=(const OwningDoubleOrString& aOther);

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDouble();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};

class OwningDoubleOrSupportedType : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eSupportedType
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eSupportedType = TypeOrUninit::eSupportedType
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<SupportedType > mSupportedType;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningDoubleOrSupportedType()
    : mType(eUninitialized)
  {
  }

  OwningDoubleOrSupportedType(OwningDoubleOrSupportedType&& aOther);

  explicit inline OwningDoubleOrSupportedType(const OwningDoubleOrSupportedType& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningDoubleOrSupportedType()
  {
    Uninit();
  }

  double&
  RawSetAsDouble();

  double&
  SetAsDouble();

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double const &
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  SupportedType&
  RawSetAsSupportedType();

  SupportedType&
  SetAsSupportedType();

  inline bool
  IsSupportedType() const
  {
    return mType == eSupportedType;
  }

  inline SupportedType&
  GetAsSupportedType()
  {
    MOZ_RELEASE_ASSERT(IsSupportedType(), "Wrong type!");
    return mValue.mSupportedType.Value();
  }

  inline SupportedType const &
  GetAsSupportedType() const
  {
    MOZ_RELEASE_ASSERT(IsSupportedType(), "Wrong type!");
    return mValue.mSupportedType.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningDoubleOrSupportedType&
  operator=(OwningDoubleOrSupportedType&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningDoubleOrSupportedType&
  operator=(const OwningDoubleOrSupportedType& aOther);

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDouble();

  bool
  TrySetToSupportedType(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSupportedType(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroySupportedType();
};

class OwningDoubleOrUSVString : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eUSVString
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eUSVString = TypeOrUninit::eUSVString
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<nsString > mUSVString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningDoubleOrUSVString()
    : mType(eUninitialized)
  {
  }

  OwningDoubleOrUSVString(OwningDoubleOrUSVString&& aOther);

  explicit inline OwningDoubleOrUSVString(const OwningDoubleOrUSVString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningDoubleOrUSVString()
  {
    Uninit();
  }

  double&
  RawSetAsDouble();

  double&
  SetAsDouble();

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double const &
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  nsString&
  RawSetAsUSVString();

  nsString&
  SetAsUSVString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsUSVString().AssignLiteral(aData);
  }

  inline bool
  IsUSVString() const
  {
    return mType == eUSVString;
  }

  inline nsString&
  GetAsUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline nsString const &
  GetAsUSVString() const
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningDoubleOrUSVString&
  operator=(OwningDoubleOrUSVString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningDoubleOrUSVString&
  operator=(const OwningDoubleOrUSVString& aOther);

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDouble();

  bool
  TrySetToUSVString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUSVString();
};

class OwningDoubleOrUTF8String : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eUTF8String
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eUTF8String = TypeOrUninit::eUTF8String
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<nsCString > mUTF8String;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningDoubleOrUTF8String()
    : mType(eUninitialized)
  {
  }

  OwningDoubleOrUTF8String(OwningDoubleOrUTF8String&& aOther);

  explicit inline OwningDoubleOrUTF8String(const OwningDoubleOrUTF8String& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningDoubleOrUTF8String()
  {
    Uninit();
  }

  double&
  RawSetAsDouble();

  double&
  SetAsDouble();

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double const &
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  nsCString&
  RawSetAsUTF8String();

  nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningDoubleOrUTF8String&
  operator=(OwningDoubleOrUTF8String&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningDoubleOrUTF8String&
  operator=(const OwningDoubleOrUTF8String& aOther);

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDouble();

  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();
};

class OwningEventHandlerNonNullOrNullOrLong : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningEventHandlerNonNullOrNullOrLong& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eEventHandlerNonNull,
    eLong
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eEventHandlerNonNull = TypeOrUninit::eEventHandlerNonNull,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<EventHandlerNonNull> > mEventHandlerNonNull;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningEventHandlerNonNullOrNullOrLong(const OwningEventHandlerNonNullOrNullOrLong&) = delete;
  OwningEventHandlerNonNullOrNullOrLong& operator=(const OwningEventHandlerNonNullOrNullOrLong&) = delete;
public:
  explicit inline OwningEventHandlerNonNullOrNullOrLong()
    : mType(eUninitialized)
  {
  }

  OwningEventHandlerNonNullOrNullOrLong(OwningEventHandlerNonNullOrNullOrLong&& aOther);

  inline ~OwningEventHandlerNonNullOrNullOrLong()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  OwningNonNull<EventHandlerNonNull>&
  RawSetAsEventHandlerNonNull();

  OwningNonNull<EventHandlerNonNull>&
  SetAsEventHandlerNonNull();

  inline bool
  IsEventHandlerNonNull() const
  {
    return mType == eEventHandlerNonNull;
  }

  inline OwningNonNull<EventHandlerNonNull>&
  GetAsEventHandlerNonNull()
  {
    MOZ_RELEASE_ASSERT(IsEventHandlerNonNull(), "Wrong type!");
    return mValue.mEventHandlerNonNull.Value();
  }

  inline OwningNonNull<EventHandlerNonNull> const &
  GetAsEventHandlerNonNull() const
  {
    MOZ_RELEASE_ASSERT(IsEventHandlerNonNull(), "Wrong type!");
    return mValue.mEventHandlerNonNull.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningEventHandlerNonNullOrNullOrLong&
  operator=(OwningEventHandlerNonNullOrNullOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToEventHandlerNonNull(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToEventHandlerNonNull(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyEventHandlerNonNull();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningEventInitOrLong : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eEventInit,
    eLong
  };
public:
  enum class Type
  {
    eEventInit = TypeOrUninit::eEventInit,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<EventInit > mEventInit;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningEventInitOrLong()
    : mType(eUninitialized)
  {
  }

  OwningEventInitOrLong(OwningEventInitOrLong&& aOther);

  explicit inline OwningEventInitOrLong(const OwningEventInitOrLong& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningEventInitOrLong()
  {
    Uninit();
  }

  EventInit&
  RawSetAsEventInit();

  EventInit&
  SetAsEventInit();

  inline bool
  IsEventInit() const
  {
    return mType == eEventInit;
  }

  inline EventInit&
  GetAsEventInit()
  {
    MOZ_RELEASE_ASSERT(IsEventInit(), "Wrong type!");
    return mValue.mEventInit.Value();
  }

  inline EventInit const &
  GetAsEventInit() const
  {
    MOZ_RELEASE_ASSERT(IsEventInit(), "Wrong type!");
    return mValue.mEventInit.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningEventInitOrLong&
  operator=(OwningEventInitOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningEventInitOrLong&
  operator=(const OwningEventInitOrLong& aOther);

private:
  bool
  TrySetToEventInit(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToEventInit(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyEventInit();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningEventInitOrStringSequence : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eEventInit,
    eStringSequence
  };
public:
  enum class Type
  {
    eEventInit = TypeOrUninit::eEventInit,
    eStringSequence = TypeOrUninit::eStringSequence
  };

private:
  union Value
  {
    UnionMember<EventInit > mEventInit;
    UnionMember<Sequence<nsString> > mStringSequence;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningEventInitOrStringSequence()
    : mType(eUninitialized)
  {
  }

  OwningEventInitOrStringSequence(OwningEventInitOrStringSequence&& aOther);

  explicit inline OwningEventInitOrStringSequence(const OwningEventInitOrStringSequence& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningEventInitOrStringSequence()
  {
    Uninit();
  }

  EventInit&
  RawSetAsEventInit();

  EventInit&
  SetAsEventInit();

  inline bool
  IsEventInit() const
  {
    return mType == eEventInit;
  }

  inline EventInit&
  GetAsEventInit()
  {
    MOZ_RELEASE_ASSERT(IsEventInit(), "Wrong type!");
    return mValue.mEventInit.Value();
  }

  inline EventInit const &
  GetAsEventInit() const
  {
    MOZ_RELEASE_ASSERT(IsEventInit(), "Wrong type!");
    return mValue.mEventInit.Value();
  }

  Sequence<nsString>&
  RawSetAsStringSequence();

  Sequence<nsString>&
  SetAsStringSequence();

  inline bool
  IsStringSequence() const
  {
    return mType == eStringSequence;
  }

  inline Sequence<nsString>&
  GetAsStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline Sequence<nsString> const &
  GetAsStringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningEventInitOrStringSequence&
  operator=(OwningEventInitOrStringSequence&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningEventInitOrStringSequence&
  operator=(const OwningEventInitOrStringSequence& aOther);

private:
  bool
  TrySetToEventInit(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToEventInit(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyEventInit();

  bool
  TrySetToStringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyStringSequence();
};

class OwningFileOrDirectory : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningFileOrDirectory& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eFile,
    eDirectory
  };
public:
  enum class Type
  {
    eFile = TypeOrUninit::eFile,
    eDirectory = TypeOrUninit::eDirectory
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::File> > mFile;
    UnionMember<OwningNonNull<mozilla::dom::Directory> > mDirectory;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningFileOrDirectory()
    : mType(eUninitialized)
  {
  }

  OwningFileOrDirectory(OwningFileOrDirectory&& aOther);

  explicit inline OwningFileOrDirectory(const OwningFileOrDirectory& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningFileOrDirectory()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::File>&
  RawSetAsFile();

  OwningNonNull<mozilla::dom::File>&
  SetAsFile();

  inline bool
  IsFile() const
  {
    return mType == eFile;
  }

  inline OwningNonNull<mozilla::dom::File>&
  GetAsFile()
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  inline OwningNonNull<mozilla::dom::File> const &
  GetAsFile() const
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  OwningNonNull<mozilla::dom::Directory>&
  RawSetAsDirectory();

  OwningNonNull<mozilla::dom::Directory>&
  SetAsDirectory();

  inline bool
  IsDirectory() const
  {
    return mType == eDirectory;
  }

  inline OwningNonNull<mozilla::dom::Directory>&
  GetAsDirectory()
  {
    MOZ_RELEASE_ASSERT(IsDirectory(), "Wrong type!");
    return mValue.mDirectory.Value();
  }

  inline OwningNonNull<mozilla::dom::Directory> const &
  GetAsDirectory() const
  {
    MOZ_RELEASE_ASSERT(IsDirectory(), "Wrong type!");
    return mValue.mDirectory.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningFileOrDirectory&
  operator=(OwningFileOrDirectory&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningFileOrDirectory&
  operator=(const OwningFileOrDirectory& aOther);

private:
  bool
  TrySetToFile(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFile(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyFile();

  bool
  TrySetToDirectory(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDirectory(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDirectory();
};

class OwningFloatOrString : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eFloat,
    eString
  };
public:
  enum class Type
  {
    eFloat = TypeOrUninit::eFloat,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<float > mFloat;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningFloatOrString()
    : mType(eUninitialized)
  {
  }

  OwningFloatOrString(OwningFloatOrString&& aOther);

  explicit inline OwningFloatOrString(const OwningFloatOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningFloatOrString()
  {
    Uninit();
  }

  float&
  RawSetAsFloat();

  float&
  SetAsFloat();

  inline bool
  IsFloat() const
  {
    return mType == eFloat;
  }

  inline float&
  GetAsFloat()
  {
    MOZ_RELEASE_ASSERT(IsFloat(), "Wrong type!");
    return mValue.mFloat.Value();
  }

  inline float const &
  GetAsFloat() const
  {
    MOZ_RELEASE_ASSERT(IsFloat(), "Wrong type!");
    return mValue.mFloat.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningFloatOrString&
  operator=(OwningFloatOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningFloatOrString&
  operator=(const OwningFloatOrString& aOther);

private:
  bool
  TrySetToFloat(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFloat(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyFloat();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};

class OwningHTMLCanvasElementOrOffscreenCanvas : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningHTMLCanvasElementOrOffscreenCanvas& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLCanvasElement,
    eOffscreenCanvas
  };
public:
  enum class Type
  {
    eHTMLCanvasElement = TypeOrUninit::eHTMLCanvasElement,
    eOffscreenCanvas = TypeOrUninit::eOffscreenCanvas
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::HTMLCanvasElement> > mHTMLCanvasElement;
    UnionMember<OwningNonNull<mozilla::dom::OffscreenCanvas> > mOffscreenCanvas;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningHTMLCanvasElementOrOffscreenCanvas()
    : mType(eUninitialized)
  {
  }

  OwningHTMLCanvasElementOrOffscreenCanvas(OwningHTMLCanvasElementOrOffscreenCanvas&& aOther);

  explicit inline OwningHTMLCanvasElementOrOffscreenCanvas(const OwningHTMLCanvasElementOrOffscreenCanvas& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningHTMLCanvasElementOrOffscreenCanvas()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  RawSetAsHTMLCanvasElement();

  OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  SetAsHTMLCanvasElement();

  inline bool
  IsHTMLCanvasElement() const
  {
    return mType == eHTMLCanvasElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  GetAsHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLCanvasElement> const &
  GetAsHTMLCanvasElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  OwningNonNull<mozilla::dom::OffscreenCanvas>&
  RawSetAsOffscreenCanvas();

  OwningNonNull<mozilla::dom::OffscreenCanvas>&
  SetAsOffscreenCanvas();

  inline bool
  IsOffscreenCanvas() const
  {
    return mType == eOffscreenCanvas;
  }

  inline OwningNonNull<mozilla::dom::OffscreenCanvas>&
  GetAsOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  inline OwningNonNull<mozilla::dom::OffscreenCanvas> const &
  GetAsOffscreenCanvas() const
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningHTMLCanvasElementOrOffscreenCanvas&
  operator=(OwningHTMLCanvasElementOrOffscreenCanvas&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningHTMLCanvasElementOrOffscreenCanvas&
  operator=(const OwningHTMLCanvasElementOrOffscreenCanvas& aOther);

private:
  bool
  TrySetToHTMLCanvasElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLCanvasElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLCanvasElement();

  bool
  TrySetToOffscreenCanvas(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToOffscreenCanvas(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyOffscreenCanvas();
};

class OwningHTMLElementOrLong : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningHTMLElementOrLong& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLElement,
    eLong
  };
public:
  enum class Type
  {
    eHTMLElement = TypeOrUninit::eHTMLElement,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<nsGenericHTMLElement> > mHTMLElement;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningHTMLElementOrLong()
    : mType(eUninitialized)
  {
  }

  OwningHTMLElementOrLong(OwningHTMLElementOrLong&& aOther);

  explicit inline OwningHTMLElementOrLong(const OwningHTMLElementOrLong& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningHTMLElementOrLong()
  {
    Uninit();
  }

  OwningNonNull<nsGenericHTMLElement>&
  RawSetAsHTMLElement();

  OwningNonNull<nsGenericHTMLElement>&
  SetAsHTMLElement();

  inline bool
  IsHTMLElement() const
  {
    return mType == eHTMLElement;
  }

  inline OwningNonNull<nsGenericHTMLElement>&
  GetAsHTMLElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLElement(), "Wrong type!");
    return mValue.mHTMLElement.Value();
  }

  inline OwningNonNull<nsGenericHTMLElement> const &
  GetAsHTMLElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLElement(), "Wrong type!");
    return mValue.mHTMLElement.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningHTMLElementOrLong&
  operator=(OwningHTMLElementOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningHTMLElementOrLong&
  operator=(const OwningHTMLElementOrLong& aOther);

private:
  bool
  TrySetToHTMLElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLElement();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningHTMLOptionElementOrHTMLOptGroupElement : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningHTMLOptionElementOrHTMLOptGroupElement& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLOptionElement,
    eHTMLOptGroupElement
  };
public:
  enum class Type
  {
    eHTMLOptionElement = TypeOrUninit::eHTMLOptionElement,
    eHTMLOptGroupElement = TypeOrUninit::eHTMLOptGroupElement
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::HTMLOptionElement> > mHTMLOptionElement;
    UnionMember<OwningNonNull<mozilla::dom::HTMLOptGroupElement> > mHTMLOptGroupElement;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningHTMLOptionElementOrHTMLOptGroupElement()
    : mType(eUninitialized)
  {
  }

  OwningHTMLOptionElementOrHTMLOptGroupElement(OwningHTMLOptionElementOrHTMLOptGroupElement&& aOther);

  explicit inline OwningHTMLOptionElementOrHTMLOptGroupElement(const OwningHTMLOptionElementOrHTMLOptGroupElement& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningHTMLOptionElementOrHTMLOptGroupElement()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::HTMLOptionElement>&
  RawSetAsHTMLOptionElement();

  OwningNonNull<mozilla::dom::HTMLOptionElement>&
  SetAsHTMLOptionElement();

  inline bool
  IsHTMLOptionElement() const
  {
    return mType == eHTMLOptionElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLOptionElement>&
  GetAsHTMLOptionElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptionElement(), "Wrong type!");
    return mValue.mHTMLOptionElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLOptionElement> const &
  GetAsHTMLOptionElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptionElement(), "Wrong type!");
    return mValue.mHTMLOptionElement.Value();
  }

  OwningNonNull<mozilla::dom::HTMLOptGroupElement>&
  RawSetAsHTMLOptGroupElement();

  OwningNonNull<mozilla::dom::HTMLOptGroupElement>&
  SetAsHTMLOptGroupElement();

  inline bool
  IsHTMLOptGroupElement() const
  {
    return mType == eHTMLOptGroupElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLOptGroupElement>&
  GetAsHTMLOptGroupElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptGroupElement(), "Wrong type!");
    return mValue.mHTMLOptGroupElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLOptGroupElement> const &
  GetAsHTMLOptGroupElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptGroupElement(), "Wrong type!");
    return mValue.mHTMLOptGroupElement.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningHTMLOptionElementOrHTMLOptGroupElement&
  operator=(OwningHTMLOptionElementOrHTMLOptGroupElement&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningHTMLOptionElementOrHTMLOptGroupElement&
  operator=(const OwningHTMLOptionElementOrHTMLOptGroupElement& aOther);

private:
  bool
  TrySetToHTMLOptionElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLOptionElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLOptionElement();

  bool
  TrySetToHTMLOptGroupElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLOptGroupElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLOptGroupElement();
};

class OwningImageDataOrNullSequenceOrLong : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningImageDataOrNullSequenceOrLong& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eImageDataOrNullSequence,
    eLong
  };
public:
  enum class Type
  {
    eImageDataOrNullSequence = TypeOrUninit::eImageDataOrNullSequence,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<Sequence<RefPtr<mozilla::dom::ImageData>> > mImageDataOrNullSequence;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningImageDataOrNullSequenceOrLong()
    : mType(eUninitialized)
  {
  }

  OwningImageDataOrNullSequenceOrLong(OwningImageDataOrNullSequenceOrLong&& aOther);

  explicit inline OwningImageDataOrNullSequenceOrLong(const OwningImageDataOrNullSequenceOrLong& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningImageDataOrNullSequenceOrLong()
  {
    Uninit();
  }

  Sequence<RefPtr<mozilla::dom::ImageData>>&
  RawSetAsImageDataOrNullSequence();

  Sequence<RefPtr<mozilla::dom::ImageData>>&
  SetAsImageDataOrNullSequence();

  inline bool
  IsImageDataOrNullSequence() const
  {
    return mType == eImageDataOrNullSequence;
  }

  inline Sequence<RefPtr<mozilla::dom::ImageData>>&
  GetAsImageDataOrNullSequence()
  {
    MOZ_RELEASE_ASSERT(IsImageDataOrNullSequence(), "Wrong type!");
    return mValue.mImageDataOrNullSequence.Value();
  }

  inline Sequence<RefPtr<mozilla::dom::ImageData>> const &
  GetAsImageDataOrNullSequence() const
  {
    MOZ_RELEASE_ASSERT(IsImageDataOrNullSequence(), "Wrong type!");
    return mValue.mImageDataOrNullSequence.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningImageDataOrNullSequenceOrLong&
  operator=(OwningImageDataOrNullSequenceOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningImageDataOrNullSequenceOrLong&
  operator=(const OwningImageDataOrNullSequenceOrLong& aOther);

private:
  bool
  TrySetToImageDataOrNullSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageDataOrNullSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyImageDataOrNullSequence();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningImageDataOrNullSequenceSequenceOrLong : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningImageDataOrNullSequenceSequenceOrLong& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eImageDataOrNullSequenceSequence,
    eLong
  };
public:
  enum class Type
  {
    eImageDataOrNullSequenceSequence = TypeOrUninit::eImageDataOrNullSequenceSequence,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<Sequence<Sequence<RefPtr<mozilla::dom::ImageData>>> > mImageDataOrNullSequenceSequence;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningImageDataOrNullSequenceSequenceOrLong()
    : mType(eUninitialized)
  {
  }

  OwningImageDataOrNullSequenceSequenceOrLong(OwningImageDataOrNullSequenceSequenceOrLong&& aOther);

  explicit inline OwningImageDataOrNullSequenceSequenceOrLong(const OwningImageDataOrNullSequenceSequenceOrLong& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningImageDataOrNullSequenceSequenceOrLong()
  {
    Uninit();
  }

  Sequence<Sequence<RefPtr<mozilla::dom::ImageData>>>&
  RawSetAsImageDataOrNullSequenceSequence();

  Sequence<Sequence<RefPtr<mozilla::dom::ImageData>>>&
  SetAsImageDataOrNullSequenceSequence();

  inline bool
  IsImageDataOrNullSequenceSequence() const
  {
    return mType == eImageDataOrNullSequenceSequence;
  }

  inline Sequence<Sequence<RefPtr<mozilla::dom::ImageData>>>&
  GetAsImageDataOrNullSequenceSequence()
  {
    MOZ_RELEASE_ASSERT(IsImageDataOrNullSequenceSequence(), "Wrong type!");
    return mValue.mImageDataOrNullSequenceSequence.Value();
  }

  inline Sequence<Sequence<RefPtr<mozilla::dom::ImageData>>> const &
  GetAsImageDataOrNullSequenceSequence() const
  {
    MOZ_RELEASE_ASSERT(IsImageDataOrNullSequenceSequence(), "Wrong type!");
    return mValue.mImageDataOrNullSequenceSequence.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningImageDataOrNullSequenceSequenceOrLong&
  operator=(OwningImageDataOrNullSequenceSequenceOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningImageDataOrNullSequenceSequenceOrLong&
  operator=(const OwningImageDataOrNullSequenceSequenceOrLong& aOther);

private:
  bool
  TrySetToImageDataOrNullSequenceSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageDataOrNullSequenceSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyImageDataOrNullSequenceSequence();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningImageDataSequenceOrLong : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningImageDataSequenceOrLong& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eImageDataSequence,
    eLong
  };
public:
  enum class Type
  {
    eImageDataSequence = TypeOrUninit::eImageDataSequence,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<Sequence<OwningNonNull<mozilla::dom::ImageData>> > mImageDataSequence;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningImageDataSequenceOrLong()
    : mType(eUninitialized)
  {
  }

  OwningImageDataSequenceOrLong(OwningImageDataSequenceOrLong&& aOther);

  explicit inline OwningImageDataSequenceOrLong(const OwningImageDataSequenceOrLong& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningImageDataSequenceOrLong()
  {
    Uninit();
  }

  Sequence<OwningNonNull<mozilla::dom::ImageData>>&
  RawSetAsImageDataSequence();

  Sequence<OwningNonNull<mozilla::dom::ImageData>>&
  SetAsImageDataSequence();

  inline bool
  IsImageDataSequence() const
  {
    return mType == eImageDataSequence;
  }

  inline Sequence<OwningNonNull<mozilla::dom::ImageData>>&
  GetAsImageDataSequence()
  {
    MOZ_RELEASE_ASSERT(IsImageDataSequence(), "Wrong type!");
    return mValue.mImageDataSequence.Value();
  }

  inline Sequence<OwningNonNull<mozilla::dom::ImageData>> const &
  GetAsImageDataSequence() const
  {
    MOZ_RELEASE_ASSERT(IsImageDataSequence(), "Wrong type!");
    return mValue.mImageDataSequence.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningImageDataSequenceOrLong&
  operator=(OwningImageDataSequenceOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningImageDataSequenceOrLong&
  operator=(const OwningImageDataSequenceOrLong& aOther);

private:
  bool
  TrySetToImageDataSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageDataSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyImageDataSequence();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningImageDataSequenceSequenceOrLong : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningImageDataSequenceSequenceOrLong& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eImageDataSequenceSequence,
    eLong
  };
public:
  enum class Type
  {
    eImageDataSequenceSequence = TypeOrUninit::eImageDataSequenceSequence,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<Sequence<Sequence<OwningNonNull<mozilla::dom::ImageData>>> > mImageDataSequenceSequence;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningImageDataSequenceSequenceOrLong()
    : mType(eUninitialized)
  {
  }

  OwningImageDataSequenceSequenceOrLong(OwningImageDataSequenceSequenceOrLong&& aOther);

  explicit inline OwningImageDataSequenceSequenceOrLong(const OwningImageDataSequenceSequenceOrLong& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningImageDataSequenceSequenceOrLong()
  {
    Uninit();
  }

  Sequence<Sequence<OwningNonNull<mozilla::dom::ImageData>>>&
  RawSetAsImageDataSequenceSequence();

  Sequence<Sequence<OwningNonNull<mozilla::dom::ImageData>>>&
  SetAsImageDataSequenceSequence();

  inline bool
  IsImageDataSequenceSequence() const
  {
    return mType == eImageDataSequenceSequence;
  }

  inline Sequence<Sequence<OwningNonNull<mozilla::dom::ImageData>>>&
  GetAsImageDataSequenceSequence()
  {
    MOZ_RELEASE_ASSERT(IsImageDataSequenceSequence(), "Wrong type!");
    return mValue.mImageDataSequenceSequence.Value();
  }

  inline Sequence<Sequence<OwningNonNull<mozilla::dom::ImageData>>> const &
  GetAsImageDataSequenceSequence() const
  {
    MOZ_RELEASE_ASSERT(IsImageDataSequenceSequence(), "Wrong type!");
    return mValue.mImageDataSequenceSequence.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningImageDataSequenceSequenceOrLong&
  operator=(OwningImageDataSequenceSequenceOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningImageDataSequenceSequenceOrLong&
  operator=(const OwningImageDataSequenceSequenceOrLong& aOther);

private:
  bool
  TrySetToImageDataSequenceSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageDataSequenceSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyImageDataSequenceSequence();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningLongOrBoolean : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eLong,
    eBoolean
  };
public:
  enum class Type
  {
    eLong = TypeOrUninit::eLong,
    eBoolean = TypeOrUninit::eBoolean
  };

private:
  union Value
  {
    UnionMember<int32_t > mLong;
    UnionMember<bool > mBoolean;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningLongOrBoolean()
    : mType(eUninitialized)
  {
  }

  OwningLongOrBoolean(OwningLongOrBoolean&& aOther);

  explicit inline OwningLongOrBoolean(const OwningLongOrBoolean& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningLongOrBoolean()
  {
    Uninit();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool&
  RawSetAsBoolean();

  bool&
  SetAsBoolean();

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool const &
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningLongOrBoolean&
  operator=(OwningLongOrBoolean&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningLongOrBoolean&
  operator=(const OwningLongOrBoolean& aOther);

private:
  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyBoolean();
};

class OwningLongOrStringAnyRecord : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eLong,
    eStringAnyRecord
  };
public:
  enum class Type
  {
    eLong = TypeOrUninit::eLong,
    eStringAnyRecord = TypeOrUninit::eStringAnyRecord
  };

private:
  union Value
  {
    UnionMember<int32_t > mLong;
    UnionMember<Record<nsString, JS::Value> > mStringAnyRecord;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningLongOrStringAnyRecord(const OwningLongOrStringAnyRecord&) = delete;
  OwningLongOrStringAnyRecord& operator=(const OwningLongOrStringAnyRecord&) = delete;
public:
  explicit inline OwningLongOrStringAnyRecord()
    : mType(eUninitialized)
  {
  }

  OwningLongOrStringAnyRecord(OwningLongOrStringAnyRecord&& aOther);

  inline ~OwningLongOrStringAnyRecord()
  {
    Uninit();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  Record<nsString, JS::Value>&
  RawSetAsStringAnyRecord();

  Record<nsString, JS::Value>&
  SetAsStringAnyRecord();

  inline bool
  IsStringAnyRecord() const
  {
    return mType == eStringAnyRecord;
  }

  inline Record<nsString, JS::Value>&
  GetAsStringAnyRecord()
  {
    MOZ_RELEASE_ASSERT(IsStringAnyRecord(), "Wrong type!");
    return mValue.mStringAnyRecord.Value();
  }

  inline Record<nsString, JS::Value> const &
  GetAsStringAnyRecord() const
  {
    MOZ_RELEASE_ASSERT(IsStringAnyRecord(), "Wrong type!");
    return mValue.mStringAnyRecord.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningLongOrStringAnyRecord&
  operator=(OwningLongOrStringAnyRecord&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();

  bool
  TrySetToStringAnyRecord(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringAnyRecord(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyStringAnyRecord();
};

class OwningLongSequenceOrLong : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eLongSequence,
    eLong
  };
public:
  enum class Type
  {
    eLongSequence = TypeOrUninit::eLongSequence,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<Sequence<int32_t> > mLongSequence;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningLongSequenceOrLong()
    : mType(eUninitialized)
  {
  }

  OwningLongSequenceOrLong(OwningLongSequenceOrLong&& aOther);

  explicit inline OwningLongSequenceOrLong(const OwningLongSequenceOrLong& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningLongSequenceOrLong()
  {
    Uninit();
  }

  Sequence<int32_t>&
  RawSetAsLongSequence();

  Sequence<int32_t>&
  SetAsLongSequence();

  inline bool
  IsLongSequence() const
  {
    return mType == eLongSequence;
  }

  inline Sequence<int32_t>&
  GetAsLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsLongSequence(), "Wrong type!");
    return mValue.mLongSequence.Value();
  }

  inline Sequence<int32_t> const &
  GetAsLongSequence() const
  {
    MOZ_RELEASE_ASSERT(IsLongSequence(), "Wrong type!");
    return mValue.mLongSequence.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningLongSequenceOrLong&
  operator=(OwningLongSequenceOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningLongSequenceOrLong&
  operator=(const OwningLongSequenceOrLong& aOther);

private:
  bool
  TrySetToLongSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToLongSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLongSequence();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningLongSequenceOrNullOrLong : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eLongSequence,
    eLong
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eLongSequence = TypeOrUninit::eLongSequence,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<Sequence<int32_t> > mLongSequence;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningLongSequenceOrNullOrLong()
    : mType(eUninitialized)
  {
  }

  OwningLongSequenceOrNullOrLong(OwningLongSequenceOrNullOrLong&& aOther);

  explicit inline OwningLongSequenceOrNullOrLong(const OwningLongSequenceOrNullOrLong& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningLongSequenceOrNullOrLong()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  Sequence<int32_t>&
  RawSetAsLongSequence();

  Sequence<int32_t>&
  SetAsLongSequence();

  inline bool
  IsLongSequence() const
  {
    return mType == eLongSequence;
  }

  inline Sequence<int32_t>&
  GetAsLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsLongSequence(), "Wrong type!");
    return mValue.mLongSequence.Value();
  }

  inline Sequence<int32_t> const &
  GetAsLongSequence() const
  {
    MOZ_RELEASE_ASSERT(IsLongSequence(), "Wrong type!");
    return mValue.mLongSequence.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningLongSequenceOrNullOrLong&
  operator=(OwningLongSequenceOrNullOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningLongSequenceOrNullOrLong&
  operator=(const OwningLongSequenceOrNullOrLong& aOther);

private:
  bool
  TrySetToLongSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToLongSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLongSequence();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eArrayBufferView,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eArrayBufferView = TypeOrUninit::eArrayBufferView,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<ArrayBufferView > mArrayBufferView;
    UnionMember<ArrayBuffer > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer(const OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer&) = delete;
  OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer& operator=(const OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer&) = delete;
public:
  explicit inline OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer()
    : mType(eUninitialized)
  {
  }

  OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer(OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer&& aOther);

  inline ~OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer()
  {
    Uninit();
  }

  ArrayBufferView&
  RawSetAsArrayBufferView();

  ArrayBufferView&
  SetAsArrayBufferView();

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline ArrayBufferView&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  ArrayBuffer&
  RawSetAsArrayBuffer();

  ArrayBuffer&
  SetAsArrayBuffer();

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline ArrayBuffer&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer&
  operator=(OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBufferView();

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBuffer();
};

class OwningNodeOrLongOrBoolean : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningNodeOrLongOrBoolean& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eNode,
    eLong,
    eBoolean
  };
public:
  enum class Type
  {
    eNode = TypeOrUninit::eNode,
    eLong = TypeOrUninit::eLong,
    eBoolean = TypeOrUninit::eBoolean
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<nsINode> > mNode;
    UnionMember<int32_t > mLong;
    UnionMember<bool > mBoolean;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningNodeOrLongOrBoolean()
    : mType(eUninitialized)
  {
  }

  OwningNodeOrLongOrBoolean(OwningNodeOrLongOrBoolean&& aOther);

  explicit inline OwningNodeOrLongOrBoolean(const OwningNodeOrLongOrBoolean& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningNodeOrLongOrBoolean()
  {
    Uninit();
  }

  OwningNonNull<nsINode>&
  RawSetAsNode();

  OwningNonNull<nsINode>&
  SetAsNode();

  inline bool
  IsNode() const
  {
    return mType == eNode;
  }

  inline OwningNonNull<nsINode>&
  GetAsNode()
  {
    MOZ_RELEASE_ASSERT(IsNode(), "Wrong type!");
    return mValue.mNode.Value();
  }

  inline OwningNonNull<nsINode> const &
  GetAsNode() const
  {
    MOZ_RELEASE_ASSERT(IsNode(), "Wrong type!");
    return mValue.mNode.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool&
  RawSetAsBoolean();

  bool&
  SetAsBoolean();

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool const &
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningNodeOrLongOrBoolean&
  operator=(OwningNodeOrLongOrBoolean&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningNodeOrLongOrBoolean&
  operator=(const OwningNodeOrLongOrBoolean& aOther);

private:
  bool
  TrySetToNode(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToNode(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyNode();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyBoolean();
};

class OwningNodeOrString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningNodeOrString& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eNode,
    eString
  };
public:
  enum class Type
  {
    eNode = TypeOrUninit::eNode,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<nsINode> > mNode;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningNodeOrString()
    : mType(eUninitialized)
  {
  }

  OwningNodeOrString(OwningNodeOrString&& aOther);

  explicit inline OwningNodeOrString(const OwningNodeOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningNodeOrString()
  {
    Uninit();
  }

  OwningNonNull<nsINode>&
  RawSetAsNode();

  OwningNonNull<nsINode>&
  SetAsNode();

  inline bool
  IsNode() const
  {
    return mType == eNode;
  }

  inline OwningNonNull<nsINode>&
  GetAsNode()
  {
    MOZ_RELEASE_ASSERT(IsNode(), "Wrong type!");
    return mValue.mNode.Value();
  }

  inline OwningNonNull<nsINode> const &
  GetAsNode() const
  {
    MOZ_RELEASE_ASSERT(IsNode(), "Wrong type!");
    return mValue.mNode.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningNodeOrString&
  operator=(OwningNodeOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningNodeOrString&
  operator=(const OwningNodeOrString& aOther);

private:
  bool
  TrySetToNode(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToNode(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyNode();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};

class OwningObjectOrBoolean : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eObject,
    eBoolean
  };
public:
  enum class Type
  {
    eObject = TypeOrUninit::eObject,
    eBoolean = TypeOrUninit::eBoolean
  };

private:
  union Value
  {
    UnionMember<JSObject* > mObject;
    UnionMember<bool > mBoolean;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningObjectOrBoolean(const OwningObjectOrBoolean&) = delete;
  OwningObjectOrBoolean& operator=(const OwningObjectOrBoolean&) = delete;
public:
  explicit inline OwningObjectOrBoolean()
    : mType(eUninitialized)
  {
  }

  OwningObjectOrBoolean(OwningObjectOrBoolean&& aOther);

  inline ~OwningObjectOrBoolean()
  {
    Uninit();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (object or boolean)");
      return false;
    }
    return true;
  }

  JSObject*&
  RawSetAsObject();

  JSObject*&
  SetAsObject();

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JSObject*&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject* const &
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  bool&
  RawSetAsBoolean();

  bool&
  SetAsBoolean();

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool const &
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningObjectOrBoolean&
  operator=(OwningObjectOrBoolean&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  void
  DestroyObject();

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyBoolean();
};

class OwningObjectOrLong : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eObject,
    eLong
  };
public:
  enum class Type
  {
    eObject = TypeOrUninit::eObject,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<JSObject* > mObject;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningObjectOrLong(const OwningObjectOrLong&) = delete;
  OwningObjectOrLong& operator=(const OwningObjectOrLong&) = delete;
public:
  explicit inline OwningObjectOrLong()
    : mType(eUninitialized)
  {
  }

  OwningObjectOrLong(OwningObjectOrLong&& aOther);

  inline ~OwningObjectOrLong()
  {
    Uninit();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (object or long)");
      return false;
    }
    return true;
  }

  JSObject*&
  RawSetAsObject();

  JSObject*&
  SetAsObject();

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JSObject*&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject* const &
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningObjectOrLong&
  operator=(OwningObjectOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  void
  DestroyObject();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningObjectOrLongOrBoolean : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eObject,
    eLong,
    eBoolean
  };
public:
  enum class Type
  {
    eObject = TypeOrUninit::eObject,
    eLong = TypeOrUninit::eLong,
    eBoolean = TypeOrUninit::eBoolean
  };

private:
  union Value
  {
    UnionMember<JSObject* > mObject;
    UnionMember<int32_t > mLong;
    UnionMember<bool > mBoolean;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningObjectOrLongOrBoolean(const OwningObjectOrLongOrBoolean&) = delete;
  OwningObjectOrLongOrBoolean& operator=(const OwningObjectOrLongOrBoolean&) = delete;
public:
  explicit inline OwningObjectOrLongOrBoolean()
    : mType(eUninitialized)
  {
  }

  OwningObjectOrLongOrBoolean(OwningObjectOrLongOrBoolean&& aOther);

  inline ~OwningObjectOrLongOrBoolean()
  {
    Uninit();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (object or long or boolean)");
      return false;
    }
    return true;
  }

  JSObject*&
  RawSetAsObject();

  JSObject*&
  SetAsObject();

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JSObject*&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject* const &
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool&
  RawSetAsBoolean();

  bool&
  SetAsBoolean();

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool const &
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningObjectOrLongOrBoolean&
  operator=(OwningObjectOrLongOrBoolean&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  void
  DestroyObject();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyBoolean();
};

class OwningObjectOrLongOrNull : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eObject,
    eLong
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eObject = TypeOrUninit::eObject,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<JSObject* > mObject;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningObjectOrLongOrNull(const OwningObjectOrLongOrNull&) = delete;
  OwningObjectOrLongOrNull& operator=(const OwningObjectOrLongOrNull&) = delete;
public:
  explicit inline OwningObjectOrLongOrNull()
    : mType(eUninitialized)
  {
  }

  OwningObjectOrLongOrNull(OwningObjectOrLongOrNull&& aOther);

  inline ~OwningObjectOrLongOrNull()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (object or long?)");
      return false;
    }
    return true;
  }

  JSObject*&
  RawSetAsObject();

  JSObject*&
  SetAsObject();

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JSObject*&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject* const &
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningObjectOrLongOrNull&
  operator=(OwningObjectOrLongOrNull&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  void
  DestroyObject();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningObjectOrNullOrLong : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eObject,
    eLong
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eObject = TypeOrUninit::eObject,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<JSObject* > mObject;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningObjectOrNullOrLong(const OwningObjectOrNullOrLong&) = delete;
  OwningObjectOrNullOrLong& operator=(const OwningObjectOrNullOrLong&) = delete;
public:
  explicit inline OwningObjectOrNullOrLong()
    : mType(eUninitialized)
  {
  }

  OwningObjectOrNullOrLong(OwningObjectOrNullOrLong&& aOther);

  inline ~OwningObjectOrNullOrLong()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (object? or long)");
      return false;
    }
    return true;
  }

  JSObject*&
  RawSetAsObject();

  JSObject*&
  SetAsObject();

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JSObject*&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject* const &
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningObjectOrNullOrLong&
  operator=(OwningObjectOrNullOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  void
  DestroyObject();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningObjectOrString : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eObject,
    eString
  };
public:
  enum class Type
  {
    eObject = TypeOrUninit::eObject,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<JSObject* > mObject;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningObjectOrString(const OwningObjectOrString&) = delete;
  OwningObjectOrString& operator=(const OwningObjectOrString&) = delete;
public:
  explicit inline OwningObjectOrString()
    : mType(eUninitialized)
  {
  }

  OwningObjectOrString(OwningObjectOrString&& aOther);

  inline ~OwningObjectOrString()
  {
    Uninit();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (object or DOMString)");
      return false;
    }
    return true;
  }

  JSObject*&
  RawSetAsObject();

  JSObject*&
  SetAsObject();

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JSObject*&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject* const &
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningObjectOrString&
  operator=(OwningObjectOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  void
  DestroyObject();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};

class OwningObjectOrStringOrBoolean : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eObject,
    eString,
    eBoolean
  };
public:
  enum class Type
  {
    eObject = TypeOrUninit::eObject,
    eString = TypeOrUninit::eString,
    eBoolean = TypeOrUninit::eBoolean
  };

private:
  union Value
  {
    UnionMember<JSObject* > mObject;
    UnionMember<nsString > mString;
    UnionMember<bool > mBoolean;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningObjectOrStringOrBoolean(const OwningObjectOrStringOrBoolean&) = delete;
  OwningObjectOrStringOrBoolean& operator=(const OwningObjectOrStringOrBoolean&) = delete;
public:
  explicit inline OwningObjectOrStringOrBoolean()
    : mType(eUninitialized)
  {
  }

  OwningObjectOrStringOrBoolean(OwningObjectOrStringOrBoolean&& aOther);

  inline ~OwningObjectOrStringOrBoolean()
  {
    Uninit();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (object or DOMString or boolean)");
      return false;
    }
    return true;
  }

  JSObject*&
  RawSetAsObject();

  JSObject*&
  SetAsObject();

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JSObject*&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject* const &
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool&
  RawSetAsBoolean();

  bool&
  SetAsBoolean();

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool const &
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningObjectOrStringOrBoolean&
  operator=(OwningObjectOrStringOrBoolean&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  void
  DestroyObject();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyBoolean();
};

class OwningObjectOrStringOrLong : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eObject,
    eString,
    eLong
  };
public:
  enum class Type
  {
    eObject = TypeOrUninit::eObject,
    eString = TypeOrUninit::eString,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<JSObject* > mObject;
    UnionMember<nsString > mString;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningObjectOrStringOrLong(const OwningObjectOrStringOrLong&) = delete;
  OwningObjectOrStringOrLong& operator=(const OwningObjectOrStringOrLong&) = delete;
public:
  explicit inline OwningObjectOrStringOrLong()
    : mType(eUninitialized)
  {
  }

  OwningObjectOrStringOrLong(OwningObjectOrStringOrLong&& aOther);

  inline ~OwningObjectOrStringOrLong()
  {
    Uninit();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (object or DOMString or long)");
      return false;
    }
    return true;
  }

  JSObject*&
  RawSetAsObject();

  JSObject*&
  SetAsObject();

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JSObject*&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject* const &
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningObjectOrStringOrLong&
  operator=(OwningObjectOrStringOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  void
  DestroyObject();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningObjectOrStringOrLongOrBoolean : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eObject,
    eString,
    eLong,
    eBoolean
  };
public:
  enum class Type
  {
    eObject = TypeOrUninit::eObject,
    eString = TypeOrUninit::eString,
    eLong = TypeOrUninit::eLong,
    eBoolean = TypeOrUninit::eBoolean
  };

private:
  union Value
  {
    UnionMember<JSObject* > mObject;
    UnionMember<nsString > mString;
    UnionMember<int32_t > mLong;
    UnionMember<bool > mBoolean;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningObjectOrStringOrLongOrBoolean(const OwningObjectOrStringOrLongOrBoolean&) = delete;
  OwningObjectOrStringOrLongOrBoolean& operator=(const OwningObjectOrStringOrLongOrBoolean&) = delete;
public:
  explicit inline OwningObjectOrStringOrLongOrBoolean()
    : mType(eUninitialized)
  {
  }

  OwningObjectOrStringOrLongOrBoolean(OwningObjectOrStringOrLongOrBoolean&& aOther);

  inline ~OwningObjectOrStringOrLongOrBoolean()
  {
    Uninit();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (object or DOMString or long or boolean)");
      return false;
    }
    return true;
  }

  JSObject*&
  RawSetAsObject();

  JSObject*&
  SetAsObject();

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JSObject*&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject* const &
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool&
  RawSetAsBoolean();

  bool&
  SetAsBoolean();

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool const &
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningObjectOrStringOrLongOrBoolean&
  operator=(OwningObjectOrStringOrLongOrBoolean&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  void
  DestroyObject();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyBoolean();
};

class OwningObjectSequenceOrLong : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eObjectSequence,
    eLong
  };
public:
  enum class Type
  {
    eObjectSequence = TypeOrUninit::eObjectSequence,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<Sequence<JSObject*> > mObjectSequence;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningObjectSequenceOrLong(const OwningObjectSequenceOrLong&) = delete;
  OwningObjectSequenceOrLong& operator=(const OwningObjectSequenceOrLong&) = delete;
public:
  explicit inline OwningObjectSequenceOrLong()
    : mType(eUninitialized)
  {
  }

  OwningObjectSequenceOrLong(OwningObjectSequenceOrLong&& aOther);

  inline ~OwningObjectSequenceOrLong()
  {
    Uninit();
  }

  Sequence<JSObject*>&
  RawSetAsObjectSequence();

  Sequence<JSObject*>&
  SetAsObjectSequence();

  inline bool
  IsObjectSequence() const
  {
    return mType == eObjectSequence;
  }

  inline Sequence<JSObject*>&
  GetAsObjectSequence()
  {
    MOZ_RELEASE_ASSERT(IsObjectSequence(), "Wrong type!");
    return mValue.mObjectSequence.Value();
  }

  inline Sequence<JSObject*> const &
  GetAsObjectSequence() const
  {
    MOZ_RELEASE_ASSERT(IsObjectSequence(), "Wrong type!");
    return mValue.mObjectSequence.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningObjectSequenceOrLong&
  operator=(OwningObjectSequenceOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToObjectSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToObjectSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyObjectSequence();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningStringLongRecordOrLong : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eStringLongRecord,
    eLong
  };
public:
  enum class Type
  {
    eStringLongRecord = TypeOrUninit::eStringLongRecord,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<Record<nsString, int32_t> > mStringLongRecord;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningStringLongRecordOrLong(const OwningStringLongRecordOrLong&) = delete;
  OwningStringLongRecordOrLong& operator=(const OwningStringLongRecordOrLong&) = delete;
public:
  explicit inline OwningStringLongRecordOrLong()
    : mType(eUninitialized)
  {
  }

  OwningStringLongRecordOrLong(OwningStringLongRecordOrLong&& aOther);

  inline ~OwningStringLongRecordOrLong()
  {
    Uninit();
  }

  Record<nsString, int32_t>&
  RawSetAsStringLongRecord();

  Record<nsString, int32_t>&
  SetAsStringLongRecord();

  inline bool
  IsStringLongRecord() const
  {
    return mType == eStringLongRecord;
  }

  inline Record<nsString, int32_t>&
  GetAsStringLongRecord()
  {
    MOZ_RELEASE_ASSERT(IsStringLongRecord(), "Wrong type!");
    return mValue.mStringLongRecord.Value();
  }

  inline Record<nsString, int32_t> const &
  GetAsStringLongRecord() const
  {
    MOZ_RELEASE_ASSERT(IsStringLongRecord(), "Wrong type!");
    return mValue.mStringLongRecord.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningStringLongRecordOrLong&
  operator=(OwningStringLongRecordOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToStringLongRecord(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringLongRecord(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyStringLongRecord();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningStringObjectRecordOrLong : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eStringObjectRecord,
    eLong
  };
public:
  enum class Type
  {
    eStringObjectRecord = TypeOrUninit::eStringObjectRecord,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<Record<nsString, JSObject*> > mStringObjectRecord;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningStringObjectRecordOrLong(const OwningStringObjectRecordOrLong&) = delete;
  OwningStringObjectRecordOrLong& operator=(const OwningStringObjectRecordOrLong&) = delete;
public:
  explicit inline OwningStringObjectRecordOrLong()
    : mType(eUninitialized)
  {
  }

  OwningStringObjectRecordOrLong(OwningStringObjectRecordOrLong&& aOther);

  inline ~OwningStringObjectRecordOrLong()
  {
    Uninit();
  }

  Record<nsString, JSObject*>&
  RawSetAsStringObjectRecord();

  Record<nsString, JSObject*>&
  SetAsStringObjectRecord();

  inline bool
  IsStringObjectRecord() const
  {
    return mType == eStringObjectRecord;
  }

  inline Record<nsString, JSObject*>&
  GetAsStringObjectRecord()
  {
    MOZ_RELEASE_ASSERT(IsStringObjectRecord(), "Wrong type!");
    return mValue.mStringObjectRecord.Value();
  }

  inline Record<nsString, JSObject*> const &
  GetAsStringObjectRecord() const
  {
    MOZ_RELEASE_ASSERT(IsStringObjectRecord(), "Wrong type!");
    return mValue.mStringObjectRecord.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningStringObjectRecordOrLong&
  operator=(OwningStringObjectRecordOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToStringObjectRecord(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringObjectRecord(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyStringObjectRecord();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningStringOrArrayBuffer : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<ArrayBuffer > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningStringOrArrayBuffer(const OwningStringOrArrayBuffer&) = delete;
  OwningStringOrArrayBuffer& operator=(const OwningStringOrArrayBuffer&) = delete;
public:
  explicit inline OwningStringOrArrayBuffer()
    : mType(eUninitialized)
  {
  }

  OwningStringOrArrayBuffer(OwningStringOrArrayBuffer&& aOther);

  inline ~OwningStringOrArrayBuffer()
  {
    Uninit();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  ArrayBuffer&
  RawSetAsArrayBuffer();

  ArrayBuffer&
  SetAsArrayBuffer();

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline ArrayBuffer&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningStringOrArrayBuffer&
  operator=(OwningStringOrArrayBuffer&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBuffer();
};

class OwningStringOrBooleanOrObject : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eBoolean,
    eObject
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eBoolean = TypeOrUninit::eBoolean,
    eObject = TypeOrUninit::eObject
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<bool > mBoolean;
    UnionMember<JSObject* > mObject;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningStringOrBooleanOrObject(const OwningStringOrBooleanOrObject&) = delete;
  OwningStringOrBooleanOrObject& operator=(const OwningStringOrBooleanOrObject&) = delete;
public:
  explicit inline OwningStringOrBooleanOrObject()
    : mType(eUninitialized)
  {
  }

  OwningStringOrBooleanOrObject(OwningStringOrBooleanOrObject&& aOther);

  inline ~OwningStringOrBooleanOrObject()
  {
    Uninit();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool&
  RawSetAsBoolean();

  bool&
  SetAsBoolean();

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool const &
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (DOMString or boolean or object)");
      return false;
    }
    return true;
  }

  JSObject*&
  RawSetAsObject();

  JSObject*&
  SetAsObject();

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JSObject*&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject* const &
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningStringOrBooleanOrObject&
  operator=(OwningStringOrBooleanOrObject&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyBoolean();

  void
  DestroyObject();
};

class OwningStringOrLong : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eLong
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningStringOrLong()
    : mType(eUninitialized)
  {
  }

  OwningStringOrLong(OwningStringOrLong&& aOther);

  explicit inline OwningStringOrLong(const OwningStringOrLong& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningStringOrLong()
  {
    Uninit();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningStringOrLong&
  operator=(OwningStringOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningStringOrLong&
  operator=(const OwningStringOrLong& aOther);

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningStringOrMaybeSharedArrayBuffer : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<ArrayBuffer > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningStringOrMaybeSharedArrayBuffer(const OwningStringOrMaybeSharedArrayBuffer&) = delete;
  OwningStringOrMaybeSharedArrayBuffer& operator=(const OwningStringOrMaybeSharedArrayBuffer&) = delete;
public:
  explicit inline OwningStringOrMaybeSharedArrayBuffer()
    : mType(eUninitialized)
  {
  }

  OwningStringOrMaybeSharedArrayBuffer(OwningStringOrMaybeSharedArrayBuffer&& aOther);

  inline ~OwningStringOrMaybeSharedArrayBuffer()
  {
    Uninit();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  ArrayBuffer&
  RawSetAsArrayBuffer();

  ArrayBuffer&
  SetAsArrayBuffer();

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline ArrayBuffer&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningStringOrMaybeSharedArrayBuffer&
  operator=(OwningStringOrMaybeSharedArrayBuffer&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBuffer();
};

class OwningStringOrObject : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eObject
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eObject = TypeOrUninit::eObject
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<JSObject* > mObject;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningStringOrObject(const OwningStringOrObject&) = delete;
  OwningStringOrObject& operator=(const OwningStringOrObject&) = delete;
public:
  explicit inline OwningStringOrObject()
    : mType(eUninitialized)
  {
  }

  OwningStringOrObject(OwningStringOrObject&& aOther);

  inline ~OwningStringOrObject()
  {
    Uninit();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (DOMString or object)");
      return false;
    }
    return true;
  }

  JSObject*&
  RawSetAsObject();

  JSObject*&
  SetAsObject();

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JSObject*&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject* const &
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningStringOrObject&
  operator=(OwningStringOrObject&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  void
  DestroyObject();
};

class OwningStringOrStringSequence : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eStringSequence
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eStringSequence = TypeOrUninit::eStringSequence
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<Sequence<nsString> > mStringSequence;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningStringOrStringSequence()
    : mType(eUninitialized)
  {
  }

  OwningStringOrStringSequence(OwningStringOrStringSequence&& aOther);

  explicit inline OwningStringOrStringSequence(const OwningStringOrStringSequence& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningStringOrStringSequence()
  {
    Uninit();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  Sequence<nsString>&
  RawSetAsStringSequence();

  Sequence<nsString>&
  SetAsStringSequence();

  inline bool
  IsStringSequence() const
  {
    return mType == eStringSequence;
  }

  inline Sequence<nsString>&
  GetAsStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline Sequence<nsString> const &
  GetAsStringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningStringOrStringSequence&
  operator=(OwningStringOrStringSequence&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningStringOrStringSequence&
  operator=(const OwningStringOrStringSequence& aOther);

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToStringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyStringSequence();
};

class OwningStringSequenceOrEventInit : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eStringSequence,
    eEventInit
  };
public:
  enum class Type
  {
    eStringSequence = TypeOrUninit::eStringSequence,
    eEventInit = TypeOrUninit::eEventInit
  };

private:
  union Value
  {
    UnionMember<Sequence<nsString> > mStringSequence;
    UnionMember<EventInit > mEventInit;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningStringSequenceOrEventInit()
    : mType(eUninitialized)
  {
  }

  OwningStringSequenceOrEventInit(OwningStringSequenceOrEventInit&& aOther);

  explicit inline OwningStringSequenceOrEventInit(const OwningStringSequenceOrEventInit& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningStringSequenceOrEventInit()
  {
    Uninit();
  }

  Sequence<nsString>&
  RawSetAsStringSequence();

  Sequence<nsString>&
  SetAsStringSequence();

  inline bool
  IsStringSequence() const
  {
    return mType == eStringSequence;
  }

  inline Sequence<nsString>&
  GetAsStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline Sequence<nsString> const &
  GetAsStringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  EventInit&
  RawSetAsEventInit();

  EventInit&
  SetAsEventInit();

  inline bool
  IsEventInit() const
  {
    return mType == eEventInit;
  }

  inline EventInit&
  GetAsEventInit()
  {
    MOZ_RELEASE_ASSERT(IsEventInit(), "Wrong type!");
    return mValue.mEventInit.Value();
  }

  inline EventInit const &
  GetAsEventInit() const
  {
    MOZ_RELEASE_ASSERT(IsEventInit(), "Wrong type!");
    return mValue.mEventInit.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningStringSequenceOrEventInit&
  operator=(OwningStringSequenceOrEventInit&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningStringSequenceOrEventInit&
  operator=(const OwningStringSequenceOrEventInit& aOther);

private:
  bool
  TrySetToStringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyStringSequence();

  bool
  TrySetToEventInit(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToEventInit(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyEventInit();
};

class OwningStringSequenceOrStringStringRecord : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eStringSequence,
    eStringStringRecord
  };
public:
  enum class Type
  {
    eStringSequence = TypeOrUninit::eStringSequence,
    eStringStringRecord = TypeOrUninit::eStringStringRecord
  };

private:
  union Value
  {
    UnionMember<Sequence<nsString> > mStringSequence;
    UnionMember<Record<nsString, nsString> > mStringStringRecord;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningStringSequenceOrStringStringRecord(const OwningStringSequenceOrStringStringRecord&) = delete;
  OwningStringSequenceOrStringStringRecord& operator=(const OwningStringSequenceOrStringStringRecord&) = delete;
public:
  explicit inline OwningStringSequenceOrStringStringRecord()
    : mType(eUninitialized)
  {
  }

  OwningStringSequenceOrStringStringRecord(OwningStringSequenceOrStringStringRecord&& aOther);

  inline ~OwningStringSequenceOrStringStringRecord()
  {
    Uninit();
  }

  Sequence<nsString>&
  RawSetAsStringSequence();

  Sequence<nsString>&
  SetAsStringSequence();

  inline bool
  IsStringSequence() const
  {
    return mType == eStringSequence;
  }

  inline Sequence<nsString>&
  GetAsStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline Sequence<nsString> const &
  GetAsStringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  Record<nsString, nsString>&
  RawSetAsStringStringRecord();

  Record<nsString, nsString>&
  SetAsStringStringRecord();

  inline bool
  IsStringStringRecord() const
  {
    return mType == eStringStringRecord;
  }

  inline Record<nsString, nsString>&
  GetAsStringStringRecord()
  {
    MOZ_RELEASE_ASSERT(IsStringStringRecord(), "Wrong type!");
    return mValue.mStringStringRecord.Value();
  }

  inline Record<nsString, nsString> const &
  GetAsStringStringRecord() const
  {
    MOZ_RELEASE_ASSERT(IsStringStringRecord(), "Wrong type!");
    return mValue.mStringStringRecord.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningStringSequenceOrStringStringRecord&
  operator=(OwningStringSequenceOrStringStringRecord&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToStringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyStringSequence();

  bool
  TrySetToStringStringRecord(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringStringRecord(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyStringStringRecord();
};

class OwningStringStringRecordOrString : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eStringStringRecord,
    eString
  };
public:
  enum class Type
  {
    eStringStringRecord = TypeOrUninit::eStringStringRecord,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<Record<nsString, nsString> > mStringStringRecord;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningStringStringRecordOrString(const OwningStringStringRecordOrString&) = delete;
  OwningStringStringRecordOrString& operator=(const OwningStringStringRecordOrString&) = delete;
public:
  explicit inline OwningStringStringRecordOrString()
    : mType(eUninitialized)
  {
  }

  OwningStringStringRecordOrString(OwningStringStringRecordOrString&& aOther);

  inline ~OwningStringStringRecordOrString()
  {
    Uninit();
  }

  Record<nsString, nsString>&
  RawSetAsStringStringRecord();

  Record<nsString, nsString>&
  SetAsStringStringRecord();

  inline bool
  IsStringStringRecord() const
  {
    return mType == eStringStringRecord;
  }

  inline Record<nsString, nsString>&
  GetAsStringStringRecord()
  {
    MOZ_RELEASE_ASSERT(IsStringStringRecord(), "Wrong type!");
    return mValue.mStringStringRecord.Value();
  }

  inline Record<nsString, nsString> const &
  GetAsStringStringRecord() const
  {
    MOZ_RELEASE_ASSERT(IsStringStringRecord(), "Wrong type!");
    return mValue.mStringStringRecord.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningStringStringRecordOrString&
  operator=(OwningStringStringRecordOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToStringStringRecord(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringStringRecord(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyStringStringRecord();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};

class OwningStringStringRecordOrStringSequence : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eStringStringRecord,
    eStringSequence
  };
public:
  enum class Type
  {
    eStringStringRecord = TypeOrUninit::eStringStringRecord,
    eStringSequence = TypeOrUninit::eStringSequence
  };

private:
  union Value
  {
    UnionMember<Record<nsString, nsString> > mStringStringRecord;
    UnionMember<Sequence<nsString> > mStringSequence;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningStringStringRecordOrStringSequence(const OwningStringStringRecordOrStringSequence&) = delete;
  OwningStringStringRecordOrStringSequence& operator=(const OwningStringStringRecordOrStringSequence&) = delete;
public:
  explicit inline OwningStringStringRecordOrStringSequence()
    : mType(eUninitialized)
  {
  }

  OwningStringStringRecordOrStringSequence(OwningStringStringRecordOrStringSequence&& aOther);

  inline ~OwningStringStringRecordOrStringSequence()
  {
    Uninit();
  }

  Record<nsString, nsString>&
  RawSetAsStringStringRecord();

  Record<nsString, nsString>&
  SetAsStringStringRecord();

  inline bool
  IsStringStringRecord() const
  {
    return mType == eStringStringRecord;
  }

  inline Record<nsString, nsString>&
  GetAsStringStringRecord()
  {
    MOZ_RELEASE_ASSERT(IsStringStringRecord(), "Wrong type!");
    return mValue.mStringStringRecord.Value();
  }

  inline Record<nsString, nsString> const &
  GetAsStringStringRecord() const
  {
    MOZ_RELEASE_ASSERT(IsStringStringRecord(), "Wrong type!");
    return mValue.mStringStringRecord.Value();
  }

  Sequence<nsString>&
  RawSetAsStringSequence();

  Sequence<nsString>&
  SetAsStringSequence();

  inline bool
  IsStringSequence() const
  {
    return mType == eStringSequence;
  }

  inline Sequence<nsString>&
  GetAsStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline Sequence<nsString> const &
  GetAsStringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningStringStringRecordOrStringSequence&
  operator=(OwningStringStringRecordOrStringSequence&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToStringStringRecord(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringStringRecord(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyStringStringRecord();

  bool
  TrySetToStringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyStringSequence();
};

class OwningSupportedTypeOrObject : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eSupportedType,
    eObject
  };
public:
  enum class Type
  {
    eSupportedType = TypeOrUninit::eSupportedType,
    eObject = TypeOrUninit::eObject
  };

private:
  union Value
  {
    UnionMember<SupportedType > mSupportedType;
    UnionMember<JSObject* > mObject;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningSupportedTypeOrObject(const OwningSupportedTypeOrObject&) = delete;
  OwningSupportedTypeOrObject& operator=(const OwningSupportedTypeOrObject&) = delete;
public:
  explicit inline OwningSupportedTypeOrObject()
    : mType(eUninitialized)
  {
  }

  OwningSupportedTypeOrObject(OwningSupportedTypeOrObject&& aOther);

  inline ~OwningSupportedTypeOrObject()
  {
    Uninit();
  }

  SupportedType&
  RawSetAsSupportedType();

  SupportedType&
  SetAsSupportedType();

  inline bool
  IsSupportedType() const
  {
    return mType == eSupportedType;
  }

  inline SupportedType&
  GetAsSupportedType()
  {
    MOZ_RELEASE_ASSERT(IsSupportedType(), "Wrong type!");
    return mValue.mSupportedType.Value();
  }

  inline SupportedType const &
  GetAsSupportedType() const
  {
    MOZ_RELEASE_ASSERT(IsSupportedType(), "Wrong type!");
    return mValue.mSupportedType.Value();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (SupportedType or object)");
      return false;
    }
    return true;
  }

  JSObject*&
  RawSetAsObject();

  JSObject*&
  SetAsObject();

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JSObject*&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject* const &
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningSupportedTypeOrObject&
  operator=(OwningSupportedTypeOrObject&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToSupportedType(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSupportedType(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroySupportedType();

  void
  DestroyObject();
};

class OwningUSVStringOrLong : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUSVString,
    eLong
  };
public:
  enum class Type
  {
    eUSVString = TypeOrUninit::eUSVString,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<nsString > mUSVString;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUSVStringOrLong()
    : mType(eUninitialized)
  {
  }

  OwningUSVStringOrLong(OwningUSVStringOrLong&& aOther);

  explicit inline OwningUSVStringOrLong(const OwningUSVStringOrLong& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUSVStringOrLong()
  {
    Uninit();
  }

  nsString&
  RawSetAsUSVString();

  nsString&
  SetAsUSVString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsUSVString().AssignLiteral(aData);
  }

  inline bool
  IsUSVString() const
  {
    return mType == eUSVString;
  }

  inline nsString&
  GetAsUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline nsString const &
  GetAsUSVString() const
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningUSVStringOrLong&
  operator=(OwningUSVStringOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUSVStringOrLong&
  operator=(const OwningUSVStringOrLong& aOther);

private:
  bool
  TrySetToUSVString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUSVString();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningUTF8StringOrLong : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eLong
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<nsCString > mUTF8String;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUTF8StringOrLong()
    : mType(eUninitialized)
  {
  }

  OwningUTF8StringOrLong(OwningUTF8StringOrLong&& aOther);

  explicit inline OwningUTF8StringOrLong(const OwningUTF8StringOrLong& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUTF8StringOrLong()
  {
    Uninit();
  }

  nsCString&
  RawSetAsUTF8String();

  nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningUTF8StringOrLong&
  operator=(OwningUTF8StringOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUTF8StringOrLong&
  operator=(const OwningUTF8StringOrLong& aOther);

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningUTF8StringOrUTF8StringSequence : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eUTF8StringSequence
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eUTF8StringSequence = TypeOrUninit::eUTF8StringSequence
  };

private:
  union Value
  {
    UnionMember<nsCString > mUTF8String;
    UnionMember<Sequence<nsCString> > mUTF8StringSequence;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUTF8StringOrUTF8StringSequence()
    : mType(eUninitialized)
  {
  }

  OwningUTF8StringOrUTF8StringSequence(OwningUTF8StringOrUTF8StringSequence&& aOther);

  explicit inline OwningUTF8StringOrUTF8StringSequence(const OwningUTF8StringOrUTF8StringSequence& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUTF8StringOrUTF8StringSequence()
  {
    Uninit();
  }

  nsCString&
  RawSetAsUTF8String();

  nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  Sequence<nsCString>&
  RawSetAsUTF8StringSequence();

  Sequence<nsCString>&
  SetAsUTF8StringSequence();

  inline bool
  IsUTF8StringSequence() const
  {
    return mType == eUTF8StringSequence;
  }

  inline Sequence<nsCString>&
  GetAsUTF8StringSequence()
  {
    MOZ_RELEASE_ASSERT(IsUTF8StringSequence(), "Wrong type!");
    return mValue.mUTF8StringSequence.Value();
  }

  inline Sequence<nsCString> const &
  GetAsUTF8StringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8StringSequence(), "Wrong type!");
    return mValue.mUTF8StringSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningUTF8StringOrUTF8StringSequence&
  operator=(OwningUTF8StringOrUTF8StringSequence&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUTF8StringOrUTF8StringSequence&
  operator=(const OwningUTF8StringOrUTF8StringSequence& aOther);

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();

  bool
  TrySetToUTF8StringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToUTF8StringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8StringSequence();
};

class OwningUndefinedOrCanvasPattern : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningUndefinedOrCanvasPattern& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eUndefined,
    eCanvasPattern
  };
public:
  enum class Type
  {
    eUndefined = TypeOrUninit::eUndefined,
    eCanvasPattern = TypeOrUninit::eCanvasPattern
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::CanvasPattern> > mCanvasPattern;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUndefinedOrCanvasPattern()
    : mType(eUninitialized)
  {
  }

  OwningUndefinedOrCanvasPattern(OwningUndefinedOrCanvasPattern&& aOther);

  explicit inline OwningUndefinedOrCanvasPattern(const OwningUndefinedOrCanvasPattern& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUndefinedOrCanvasPattern()
  {
    Uninit();
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  OwningNonNull<mozilla::dom::CanvasPattern>&
  RawSetAsCanvasPattern();

  OwningNonNull<mozilla::dom::CanvasPattern>&
  SetAsCanvasPattern();

  inline bool
  IsCanvasPattern() const
  {
    return mType == eCanvasPattern;
  }

  inline OwningNonNull<mozilla::dom::CanvasPattern>&
  GetAsCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline OwningNonNull<mozilla::dom::CanvasPattern> const &
  GetAsCanvasPattern() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningUndefinedOrCanvasPattern&
  operator=(OwningUndefinedOrCanvasPattern&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUndefinedOrCanvasPattern&
  operator=(const OwningUndefinedOrCanvasPattern& aOther);

private:
  bool
  TrySetToCanvasPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyCanvasPattern();
};

class OwningUndefinedOrCanvasPatternOrNull : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningUndefinedOrCanvasPatternOrNull& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eUndefined,
    eCanvasPattern
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eUndefined = TypeOrUninit::eUndefined,
    eCanvasPattern = TypeOrUninit::eCanvasPattern
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::CanvasPattern> > mCanvasPattern;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUndefinedOrCanvasPatternOrNull()
    : mType(eUninitialized)
  {
  }

  OwningUndefinedOrCanvasPatternOrNull(OwningUndefinedOrCanvasPatternOrNull&& aOther);

  explicit inline OwningUndefinedOrCanvasPatternOrNull(const OwningUndefinedOrCanvasPatternOrNull& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUndefinedOrCanvasPatternOrNull()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  OwningNonNull<mozilla::dom::CanvasPattern>&
  RawSetAsCanvasPattern();

  OwningNonNull<mozilla::dom::CanvasPattern>&
  SetAsCanvasPattern();

  inline bool
  IsCanvasPattern() const
  {
    return mType == eCanvasPattern;
  }

  inline OwningNonNull<mozilla::dom::CanvasPattern>&
  GetAsCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline OwningNonNull<mozilla::dom::CanvasPattern> const &
  GetAsCanvasPattern() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningUndefinedOrCanvasPatternOrNull&
  operator=(OwningUndefinedOrCanvasPatternOrNull&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUndefinedOrCanvasPatternOrNull&
  operator=(const OwningUndefinedOrCanvasPatternOrNull& aOther);

private:
  bool
  TrySetToCanvasPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyCanvasPattern();
};

class OwningUndefinedOrNullOrCanvasPattern : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningUndefinedOrNullOrCanvasPattern& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eUndefined,
    eCanvasPattern
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eUndefined = TypeOrUninit::eUndefined,
    eCanvasPattern = TypeOrUninit::eCanvasPattern
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::CanvasPattern> > mCanvasPattern;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUndefinedOrNullOrCanvasPattern()
    : mType(eUninitialized)
  {
  }

  OwningUndefinedOrNullOrCanvasPattern(OwningUndefinedOrNullOrCanvasPattern&& aOther);

  explicit inline OwningUndefinedOrNullOrCanvasPattern(const OwningUndefinedOrNullOrCanvasPattern& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUndefinedOrNullOrCanvasPattern()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  OwningNonNull<mozilla::dom::CanvasPattern>&
  RawSetAsCanvasPattern();

  OwningNonNull<mozilla::dom::CanvasPattern>&
  SetAsCanvasPattern();

  inline bool
  IsCanvasPattern() const
  {
    return mType == eCanvasPattern;
  }

  inline OwningNonNull<mozilla::dom::CanvasPattern>&
  GetAsCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline OwningNonNull<mozilla::dom::CanvasPattern> const &
  GetAsCanvasPattern() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningUndefinedOrNullOrCanvasPattern&
  operator=(OwningUndefinedOrNullOrCanvasPattern&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUndefinedOrNullOrCanvasPattern&
  operator=(const OwningUndefinedOrNullOrCanvasPattern& aOther);

private:
  bool
  TrySetToCanvasPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyCanvasPattern();
};

class OwningUnrestrictedDoubleOrString : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUnrestrictedDouble,
    eString
  };
public:
  enum class Type
  {
    eUnrestrictedDouble = TypeOrUninit::eUnrestrictedDouble,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<double > mUnrestrictedDouble;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUnrestrictedDoubleOrString()
    : mType(eUninitialized)
  {
  }

  OwningUnrestrictedDoubleOrString(OwningUnrestrictedDoubleOrString&& aOther);

  explicit inline OwningUnrestrictedDoubleOrString(const OwningUnrestrictedDoubleOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUnrestrictedDoubleOrString()
  {
    Uninit();
  }

  double&
  RawSetAsUnrestrictedDouble();

  double&
  SetAsUnrestrictedDouble();

  inline bool
  IsUnrestrictedDouble() const
  {
    return mType == eUnrestrictedDouble;
  }

  inline double&
  GetAsUnrestrictedDouble()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline double const &
  GetAsUnrestrictedDouble() const
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningUnrestrictedDoubleOrString&
  operator=(OwningUnrestrictedDoubleOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUnrestrictedDoubleOrString&
  operator=(const OwningUnrestrictedDoubleOrString& aOther);

private:
  bool
  TrySetToUnrestrictedDouble(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUnrestrictedDouble();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};

class OwningUnrestrictedFloatOrString : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUnrestrictedFloat,
    eString
  };
public:
  enum class Type
  {
    eUnrestrictedFloat = TypeOrUninit::eUnrestrictedFloat,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<float > mUnrestrictedFloat;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUnrestrictedFloatOrString()
    : mType(eUninitialized)
  {
  }

  OwningUnrestrictedFloatOrString(OwningUnrestrictedFloatOrString&& aOther);

  explicit inline OwningUnrestrictedFloatOrString(const OwningUnrestrictedFloatOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUnrestrictedFloatOrString()
  {
    Uninit();
  }

  float&
  RawSetAsUnrestrictedFloat();

  float&
  SetAsUnrestrictedFloat();

  inline bool
  IsUnrestrictedFloat() const
  {
    return mType == eUnrestrictedFloat;
  }

  inline float&
  GetAsUnrestrictedFloat()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedFloat(), "Wrong type!");
    return mValue.mUnrestrictedFloat.Value();
  }

  inline float const &
  GetAsUnrestrictedFloat() const
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedFloat(), "Wrong type!");
    return mValue.mUnrestrictedFloat.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningUnrestrictedFloatOrString&
  operator=(OwningUnrestrictedFloatOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUnrestrictedFloatOrString&
  operator=(const OwningUnrestrictedFloatOrString& aOther);

private:
  bool
  TrySetToUnrestrictedFloat(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUnrestrictedFloat();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};
} // namespace mozilla::dom


#endif // mozilla_dom_UnionTypes_h
