// -*- mode: C++ -*-

/* This file is auto-generated by run_glean_parser.py.
   It is only for internal use by types in
   toolkit/components/glean/bindings/private */

#include "mozilla/AppShutdown.h"
#include "mozilla/ClearOnShutdown.h"
#include "mozilla/glean/bindings/GleanJSMetricsLookup.h"
#include "mozilla/glean/bindings/jog/JOG.h"
#include "mozilla/Maybe.h"
#include "mozilla/Telemetry.h"
#include <tuple>
#include "mozilla/DataMutex.h"
#include "nsClassHashtable.h"
#include "nsTHashMap.h"
#include "nsIThread.h"
#include "nsThreadUtils.h"

#ifndef mozilla_glean_ScalarGifftMap_h
#define mozilla_glean_ScalarGifftMap_h

#define DYNAMIC_METRIC_BIT (26)
#define GLEAN_METRIC_ID(id) ((id) & ((1ULL << 27) - 1))

namespace mozilla::glean {

using Telemetry::ScalarID;

typedef nsUint32HashKey SubmetricIdHashKey;
typedef nsTHashMap<SubmetricIdHashKey, std::tuple<ScalarID, nsString>>
    SubmetricToLabeledMirrorMapType;
typedef StaticDataMutex<UniquePtr<SubmetricToLabeledMirrorMapType>>
    SubmetricToMirrorMutex;
static inline Maybe<SubmetricToMirrorMutex::AutoLock> GetLabeledMirrorLock() {
  static SubmetricToMirrorMutex sLabeledMirrors("sLabeledMirrors");
  auto lock = sLabeledMirrors.Lock();
  // GIFFT will work up to the end of AppShutdownTelemetry.
  if (AppShutdown::IsInOrBeyond(ShutdownPhase::XPCOMWillShutdown)) {
    return Nothing();
  }
  if (!*lock) {
    *lock = MakeUnique<SubmetricToLabeledMirrorMapType>();
    RefPtr<nsIRunnable> cleanupFn = NS_NewRunnableFunction(__func__, [&] {
      if (AppShutdown::IsInOrBeyond(ShutdownPhase::XPCOMWillShutdown)) {
        auto lock = sLabeledMirrors.Lock();
        *lock = nullptr;  // deletes, see UniquePtr.h
        return;
      }
      RunOnShutdown([&] {
        auto lock = sLabeledMirrors.Lock();
        *lock = nullptr;  // deletes, see UniquePtr.h
      }, ShutdownPhase::XPCOMWillShutdown);
    });
    // Both getting the main thread and dispatching to it can fail.
    // In that event we leak. Grab a pointer so we have something to NS_RELEASE
    // in that case.
    nsIRunnable* temp = cleanupFn.get();
    nsCOMPtr<nsIThread> mainThread;
    if (NS_FAILED(NS_GetMainThread(getter_AddRefs(mainThread)))
      || NS_FAILED(mainThread->Dispatch(cleanupFn.forget(), nsIThread::DISPATCH_NORMAL))
    ) {
      // Failed to dispatch cleanup routine.
      // First, un-leak the runnable (but only if we actually attempted dispatch)
      if (!cleanupFn) {
        NS_RELEASE(temp);
      }
      // Next, cleanup immediately, and allow metrics to try again later.
      *lock = nullptr;
      return Nothing();
    }
  }
  return Some(std::move(lock));
}

namespace {
class ScalarIDHashKey : public PLDHashEntryHdr {
 public:
  typedef const ScalarID& KeyType;
  typedef const ScalarID* KeyTypePointer;

  explicit ScalarIDHashKey(KeyTypePointer aKey) : mValue(*aKey) {}
  ScalarIDHashKey(ScalarIDHashKey&& aOther)
      : PLDHashEntryHdr(std::move(aOther)), mValue(std::move(aOther.mValue)) {}
  ~ScalarIDHashKey() = default;

  KeyType GetKey() const { return mValue; }
  bool KeyEquals(KeyTypePointer aKey) const { return *aKey == mValue; }

  static KeyTypePointer KeyToPointer(KeyType aKey) { return &aKey; }
  static PLDHashNumber HashKey(KeyTypePointer aKey) {
    return static_cast<std::underlying_type<ScalarID>::type>(*aKey);
  }
  enum { ALLOW_MEMMOVE = true };

 private:
  const ScalarID mValue;
};
}  // namespace
typedef StaticDataMutex<UniquePtr<nsTHashMap<ScalarIDHashKey, TimeStamp>>> TimesToStartsMutex;
static inline Maybe<TimesToStartsMutex::AutoLock> GetTimesToStartsLock() {
  static TimesToStartsMutex sTimespanStarts("sTimespanStarts");
  auto lock = sTimespanStarts.Lock();
  // GIFFT will work up to the end of AppShutdownTelemetry.
  if (AppShutdown::IsInOrBeyond(ShutdownPhase::XPCOMWillShutdown)) {
    return Nothing();
  }
  if (!*lock) {
    *lock = MakeUnique<nsTHashMap<ScalarIDHashKey, TimeStamp>>();
    RefPtr<nsIRunnable> cleanupFn = NS_NewRunnableFunction(__func__, [&] {
      if (AppShutdown::IsInOrBeyond(ShutdownPhase::XPCOMWillShutdown)) {
        auto lock = sTimespanStarts.Lock();
        *lock = nullptr;  // deletes, see UniquePtr.h
        return;
      }
      RunOnShutdown([&] {
        auto lock = sTimespanStarts.Lock();
        *lock = nullptr;  // deletes, see UniquePtr.h
      }, ShutdownPhase::XPCOMWillShutdown);
    });
    // Both getting the main thread and dispatching to it can fail.
    // In that event we leak. Grab a pointer so we have something to NS_RELEASE
    // in that case.
    nsIRunnable* temp = cleanupFn.get();
    nsCOMPtr<nsIThread> mainThread;
    if (NS_FAILED(NS_GetMainThread(getter_AddRefs(mainThread)))
      || NS_FAILED(mainThread->Dispatch(cleanupFn.forget(), nsIThread::DISPATCH_NORMAL))
    ) {
      // Failed to dispatch cleanup routine.
      // First, un-leak the runnable (but only if we actually attempted dispatch)
      if (!cleanupFn) {
        NS_RELEASE(temp);
      }
      // Next, cleanup immediately, and allow metrics to try again later.
      *lock = nullptr;
      return Nothing();
    }
  }
  return Some(std::move(lock));
}

static inline bool IsSubmetricId(uint32_t aId) {
  // Submetrics have the 2^25 bit set.
  // (ID_BITS - ID_SIGNAL_BITS, keep it in sync with js.py).
  return (aId & (1 << 25)) > 0;
}

static inline Maybe<ScalarID> ScalarIdForMetric(uint32_t aId) {
  switch(aId) {
    case 128: { // networking.speculative_connect_outcome
      return Some(ScalarID::NETWORKING_SPECULATIVE_CONNECT_OUTCOME);
    }
    case 132: { // network.data_size_pb_per_type
      return Some(ScalarID::NETWORKING_DATA_TRANSFERRED_PB_PER_CONTENT_TYPE);
    }
    case 133: { // network.data_size_per_type
      return Some(ScalarID::NETWORKING_DATA_TRANSFERRED_PER_CONTENT_TYPE);
    }
    case 158: { // cookie.banners.normal_window_service_mode
      return Some(ScalarID::COOKIE_BANNERS_NORMAL_WINDOW_SERVICE_MODE);
    }
    case 159: { // cookie.banners.private_window_service_mode
      return Some(ScalarID::COOKIE_BANNERS_PRIVATE_WINDOW_SERVICE_MODE);
    }
    case 161: { // cookie.banners.rule_lookup_by_domain
      return Some(ScalarID::COOKIE_BANNERS_RULE_LOOKUP_BY_DOMAIN);
    }
    case 162: { // cookie.banners.rule_lookup_by_load
      return Some(ScalarID::COOKIE_BANNERS_RULE_LOOKUP_BY_LOAD);
    }
    case 163: { // cookie.banners.service_detect_only
      return Some(ScalarID::COOKIE_BANNERS_SERVICE_DETECT_ONLY);
    }
    case 165: { // cookie.banners.click.result
      return Some(ScalarID::COOKIE_BANNERS_CLICK_RESULT);
    }
    case 170: { // extensions.startup_cache_load_time
      return Some(ScalarID::EXTENSIONS_STARTUPCACHE_LOAD_TIME);
    }
    case 171: { // extensions.apis.dnr.evaluate_rules_count_max
      return Some(ScalarID::EXTENSIONS_APIS_DNR_EVALUATE_RULES_COUNT_MAX);
    }
    case 173: { // extensions.apis.dnr.startup_cache_entries
      return Some(ScalarID::EXTENSIONS_APIS_DNR_STARTUP_CACHE_ENTRIES);
    }
    case 200: { // test_only.meaning_of_life
      return Some(ScalarID::TELEMETRY_TEST_MIRROR_FOR_QUANTITY);
    }
    case 201: { // test_only.mirror_time
      return Some(ScalarID::TELEMETRY_TEST_MIRROR_FOR_TIMESPAN);
    }
    case 202: { // test_only.mirror_time_nanos
      return Some(ScalarID::TELEMETRY_TEST_MIRROR_FOR_TIMESPAN_NANOS);
    }
    case 203: { // test_only.mirrors_for_labeled_bools
      return Some(ScalarID::TELEMETRY_TEST_MIRROR_FOR_LABELED_BOOL);
    }
    case 208: { // test_only.ipc.a_bool
      return Some(ScalarID::TELEMETRY_TEST_BOOLEAN_KIND);
    }
    case 209: { // test_only.ipc.a_counter
      return Some(ScalarID::TELEMETRY_TEST_MIRROR_FOR_COUNTER);
    }
    case 211: { // test_only.ipc.a_date
      return Some(ScalarID::TELEMETRY_TEST_MIRROR_FOR_DATE);
    }
    case 212: { // test_only.ipc.a_labeled_counter
      return Some(ScalarID::TELEMETRY_TEST_ANOTHER_MIRROR_FOR_LABELED_COUNTER);
    }
    case 215: { // test_only.ipc.a_string
      return Some(ScalarID::TELEMETRY_TEST_MULTIPLE_STORES_STRING);
    }
    case 216: { // test_only.ipc.a_string_list
      return Some(ScalarID::TELEMETRY_TEST_KEYED_BOOLEAN_KIND);
    }
    case 219: { // test_only.ipc.a_url
      return Some(ScalarID::TELEMETRY_TEST_MIRROR_FOR_URL);
    }
    case 220: { // test_only.ipc.a_uuid
      return Some(ScalarID::TELEMETRY_TEST_STRING_KIND);
    }
    case 223: { // test_only.ipc.another_labeled_counter
      return Some(ScalarID::TELEMETRY_TEST_MIRROR_FOR_LABELED_COUNTER);
    }
    case 225: { // test_only.ipc.irate
      return Some(ScalarID::TELEMETRY_TEST_MIRROR_FOR_RATE);
    }
    case 241: { // power.cpu_time_bogus_values
      return Some(ScalarID::POWER_CPU_TIME_BOGUS_VALUES);
    }
    case 242: { // power.cpu_time_per_process_type_ms
      return Some(ScalarID::POWER_CPU_TIME_PER_PROCESS_TYPE_MS);
    }
    case 244: { // power.gpu_time_bogus_values
      return Some(ScalarID::POWER_GPU_TIME_BOGUS_VALUES);
    }
    case 245: { // power.gpu_time_per_process_type_ms
      return Some(ScalarID::POWER_GPU_TIME_PER_PROCESS_TYPE_MS);
    }
    case 246: { // power.total_cpu_time_ms
      return Some(ScalarID::POWER_TOTAL_CPU_TIME_MS);
    }
    case 247: { // power.total_gpu_time_ms
      return Some(ScalarID::POWER_TOTAL_GPU_TIME_MS);
    }
    case 248: { // power.total_thread_wakeups
      return Some(ScalarID::POWER_TOTAL_THREAD_WAKEUPS);
    }
    case 249: { // power.wakeups_per_process_type
      return Some(ScalarID::POWER_WAKEUPS_PER_PROCESS_TYPE);
    }
    case 286: { // blocklist.mlbf_source
      return Some(ScalarID::BLOCKLIST_MLBF_SOURCE);
    }
    default: {
      if (MOZ_UNLIKELY(aId & (1 << DYNAMIC_METRIC_BIT))) {
        // Dynamic (runtime-registered) metric. Use its static (compiletime-
        // registered) metric's telemetry_mirror mapping.
        // ...if applicable.

        // Only JS can use dynamic (runtime-registered) metric ids.
        MOZ_ASSERT(NS_IsMainThread());

        auto metricName = JOG::GetMetricName(aId);
        // All of these should have names, but the storage only lasts until
        // XPCOMWillShutdown, so it might return `Nothing()`.
        if (metricName.isSome()) {
          auto maybeMetric = MetricByNameLookup(metricName.ref());
          if (maybeMetric.isSome()) {
            uint32_t staticId = GLEAN_METRIC_ID(maybeMetric.value());
            // Let's ensure we don't infinite loop, huh.
            MOZ_ASSERT(!(staticId & (1 << DYNAMIC_METRIC_BIT)));
            return ScalarIdForMetric(staticId);
          }
        }
      }
      return Nothing();
    }
  }
}

}  // namespace mozilla::glean

#undef GLEAN_METRIC_ID
#undef DYNAMIC_METRIC_BIT

#endif  // mozilla_glean_ScalarGifftMaps_h
