/* THIS FILE IS AUTOGENERATED FROM HTMLAllCollection.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_HTMLAllCollectionBinding_h
#define mozilla_dom_HTMLAllCollectionBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

class nsIHTMLCollection;

namespace mozilla {
namespace dom {

class Element;
class HTMLAllCollection;
struct NativePropertyHooks;
class OwningHTMLCollectionOrElement;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningHTMLCollectionOrElement& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningHTMLCollectionOrElement& aUnion);


class HTMLCollectionOrElement
{
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLCollection,
    eElement
  };
public:
  enum class Type
  {
    eHTMLCollection = TypeOrUninit::eHTMLCollection,
    eElement = TypeOrUninit::eElement
  };

private:
  union Value
  {
    UnionMember<NonNull<nsIHTMLCollection> > mHTMLCollection;
    UnionMember<NonNull<mozilla::dom::Element> > mElement;

  };

  TypeOrUninit mType;
  Value mValue;

  HTMLCollectionOrElement(const HTMLCollectionOrElement&) = delete;
  HTMLCollectionOrElement& operator=(const HTMLCollectionOrElement&) = delete;
public:
  explicit inline HTMLCollectionOrElement()
    : mType(eUninitialized)
  {
  }

  inline ~HTMLCollectionOrElement()
  {
    Uninit();
  }

  inline NonNull<nsIHTMLCollection>&
  RawSetAsHTMLCollection()
  {
    if (mType == eHTMLCollection) {
      return mValue.mHTMLCollection.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLCollection;
    return mValue.mHTMLCollection.SetValue();
  }

  inline NonNull<nsIHTMLCollection>&
  SetAsHTMLCollection()
  {
    if (mType == eHTMLCollection) {
      return mValue.mHTMLCollection.Value();
    }
    Uninit();
    mType = eHTMLCollection;
    return mValue.mHTMLCollection.SetValue();
  }

  inline bool
  IsHTMLCollection() const
  {
    return mType == eHTMLCollection;
  }

  inline NonNull<nsIHTMLCollection>&
  GetAsHTMLCollection()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCollection(), "Wrong type!");
    return mValue.mHTMLCollection.Value();
  }

  inline nsIHTMLCollection&
  GetAsHTMLCollection() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLCollection(), "Wrong type!");
    return mValue.mHTMLCollection.Value();
  }

  inline NonNull<mozilla::dom::Element>&
  RawSetAsElement()
  {
    if (mType == eElement) {
      return mValue.mElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eElement;
    return mValue.mElement.SetValue();
  }

  inline NonNull<mozilla::dom::Element>&
  SetAsElement()
  {
    if (mType == eElement) {
      return mValue.mElement.Value();
    }
    Uninit();
    mType = eElement;
    return mValue.mElement.SetValue();
  }

  inline bool
  IsElement() const
  {
    return mType == eElement;
  }

  inline NonNull<mozilla::dom::Element>&
  GetAsElement()
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  inline mozilla::dom::Element&
  GetAsElement() const
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eHTMLCollection: {
        DestroyHTMLCollection();
        break;
      }
      case eElement: {
        DestroyElement();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToHTMLCollection(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLCollection(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLCollection()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCollection(), "Wrong type!");
    mValue.mHTMLCollection.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyElement()
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    mValue.mElement.Destroy();
    mType = eUninitialized;
  }
};


class OwningHTMLCollectionOrElement : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningHTMLCollectionOrElement& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLCollection,
    eElement
  };
public:
  enum class Type
  {
    eHTMLCollection = TypeOrUninit::eHTMLCollection,
    eElement = TypeOrUninit::eElement
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<nsIHTMLCollection> > mHTMLCollection;
    UnionMember<OwningNonNull<mozilla::dom::Element> > mElement;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningHTMLCollectionOrElement()
    : mType(eUninitialized)
  {
  }

  OwningHTMLCollectionOrElement(OwningHTMLCollectionOrElement&& aOther);

  explicit inline OwningHTMLCollectionOrElement(const OwningHTMLCollectionOrElement& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningHTMLCollectionOrElement()
  {
    Uninit();
  }

  OwningNonNull<nsIHTMLCollection>&
  RawSetAsHTMLCollection();

  OwningNonNull<nsIHTMLCollection>&
  SetAsHTMLCollection();

  inline bool
  IsHTMLCollection() const
  {
    return mType == eHTMLCollection;
  }

  inline OwningNonNull<nsIHTMLCollection>&
  GetAsHTMLCollection()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCollection(), "Wrong type!");
    return mValue.mHTMLCollection.Value();
  }

  inline OwningNonNull<nsIHTMLCollection> const &
  GetAsHTMLCollection() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLCollection(), "Wrong type!");
    return mValue.mHTMLCollection.Value();
  }

  OwningNonNull<mozilla::dom::Element>&
  RawSetAsElement();

  OwningNonNull<mozilla::dom::Element>&
  SetAsElement();

  inline bool
  IsElement() const
  {
    return mType == eElement;
  }

  inline OwningNonNull<mozilla::dom::Element>&
  GetAsElement()
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  inline OwningNonNull<mozilla::dom::Element> const &
  GetAsElement() const
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningHTMLCollectionOrElement&
  operator=(OwningHTMLCollectionOrElement&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningHTMLCollectionOrElement&
  operator=(const OwningHTMLCollectionOrElement& aOther);

private:
  bool
  TrySetToHTMLCollection(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLCollection(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLCollection();

  bool
  TrySetToElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyElement();
};


namespace HTMLAllCollection_Binding {

  typedef mozilla::dom::HTMLAllCollection NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::HTMLAllCollection* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::HTMLAllCollection,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::HTMLAllCollection,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace HTMLAllCollection_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_HTMLAllCollectionBinding_h
