/* THIS FILE IS AUTOGENERATED FROM HTMLInputElement.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_HTMLInputElementBinding_h
#define mozilla_dom_HTMLInputElementBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"

namespace mozilla {
namespace dom {

struct DateTimeValueAtoms;
class HTMLInputElement;
struct NativePropertyHooks;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class SelectionMode : uint8_t {
  Select,
  Start,
  End,
  Preserve,
  EndGuard_
};

namespace SelectionModeValues {
extern const EnumEntry strings[5];

static constexpr size_t Count = 4;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(SelectionMode::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(SelectionMode stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace SelectionModeValues

bool
ToJSValue(JSContext* aCx, SelectionMode aArgument, JS::MutableHandle<JS::Value> aValue);


struct DateTimeValue : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mDay;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mHour;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mMinute;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mMonth;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mYear;

  DateTimeValue();

  explicit inline DateTimeValue(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  DateTimeValue(DateTimeValue&& aOther) = default;

  explicit inline DateTimeValue(const DateTimeValue& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  DateTimeValue&
  operator=(const DateTimeValue& aOther);

  bool
  operator==(const DateTimeValue& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, DateTimeValueAtoms* atomsCache);
};

namespace binding_detail {
struct FastDateTimeValue : public DateTimeValue
{
  inline FastDateTimeValue()
    : DateTimeValue(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace HTMLInputElement_Binding {

  typedef mozilla::dom::HTMLInputElement NativeType;

  static const int32_t UNKNOWN_REQUEST = -1;
  static const int32_t CURRENT_REQUEST = 0;
  static const int32_t PENDING_REQUEST = 1;
  bool
  Wrap(JSContext* aCx, mozilla::dom::HTMLInputElement* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  ClearCachedWebkitEntriesValue(mozilla::dom::HTMLInputElement* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::HTMLInputElement,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::HTMLInputElement,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace HTMLInputElement_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_HTMLInputElementBinding_h
