/* THIS FILE IS AUTOGENERATED FROM OscillatorNode.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_OscillatorNodeBinding_h
#define mozilla_dom_OscillatorNodeBinding_h

#include "AudioNodeBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PeriodicWave.h"
#include "mozilla/dom/PrototypeList.h"

namespace mozilla {
namespace dom {

struct NativePropertyHooks;
class OscillatorNode;
struct OscillatorOptionsAtoms;
class PeriodicWave;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class OscillatorType : uint8_t {
  Sine,
  Square,
  Sawtooth,
  Triangle,
  Custom,
  EndGuard_
};

namespace OscillatorTypeValues {
extern const EnumEntry strings[6];

static constexpr size_t Count = 5;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(OscillatorType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(OscillatorType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace OscillatorTypeValues

bool
ToJSValue(JSContext* aCx, OscillatorType aArgument, JS::MutableHandle<JS::Value> aValue);


struct OscillatorOptions : public AudioNodeOptions
{
  MOZ_INIT_OUTSIDE_CTOR float mDetune;
  MOZ_INIT_OUTSIDE_CTOR float mFrequency;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<mozilla::dom::PeriodicWave>> mPeriodicWave;
  MOZ_INIT_OUTSIDE_CTOR OscillatorType mType;

  OscillatorOptions();

  explicit inline OscillatorOptions(const FastDictionaryInitializer& )
    : AudioNodeOptions(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  OscillatorOptions(OscillatorOptions&& aOther) = default;

  explicit inline OscillatorOptions(const OscillatorOptions& aOther)
    : AudioNodeOptions(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mPeriodicWave, "mPeriodicWave", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mPeriodicWave);
  }

  OscillatorOptions&
  operator=(const OscillatorOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, OscillatorOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastOscillatorOptions : public OscillatorOptions
{
  inline FastOscillatorOptions()
    : OscillatorOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace OscillatorNode_Binding {

  typedef mozilla::dom::OscillatorNode NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::OscillatorNode* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::OscillatorNode,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::OscillatorNode,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace OscillatorNode_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_OscillatorNodeBinding_h
