/* THIS FILE IS AUTOGENERATED FROM PushSubscription.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_PushSubscriptionBinding_h
#define mozilla_dom_PushSubscriptionBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/TypedArray.h"
#include "mozilla/dom/UnionTypes.h"

namespace mozilla {
namespace dom {

class ArrayBufferViewOrArrayBuffer;
struct NativePropertyHooks;
class OwningArrayBufferViewOrArrayBuffer;
class ProtoAndIfaceCache;
class PushSubscription;
struct PushSubscriptionInitAtoms;
struct PushSubscriptionJSONAtoms;
struct PushSubscriptionKeys;
struct PushSubscriptionKeysAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class PushEncryptionKeyName : uint8_t {
  P256dh,
  Auth,
  EndGuard_
};

namespace PushEncryptionKeyNameValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(PushEncryptionKeyName::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(PushEncryptionKeyName stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace PushEncryptionKeyNameValues

bool
ToJSValue(JSContext* aCx, PushEncryptionKeyName aArgument, JS::MutableHandle<JS::Value> aValue);


struct PushSubscriptionInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<Nullable<OwningArrayBufferViewOrArrayBuffer >> mAppServerKey;
  MOZ_INIT_OUTSIDE_CTOR Optional<Nullable<ArrayBuffer>> mAuthSecret;
  MOZ_INIT_OUTSIDE_CTOR nsString mEndpoint;
  MOZ_INIT_OUTSIDE_CTOR Nullable<uint64_t> mExpirationTime;
  MOZ_INIT_OUTSIDE_CTOR Optional<Nullable<ArrayBuffer>> mP256dhKey;
  MOZ_INIT_OUTSIDE_CTOR nsString mScope;

  PushSubscriptionInit();

  explicit inline PushSubscriptionInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  PushSubscriptionInit(PushSubscriptionInit&& aOther) = default;

private:
  PushSubscriptionInit(const PushSubscriptionInit&) = delete;
  PushSubscriptionInit& operator=(const PushSubscriptionInit&) = delete;

  static bool
  InitIds(JSContext* cx, PushSubscriptionInitAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastPushSubscriptionInit : public PushSubscriptionInit
{
  inline FastPushSubscriptionInit()
    : PushSubscriptionInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct PushSubscriptionKeys : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsCString> mAuth;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsCString> mP256dh;

  PushSubscriptionKeys();

  explicit inline PushSubscriptionKeys(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  PushSubscriptionKeys(PushSubscriptionKeys&& aOther) = default;

  explicit inline PushSubscriptionKeys(const PushSubscriptionKeys& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  PushSubscriptionKeys&
  operator=(const PushSubscriptionKeys& aOther);

  bool
  operator==(const PushSubscriptionKeys& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, PushSubscriptionKeysAtoms* atomsCache);
};

namespace binding_detail {
struct FastPushSubscriptionKeys : public PushSubscriptionKeys
{
  inline FastPushSubscriptionKeys()
    : PushSubscriptionKeys(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct PushSubscriptionJSON : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mEndpoint;
  MOZ_INIT_OUTSIDE_CTOR Optional<Nullable<uint64_t>> mExpirationTime;
  MOZ_INIT_OUTSIDE_CTOR PushSubscriptionKeys mKeys;

  PushSubscriptionJSON();

  explicit inline PushSubscriptionJSON(const FastDictionaryInitializer& )
    : mKeys(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  PushSubscriptionJSON(PushSubscriptionJSON&& aOther) = default;

  explicit inline PushSubscriptionJSON(const PushSubscriptionJSON& aOther)
    : mKeys(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  PushSubscriptionJSON&
  operator=(const PushSubscriptionJSON& aOther);

private:
  static bool
  InitIds(JSContext* cx, PushSubscriptionJSONAtoms* atomsCache);
};

namespace binding_detail {
struct FastPushSubscriptionJSON : public PushSubscriptionJSON
{
  inline FastPushSubscriptionJSON()
    : PushSubscriptionJSON(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace PushSubscription_Binding {

  typedef mozilla::dom::PushSubscription NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::PushSubscription* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::PushSubscription,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::PushSubscription,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace PushSubscription_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_PushSubscriptionBinding_h
