/* THIS FILE IS AUTOGENERATED FROM VideoFrame.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_VideoFrameBinding_h
#define mozilla_dom_VideoFrameBinding_h

#include "DOMRectBinding.h"
#include "VideoColorSpaceBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"

namespace mozilla {
namespace dom {

struct DOMRectInit;
struct NativePropertyHooks;
struct PlaneLayout;
struct PlaneLayoutAtoms;
class ProtoAndIfaceCache;
struct VideoColorSpaceInit;
class VideoFrame;
struct VideoFrameBufferInitAtoms;
struct VideoFrameCopyToOptionsAtoms;
struct VideoFrameInitAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class AlphaOption : uint8_t {
  Keep,
  Discard,
  EndGuard_
};

namespace AlphaOptionValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(AlphaOption::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(AlphaOption stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace AlphaOptionValues

bool
ToJSValue(JSContext* aCx, AlphaOption aArgument, JS::MutableHandle<JS::Value> aValue);


enum class VideoPixelFormat : uint8_t {
  I420,
  I420A,
  I422,
  I444,
  NV12,
  RGBA,
  RGBX,
  BGRA,
  BGRX,
  EndGuard_
};

namespace VideoPixelFormatValues {
extern const EnumEntry strings[10];

static constexpr size_t Count = 9;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(VideoPixelFormat::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(VideoPixelFormat stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace VideoPixelFormatValues

bool
ToJSValue(JSContext* aCx, VideoPixelFormat aArgument, JS::MutableHandle<JS::Value> aValue);


struct PlaneLayout : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mOffset;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mStride;

  PlaneLayout();

  explicit inline PlaneLayout(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  PlaneLayout(PlaneLayout&& aOther) = default;

  explicit inline PlaneLayout(const PlaneLayout& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  PlaneLayout&
  operator=(const PlaneLayout& aOther);

  bool
  operator==(const PlaneLayout& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, PlaneLayoutAtoms* atomsCache);
};

namespace binding_detail {
struct FastPlaneLayout : public PlaneLayout
{
  inline FastPlaneLayout()
    : PlaneLayout(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct VideoFrameInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR AlphaOption mAlpha;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mDisplayHeight;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mDisplayWidth;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mDuration;
  MOZ_INIT_OUTSIDE_CTOR Optional<int64_t> mTimestamp;
  MOZ_INIT_OUTSIDE_CTOR Optional<DOMRectInit> mVisibleRect;

  VideoFrameInit();

  explicit inline VideoFrameInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  VideoFrameInit(VideoFrameInit&& aOther) = default;

  explicit inline VideoFrameInit(const VideoFrameInit& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  VideoFrameInit&
  operator=(const VideoFrameInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, VideoFrameInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastVideoFrameInit : public VideoFrameInit
{
  inline FastVideoFrameInit()
    : VideoFrameInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct VideoFrameBufferInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mCodedHeight;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mCodedWidth;
  MOZ_INIT_OUTSIDE_CTOR Optional<VideoColorSpaceInit> mColorSpace;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mDisplayHeight;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mDisplayWidth;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mDuration;
  MOZ_INIT_OUTSIDE_CTOR VideoPixelFormat mFormat;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<PlaneLayout>> mLayout;
  MOZ_INIT_OUTSIDE_CTOR int64_t mTimestamp;
  MOZ_INIT_OUTSIDE_CTOR Optional<DOMRectInit> mVisibleRect;

  VideoFrameBufferInit();

  explicit inline VideoFrameBufferInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  VideoFrameBufferInit(VideoFrameBufferInit&& aOther) = default;

  explicit inline VideoFrameBufferInit(const VideoFrameBufferInit& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  VideoFrameBufferInit&
  operator=(const VideoFrameBufferInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, VideoFrameBufferInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastVideoFrameBufferInit : public VideoFrameBufferInit
{
  inline FastVideoFrameBufferInit()
    : VideoFrameBufferInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct VideoFrameCopyToOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<PlaneLayout>> mLayout;
  MOZ_INIT_OUTSIDE_CTOR Optional<DOMRectInit> mRect;

  VideoFrameCopyToOptions();

  explicit inline VideoFrameCopyToOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  VideoFrameCopyToOptions(VideoFrameCopyToOptions&& aOther) = default;

  explicit inline VideoFrameCopyToOptions(const VideoFrameCopyToOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  VideoFrameCopyToOptions&
  operator=(const VideoFrameCopyToOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, VideoFrameCopyToOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastVideoFrameCopyToOptions : public VideoFrameCopyToOptions
{
  inline FastVideoFrameCopyToOptions()
    : VideoFrameCopyToOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace VideoFrame_Binding {

  typedef mozilla::dom::VideoFrame NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::VideoFrame* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::VideoFrame,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::VideoFrame,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace VideoFrame_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_VideoFrameBinding_h
